/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreePsbModel;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;

public class CatalogTreeConnection
extends CatalogTreeParent {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionProfile connProf;
    private String connProfId;
    private boolean attemptingToConnect = false;
    private String password = null;
    private String projectName = null;
    private IImsDbConnection connection;
    private CatalogTreeParent dbdFolder;
    private CatalogTreeParent psbFolder;
    private CatTreePsbModel userPsbNode;
    private CatTreePsbModel catPsbNode;

    public CatalogTreeConnection(ConnectionProfile connProf) {
        super(connProf.getName(), "IMS CATALOG CONNECTION");
        this.connProf = connProf;
        this.connProfId = connProf.getId();
        this.projectName = (String)connProf.getAttributes().get("PROJECT_NAME");
        if (this.projectName != null && this.projectName.isEmpty()) {
            this.projectName = null;
        }
        super.setTreeConnectionNode(this);
    }

    @Override
    public IImsDbConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IImsDbConnection connection) {
        this.connection = connection;
    }

    public String getConnectionProfileId() {
        return this.connProfId;
    }

    public ConnectionProfile getConnectionProfile() {
        return this.connProf;
    }

    public void setConnectionProfile(ConnectionProfile connProf) {
        this.connProf = connProf;
    }

    public synchronized boolean testAndSetAttemptingToConnect(boolean isAttemptingToConnect) {
        boolean retVal = this.attemptingToConnect;
        this.attemptingToConnect = isAttemptingToConnect;
        return retVal;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public CatalogTreeObject[] getChildren() {
        this.populateChildren();
        return super.getChildren();
    }

    private void populateChildren() {
        if (this.dbdFolder == null) {
            this.dbdFolder = new CatalogTreeParent("DBD", "DBD FOLDER", this);
            this.addChild(this.dbdFolder);
        }
        if (this.psbFolder == null) {
            this.psbFolder = new CatalogTreeParent("PSB", "PSB FOLDER", this);
            this.addChild(this.psbFolder);
        }
        if (this.userPsbNode == null) {
            this.connProf = ImsDbUtils.getConnectionProfileById((String)this.connProfId);
            String psbName = (String)this.connProf.getAttributes().get("PSB_NAME");
            if (psbName == null || psbName.isEmpty()) {
                String projectName = (String)this.connProf.getAttributes().get("PROJECT_NAME");
                if (projectName != null && !projectName.isEmpty()) {
                    psbName = (String)this.connProf.getAttributes().get("PROJECT_PSB_NAME");
                    this.userPsbNode = new CatTreePsbModel(psbName, this);
                } else {
                    String fileLocation = (String)this.connProf.getAttributes().get("FILE_LOCATION");
                    if (fileLocation != null && !fileLocation.isEmpty()) {
                        String localFilePsbName = (String)this.connProf.getAttributes().get("METADATA_CLASS");
                        this.userPsbNode = new CatTreePsbModel(localFilePsbName, this);
                    }
                }
            } else {
                this.userPsbNode = new CatTreePsbModel(psbName, this);
            }
            this.userPsbNode.isUserPsbConnection = true;
            this.addChild(this.userPsbNode);
        }
        if (this.catPsbNode == null) {
            this.catPsbNode = new CatTreePsbModel("DFSCP000", this);
            this.catPsbNode.isCatalogPsbConnection = true;
            this.addChild(this.catPsbNode);
        }
    }

    public CatalogTreeParent getDbdFolder() {
        return this.dbdFolder;
    }

    public CatalogTreeParent getPsbFolder() {
        return this.psbFolder;
    }

    public void clearDbdPsbFolders() {
        this.removeChild(this.dbdFolder);
        this.dbdFolder = null;
        this.removeChild(this.psbFolder);
        this.psbFolder = null;
    }

    public void clearPsbNodes() {
        this.removeChild(this.userPsbNode);
        this.userPsbNode = null;
        this.removeChild(this.catPsbNode);
        this.catPsbNode = null;
    }
}

