/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav;

import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.CredentialsManagerListener;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.utilities.Utility;
import com.ibm.im.ims.catalog.ui.view.nav.CatNavComparator;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogViewContentProvider;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogViewLabelProvider;
import com.ibm.im.ims.catalog.ui.view.nav.NavigatorFilter;
import com.ibm.im.ims.catalog.ui.view.nav.NavigatorFilteredTree;
import com.ibm.im.ims.catalog.ui.view.nav.actions.CatalogSearchDialog;
import com.ibm.im.ims.catalog.ui.view.search.CatalogSearchView;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionException;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.IConnManagerListener;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.IConnServiceListener;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.ImsDbConnectionManagerListener;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.ImsDbConnectionServiceListener;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.ImsDbCredentialsManagerListener;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class CatalogNav
extends ViewPart
implements IDoubleClickListener,
IConnServiceListener,
IConnManagerListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.im.ims.catalog.ui.view.nav.CatalogNav";
    public static final String ResourceMultiPageEditorPsbId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private TreeViewer viewer;
    private Action actionCollapse;
    private Action actionSearch;
    private Action actionRefresh;
    private NavigatorFilteredTree filteredTree;
    private NavigatorFilter patternFilter;
    private IPath stateLocationPath;
    private static CatalogNav singletonInstance;
    private List<IImsDbConnection> imsConns = null;
    private IImsDbConnection updatedConnection;
    private CatalogViewContentProvider contentProvider = null;

    public CatalogNav() {
        try {
            this.setTitleToolTip(CatNavMessages.getLabel().getString("CN_VIEW_TITLE"));
            IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
            connectionManager.addListener((ConnectionManagerListener)new ImsDbConnectionManagerListener((IConnManagerListener)this));
            IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
            connectionService.addConnectionServiceListener((ConnectionServiceListener)new ImsDbConnectionServiceListener((IConnServiceListener)this));
            ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
            credentialsManager.addCredentialsManagerListener((CredentialsManagerListener)new ImsDbCredentialsManagerListener());
            singletonInstance = this;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "CatalogNav()", e);
            logger.error(e);
        }
    }

    public static CatalogNav getSingletonInstance() {
        return singletonInstance;
    }

    public void clearSelection() {
        CatalogViewContentProvider contentProvider = (CatalogViewContentProvider)this.viewer.getContentProvider();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)contentProvider.getInvisibleRoot()), true);
    }

    public void populateDbdFolder(CatalogTreeParent dbdFolder) throws ImsDbConnectionException {
        CatalogTreeConnection treeConnectionNode = (CatalogTreeConnection)dbdFolder.getParent();
        List<String> dbdList = this.getDbdList(treeConnectionNode);
        if (dbdList != null && !dbdList.isEmpty()) {
            for (String dbdName : dbdList) {
                CatalogTreeParent newDdb = new CatalogTreeParent(dbdName, "DBD", treeConnectionNode);
                dbdFolder.addChild(newDdb);
            }
        }
    }

    public void populatePsbFolder(CatalogTreeParent psbFolder) throws ImsDbConnectionException {
        CatalogTreeConnection treeConnectionNode = (CatalogTreeConnection)psbFolder.getParent();
        List<String> psbList = this.getPsbList(treeConnectionNode);
        if (psbList != null && !psbList.isEmpty()) {
            for (String psbName : psbList) {
                CatalogTreeParent newPsb = new CatalogTreeParent(psbName, "PSB", treeConnectionNode);
                psbFolder.addChild(newPsb);
            }
        }
    }

    public static List<CatalogTreeConnection> getImplicatedConns(List<CatalogTreeParent> selTreeObjs) throws Exception {
        ArrayList<CatalogTreeConnection> conns = new ArrayList<CatalogTreeConnection>();
        for (CatalogTreeParent obj : selTreeObjs) {
            if (obj.getType().equals("ALL CONNECTIONS")) {
                CatalogTreeObject[] children = obj.getChildren();
                int i = 0;
                while (i < children.length) {
                    CatalogTreeConnection currChild = (CatalogTreeConnection)children[i];
                    IImsDbConnection currConn = currChild.getConnection();
                    if (currConn != null) {
                        conns.add(currChild);
                    }
                    ++i;
                }
                continue;
            }
            if (obj.getType().equals("IMS CATALOG CONNECTION")) {
                CatalogTreeConnection conn = (CatalogTreeConnection)obj;
                if (conns.contains(conn)) continue;
                conns.add(conn);
                continue;
            }
            CatalogTreeParent theParent = obj.getParent();
            while (!(theParent instanceof CatalogTreeConnection)) {
                theParent = theParent.getParent();
            }
            CatalogTreeConnection conn = (CatalogTreeConnection)theParent;
            if (conns.contains(conn)) continue;
            conns.add(conn);
        }
        return conns;
    }

    public void createPartControl(Composite parent) {
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.viewer = new TreeViewer(parent);
        this.contentProvider = new CatalogViewContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new NavDecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)new CatalogViewLabelProvider()), decorator, null));
        this.viewer.setComparator((ViewerComparator)new CatNavComparator());
        this.viewer.setInput((Object)this.getViewSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "com.ibm.im.ims.workbench.catalog.nav.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void refresh(CatalogTreeObject node) {
        this.viewer.refresh((Object)node);
    }

    public void expand(CatalogTreeObject node) {
        this.viewer.setExpandedState((Object)node, true);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCollapse);
        manager.add((IAction)this.actionSearch);
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCollapse);
        manager.add((IAction)this.actionSearch);
        manager.add((IAction)this.actionRefresh);
    }

    private void makeActions() {
        this.actionCollapse = new Action(){

            public void run() {
                CatalogViewContentProvider contentProvider = (CatalogViewContentProvider)CatalogNav.this.viewer.getContentProvider();
                Object[] elems = contentProvider.getElements(CatalogNav.this.getViewSite());
                CatalogNav.this.viewer.collapseToLevel(elems[0], 3);
                CatalogNav.this.viewer.expandToLevel(2);
            }
        };
        this.actionCollapse.setText("Collapse");
        this.actionCollapse.setToolTipText("Collapse");
        this.actionCollapse.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        this.actionRefresh = new Action(){

            public void run() {
                try {
                    CatalogNav.this.searchOrRefresh(false);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    logger.error(e);
                }
            }
        };
        this.actionRefresh.setText(CatNavMessages.getLabel().getString("CN_REFRESH"));
        this.actionRefresh.setToolTipText(CatNavMessages.getLabel().getString("CN_REFRESH"));
        this.actionRefresh.setImageDescriptor(Utility.getImageDescriptor("refresh.gif"));
        this.actionSearch = new Action(){

            public void run() {
                try {
                    CatalogNav.this.searchOrRefresh(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    logger.error(e);
                }
            }
        };
        this.actionSearch.setText(CatNavMessages.getLabel().getString("CNSD_SEACH_MENU"));
        this.actionSearch.setToolTipText(CatNavMessages.getLabel().getString("CNSD_SEACH_MENU"));
        this.actionSearch.setImageDescriptor(Utility.getImageDescriptor("searchGeneral_16.gif"));
    }

    public IImsDbConnection getUpdatedConnection() {
        return this.updatedConnection;
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public NavigatorFilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    public NavigatorFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void doubleClick(DoubleClickEvent event) {
        try {
            ISelection selection = event.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (((CatalogTreeObject)obj).getType() == "IMS CATALOG CONNECTION") {
                CatalogTreeConnection connNode = (CatalogTreeConnection)obj;
                IImsDbConnection conn = connNode.getConnection();
                if (conn == null) {
                    ImsDbUtils.doConnect((ConnectionProfile)connNode.getConnectionProfile(), (boolean)true);
                }
                return;
            }
            if (obj instanceof CatalogTreeParent) {
                if (((CatalogTreeObject)obj).getType() == "DBD") {
                    Utility.openDBDEditor((CatalogTreeParent)obj);
                } else if (((CatalogTreeObject)obj).getType() == "PSB") {
                    Utility.openPSBEditor((CatalogTreeParent)obj);
                } else if (((CatalogTreeObject)obj).getType() == "PCB DB") {
                    Utility.openPCBEditor((CatalogTreeParent)obj);
                } else if (this.viewer.getTree().getSelection()[0].getExpanded()) {
                    this.viewer.collapseToLevel(obj, 1);
                } else {
                    this.viewer.expandToLevel(obj, 1);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            MessageDialog.openError((Shell)XSwt.getActiveShell(), (String)CatNavMessages.getError().getString("CATNAV_ERROR"), (String)e.getMessage());
        }
    }

    public List<ConnectionProfile> getConnectionProfiles() {
        return ImsDbUtils.getConnectionProfiles();
    }

    public List<String> getConnectionProfileNames() {
        return ImsDbUtils.getConnectionProfileNames();
    }

    public boolean connNameExists(String connName) {
        boolean retVal = false;
        return retVal;
    }

    public IImsDbConnection getImsConnection(String connName) {
        IImsDbConnection retVal = null;
        List<IImsDbConnection> connsList = this.imsConns;
        int i = 0;
        while (i < connsList.size()) {
            IImsDbConnection currConn = connsList.get(i);
            if (currConn.getName().equals(connName)) {
                retVal = currConn;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private void clearConnNode(CatalogTreeConnection connNode) {
        if (connNode != null) {
            CatalogTreeObject[] childNodes = connNode.getChildren();
            if (childNodes != null) {
                int i = 0;
                while (i < childNodes.length) {
                    this.clearTree(childNodes[i]);
                    ++i;
                }
                connNode.removeChildren();
            }
            connNode.clearDbdPsbFolders();
            connNode.clearPsbNodes();
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void refresh(List<CatalogTreeConnection> conns) {
        for (CatalogTreeConnection conn : conns) {
            conn.getDbdFolder().removeChildren();
            conn.getPsbFolder().removeChildren();
            conn.clearPsbNodes();
        }
        this.viewer.refresh();
    }

    private void clearTree(CatalogTreeObject parent) {
        if (parent instanceof CatalogTreeParent) {
            this.viewer.remove((Object)parent);
        }
    }

    public List<String> getPsbList(CatalogTreeConnection treeConnectionNode) throws ImsDbConnectionException {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getPsbList() : null;
    }

    public List<String> getDbdListFromTreeNodes(CatalogTreeConnection treeConnectionNode) {
        CatalogTreeParent dbdFolder = (CatalogTreeParent)treeConnectionNode.getChildren()[0];
        CatalogTreeObject[] dbdNodes = dbdFolder.getChildren();
        ArrayList<String> retVal = new ArrayList<String>(dbdNodes.length);
        int i = 0;
        while (i < dbdNodes.length) {
            retVal.add(dbdNodes[i].getName());
            ++i;
        }
        return retVal;
    }

    public List<String> getPsbListFromTreeNodes(CatalogTreeConnection treeConnectionNode) {
        CatalogTreeParent psbFolder = (CatalogTreeParent)treeConnectionNode.getChildren()[1];
        CatalogTreeObject[] psbNodes = psbFolder.getChildren();
        ArrayList<String> retVal = new ArrayList<String>(psbNodes.length);
        int i = 0;
        while (i < psbNodes.length) {
            retVal.add(psbNodes[i].getName());
            ++i;
        }
        return retVal;
    }

    public List<String> getDbdList(CatalogTreeConnection treeConnectionNode) throws ImsDbConnectionException {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getDbdList() : null;
    }

    public Vector<String[]> getReferencingPsbs(CatalogTreeConnection treeConnectionNode, String dbdName) throws ImsDbConnectionException {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getReferencingPsbs(dbdName) : null;
    }

    public byte[] getActiveDbdXml(CatalogTreeConnection treeConnectionNode, String dbdName) throws ImsDbConnectionException {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getActiveDbdXml(dbdName) : null;
    }

    public byte[] getActivePsbXml(CatalogTreeConnection treeConnectionNode, String psbName) throws ImsDbConnectionException {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getActivePsbXml(psbName) : null;
    }

    public List<String> getDbdAllTSVersions(CatalogTreeConnection treeConnectionNode, String dbdName) throws ImsDbConnectionException {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getDbdAllTSVersions(dbdName) : null;
    }

    public List<String> getPsbAllTSVersions(CatalogTreeConnection treeConnectionNode, String psbName) throws ImsDbConnectionException {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getPsbAllTSVersions(psbName) : null;
    }

    public byte[] getDbdXml(CatalogTreeConnection treeConnectionNode, String dbdName) throws ImsDbConnectionException {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getDbdXml(dbdName) : null;
    }

    public byte[] getDbdXmlByTS(CatalogTreeConnection treeConnectionNode, String dbdName, String timestamp) throws Exception {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getDbdXmlByTS(dbdName, timestamp) : null;
    }

    public byte[] getPsbXmlByTS(CatalogTreeConnection treeConnectionNode, String psbName, String timestamp) throws Exception {
        IImsDbConnection imsConn = treeConnectionNode.getConnection();
        return imsConn != null ? imsConn.getPsbXmlByTS(psbName, timestamp) : null;
    }

    public void processException(Exception e) {
        logger.error((Throwable)e);
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)CatNavMessages.getError().getString("CATNAV_ERROR"), (String)e.getMessage());
    }

    private void searchOrRefresh(boolean isSearch) throws Exception {
        CatalogNav catNav = CatalogNav.getSingletonInstance();
        ISelection selection = this.viewer.getSelection();
        List<CatalogTreeParent> selTreeObjs = Utility.getSelectedNodes(selection);
        List<CatalogTreeConnection> conns = CatalogNav.getImplicatedConns(selTreeObjs);
        if (conns.size() == 0 && catNav.getConnectionProfiles().size() > 0) {
            TreeViewer viewer = catNav.getViewer();
            viewer.refresh(true);
            CatalogViewContentProvider contentProvider = (CatalogViewContentProvider)viewer.getContentProvider();
            CatalogTreeParent parent = (CatalogTreeParent)contentProvider.getInvisibleRoot().getChildren()[0];
            viewer.setExpandedState((Object)parent, true);
            if (parent.hasChildren()) {
                CatalogTreeObject[] connections = parent.getChildren();
                int i = 0;
                while (i < connections.length) {
                    conns.add((CatalogTreeConnection)connections[i]);
                    ++i;
                }
                viewer.setSelection((ISelection)new StructuredSelection(conns), true);
            }
        }
        try {
            if (isSearch) {
                Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                CatalogSearchDialog catSearchDialog = new CatalogSearchDialog(activeShell, CatNavMessages.getLabel().getString("CNSD_TITLE"), selTreeObjs);
                catSearchDialog.open();
            } else {
                catNav.refresh(conns);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void connProfileDisconnected(ConnectionProfile connProf) {
        final CatalogTreeConnection connNode = this.contentProvider.getConnNode(connProf.getId());
        if (connNode != null) {
            connNode.setConnection(null);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CatalogNav.this.clearConnNode(connNode);
                    CatalogNav.this.viewer.expandToLevel(2);
                    CatalogNav.this.viewer.setExpandedState((Object)connNode, false);
                    CatalogNav.this.viewer.refresh();
                    CatalogSearchView searchView = (CatalogSearchView)XSwt.getActivePage().findView("com.ibm.im.ims.catalog.ui.view.search.CatalogSearchView");
                    if (searchView != null) {
                        searchView.deleteTree(connNode.getName());
                    }
                }
            });
        }
    }

    public void connProfileConnected(ConnectionProfile connProf) {
        final CatalogTreeConnection connNode = this.contentProvider.getConnNode(connProf.getId());
        connNode.setConnection(ImsDbUtils.getConnectionById((String)connProf.getId(), (boolean)false));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CatalogNav.this.viewer.expandToLevel(2);
                CatalogNav.this.viewer.setExpandedState((Object)connNode, true);
                CatalogNav.this.viewer.refresh();
            }
        });
    }

    public void connProfileUpdated(ConnectionProfile connProf) {
        CatalogTreeConnection connNode = this.contentProvider.getConnNode(connProf.getId());
        connNode.setName(connProf.getName());
        connNode.setConnectionProfile(connProf);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CatalogNav.this.viewer.expandToLevel(2);
                CatalogNav.this.viewer.refresh();
            }
        });
    }

    public void connProfileAdded(ConnectionProfile connProfile) {
        this.contentProvider.addConnection(connProfile);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CatalogNav.this.viewer.expandToLevel(2);
                CatalogNav.this.viewer.refresh();
            }
        });
    }

    public void connProfileRemoved(ConnectionProfile connProfile) {
        this.contentProvider.removeConnection(connProfile);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CatalogNav.this.viewer.expandToLevel(2);
                CatalogNav.this.viewer.refresh();
            }
        });
    }

    private class NavDecoratingStyledCellLabelProvider
    extends DecoratingStyledCellLabelProvider
    implements ILabelProvider {
        public NavDecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
            super(labelProvider, decorator, decorationContext);
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }
    }
}

