/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreeDbPcb;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreeField;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbJob;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;

public class CatTreeSenseg
extends CatalogTreeParent {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    PcbDBModel parentDbpcb = null;
    SensegModel sensegModel = null;
    SegmentModel segmentModel = null;
    CatTreeSenseg self = null;

    public CatTreeSenseg(SensegModel sensegModel, PcbDBModel dbPcb, CatalogTreeConnection connNode) {
        super(sensegModel.getName(), "SENSEG", connNode);
        this.parentDbpcb = dbPcb;
        this.sensegModel = sensegModel;
        this.self = this;
    }

    @Override
    public CatalogTreeObject[] getChildren() {
        CatalogTreeObject[] retVal = new CatalogTreeObject[]{};
        try {
            CatTreeDbPcb parent = (CatTreeDbPcb)this.getParent();
            if (parent.getDbdModel() == null) {
                CatalogTreeParent newPending = new CatalogTreeParent(CatNavMessages.getDescription().getString("CN_PENDING"), "PENDING");
                retVal = new CatalogTreeObject[]{newPending};
                this.populateDbdModelFromCatalogAsync();
            } else {
                ArrayList senfields = this.sensegModel.getSenfields();
                if (senfields.size() == 0) {
                    this.segmentModel = parent.getDbdModel().getSegment(this.sensegModel.getName());
                    Vector fields = this.segmentModel.getFieldList(false, false);
                    retVal = new CatalogTreeObject[fields.size()];
                    int i = 0;
                    while (i < fields.size()) {
                        FieldModel currField = (FieldModel)fields.get(i);
                        retVal[i] = new CatTreeField(currField, this.segmentModel, this.sensegModel);
                        retVal[i].setParent(this);
                        this.addChild(retVal[i]);
                        ++i;
                    }
                } else {
                    retVal = new CatalogTreeObject[senfields.size()];
                    int i = 0;
                    while (i < senfields.size()) {
                        SenfieldModel currSenfield = (SenfieldModel)senfields.get(i);
                        retVal[i] = new CatalogTreeObject(currSenfield.getName(), "FIELD");
                        retVal[i].setParent(this);
                        ++i;
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error(t);
        }
        return retVal;
    }

    public void populateDbdModelFromCatalogAsync() throws InterruptedException {
        ImsDbJob job = new ImsDbJob(CatNavMessages.getDescription().getString("CN_LOAD_DBD_META_JOB")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    byte[] xml;
                    CatalogTreeConnection connNode = CatTreeSenseg.this.getTreeConnectionNode();
                    this.setName(CatNavMessages.getDescription().getString("CN_LOAD_DBD_META_JOB_CONN", new Object[]{this.getResourceName(), connNode.getName()}));
                    IImsDbConnection conn = connNode.getConnection();
                    if (conn != null && (xml = conn.getDbdXml(this.getResourceName())) != null && xml.length > 0) {
                        CatTreeDbPcb parent = (CatTreeDbPcb)CatTreeSenseg.this.getParent();
                        parent.setDbdModel(new DbdModel((InputStream)new ByteArrayInputStream(xml)));
                    }
                }
                catch (Throwable t) {
                    logger.error(t);
                    this.addError(t);
                }
                if (!this.getErrors().isEmpty()) {
                    this.displayErrorDialog();
                }
                return Status.OK_STATUS;
            }
        };
        job.setResourceName(((CatTreeDbPcb)this.getParent()).getDbdName());
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CatalogNav.getSingletonInstance().refresh((this).CatTreeSenseg.this.self);
                    }
                });
            }
        });
    }

    public String getParentSegmentName() {
        String retVal = null;
        SensegModel parent = this.sensegModel.getParent();
        if (parent != null) {
            retVal = parent.getName();
        }
        return retVal;
    }
}

