/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreeDbPcb;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbJob;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;

public class CatTreePsbModel
extends CatalogTreeParent {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public boolean isUserPsbConnection = false;
    public boolean isCatalogPsbConnection = false;
    private PsbModel psbModel = null;
    private CatTreePsbModel self = this;

    public CatTreePsbModel(String name, CatalogTreeConnection connNode) {
        super(name, "PSB", connNode);
    }

    public void populatePsbModelFromCatalogAsync() {
        ImsDbJob job = new ImsDbJob(CatNavMessages.getDescription().getString("CN_LOAD_PSB_META_JOB")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CatalogTreeConnection connNode = CatTreePsbModel.this.getTreeConnectionNode();
                    String projectName = connNode.getProjectName();
                    if (projectName != null && !projectName.isEmpty() && !this.getResourceName().equals("DFSCP000")) {
                        IFile psbFile = ProjectTreeFileHelper.getPsbMetadataFile((String)projectName, (String)this.getResourceName());
                        this.setName(CatNavMessages.getDescription().getString("CN_LOAD_PSB_META_JOB_FILE", new Object[]{this.getResourceName(), psbFile.getName()}));
                        if (psbFile.exists()) {
                            CatTreePsbModel.this.psbModel = new PsbModel(psbFile.getContents());
                        }
                    } else {
                        byte[] psbXml;
                        this.setName(CatNavMessages.getDescription().getString("CN_LOAD_PSB_META_JOB_CONN", new Object[]{this.getResourceName(), connNode.getName()}));
                        IImsDbConnection conn = connNode.getConnection();
                        if (conn != null && (psbXml = CatTreePsbModel.this.getConnection().getPsbXml(this.getResourceName())) != null && psbXml.length > 0) {
                            CatTreePsbModel.this.psbModel = new PsbModel((InputStream)new ByteArrayInputStream(psbXml));
                        }
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CatalogNav.getSingletonInstance().refresh();
                        }
                    });
                }
                catch (Throwable t) {
                    logger.error(t);
                    this.addError(t);
                }
                if (!this.getErrors().isEmpty()) {
                    this.displayErrorDialog();
                }
                return Status.OK_STATUS;
            }
        };
        job.setResourceName(this.getName());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CatalogNav.getSingletonInstance().refresh((this).CatTreePsbModel.this.self);
                    }
                });
            }
        });
        job.schedule();
    }

    public PsbModel getPsbModel() {
        return this.psbModel;
    }

    @Override
    public CatalogTreeObject[] getChildren() {
        CatalogTreeObject[] retVal = new CatalogTreeObject[]{};
        if (this.psbModel == null) {
            CatalogTreeParent newPending = new CatalogTreeParent(CatNavMessages.getDescription().getString("CN_PENDING"), "PENDING");
            retVal = new CatalogTreeObject[]{newPending};
            this.populatePsbModelFromCatalogAsync();
        } else {
            List dbPcbs = this.psbModel.getDBPcbList();
            retVal = new CatalogTreeObject[dbPcbs.size()];
            int i = 0;
            while (i < dbPcbs.size()) {
                PcbDBModel currPcb = (PcbDBModel)dbPcbs.get(i);
                retVal[i] = new CatTreeDbPcb(currPcb.getPcbAlias(), currPcb, this.psbModel, this.getTreeConnectionNode());
                retVal[i].setParent(this);
                this.addChild(retVal[i]);
                ++i;
            }
        }
        return retVal;
    }
}

