/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.utilities;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.utilities.SearchPsbRunnable;
import com.ibm.im.ims.catalog.ui.utilities.SearchRunnable;
import com.ibm.im.ims.catalog.ui.view.nav.Activator;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreeDbPcb;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreeField;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.search.CatalogSearchView;
import com.ibm.im.ims.metadata.driver.connections.UnivDriverConnectionType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbJob;
import com.ibm.im.ims.workbench.imsdb.connections.utils.JDBCURL;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.ui.navigator.actions.ManageGraphicalAction;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class Utility {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<String, ImageDescriptor> imageCache;
    private static final IExplorerLogger logger;

    static {
        logger = ExplorerLogger.instance();
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        ImageDescriptor img;
        if (imageCache == null) {
            imageCache = new HashMap<String, ImageDescriptor>();
        }
        if ((img = imageCache.get(fileName)) == null || img.equals(ImageDescriptor.getMissingImageDescriptor())) {
            Bundle bundle = Activator.getDefault().getBundle();
            Path iconPath = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)bundle, (IPath)iconPath, null);
            img = ImageDescriptor.createFromURL((URL)url);
            imageCache.put(fileName, img);
        }
        return img;
    }

    public static URL getURL(String path) {
        try {
            Activator plugin = Activator.getDefault();
            URL installURL = plugin.getBundle().getEntry(File.separator);
            URL url = FileLocator.resolve((URL)installURL);
            return new URL(url, path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getTextWidth(Composite composite, int style, String label) {
        Text text = new Text(composite, style);
        text.setText(label);
        text.setFont(composite.getFont());
        int retVal = text.computeSize((int)-1, (int)-1).x;
        text.dispose();
        return retVal;
    }

    public static int getMaxSize(int[] labelSize) {
        Arrays.sort(labelSize);
        return labelSize[labelSize.length - 1];
    }

    public static String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        Utility.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private static void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        if (!newEntry.isEmpty()) {
            history.add(0, newEntry);
        }
    }

    public static IDialogSettings getDialogSettings(String sectionID) {
        IDialogSettings settings = WorkbenchPlugin.getDefault().getDialogSettings();
        if (settings == null) {
            settings = WorkbenchPlugin.getDefault().getDialogSettings().addNewSection(sectionID);
        } else {
            settings = WorkbenchPlugin.getDefault().getDialogSettings().getSection(sectionID);
            if (settings == null) {
                settings = WorkbenchPlugin.getDefault().getDialogSettings().addNewSection(sectionID);
            }
        }
        return settings;
    }

    public static List<CatalogTreeParent> getSelectedNodes(ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection selection = null;
        if (part instanceof CatalogNav) {
            selection = ((CatalogNav)part).getViewer().getSelection();
        } else if (part instanceof CatalogSearchView) {
            selection = ((CatalogSearchView)part).getViewer().getSelection();
        }
        return Utility.getSelectedNodes(selection);
    }

    public static List<CatalogTreeParent> getSelectedNodes(ISelection selection) {
        ArrayList<CatalogTreeParent> treeParents = new ArrayList<CatalogTreeParent>();
        if (selection instanceof TreeSelection) {
            TreeSelection currSel = (TreeSelection)selection;
            for (Object selectedNode : currSel) {
                if (selectedNode instanceof CatTreeField) {
                    selectedNode = ((CatTreeField)selectedNode).getParent();
                }
                CatalogTreeParent obj = (CatalogTreeParent)selectedNode;
                treeParents.add(obj);
            }
        }
        return treeParents;
    }

    public static void openDBDEditor(final CatalogTreeParent selTreeObj) throws Exception {
        ImsDbJob job = new ImsDbJob(CatNavMessages.getDescription().getString("CN_OPEN_DBD_EDITOR_JOB")){
            final String ResourceMultiPageEditorDbdId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd";
            {
                super($anonymous0);
                this.ResourceMultiPageEditorDbdId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd";
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CatalogTreeParent obj = (CatalogTreeParent)selTreeObj.getAllInstancesSearchSubject();
                    if (obj == null) {
                        obj = selTreeObj;
                    }
                    String instanceTs = selTreeObj.getInstanceTimestamp();
                    String objName = obj.getName();
                    if (obj.getType().equals("PCB DB")) {
                        objName = ((CatTreeDbPcb)obj).getDbdName();
                    }
                    CatalogTreeConnection connNode = selTreeObj.getTreeConnectionNode();
                    this.setName(CatNavMessages.getDescription().getString("CN_OPEN_DBD_EDITOR_JOB_CONN", new Object[]{objName, connNode.getName()}));
                    IImsDbConnection imsConn = connNode.getConnection();
                    byte[] xml = null;
                    xml = instanceTs == null || instanceTs.isEmpty() ? imsConn.getDbdXml(objName) : imsConn.getDbdXmlByTS(objName, instanceTs);
                    DbdModel dbdModel = new DbdModel((InputStream)new ByteArrayInputStream(xml));
                    IFile dbdFile = ProjectTreeFileHelper.marshallDbdToReadOnlyProject((DbdModel)dbdModel);
                    Display.getDefault().asyncExec(() -> {
                        try {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            com.ibm.im.ims.workbench.model.utilities.Utility.closeOpenedEditorForResourceFile((IFile)dbdFile, (String)"IMS_Explorer_Catalog_ReadOnly");
                            page.openEditor((IEditorInput)new FileEditorInput(dbdFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                            if (dbdModel.getAccessType() != DBDConstants.LOGICAL) {
                                SearchRunnable popOp = new SearchRunnable(connNode, dbdModel, false);
                                new ProgressMonitorDialog(XSwt.getActiveShell()).run(true, true, (IRunnableWithProgress)popOp);
                            }
                        }
                        catch (Throwable t) {
                            logger.error(t);
                            this.addError(t);
                        }
                    });
                }
                catch (Throwable t) {
                    logger.error(t);
                    this.addError(t);
                }
                if (!this.getErrors().isEmpty()) {
                    this.displayErrorDialog();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void openPSBEditor(final CatalogTreeObject viewNode) throws Exception {
        ImsDbJob job = new ImsDbJob(CatNavMessages.getDescription().getString("CN_OPEN_PSB_EDITOR_JOB")){
            final String ResourceMultiPageEditorPsbId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb";
            {
                super($anonymous0);
                this.ResourceMultiPageEditorPsbId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb";
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CatalogTreeObject actualSubjectNode = viewNode.getAllInstancesSearchSubject();
                    if (actualSubjectNode == null) {
                        actualSubjectNode = viewNode;
                    }
                    String psbName = actualSubjectNode.getName();
                    String instanceTs = actualSubjectNode.getInstanceTimestamp();
                    if (viewNode.getType().equals("PCB DB")) {
                        psbName = ((CatTreeDbPcb)viewNode).getPsbModel().getPsbName();
                    }
                    CatalogTreeConnection connNode = viewNode.getTreeConnectionNode();
                    this.setName(CatNavMessages.getDescription().getString("CN_OPEN_PSB_EDITOR_JOB_CONN", new Object[]{psbName, connNode.getName()}));
                    IImsDbConnection imsConn = connNode.getConnection();
                    byte[] xml = null;
                    xml = instanceTs == null || instanceTs.isEmpty() ? imsConn.getPsbXml(psbName) : imsConn.getPsbXmlByTS(psbName, instanceTs);
                    if (xml != null && xml.length > 0) {
                        PsbModel psbModel = new PsbModel((InputStream)new ByteArrayInputStream(xml));
                        IFile psbFile = ProjectTreeFileHelper.getPsbCatalogMetadataFile((PsbModel)psbModel);
                        Display.getDefault().asyncExec(() -> {
                            try {
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage page = window.getActivePage();
                                com.ibm.im.ims.workbench.model.utilities.Utility.closeOpenedEditorForResourceFile((IFile)psbFile, (String)"IMS_Explorer_Catalog_ReadOnly");
                                page.openEditor((IEditorInput)new FileEditorInput(psbFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb");
                                SearchPsbRunnable popOp = new SearchPsbRunnable(connNode, psbModel);
                                new ProgressMonitorDialog(XSwt.getActiveShell()).run(true, true, (IRunnableWithProgress)popOp);
                            }
                            catch (Throwable t) {
                                logger.error(t);
                                this.addError(t);
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    logger.error(t);
                    this.addError(t);
                }
                if (!this.getErrors().isEmpty()) {
                    this.displayErrorDialog();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void openPCBEditor(final CatalogTreeParent selTreeObj) {
        ImsDbJob job = new ImsDbJob(CatNavMessages.getDescription().getString("CN_OPEN_PCB_EDITOR_JOB")){
            final String ResourceMultiPageEditorPsbId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb";
            {
                super($anonymous0);
                this.ResourceMultiPageEditorPsbId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb";
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String psbName = selTreeObj.getParent().getName();
                    CatalogTreeConnection connNode = selTreeObj.getTreeConnectionNode();
                    this.setName(CatNavMessages.getDescription().getString("CN_OPEN_PCB_EDITOR_JOB_CONN", new Object[]{psbName, connNode.getName()}));
                    IImsDbConnection imsConn = connNode.getConnection();
                    byte[] xml = imsConn.getPsbXml(psbName);
                    PsbModel psbModel = new PsbModel((InputStream)new ByteArrayInputStream(xml));
                    IFile psbFile = ProjectTreeFileHelper.getPsbCatalogMetadataFile((PsbModel)psbModel);
                    Display.getDefault().asyncExec(() -> {
                        try {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            ResourceMultiPageEditor psbEditor = null;
                            IViewPart vp = page.findView("com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb");
                            psbEditor = vp == null ? (ResourceMultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(psbFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb") : (ResourceMultiPageEditor)vp;
                            ManageGraphicalAction.openPcbGraphicalEditor((ResourceMultiPageEditor)psbEditor, (IWorkbenchWindow)window, (String)selTreeObj.getName());
                        }
                        catch (Throwable t) {
                            this.addError(t);
                        }
                    });
                }
                catch (Throwable t) {
                    this.addError(t);
                }
                if (!this.getErrors().isEmpty()) {
                    this.displayErrorDialog();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static UnivDriverConnectionType intializeConnection(String newConnectionProfileName, String newConnectionName, JDBCURL url) {
        UnivDriverConnectionType newConn = new UnivDriverConnectionType();
        newConn.setConnName(newConnectionName);
        newConn.setCurrentSchema(url.getCurrentSchema());
        newConn.setDpsbOnCommit(Boolean.valueOf(true));
        newConn.setDtpConnProfileName(newConnectionProfileName);
        newConn.setIpAddr(url.getDatastoreServer());
        String loginTimeoutStr = url.getLoginTimeout();
        if (loginTimeoutStr != null && !loginTimeoutStr.isEmpty()) {
            newConn.setLoginTimeout(new BigInteger(loginTimeoutStr, 10));
        }
        newConn.setPort(url.getPort());
        newConn.setPsbName(url.getPsbName());
        newConn.setSslConnection(Boolean.valueOf(url.getSslConnection()));
        newConn.setTraceDirectory(url.getTraceDirectory());
        newConn.setTraceFile(url.getTraceFile());
        newConn.setTraceFileAppend(Boolean.valueOf(url.getTraceFileAppend()));
        String traceLevelStr = url.getTraceLevel();
        if (traceLevelStr != null && !traceLevelStr.isEmpty()) {
            newConn.setTraceLevel(new BigInteger(traceLevelStr, 10));
        }
        Properties origAdditionalProps = url.getAdditionalProperties();
        newConn.setDatastoreName(origAdditionalProps.getProperty("datastoreName"));
        newConn.setFetchSize(new BigInteger(origAdditionalProps.getProperty("fetchSize"), 10));
        List newAdditionalPropList = newConn.getAdditionalProperty();
        for (String propName : origAdditionalProps.stringPropertyNames()) {
            if (propName.equals("datastoreName") || propName.equals("fetchSize")) continue;
            String propValue = origAdditionalProps.getProperty(propName);
            newAdditionalPropList.add(propName + "=" + propValue + ";");
        }
        return newConn;
    }
}

