/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.utilities;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.MissingDBDException;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.dli.DLIException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SearchRunnable
implements IRunnableWithProgress {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Vector<String> relatedDbds = new Vector();
    private Vector<LogicalRelationshipModel> logicalRelationships = new Vector();
    private CatalogTreeConnection connNode;
    private DbdModel dbdModel;
    private boolean isLogicalDbd;

    public SearchRunnable(CatalogTreeConnection connNode, DbdModel dbdModel, boolean isLogicalDbd) {
        this.dbdModel = dbdModel;
        this.connNode = connNode;
        this.isLogicalDbd = isLogicalDbd;
    }

    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        String dbdName = this.dbdModel.getDBDName();
        if (logger.isLoggable(Level.FINER)) {
            String parm = this.connNode.getName() + "." + dbdName;
            logger.entering(this.getClass().getName(), "run(IProgressMonitor monitor)", new Object[]{parm});
        }
        try {
            if (!this.isLogicalDbd) {
                if (this.dbdModel.getAccessType() != DBDConstants.GSAM) {
                    monitor.beginTask(CatNavMessages.getLabel().getString("CNS_SEARCH_PROGRESS_INDICATOR_RELATED_DBDS", (Object[])new String[]{dbdName}), -1);
                    this.relatedDbds.add(dbdName);
                    this.populateLogicalRelsForDbd(this.dbdModel.getRootSegment(), this.dbdModel, monitor);
                    int listSize = this.relatedDbds.size();
                    if (listSize > 0) {
                        int i = 0;
                        while (i < listSize) {
                            String currDbdName = this.relatedDbds.get(i);
                            if (monitor.isCanceled()) {
                                logger.finer("Importing of new logically related DBD " + currDbdName + " is cancelled.");
                                break;
                            }
                            this.importRelatedDbdToReadOnlyProject(currDbdName);
                            ++i;
                        }
                    }
                }
            } else {
                monitor.beginTask(CatNavMessages.getLabel().getString("CNS_SEARCH_PROGRESS_INDICATOR_PHYSICAL_DBDS", (Object[])new String[]{dbdName}), -1);
                this.getSourceDBDNameList(this.dbdModel.getRootSegment());
                int listSize = this.relatedDbds.size();
                if (listSize > 0) {
                    int i = 0;
                    while (i < listSize) {
                        String currDbdName = this.relatedDbds.get(i);
                        if (monitor.isCanceled()) {
                            logger.finer("Importing of physical DBD " + currDbdName + " is cancelled.");
                            break;
                        }
                        this.importRelatedDbdToReadOnlyProject(currDbdName);
                        ++i;
                    }
                }
            }
            monitor.done();
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "run(IProgressMonitor monitor)", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            String parm = this.connNode.getName() + "." + dbdName;
            logger.exiting(this.getClass().getName(), "run(IProgressMonitor monitor)", new Object[]{parm});
        }
    }

    private void getSourceDBDNameList(SegmentModel segmentModel) throws MissingDBDException, ModelException, InvalidDBDSourceException {
        if (logger.isLoggable(Level.FINER)) {
            String parm = segmentModel.getDbdName() + "." + segmentModel.getImsName();
            logger.entering(this.getClass().getName(), "getSourceDBDNameList(SegmentModel segment)", new Object[]{parm});
        }
        this.getLogicalSourceDBDNamesForSegment(segmentModel);
        for (SegmentModel childSeg : segmentModel.getChildSegments()) {
            this.getSourceDBDNameList(childSeg);
        }
        if (logger.isLoggable(Level.FINER)) {
            String parm = segmentModel.getDbdName() + "." + segmentModel.getImsName();
            logger.exiting(this.getClass().getName(), "getSourceDBDNameList(SegmentModel segment)", new Object[]{parm});
        }
    }

    private void getLogicalSourceDBDNamesForSegment(SegmentModel segmentModel) throws MissingDBDException, ModelException, InvalidDBDSourceException {
        if (logger.isLoggable(Level.FINER)) {
            String parm = segmentModel.getDbdName() + "." + segmentModel.getImsName();
            logger.entering(this.getClass().getName(), "getLogicalSourceDBDNamesForSegment(SegmentModel segment)", new Object[]{parm});
        }
        if (segmentModel.hasSegmentSource()) {
            newSourceDbdName = segmentModel.getSegmentSourceDBName();
            if (!this.isDbdInList(newSourceDbdName)) {
                this.relatedDbds.add(newSourceDbdName);
            }
        } else if (segmentModel.hasConcatenatedSegmentSource()) {
            newSourceDbdName = segmentModel.getLogicalChildSourceDBName();
            if (!this.isDbdInList(newSourceDbdName)) {
                this.relatedDbds.add(newSourceDbdName);
            }
            if (!this.isDbdInList(newSourceDbdName = segmentModel.getTargetParentSourceDBName())) {
                this.relatedDbds.add(newSourceDbdName);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            String parm = segmentModel.getDbdName() + "." + segmentModel.getImsName();
            logger.exiting(this.getClass().getName(), "getLogicalSourceDBDNamesForSegment(SegmentModel segment)", new Object[]{parm});
        }
    }

    private LogicalRelationshipModel getLogicalRel(String logicalParentSegment, String logicalParentDbd, String realLogicalChildSegment, String realLogicalChildDbd, Vector<LogicalRelationshipModel> logicalRels) {
        LogicalRelationshipModel retVal = null;
        int i = 0;
        while (i < logicalRels.size()) {
            LogicalRelationshipModel temp = logicalRels.elementAt(i);
            if (temp.getLogicalParentDbd() != null && temp.getLogicalParentDbd().equalsIgnoreCase(logicalParentDbd) && temp.getLogicalParentSegment() != null && temp.getLogicalParentSegment().equalsIgnoreCase(logicalParentSegment) && temp.getRealLogicalChildDbd() != null && temp.getRealLogicalChildDbd().equalsIgnoreCase(realLogicalChildDbd) && temp.getRealLogicalChildSegment() != null && temp.getRealLogicalChildSegment().equalsIgnoreCase(realLogicalChildSegment)) {
                retVal = temp;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private DbdModel importRelatedDbdToReadOnlyProject(String dbdName) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            String parm = this.dbdModel.getDBDName();
            logger.entering(this.getClass().getName(), "importRelatedDbdToReadOnlyProject(DbdModel dbdModel)", new Object[]{parm});
        }
        CatalogNav catNav = CatalogNav.getSingletonInstance();
        byte[] currXml = catNav.getDbdXml(this.connNode, dbdName);
        DbdModel currDbdModel = new DbdModel((InputStream)new ByteArrayInputStream(currXml));
        ProjectTreeFileHelper.marshallDbdToReadOnlyProject((DbdModel)currDbdModel);
        if (logger.isLoggable(Level.FINER)) {
            String parm = this.dbdModel.getDBDName();
            logger.exiting(this.getClass().getName(), "importRelatedDbdToReadOnlyProject(DbdModel dbdModel)", new Object[]{parm});
        }
        return currDbdModel;
    }

    private void populateLogicalRelsForDbd(SegmentModel segmentModel, DbdModel dbdModel, IProgressMonitor monitor) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            String parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.entering(this.getClass().getName(), "populateLogicalRelsForDbd(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
        this.populateLogicalRelsForSegment(segmentModel, dbdModel, monitor);
        for (SegmentModel childSeg : segmentModel.getChildSegments()) {
            this.populateLogicalRelsForDbd(childSeg, dbdModel, monitor);
        }
        if (logger.isLoggable(Level.FINER)) {
            String parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.exiting(this.getClass().getName(), "populateLogicalRelsForDbd(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
    }

    private void populateLogicalRelsForSegment(SegmentModel segmentModel, DbdModel dbdModel, IProgressMonitor monitor) throws Exception {
        String parm;
        if (logger.isLoggable(Level.FINER)) {
            parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.entering(this.getClass().getName(), "populateLogicalRelsForSegment(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
        this.populateLogicalParentRels(segmentModel, dbdModel, monitor);
        this.populateVirtualLogicalChildRels(segmentModel, dbdModel);
        this.populateRealLogicalChildRels(segmentModel, dbdModel, monitor);
        if (logger.isLoggable(Level.FINER)) {
            parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.exiting(this.getClass().getName(), "populateLogicalRelsForSegment(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
    }

    private void populateRealLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel, IProgressMonitor monitor) throws Exception {
        String parm;
        block14: {
            if (logger.isLoggable(Level.FINER)) {
                parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
                logger.entering(this.getClass().getName(), "populateRealLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
            }
            if (segmentModel.isRealLogicalChild()) {
                String relatedDbdName;
                LogicalRelationshipModel logicalRel = this.getLogicalRel(segmentModel.getLogicalParentName(), segmentModel.getLogicalParentDbdName(), segmentModel.getImsName(), dbdModel.getDbd().getDbdName(), this.logicalRelationships);
                boolean logicalRelAlreadyAdded = false;
                if (logicalRel == null) {
                    logicalRel = new LogicalRelationshipModel();
                    logicalRel.setLogicalParentDbd(segmentModel.getLogicalParentDbdName());
                    logicalRel.setLogicalParentSegment(segmentModel.getLogicalParentName());
                    logicalRel.setRealLogicalChild(segmentModel);
                    this.logicalRelationships.add(logicalRel);
                } else {
                    logicalRelAlreadyAdded = true;
                    logicalRel.setRealLogicalChild(segmentModel);
                }
                if (logger.isLoggable(Level.FINER)) {
                    String traceStr = "Logical relationship found. Real Logical Child: " + logicalRel.getRealLogicalChildDbd() + "." + logicalRel.getRealLogicalChildSegment() + " Logical Parent: " + logicalRel.getLogicalParentDbd() + "." + logicalRel.getLogicalParentSegment();
                    if (logicalRelAlreadyAdded) {
                        traceStr = traceStr + " - Logical Rel had already been added.";
                    }
                    logger.finer(traceStr);
                }
                if (!this.isDbdInList(relatedDbdName = logicalRel.getLogicalParentDbd())) {
                    logger.finer("New logically related DBD " + relatedDbdName + " is not in the list. Reading it in now...");
                    try {
                        if (!monitor.isCanceled()) {
                            DbdModel newDb = this.importRelatedDbdToReadOnlyProject(relatedDbdName);
                            if (newDb != null) {
                                this.relatedDbds.addElement(relatedDbdName);
                                this.populateLogicalRelsForDbd(newDb.getRootSegment(), newDb, monitor);
                            } else {
                                logger.finer("Failed to read the new logically related DBD " + relatedDbdName + ".");
                            }
                            break block14;
                        }
                        logger.finer("Importing of new logically related DBD " + relatedDbdName + " is cancelled.");
                    }
                    catch (CoreException e) {
                        logger.throwing(this.getClass().getName(), "populateRealLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel)", (Throwable)e);
                        logger.error((Throwable)e);
                    }
                } else {
                    logger.finer("New logically related DBD " + relatedDbdName + " was already in the logicallyRelatedDBDs list.");
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.exiting(this.getClass().getName(), "populateRealLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
    }

    private void populateVirtualLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel) throws MissingDBDException, ModelException, InvalidDBDSourceException, DLIException, SQLException, CoreException {
        String parm;
        if (logger.isLoggable(Level.FINER)) {
            parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.entering(this.getClass().getName(), "populateVirtualLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
        if (segmentModel.isVirtualLogicalChild()) {
            String parentSegStr = segmentModel.getParent().getImsName();
            LogicalRelationshipModel logicalRel = this.getLogicalRel(parentSegStr, dbdModel.getDbd().getDbdName(), segmentModel.getSegmentSourceSegName(), segmentModel.getSegmentSourceDBName(), this.logicalRelationships);
            boolean logicalRelAlreadyAdded = false;
            if (logicalRel == null) {
                logicalRel = new LogicalRelationshipModel();
                logicalRel.setVirtualLogicalChild(segmentModel);
                this.logicalRelationships.add(logicalRel);
            } else {
                logicalRelAlreadyAdded = true;
                logicalRel.setVirtualLogicalChild(segmentModel);
            }
            if (logger.isLoggable(Level.FINER)) {
                String traceStr = "Logical relationship found. Virtual Logical Child: " + segmentModel.getDbdName() + "." + logicalRel.getVirtualLogicalChildSegment() + " Real Logical Child: " + logicalRel.getRealLogicalChildDbd() + "." + logicalRel.getRealLogicalChildSegment();
                if (logicalRelAlreadyAdded) {
                    traceStr = traceStr + " - Logical Rel had already been added.";
                }
                logger.finer(traceStr);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.exiting(this.getClass().getName(), "populateVirtualLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
    }

    private void populateLogicalParentRels(SegmentModel segmentModel, DbdModel dbdModel, IProgressMonitor monitor) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            String parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.entering(this.getClass().getName(), "populateLogicalParentRels(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
        for (LogicalChildModel logicalChild : segmentModel.getLogicalChildList()) {
            String relatedDbdName;
            if (logicalChild.getPointer() == DBDConstants.INDX || logicalChild.getPointer() == DBDConstants.SYMB) continue;
            LogicalRelationshipModel logicalRel = this.getLogicalRel(segmentModel.getImsName(), dbdModel.getDBDName(), logicalChild.getName(), logicalChild.getDbd(), this.logicalRelationships);
            boolean logicalRelAlreadyAdded = false;
            if (logicalRel == null) {
                logicalRel = new LogicalRelationshipModel();
                logicalRel.setLogicalParent(segmentModel);
                logicalRel.setRealLogicalChildDbd(logicalChild.getDbd());
                logicalRel.setRealLogicalChildSegment(logicalChild.getName());
                this.logicalRelationships.add(logicalRel);
            } else {
                logicalRelAlreadyAdded = true;
                logicalRel.setLogicalParent(segmentModel);
            }
            if (logger.isLoggable(Level.FINER)) {
                String traceStr = "Logical relationship found. Logical Parent: " + dbdModel.getDBDName() + "." + logicalRel.getLogicalParentSegment() + " Real Logical Child: " + logicalRel.getRealLogicalChildDbd() + "." + logicalRel.getRealLogicalChildSegment();
                if (logicalRelAlreadyAdded) {
                    traceStr = traceStr + " - Logical Rel had already been added.";
                }
                logger.finer(traceStr);
            }
            if (!this.isDbdInList(relatedDbdName = logicalRel.getRealLogicalChildDbd())) {
                logger.finer("New logically related DBD " + relatedDbdName + " is not in the list. Reading it in now...");
                try {
                    DbdModel newDb = this.importRelatedDbdToReadOnlyProject(relatedDbdName);
                    if (newDb != null) {
                        this.relatedDbds.addElement(relatedDbdName);
                        this.populateLogicalRelsForDbd(newDb.getRootSegment(), newDb, monitor);
                        continue;
                    }
                    logger.finer("Failed to read the new logically related DBD " + relatedDbdName + ".");
                }
                catch (CoreException e) {
                    logger.throwing(this.getClass().getName(), "populateLogicalParentRels(SegmentModel segmentModel, DbdModel dbdModel)", (Throwable)e);
                    logger.error((Throwable)e);
                }
                continue;
            }
            logger.finer("New logically related DBD " + relatedDbdName + " was already in the logicallyRelatedDBDs list.");
        }
        if (logger.isLoggable(Level.FINER)) {
            String parm = dbdModel.getDBDName() + "." + segmentModel.getImsName();
            logger.exiting(this.getClass().getName(), "populateLogicalParentRels(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
    }

    private boolean isDbdInList(String dbdName) {
        boolean retVal = false;
        if (dbdName == null) {
            retVal = true;
        } else {
            Iterator<String> iter = this.relatedDbds.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(dbdName)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    class LogicalRelationshipModel {
        private SegmentModel logicalParent;
        private SegmentModel realLogicalChild;
        private SegmentModel virtualLogicalChild;
        private String logicalParentDbdStr;
        private String logicalParentSegmentStr;
        private String realLogicalChildDbdStr;
        private String realLogicalChildSegmentStr;
        private String virtualLogicalChildSegmentStr;

        LogicalRelationshipModel() {
        }

        public SegmentModel getLogicalParent() {
            return this.logicalParent;
        }

        public SegmentModel getRealLogicalChild() {
            return this.realLogicalChild;
        }

        public SegmentModel getVirtualLogicalChild() {
            return this.virtualLogicalChild;
        }

        public String getLogicalParentDbd() {
            if (this.logicalParent == null) {
                return this.logicalParentDbdStr;
            }
            return this.logicalParent.getDbdModel().getDbd().getDbdName();
        }

        public String getLogicalParentSegment() {
            if (this.logicalParent == null) {
                return this.logicalParentSegmentStr;
            }
            return this.logicalParent.getImsName();
        }

        public String getRealLogicalChildDbd() {
            if (this.realLogicalChild == null) {
                return this.realLogicalChildDbdStr;
            }
            return this.realLogicalChild.getDbdModel().getDbd().getDbdName();
        }

        public String getRealLogicalChildSegment() {
            if (this.realLogicalChild == null) {
                return this.realLogicalChildSegmentStr;
            }
            return this.realLogicalChild.getImsName();
        }

        public String getVirtualLogicalChildSegment() {
            if (this.virtualLogicalChild == null) {
                return this.virtualLogicalChildSegmentStr;
            }
            return this.virtualLogicalChild.getImsName();
        }

        public void setLogicalParentDbd(String logicalParentDbd) {
            this.logicalParentDbdStr = logicalParentDbd;
        }

        public void setVirtualLogicalChildSegment(String virtualLogicalChildSegment) {
            this.virtualLogicalChildSegmentStr = virtualLogicalChildSegment;
        }

        public void setRealLogicalChildSegment(String realLogicalChildSegment) {
            this.realLogicalChildSegmentStr = realLogicalChildSegment;
        }

        public void setRealLogicalChildDbd(String realLogicalChildDbd) {
            this.realLogicalChildDbdStr = realLogicalChildDbd;
        }

        public void setLogicalParentSegment(String logicalParentSegment) {
            this.logicalParentSegmentStr = logicalParentSegment;
        }

        public void setLogicalParent(SegmentModel logicalParent) {
            this.logicalParent = logicalParent;
        }

        public void setRealLogicalChild(SegmentModel realLogicalChild) {
            this.realLogicalChild = realLogicalChild;
        }

        public void setVirtualLogicalChild(SegmentModel virtualLogicalChild) {
            this.virtualLogicalChild = virtualLogicalChild;
        }
    }
}

