/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.utilities;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SearchPsbRunnable
implements IRunnableWithProgress {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private CatalogTreeConnection connNode;
    private PsbModel psbModel;

    public SearchPsbRunnable(CatalogTreeConnection connNode, PsbModel psbModel) {
        this.psbModel = psbModel;
        this.connNode = connNode;
    }

    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        List dbPcbList = this.psbModel.getDBPcbList();
        String psbName = this.psbModel.getPsbName();
        if (logger.isLoggable(Level.FINER)) {
            String parm = this.connNode.getName() + "." + psbName;
            logger.entering(this.getClass().getName(), "run(IProgressMonitor monitor)", new Object[]{parm});
        }
        try {
            if (dbPcbList != null) {
                int numDbPcbs = dbPcbList.size();
                int startPcbNum = 1;
                List tpPcbs = this.psbModel.getTPPcbList();
                if (tpPcbs != null) {
                    startPcbNum += tpPcbs.size();
                }
                if (numDbPcbs > 0) {
                    int i = 0;
                    while (i < numDbPcbs) {
                        PcbDBModel currPcb = (PcbDBModel)dbPcbList.get(i);
                        String pcbName = currPcb.getPcbNameOrLabel();
                        if (pcbName == null) {
                            pcbName = String.valueOf(startPcbNum + i);
                        }
                        String currDbdName = currPcb.getDbdName();
                        if (monitor.isCanceled()) {
                            logger.finer("Importing referenced DBD " + currDbdName + " for DBPCB " + pcbName + " is cancelled.");
                            break;
                        }
                        monitor.beginTask(CatNavMessages.getLabel().getString("CNS_SEARCH_PROGRESS_INDICATOR_DBPCBS", (Object[])new String[]{currDbdName, pcbName}), -1);
                        try {
                            DbdModel newDb = this.importRelatedDbdToReadOnlyProject(currDbdName);
                            if (newDb == null) {
                                logger.finer("Failed to read the DBD " + currDbdName + " for DBPCB " + pcbName + ".");
                            }
                        }
                        catch (CoreException e) {
                            logger.throwing(this.getClass().getName(), "run(IProgressMonitor monitor)", (Throwable)e);
                            logger.error((Throwable)e);
                        }
                        ++i;
                    }
                }
            }
            monitor.done();
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "run(IProgressMonitor monitor)", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            String parm = this.connNode.getName() + "." + psbName;
            logger.exiting(this.getClass().getName(), "run(IProgressMonitor monitor)", new Object[]{parm});
        }
    }

    private DbdModel importRelatedDbdToReadOnlyProject(String dbdName) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "importRelatedDbdToReadOnlyProject(DbdModel dbdModel)", new Object[]{dbdName});
        }
        CatalogNav catNav = CatalogNav.getSingletonInstance();
        byte[] currXml = catNav.getDbdXml(this.connNode, dbdName);
        DbdModel currDbdModel = new DbdModel((InputStream)new ByteArrayInputStream(currXml));
        ProjectTreeFileHelper.marshallDbdToReadOnlyProject((DbdModel)currDbdModel);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "importRelatedDbdToReadOnlyProject(DbdModel dbdModel)", new Object[]{dbdName});
        }
        return currDbdModel;
    }
}

