/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.utilities;

import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.DatabaseDDLGenerator;
import com.ibm.im.ims.workbench.model.utilities.ProgramDDLGenerator;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.DDLGenerator;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.EngineeringOption;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.IEngineeringCallBack;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc.JDBCSchema;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc.JDBCTable;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGenerationOptions;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.Column;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public class DdlGenerator
implements DDLGenerator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static Preferences instanceNode = new InstanceScope().getNode("com.ibm.datatools.core.ui");
    private static final String PREF_GENERATE_DDL_OPTION = "generateDDLOption";
    private static final String GENERATE_PROGRAM_VIEW = "GENERATE_PROGRAM_VIEW";
    private EngineeringOption[] options = null;
    private EngineeringOption[] defaultOptions = null;
    private EngineeringOptionCategory[] categories = null;

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "generateDDL(SQLObject[] elements,IProgressMonitor progressMonitor)", new Object[0]);
        }
        Vector<String> retVal = new Vector<String>();
        boolean generateProgramView = false;
        boolean generateTables = false;
        boolean generateCreate = false;
        boolean generateDrop = false;
        boolean generateComments = false;
        JDBCSchema schema = null;
        SQLObject selObj = null;
        int i = 0;
        while (i < this.options.length) {
            EngineeringOption currOption = this.options[i];
            if (currOption.getId().equals("GENERATE_TABLES") && currOption.getBoolean()) {
                generateTables = true;
            } else if (currOption.getId().equals("GENERATE_CREATE_STATEMENTS") && currOption.getBoolean()) {
                generateCreate = true;
            } else if (currOption.getId().equals(GENERATE_PROGRAM_VIEW) && currOption.getBoolean()) {
                generateProgramView = true;
            } else if (currOption.getId().equals("GENERATE_DROP_STATEMENTS") && currOption.getBoolean()) {
                generateDrop = true;
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            String connName;
            selObj = elements[i];
            if (selObj instanceof JDBCSchema) {
                schema = (JDBCSchema)selObj;
            } else {
                boolean cfr_ignored_0 = selObj instanceof JDBCTable;
            }
            if (schema != null && DdlGenerator.isSupportedDatabase((EObject)schema) && (connName = "") != null && generateTables) {
                if (generateDrop) {
                    retVal.add(this.generateDDL(schema, true, true, false));
                }
                if (generateCreate) {
                    retVal.add(this.generateDDL(schema, true, false, generateComments));
                }
            }
            ++i;
        }
        if (generateProgramView) {
            if (generateDrop) {
                retVal.add(this.generateProgramDDL(schema, true, false));
            }
            if (generateCreate) {
                retVal.add(this.generateProgramDDL(schema, false, generateComments));
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)WorkbenchModelBundle.getLabel().getString("GENERATE_PROGRAM_VIEW_IMP"), (String)WorkbenchModelBundle.getLabel().getString("GENERATE_PROGRAM_VIEW_WRN"));
                }
            });
        }
        if (retVal.size() > 0) {
            retVal.add("COMMIT DDL;");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "generateDDL(SQLObject[] elements,IProgressMonitor progressMonitor)", new Object[0]);
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    private String generateProgramDDL(JDBCSchema schema, boolean isDrop, boolean generateComments) {
        String retVal = "";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "generateProgramDDL(String connName, ArrayList<String> schemaNames, boolean isDrop, boolean isAutoDrop, boolean generateComments)", new Object[0]);
        }
        try {
            PsbModel psbModel = (PsbModel)schema.psbModel;
            retVal = ProgramDDLGenerator.genPsbDdl(null, (PsbModel)psbModel, (boolean)isDrop, (boolean)false, (boolean)generateComments);
        }
        catch (Throwable t) {
            logger.throwing(this.getClass().getName(), "generateProgramDDL(String connName, ArrayList<String> schemaNames, boolean isDrop, boolean isAutoDrop, boolean generateComments)", t);
            logger.error(t);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "generateProgramDDL(String connName, ArrayList<String> schemaNames, boolean isDrop, boolean isAutoDrop, boolean generateComments)", new Object[0]);
        }
        return retVal;
    }

    private String generateDDL(JDBCSchema schema, boolean generateTables, boolean isDropCommand, boolean generateComments) {
        String retVal = "";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "generateDDL(String connName, String dbdName, String segmentName, boolean generateTables, boolean isDropCommand, boolean generateAutoDrop, boolean generateComments)", new Object[0]);
        }
        try {
            CatalogTreeConnection connNode = (CatalogTreeConnection)schema.connNode;
            IImsDbConnection imsConn = connNode.getConnection();
            PcbDBModel dbPcb = (PcbDBModel)schema.dbPcbModel;
            byte[] xmlDbdBytes = imsConn.getDbdXml(dbPcb.getDbdName());
            DbdModel dbdModel = new DbdModel((InputStream)new ByteArrayInputStream(xmlDbdBytes));
            retVal = DatabaseDDLGenerator.genDbdDdl((DbdModel)dbdModel, (boolean)generateTables, (boolean)isDropCommand, (boolean)generateComments);
        }
        catch (Throwable t) {
            logger.throwing(this.getClass().getName(), "generateDDL(ConnectionImpl imsConn, String psbName, String dbdName, String segmentName, boolean generateTables, boolean isDropCommand, boolean generateAutoDrop, boolean generateComments)", t);
            logger.error(t);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "generateDDL(ConnectionImpl imsConn, String psbName, String dbdName, String segmentName, boolean generateTables, boolean isDropCommand, boolean generateAutoDrop)", new Object[0]);
        }
        return retVal;
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.createSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor, null);
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        return null;
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.dropSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor, null);
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        return null;
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            this.categories = GenericDdlGenerationOptions.createDDLGenerationOptionCategories();
        }
        return this.categories;
    }

    public EngineeringOption[] getOptions(SQLObject[] elements) {
        return this.calculateOptions(elements);
    }

    public EngineeringOption[] getDefaultOptions(SQLObject[] elements) {
        return this.calculateDefaultOptions(elements);
    }

    private EngineeringOption[] calculateOptions(SQLObject[] elements) {
        EngineeringOptionCategory[] categories_new = this.getOptionCategories();
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        int i = 0;
        while (i < categories_new.length) {
            if (categories_new[i].getId().equals("GENERATE_OPTIONS")) {
                general_options = categories_new[i];
            } else if (categories_new[i].getId().equals("GENERATE_ELEMENTS")) {
                additional_element = categories_new[i];
            }
            ++i;
        }
        this.options = this.getOptionDependency(elements, general_options, additional_element);
        this.setupDefault(elements[0].getName());
        return this.options;
    }

    private void setupDefault(String className) {
        boolean optionSelect = false;
        boolean elementSelect = false;
        int i = 0;
        while (i < this.options.length) {
            String category = this.options[i].getCategory().getId();
            boolean value = this.options[i].getBoolean();
            if (!optionSelect && category.equals("GENERATE_OPTIONS") && value) {
                optionSelect = true;
            }
            if (!elementSelect && category.equals("GENERATE_ELEMENTS") && value) {
                elementSelect = true;
            }
            ++i;
        }
        if (!optionSelect || !elementSelect) {
            i = 0;
            while (i < this.options.length) {
                String id = this.options[i].getId();
                if (id.equals("GENERATE_DROP_STATEMENTS")) {
                    this.options[i].setBoolean(false);
                } else {
                    this.options[i].setBoolean(true);
                }
                instanceNode.putBoolean("generateDDLOptionIMSV14" + className + id, this.options[i].getBoolean());
                ++i;
            }
        }
    }

    private EngineeringOption[] calculateDefaultOptions(SQLObject[] elements) {
        EngineeringOptionCategory[] categories_new = this.getOptionCategories();
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        int i = 0;
        while (i < categories_new.length) {
            if (categories_new[i].getId().equals("GENERATE_OPTIONS")) {
                general_options = categories_new[i];
            } else if (categories_new[i].getId().equals("GENERATE_ELEMENTS")) {
                additional_element = categories_new[i];
            }
            ++i;
        }
        this.defaultOptions = this.getDefaultOptionDependency(elements, general_options, additional_element);
        return this.defaultOptions;
    }

    private EngineeringOption[] getOptionDependency(SQLObject[] elements, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        LinkedHashSet<String> sOptions = new LinkedHashSet<String>();
        sOptions.add("GENERATE_CREATE_STATEMENTS");
        sOptions.add("GENERATE_DROP_STATEMENTS");
        sOptions.add("GENERATE_COMMENTS");
        sOptions.addAll(this.getAllContainedDisplayableElementSetDepedency(elements));
        int idx = 0;
        int size = 0;
        EngineeringOption[] options = new EngineeringOption[sOptions.size()];
        int i = 0;
        Iterator it = sOptions.iterator();
        while (it.hasNext()) {
            options[i] = this.getEngineeringOption((String)it.next(), general_options, additional_element, elements);
            if (options[i] != null && (options[i].getCategory().getId().equals("GENERATE_ELEMENTS") || options[i].getCategory().getId().equals("GENERATE_OPTIONS"))) {
                idx = i;
                ++size;
            }
            ++i;
        }
        if (size == 1) {
            EngineeringOption option = options[idx];
            option.setBoolean(true);
        }
        return options;
    }

    private EngineeringOption[] getDefaultOptionDependency(SQLObject[] elements, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        LinkedHashSet<String> sOptions = new LinkedHashSet<String>();
        sOptions.add("GENERATE_CREATE_STATEMENTS");
        sOptions.add("GENERATE_DROP_STATEMENTS");
        sOptions.add("GENERATE_COMMENTS");
        sOptions.addAll(this.getAllContainedDisplayableElementSetDepedency(elements));
        int idx = 0;
        int size = 0;
        EngineeringOption[] defaultOptions = new EngineeringOption[sOptions.size()];
        int i = 0;
        Iterator it = sOptions.iterator();
        while (it.hasNext()) {
            defaultOptions[i] = this.getDefaultEngineeringOption((String)it.next(), general_options, additional_element);
            if (this.options[i] != null && (this.options[i].getCategory().getId().equals("GENERATE_ELEMENTS") || this.options[i].getCategory().getId().equals("GENERATE_OPTIONS"))) {
                idx = i;
                ++size;
            }
            ++i;
        }
        if (size == 1) {
            EngineeringOption defaultOption = defaultOptions[idx];
            defaultOption.setBoolean(true);
        }
        return defaultOptions;
    }

    private EngineeringOption getEngineeringOption(String id, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element, SQLObject[] elements) {
        ResourceBundle resource = ResourceBundle.getBundle("com.ibm.ims.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGeneration");
        try {
            if (id.equalsIgnoreCase("GENERATE_CREATE_STATEMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"), this.getOptionPreference(id, elements, false), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_DROP_STATEMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"), this.getOptionPreference(id, elements, false), general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_COMMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_COMMENTS"), resource.getString("GENERATE_COMMENTS_DES"), this.getOptionPreference(id, elements, false), general_options);
            }
            if (id.equalsIgnoreCase(GENERATE_PROGRAM_VIEW)) {
                return new EngineeringOption(id, WorkbenchModelBundle.getLabel().getString(GENERATE_PROGRAM_VIEW), WorkbenchModelBundle.getLabel().getString("GENERATE_PROGRAM_VIEW_DES"), this.getOptionPreference(id, elements, false), additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TABLES"), resource.getString("GENERATE_TABLES_DES"), this.getOptionPreference(id, elements, false), additional_element);
            }
        }
        catch (Exception e) {
            logger.throwing(this.getClass().getName(), "getEngineeringOption(String id, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element, SQLObject[] elements)", (Throwable)e);
            logger.error((Throwable)e);
        }
        return null;
    }

    private EngineeringOption getDefaultEngineeringOption(String id, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        ResourceBundle.getBundle("com.ibm.ims.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGeneration");
        return null;
    }

    private boolean getOptionPreference(String id, Object[] elements, boolean defaultValue) {
        String preferenceKey = "generateDDLOptionIMSV14" + elements[0].toString() + id;
        String defaultValueStr = String.valueOf(defaultValue);
        String booleanStr = instanceNode.get(preferenceKey, defaultValueStr);
        return Boolean.parseBoolean(booleanStr);
    }

    private Set<String> getAllContainedDisplayableElementSetDepedency(SQLObject[] elements) {
        SingletonOptionDependency sod = SingletonOptionDependency.getSingletonObject();
        TreeSet<String> s = new TreeSet<String>();
        int i = 0;
        while (i < elements.length) {
            Class<Database> key = null;
            if (elements[i] instanceof Database) {
                key = Database.class;
            } else if (elements[i] instanceof Schema) {
                key = Schema.class;
            } else if (elements[i] instanceof Column) {
                key = Column.class;
            }
            try {
                int mask = sod.getMask(key);
                this.populateOptions(s, mask);
            }
            catch (Exception e) {
                System.err.println("Missing definition for: " + elements[i].getClass().toString());
                e.printStackTrace();
            }
            ++i;
        }
        return s;
    }

    private void populateOptions(Set<String> s, int mask) {
        if ((mask & 2) == 2) {
            s.add("GENERATE_TABLES");
            s.add(GENERATE_PROGRAM_VIEW);
        }
        if ((mask & 4) == 4) {
            s.add("GENERATE_TABLES");
            s.add(GENERATE_PROGRAM_VIEW);
        }
        if ((mask & 1) == 1) {
            s.add(GENERATE_PROGRAM_VIEW);
        }
    }

    private static boolean isSupportedDatabase(EObject eObj) {
        return true;
    }

    public static class SingletonOptionDependency {
        private Map<Class<?>, Integer> data = new HashMap();
        private static SingletonOptionDependency ref;

        private SingletonOptionDependency() {
        }

        public static SingletonOptionDependency getSingletonObject() {
            if (ref == null) {
                ref = new SingletonOptionDependency();
                int mask = 1;
                SingletonOptionDependency.ref.data.put(Database.class, new Integer(mask));
                mask = 4;
                SingletonOptionDependency.ref.data.put(Schema.class, new Integer(mask));
                mask = 4;
                SingletonOptionDependency.ref.data.put(Table.class, new Integer(mask));
                mask = 4;
                SingletonOptionDependency.ref.data.put(Column.class, new Integer(mask));
            }
            return ref;
        }

        public Integer getMask(Class<?> key) {
            return this.data.get(key);
        }
    }
}

