/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.page;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public abstract class PreferencePage
extends DialogPage
implements IPreferencePage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean isValid = true;
    private Control body;
    private IPreferencePageContainer container = null;
    private Point size = null;

    protected PreferencePage() {
        this("");
    }

    protected PreferencePage(String title) {
        super(title);
    }

    protected PreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public Point computeSize() {
        if (this.size != null) {
            return this.size;
        }
        Control control = this.getControl();
        if (control != null) {
            this.size = this.doComputeSize();
            return this.size;
        }
        return new Point(0, 0);
    }

    protected abstract Control createContents(Composite var1);

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)content);
        this.body = this.createContents(content);
        if (this.body != null) {
            GridData gd = new GridData();
            gd.verticalAlignment = 2;
            this.body.setLayoutData((Object)gd);
        }
        this.setControl((Control)content);
    }

    protected Point doComputeSize() {
        if (this.body != null) {
            return this.body.computeSize(-1, -1, true);
        }
        return this.getControl().computeSize(-1, -1, true);
    }

    public IPreferencePageContainer getContainer() {
        return this.container;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean okToLeave() {
        return this.isValid();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performOk() {
        return true;
    }

    public void setContainer(IPreferencePageContainer container) {
        this.container = container;
    }

    public void setSize(Point uiSize) {
        Control control = this.getControl();
        if (control != null) {
            control.setSize(uiSize);
            this.size = uiSize;
        }
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.getContainer() != null) {
            this.getContainer().updateTitle();
        }
    }

    public void setValid(boolean b) {
        boolean oldValue = this.isValid;
        this.isValid = b;
        if (oldValue != this.isValid && this.getContainer() != null) {
            this.getContainer().updateButtons();
        }
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        if (this.getContainer() != null) {
            this.getContainer().updateMessage();
        }
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        if (this.getContainer() != null) {
            this.getContainer().updateMessage();
        }
    }
}

