/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.page;

import com.ibm.im.ims.catalog.ui.page.IIMSJDBCDriverProvider;
import com.ibm.im.ims.catalog.ui.page.ResourceLoader;
import com.ibm.im.ims.metadata.driver.connections.UnivDriverConnectionType;
import java.io.File;
import java.math.BigInteger;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IMSJDBCDriverTracingOptionsPane
extends Composite
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Button disableTracingCheckbox;
    private Label traceDirectoryLabel;
    private Text traceDirectoryText;
    private Button browseDirectory;
    private Label traceFileLabel;
    private Text traceFileText;
    private Button appendCheckbox;
    private Group traceLevelGroup;
    private Button drdaCheckbox;
    private Button dliApiCheckbox;
    private Button jdbcCheckbox;
    private Button jeeCheckbox;
    private Button allButton;
    private Button noneButton;
    private IIMSJDBCDriverProvider parentDriverProvider;
    private static final String TRACE_LEVEL_TRACE_NONE_PROPERTY_VALUE = "0";
    private static final String CUI_NEWCW_DISABLE_TRACING_CHECKBOX_UI_ = ResourceLoader.CUI_NEWCW_DISABLE_TRACING_CHECKBOX_UI_;
    private static final String CUI_NEWCW_TRACE_DIRECTORY_LABEL_UI_ = ResourceLoader.CUI_NEWCW_TRACE_DIRECTORY_LABEL_UI_;
    private static final String CUI_NEWCW_TRACE_DIRECTORY_BROWSE_BUTTON_UI_ = ResourceLoader.CUI_NEWCW_TRACE_DIRECTORY_BROWSE_BUTTON_UI_;
    private static final String CUI_NEWCW_TRACE_FILE_LABEL_UI_ = ResourceLoader.CUI_NEWCW_TRACE_FILE_LABEL_UI_;
    private static final String CUI_NEWCW_DEFAULT_TRACE_FILE_NAME_UI_ = "IMS_JDBC_trace.txt";
    private static final String CUI_NEWCW_APPEND_CHECKBOX_UI_ = ResourceLoader.CUI_NEWCW_APPEND_CHECKBOX_UI_;
    private static final String CUI_NEWCW_TRACE_LEVELS_GROUPBOX_UI_ = ResourceLoader.CUI_NEWCW_TRACE_LEVELS_GROUPBOX_UI_;
    private static final String CUI_NEWCW_APPEND_HOVERTEXT = ResourceLoader.CUI_NEWCW_APPEND_HOVERTEXT;
    private static final String CUI_NEWCW_FILENAME_HOVERTEXT = ResourceLoader.CUI_NEWCW_FILENAME_HOVERTEXT;
    public static final String SELECT_ALL = ResourceLoader.SELECT_ALL;
    public static final String DESELECT_ALL = ResourceLoader.DESELECT_ALL;
    private boolean isReadOnly = false;

    public IMSJDBCDriverTracingOptionsPane(Composite parent, int style, IIMSJDBCDriverProvider parentDriverProvider, boolean isReadOnly) {
        super(parent, style);
        this.parentDriverProvider = parentDriverProvider;
        IMSJDBCDriverTracingOptionsPane parentComposite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parentComposite.setLayout((Layout)layout);
        this.isReadOnly = isReadOnly;
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        this.disableTracingCheckbox = new Button((Composite)parentComposite, 32);
        this.disableTracingCheckbox.setText(CUI_NEWCW_DISABLE_TRACING_CHECKBOX_UI_);
        this.disableTracingCheckbox.setSelection(true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 3;
        this.disableTracingCheckbox.setLayoutData((Object)gd);
        this.traceDirectoryLabel = new Label((Composite)parentComposite, 0);
        this.traceDirectoryLabel.setText(CUI_NEWCW_TRACE_DIRECTORY_LABEL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.traceDirectoryLabel.setLayoutData((Object)gd);
        this.traceDirectoryText = new Text((Composite)parentComposite, 0x804 | additionalStyles);
        gd = new GridData();
        gd.widthHint = 180;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.traceDirectoryText.setLayoutData((Object)gd);
        this.browseDirectory = new Button((Composite)parentComposite, 8);
        this.browseDirectory.setText(CUI_NEWCW_TRACE_DIRECTORY_BROWSE_BUTTON_UI_);
        this.browseDirectory.setEnabled(!isReadOnly);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.browseDirectory.setLayoutData((Object)gd);
        this.traceFileLabel = new Label((Composite)parentComposite, 0);
        this.traceFileLabel.setText(CUI_NEWCW_TRACE_FILE_LABEL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.traceFileLabel.setLayoutData((Object)gd);
        this.traceFileText = new Text((Composite)parentComposite, 0x804 | additionalStyles);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        this.traceFileText.setLayoutData((Object)gd);
        this.traceFileText.setText(CUI_NEWCW_DEFAULT_TRACE_FILE_NAME_UI_);
        this.traceFileText.setToolTipText(CUI_NEWCW_FILENAME_HOVERTEXT);
        this.appendCheckbox = new Button((Composite)parentComposite, 32);
        this.appendCheckbox.setText(CUI_NEWCW_APPEND_CHECKBOX_UI_);
        this.appendCheckbox.setToolTipText(CUI_NEWCW_APPEND_HOVERTEXT);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 3;
        this.appendCheckbox.setLayoutData((Object)gd);
        this.traceLevelGroup = new Group((Composite)parentComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.traceLevelGroup.setLayout((Layout)layout);
        this.traceLevelGroup.setText(CUI_NEWCW_TRACE_LEVELS_GROUPBOX_UI_);
        this.traceLevelGroup.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 2;
        this.traceLevelGroup.setLayoutData((Object)gd);
        this.dliApiCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.dliApiCheckbox.setText("DLI API");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.dliApiCheckbox.setLayoutData((Object)gd);
        this.drdaCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.drdaCheckbox.setText("DRDA");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.drdaCheckbox.setLayoutData((Object)gd);
        this.jeeCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.jeeCheckbox.setText("Java EE");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.jeeCheckbox.setLayoutData((Object)gd);
        this.jdbcCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.jdbcCheckbox.setText("JDBC");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.jdbcCheckbox.setLayoutData((Object)gd);
        this.allButton = new Button((Composite)this.traceLevelGroup, 0);
        this.allButton.setEnabled(!isReadOnly);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.allButton.setLayoutData((Object)gd);
        this.allButton.setText(SELECT_ALL);
        this.noneButton = new Button((Composite)this.traceLevelGroup, 0);
        this.noneButton.setEnabled(!isReadOnly);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.noneButton.setLayoutData((Object)gd);
        this.noneButton.setText(DESELECT_ALL);
        this.restoreDefaultSettings();
        this.enableTracingUI(false);
    }

    private void enableTracingUI(boolean enable) {
        this.traceDirectoryLabel.setEnabled(enable);
        this.traceDirectoryText.setEnabled(enable);
        this.traceFileLabel.setEnabled(enable);
        this.traceFileText.setEnabled(enable);
        this.appendCheckbox.setEnabled(enable);
        this.traceLevelGroup.setEnabled(enable);
        this.drdaCheckbox.setEnabled(enable);
        this.dliApiCheckbox.setEnabled(enable);
        this.jdbcCheckbox.setEnabled(enable);
        this.jeeCheckbox.setEnabled(enable);
        if (!this.isReadOnly) {
            this.browseDirectory.setEnabled(enable);
            this.allButton.setEnabled(enable);
            this.noneButton.setEnabled(enable);
        }
    }

    private void addListeners() {
        this.disableTracingCheckbox.addListener(13, (Listener)this);
        this.traceDirectoryText.addListener(24, (Listener)this);
        this.browseDirectory.addListener(13, (Listener)this);
        this.traceFileText.addListener(24, (Listener)this);
        this.appendCheckbox.addListener(13, (Listener)this);
        this.drdaCheckbox.addListener(13, (Listener)this);
        this.dliApiCheckbox.addListener(13, (Listener)this);
        this.jdbcCheckbox.addListener(13, (Listener)this);
        this.jeeCheckbox.addListener(13, (Listener)this);
        this.allButton.addListener(13, (Listener)this);
        this.noneButton.addListener(13, (Listener)this);
    }

    private void removeListeners() {
        this.disableTracingCheckbox.removeListener(13, (Listener)this);
        this.traceDirectoryText.removeListener(24, (Listener)this);
        this.browseDirectory.removeListener(13, (Listener)this);
        this.traceFileText.removeListener(24, (Listener)this);
        this.appendCheckbox.removeListener(13, (Listener)this);
        this.drdaCheckbox.removeListener(13, (Listener)this);
        this.dliApiCheckbox.removeListener(13, (Listener)this);
        this.jdbcCheckbox.removeListener(13, (Listener)this);
        this.jeeCheckbox.removeListener(13, (Listener)this);
        this.allButton.removeListener(13, (Listener)this);
        this.noneButton.removeListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (this.isReadOnly) {
            if (source == this.disableTracingCheckbox || source == this.appendCheckbox || source == this.drdaCheckbox || source == this.dliApiCheckbox || source == this.jdbcCheckbox || source == this.jeeCheckbox) {
                ((Button)source).setSelection(!((Button)source).getSelection());
            }
        } else {
            if (source == this.disableTracingCheckbox) {
                this.enableTracingUI(!this.disableTracingCheckbox.getSelection());
            } else if (source == this.allButton) {
                this.setAllLevelsChecked(true);
            } else if (source == this.noneButton) {
                this.setAllLevelsChecked(false);
            } else if (source == this.browseDirectory) {
                DirectoryDialog dialog = new DirectoryDialog(this.browseDirectory.getShell(), 4096);
                dialog.setFilterPath(this.traceDirectoryText.getText().trim());
                String directory = dialog.open();
                if (directory != null) {
                    this.traceDirectoryText.setText(directory);
                }
            }
            this.parentDriverProvider.updateURL();
            this.parentDriverProvider.setConnectionInformation();
        }
    }

    private void setAllLevelsChecked(boolean check) {
        this.drdaCheckbox.setSelection(check);
        this.dliApiCheckbox.setSelection(check);
        this.jdbcCheckbox.setSelection(check);
        this.jeeCheckbox.setSelection(check);
    }

    public void initWidgets(UnivDriverConnectionType udbType) {
        this.removeListeners();
        BigInteger traceLevel = udbType.getTraceLevel();
        if (traceLevel != null && traceLevel.toString().length() > 0) {
            this.appendCheckbox.setSelection(udbType.isTraceFileAppend().booleanValue());
            this.disableTracingCheckbox.setSelection(false);
            this.enableTracingUI(true);
            this.setTraceLevel(traceLevel.toString());
            String traceDirStr = udbType.getTraceDirectory();
            this.traceDirectoryText.setText(traceDirStr);
            String traceFileStr = udbType.getTraceFile();
            this.traceFileText.setText(traceFileStr);
        } else {
            this.disableTracingCheckbox.setSelection(true);
            this.enableTracingUI(false);
        }
        this.addListeners();
    }

    public boolean validateControl(DialogPage page) {
        boolean isValid = true;
        if (!this.disableTracingCheckbox.getSelection()) {
            if (this.traceDirectoryText.getText() == null || this.traceDirectoryText.getText().trim().length() < 1) {
                page.setErrorMessage("Enter a directory.");
                isValid = false;
            } else if (!this.isDirectoryValid(this.traceDirectoryText.getText().trim())) {
                page.setErrorMessage("Enter a valid directory.");
                isValid = false;
            } else if (this.traceFileText.getText() == null || this.traceFileText.getText().trim().length() < 1) {
                page.setErrorMessage("Enter a file name.");
                isValid = false;
            } else if (!this.isTraceLevelSelected()) {
                page.setErrorMessage("Select at least one trace level.");
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean isDirectoryValid(String directory) {
        boolean isDirectoryValid = false;
        File file = new File(directory);
        if (file.exists() && file.isDirectory()) {
            isDirectoryValid = true;
        }
        return isDirectoryValid;
    }

    public boolean isTraceLevelSelected() {
        boolean isSelected = false;
        if (!this.getTraceLevel().equals(TRACE_LEVEL_TRACE_NONE_PROPERTY_VALUE)) {
            isSelected = true;
        }
        return isSelected;
    }

    public String getTracingURLProperties() {
        Object properties = "";
        if (!this.disableTracingCheckbox.getSelection()) {
            String traceDirectory = this.getTraceDirectory();
            String traceFile = this.getTraceFile();
            boolean append = this.getAppendFile();
            String traceLevel = this.getTraceLevel();
            properties = "traceFile=" + traceFile + ";traceFileAppend=" + String.valueOf(append) + ";traceLevel=" + traceLevel + ";traceDirectory=" + traceDirectory + ";";
        }
        return properties;
    }

    protected String getTraceDirectory() {
        return this.traceDirectoryText.getText().trim();
    }

    protected String getTraceFile() {
        return this.traceFileText.getText().trim();
    }

    protected boolean getAppendFile() {
        return this.appendCheckbox.getSelection();
    }

    protected String getTraceLevel() {
        String traceLevelString = TRACE_LEVEL_TRACE_NONE_PROPERTY_VALUE;
        int traceLevel = 0;
        if (this.dliApiCheckbox.getSelection()) {
            traceLevel += 28;
        }
        if (this.drdaCheckbox.getSelection()) {
            traceLevel += 3;
        }
        if (this.jdbcCheckbox.getSelection()) {
            traceLevel += 32;
        }
        if (this.jeeCheckbox.getSelection()) {
            traceLevel += 192;
        }
        if (traceLevel == 255) {
            traceLevel = -1;
        }
        traceLevelString = Integer.toString(traceLevel);
        return traceLevelString;
    }

    private void setTraceLevel(String traceLevelString) {
        int traceLevel = Integer.parseInt(traceLevelString);
        if (traceLevel == -1) {
            this.setAllLevelsChecked(true);
        } else {
            if ((traceLevel & 4) != 0 && (traceLevel & 8) != 0 && (traceLevel & 0x10) != 0) {
                this.dliApiCheckbox.setSelection(true);
            } else {
                this.dliApiCheckbox.setSelection(false);
            }
            if ((traceLevel & 1) != 0 && (traceLevel & 2) != 0) {
                this.drdaCheckbox.setSelection(true);
            } else {
                this.drdaCheckbox.setSelection(false);
            }
            if ((traceLevel & 0x20) != 0) {
                this.jdbcCheckbox.setSelection(true);
            } else {
                this.jdbcCheckbox.setSelection(false);
            }
            if ((traceLevel & 0x40) != 0 && (traceLevel & 0x80) != 0) {
                this.jeeCheckbox.setSelection(true);
            } else {
                this.jeeCheckbox.setSelection(false);
            }
        }
    }

    private void restoreDefaultSettings() {
        this.setAllLevelsChecked(false);
        this.drdaCheckbox.setSelection(true);
        this.traceDirectoryText.setText(System.getProperty("user.home"));
        this.traceFileText.setText(CUI_NEWCW_DEFAULT_TRACE_FILE_NAME_UI_);
    }

    public void dispose() {
        this.removeListeners();
    }
}

