/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.page;

import com.ibm.im.ims.catalog.ui.page.IIMSJDBCDriverProvider;
import com.ibm.im.ims.catalog.ui.page.IMSJDBCDriverTracingOptionsPane;
import com.ibm.im.ims.catalog.ui.page.PreferencePage;
import com.ibm.im.ims.catalog.ui.page.ResourceLoader;
import com.ibm.im.ims.metadata.driver.connections.UnivDriverConnectionType;
import com.ibm.im.ims.workbench.utilities.TextFocusHightlightListener;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.metadata.db.connections.ConnectionProfile;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class DriverPropertyPage
extends PreferencePage
implements IIMSJDBCDriverProvider,
IWorkbenchPropertyPage,
Listener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private boolean isValid = true;
    public static final String IMS_NEWCW_PROPERTY_CATALOG_PSB = ResourceLoader.IMS_NEWCW_PROPERTY_CATALOG_PSB;
    public static final String IMS_NEWCW_YES = ResourceLoader.IMS_NEWCW_YES;
    public static final String IMS_NEWCW_NO = ResourceLoader.IMS_NEWCW_NO;
    public static final String IMS_NEWCW_SECONDS_LBL = ResourceLoader.IMS_NEWCW_SECONDS_LBL;
    public static final String IMS_NEWCW_DATASTORE_LBL = ResourceLoader.IMS_NEWCW_DATASTORE_LBL;
    public static final String IMS_NEWCW_CONN_PROFILE_LBL = ResourceLoader.IMS_NEWCW_CONN_PROFILE_LBL;
    public static final String IMS_NEWCW_CONN_NAME_LBL = ResourceLoader.IMS_NEWCW_CONN_NAME_LBL;
    public static final String IMS_NEWCW_PORT_LBL = ResourceLoader.IMS_NEWCW_PORT_LBL;
    public static final String IMS_NEWCW_USERID_LBL = "  " + ResourceLoader.IMS_NEWCW_USERID_LBL;
    public static final String IMS_NEWCW_PASSWORD_LBL = "  " + ResourceLoader.IMS_NEWCW_PASSWORD_LBL;
    public static final String IMS_NEWCW_CURR_SCHEMA_LBL = "  " + ResourceLoader.IMS_NEWCW_CURR_SCHEMA_LBL;
    public static final String IMS_NEWCW_URL_LBL = ResourceLoader.IMS_NEWCW_URL_LBL;
    public static final String IMS_METADATASOURCE_LBL = "  " + ResourceLoader.IMS_METADATASOURCE_LBL;
    public static final String IMS_METADATASOURCE_CATALOG = ResourceLoader.IMS_METADATASOURCE_CATALOG;
    public static final String IMS_NEWCW_RADIO_LOCAL_SUMMARY_DATA_TEXT = ResourceLoader.IMS_NEWCW_RADIO_LOCAL_SUMMARY_DATA_TEXT;
    public static final String IMS_NEWCW_PROJECT_SUMMARY_DATA_TEXT = ResourceLoader.IMS_NEWCW_PROJECT_SUMMARY_DATA_TEXT;
    public static final String IMS_NEWCW_RADIO_REMOTE_SUMMARY_DATA_TEXT = ResourceLoader.IMS_NEWCW_RADIO_REMOTE_SUMMARY_DATA_TEXT;
    public static final String IMS_NEWCW_DATASTORE_SUMMARY_DATA_TEXT = ResourceLoader.IMS_NEWCW_DATASTORE_SUMMARY_DATA_TEXT;
    public static final String IMS_NEWCW_PORT_SUMMARY_DATA_TEXT = ResourceLoader.IMS_NEWCW_PORT_SUMMARY_DATA_TEXT;
    public static final String IMS_NEWCW_USERID_SUMMARY_DATA_TEXT = ResourceLoader.IMS_NEWCW_USERID_SUMMARY_DATA_TEXT;
    public static final String IMS_NEWCW_PASSWORD_SUMMARY_DATA_TEXT = ResourceLoader.IMS_NEWCW_PASSWORD_SUMMARY_DATA_TEXT;
    public static final String IMS_NEWCW_URL_SUMMARY_DATA_TEXT = ResourceLoader.IMS_NEWCW_URL_SUMMARY_DATA_TEXT;
    public static final String IMS_NEWCW_VALIDATE_DATABASE_REQ_UI = ResourceLoader.IMS_NEWCW_VALIDATE_DATABASE_REQ_UI;
    public static final String IMS_NEWCW_VALIDATE_DATASTORE_REQ_UI = ResourceLoader.IMS_NEWCW_VALIDATE_DATASTORE_REQ_UI;
    public static final String IMS_NEWCW_VALIDATE_HOST_REQ_UI = ResourceLoader.IMS_NEWCW_VALIDATE_HOST_REQ_UI;
    public static final String IMS_NEWCW_VALIDATE_PORT_REQ_UI = ResourceLoader.IMS_NEWCW_VALIDATE_PORT_REQ_UI;
    public static final String IMS_NEWCW_VALIDATE_USERID_REQ_UI = ResourceLoader.IMS_NEWCW_VALIDATE_USERID_REQ_UI;
    public static final String IMS_NEWCW_VALIDATE_PASSWORD_REQ_UI = ResourceLoader.IMS_NEWCW_VALIDATE_PASSWORD_REQ_UI;
    public static final String IMS_NEWCW_SAVE_PASSWORD_LBL = ResourceLoader.IMS_NEWCW_SAVE_PASSWORD_LBL;
    public static final String IMS_NEWCW_HOST_LBL = ResourceLoader.IMS_NEWCW_HOST_LBL;
    public static final String IMS_NEWCW_METADATA_LBL = ResourceLoader.IMS_NEWCW_METADATA_LBL;
    public static final String IMS_NEWCW_PSB_LBL = "              " + ResourceLoader.IMS_NEWCW_PSB_LBL;
    public static final String IMS_NEWCW_PSB_LBL2 = ResourceLoader.IMS_NEWCW_PSB_LBL;
    public static final String IMS_NEWCW_FILELOCATION_LBL = ResourceLoader.IMS_NEWCW_FILELOCATION_LBL;
    public static final String IMS_NEWCW_BROWSE_LBL = ResourceLoader.IMS_NEWCW_BROWSE_LBL;
    public static final String IMS_NEWCW_LINK_SUMMARY_LBL = ResourceLoader.IMS_NEWCW_LINK_SUMMARY_LBL;
    public static final String IMS_NEWCW_DATASTORE_HOVERTEXT = ResourceLoader.IMS_NEWCW_DATASTORE_HOVERTEXT;
    public static final String IMS_NEWCW_HOST_HOVERTEXT = ResourceLoader.IMS_NEWCW_HOST_HOVERTEXT;
    public static final String IMS_NEWCW_PORT_HOVERTEXT = ResourceLoader.IMS_NEWCW_PORT_HOVERTEXT;
    public static final String IMS_NEWCW_USER_HOVERTEXT = ResourceLoader.IMS_NEWCW_USER_HOVERTEXT;
    public static final String IMS_NEWCW_PASSWORD_HOVERTEXT = ResourceLoader.IMS_NEWCW_PASSWORD_HOVERTEXT;
    public static final String IMS_NEWCW_CURR_SCHEMA_HOVERTEXT = ResourceLoader.IMS_NEWCW_CURR_SCHEMA_HOVERTEXT;
    public static final String IMS_NEWCW_METADATACLASS_HOVERTEXT = ResourceLoader.IMS_NEWCW_METADATACLASS_HOVERTEXT;
    public static final String IMS_NEWCW_CATALOGPSB_HOVERTEXT = ResourceLoader.IMS_NEWCW_CATALOGPSB_HOVERTEXT;
    public static final String IMS_NEWCW_LOGINTIMEOUT_HOVERTEXT = ResourceLoader.IMS_NEWCW_LOGINTIMEOUT_HOVERTEXT;
    public static final String IMS_METADATA_ERROR_MESSAGE = ResourceLoader.IMS_METADATA_ERROR_MESSAGE;
    public static final String IMS_PORTNUM_ERROR_MESSAGE = ResourceLoader.IMS_PORTNUM_ERROR_MESSAGE;
    public static final String IMS_IPADDR_ERROR_MESSAGE = ResourceLoader.IMS_IPADDR_ERROR_MESSAGE;
    public static final String IMS_CONNECTION_NAME_ERROR_MESSAGE = ResourceLoader.IMS_CONNECTION_NAME_ERROR_MESSAGE;
    public static final String IMS_CONNECTION_NAME_DUPLICATE_ERROR_MESSAGE = ResourceLoader.IMS_CONNECTION_NAME_DUPLICATE_ERROR_MESSAGE;
    public static final String IMS_CONNECTION_PROFILE_ERROR_MESSAGE = ResourceLoader.IMS_CONNECTION_PROFILE_ERROR_MESSAGE;
    private static final String IMS_NEWCW_DRIVER_OPTIONS_TAB_LBL = ResourceLoader.IMS_NEWCW_DRIVER_OPTIONS_TAB_LBL;
    private static final String IMS_NEWCW_TRACING_OPTIONS_TAB_LBL = ResourceLoader.IMS_NEWCW_TRACING_OPTIONS_TAB_LBL;
    private static final String IMS_NEWCW_OPTIONAL_TAB_LBL = ResourceLoader.IMS_NEWCW_OPTIONAL_TAB_LBL;
    private static final String IMS_NEWCW_SSLCONNECTION_LBL = ResourceLoader.IMS_NEWCW_SSLCONNECTION_LBL;
    private static final String IMS_NEWCW_LOGINTIMEOUT_LBL = ResourceLoader.IMS_NEWCW_LOGINTIMEOUT_LBL;
    public static final String BUFFERSPACES = "                ";
    private ScrolledComposite parentComposite;
    private Combo connectionProfileCombo;
    private Text connectionNameText;
    private Label datastoreLabel;
    private Text datastoreText;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Label useridLabel;
    private Text useridText;
    private Label passwordLabel;
    private Text passwordText;
    private Label currSchemaLabel;
    private Text currSchemaText;
    private Label urlLabel;
    private Text urlText;
    private Text nameText;
    private Text valueText;
    private Composite driverOptionsComposite;
    private Label metadataSourceLabel;
    private Combo metadataSourceCombo;
    private Composite metadataComposite;
    private Composite optionalPropsComposite;
    private Button browseButton;
    private Button savePasswordButton;
    private Label sslConnectionLabel;
    private Label loginTimeoutLabel;
    private Label secondsLabel;
    private Label catalogPsbLabel;
    private Text catalogPsbText;
    private Combo sslConnectionCombo;
    private Text loginTimeoutText;
    private Button addButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button removeButton;
    private Button clearAllButton;
    private Table propertiesTable;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 30;
    private IMSJDBCDriverTracingOptionsPane tracingOptionsComposite;
    private UnivDriverConnectionType univDriverConnection;
    private ConnectionProfile connectionProfile;
    private TextFocusHightlightListener textFocusHighLight;
    private IAdaptable element;

    @Override
    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.getContributedDriverUI(parent, false);
        return composite;
    }

    @Override
    public boolean performOk() {
        this.setConnectionInformation();
        return true;
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.character >= 'a' && event.character <= 'z') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public void handleEvent(Event event) {
        try {
            boolean connectionNameModified = false;
            if (event.widget != this.connectionProfileCombo) {
                if (event.widget == this.addButton) {
                    this.doAddTableItem();
                } else if (event.widget == this.removeButton) {
                    this.propertiesTable.remove(this.propertiesTable.getSelectionIndices());
                } else if (event.widget == this.clearAllButton) {
                    this.propertiesTable.removeAll();
                } else if (event.widget == this.moveUpButton) {
                    int movefrompos = 0;
                    int movetopos = 0;
                    movefrompos = this.propertiesTable.getSelectionIndex();
                    if (movefrompos >= 0 && (movetopos = movefrompos - 1) >= 0) {
                        this.moveTableItem(this.propertiesTable, movefrompos, movetopos);
                    }
                } else if (event.widget == this.moveDownButton) {
                    int movefrompos = 0;
                    int movetopos = 0;
                    int itemCnt = 0;
                    if (this.propertiesTable != null) {
                        itemCnt = this.propertiesTable.getItemCount();
                    }
                    if ((movefrompos = this.propertiesTable.getSelectionIndex()) >= 0 && (movetopos = movefrompos + 1) < itemCnt) {
                        this.moveTableItem(this.propertiesTable, movefrompos, movetopos);
                    }
                } else if (event.widget == this.connectionNameText) {
                    connectionNameModified = true;
                }
            }
            if (!connectionNameModified) {
                this.setValid(this.validatePage());
            }
            this.enableButtons();
            this.updateURL();
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "handleEvent(Event event)", e);
            logger.error(e);
        }
    }

    private void moveTableItem(Table table, int from, int to) {
        TableItem item2MoveDown = table.getItem(from);
        TableItem item2MoveUp = table.getItem(to);
        TableItem newTableItemDown = new TableItem(table, 0, to);
        TableItem newTableItemUp = new TableItem(table, 0, from);
        newTableItemUp.setText(item2MoveUp.getText());
        newTableItemDown.setText(item2MoveDown.getText());
        table.setSelection(newTableItemDown);
        item2MoveUp.dispose();
        item2MoveDown.dispose();
    }

    private void enableButtons() {
        String propStr = this.nameText.getText();
        String valueStr = this.valueText.getText();
        if (propStr != null && !propStr.isEmpty() && valueStr != null && !valueStr.isEmpty()) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    private void doAddTableItem() {
        String propName = this.nameText.getText();
        String propValue = this.valueText.getText();
        if (propName.length() > 0 && propValue.length() > 0) {
            String itemTableStr = propName + "=" + propValue + ";";
            TableItem propertyItem = new TableItem(this.propertiesTable, 16384);
            propertyItem.setText(itemTableStr);
            this.nameText.setText("");
            this.valueText.setText("");
            this.propertiesTable.setSelection(0);
        }
    }

    private boolean validatePage() {
        String ipAddrStr;
        String portNumStr;
        boolean retVal = false;
        boolean validConnectionName = false;
        boolean validIpAddr = false;
        boolean validPortNum = false;
        boolean validMetadataSource = false;
        validMetadataSource = this.validateMetadataSource();
        if (!validMetadataSource) {
            this.setErrorMessage(IMS_METADATA_ERROR_MESSAGE);
        }
        if ((portNumStr = this.portText.getText().trim()) != null && portNumStr.length() > 0) {
            try {
                Integer.parseInt(portNumStr);
                validPortNum = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!validPortNum) {
            this.setErrorMessage(IMS_PORTNUM_ERROR_MESSAGE);
        }
        if ((ipAddrStr = this.hostText.getText().trim()) != null && ipAddrStr.length() > 0) {
            validIpAddr = true;
        } else {
            this.setErrorMessage(IMS_IPADDR_ERROR_MESSAGE);
        }
        String connectionProfileStr = this.connectionProfileCombo.getText().trim();
        String connectionNameStr = this.connectionNameText.getText().trim();
        if (connectionProfileStr != null && connectionProfileStr.length() > 0 && connectionNameStr != null && connectionNameStr.length() > 0) {
            validConnectionName = true;
        } else {
            this.setErrorMessage(IMS_CONNECTION_NAME_ERROR_MESSAGE);
        }
        boolean bl = retVal = validConnectionName && validIpAddr && validPortNum && validMetadataSource;
        if (retVal) {
            this.setErrorMessage(null);
        }
        return retVal;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setValid(boolean b) {
        boolean oldValue = this.isValid;
        this.isValid = b;
        if (oldValue != this.isValid && this.getContainer() != null) {
            this.getContainer().updateButtons();
        }
    }

    private boolean validateMetadataSource() {
        boolean retVal = false;
        String catalogPsbName = this.catalogPsbText.getText().trim();
        if (catalogPsbName != null && catalogPsbName.length() > 0) {
            retVal = true;
        }
        return retVal;
    }

    private Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            GridData gd = new GridData();
            gd.verticalAlignment = 4;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            int additionalStyles = 0;
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            this.parentComposite.setLayoutData((Object)gd);
            this.textFocusHighLight = new TextFocusHightlightListener();
            TabFolder tabComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem driverOptionsTab = new TabItem(tabComposite, 0);
            driverOptionsTab.setText(IMS_NEWCW_DRIVER_OPTIONS_TAB_LBL);
            TabItem tracingOptionsTab = new TabItem(tabComposite, 0);
            tracingOptionsTab.setText(IMS_NEWCW_TRACING_OPTIONS_TAB_LBL);
            TabItem optionalPropsTab = new TabItem(tabComposite, 0);
            optionalPropsTab.setText(IMS_NEWCW_OPTIONAL_TAB_LBL);
            this.driverOptionsComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            this.driverOptionsComposite.setLayout((Layout)layout);
            driverOptionsTab.setControl((Control)this.driverOptionsComposite);
            this.tracingOptionsComposite = new IMSJDBCDriverTracingOptionsPane((Composite)tabComposite, 0, this, isReadOnly);
            tracingOptionsTab.setControl((Control)this.tracingOptionsComposite);
            Label connectionProfileLabel = new Label(this.driverOptionsComposite, 0);
            connectionProfileLabel.setText(IMS_NEWCW_CONN_PROFILE_LBL);
            gd = new GridData();
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 1;
            connectionProfileLabel.setLayoutData((Object)gd);
            this.connectionProfileCombo = new Combo(this.driverOptionsComposite, 2056);
            gd = new GridData();
            gd.verticalAlignment = 2;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.connectionProfileCombo.setLayoutData((Object)gd);
            Label connectionNameLabel = new Label(this.driverOptionsComposite, 0);
            connectionNameLabel.setText(IMS_NEWCW_CONN_NAME_LBL);
            gd = new GridData();
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 1;
            connectionNameLabel.setLayoutData((Object)gd);
            this.connectionNameText = new Text(this.driverOptionsComposite, 2052);
            gd = new GridData();
            gd.verticalAlignment = 2;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.connectionNameText.setLayoutData((Object)gd);
            this.hostLabel = new Label(this.driverOptionsComposite, 0);
            this.hostLabel.setText(IMS_NEWCW_HOST_LBL);
            gd = new GridData();
            gd.verticalAlignment = 2;
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(this.driverOptionsComposite, 2052);
            this.hostText.setToolTipText(IMS_NEWCW_HOST_HOVERTEXT);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.hostText.setEnabled(false);
            this.portLabel = new Label(this.driverOptionsComposite, 0);
            this.portLabel.setText(IMS_NEWCW_PORT_LBL);
            gd = new GridData();
            gd.verticalAlignment = 2;
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(this.driverOptionsComposite, 2052);
            this.portText.setToolTipText(IMS_NEWCW_PORT_HOVERTEXT);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.portText.setEnabled(false);
            this.useridLabel = new Label(this.driverOptionsComposite, 0);
            this.useridLabel.setText(IMS_NEWCW_USERID_LBL);
            gd = new GridData();
            gd.verticalAlignment = 2;
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 1;
            this.useridLabel.setLayoutData((Object)gd);
            this.useridText = new Text(this.driverOptionsComposite, 2052);
            this.useridText.setToolTipText(IMS_NEWCW_USER_HOVERTEXT);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.useridText.setLayoutData((Object)gd);
            this.useridText.setEnabled(false);
            this.passwordLabel = new Label(this.driverOptionsComposite, 0);
            this.passwordLabel.setText(IMS_NEWCW_PASSWORD_LBL);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(this.driverOptionsComposite, 0x400804 | additionalStyles);
            this.passwordText.setToolTipText(IMS_NEWCW_PASSWORD_HOVERTEXT);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.passwordText.setEnabled(false);
            this.savePasswordButton = new Button(this.driverOptionsComposite, 32);
            this.savePasswordButton.setText(IMS_NEWCW_SAVE_PASSWORD_LBL);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.savePasswordButton.setEnabled(false);
            this.currSchemaLabel = new Label(this.driverOptionsComposite, 0);
            this.currSchemaLabel.setText(IMS_NEWCW_CURR_SCHEMA_LBL);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 1;
            this.currSchemaLabel.setLayoutData((Object)gd);
            this.currSchemaText = new Text(this.driverOptionsComposite, 2052);
            this.currSchemaText.setToolTipText(IMS_NEWCW_CURR_SCHEMA_HOVERTEXT);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.currSchemaText.setLayoutData((Object)gd);
            this.currSchemaText.setEnabled(false);
            this.metadataSourceLabel = new Label(this.driverOptionsComposite, 0);
            this.metadataSourceLabel.setText(IMS_METADATASOURCE_LBL);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 4;
            this.metadataSourceLabel.setLayoutData((Object)gd);
            this.metadataSourceCombo = new Combo(this.driverOptionsComposite, 8);
            this.metadataSourceCombo.add(IMS_METADATASOURCE_CATALOG);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.metadataSourceCombo.setLayoutData((Object)gd);
            this.metadataSourceCombo.setText(IMS_METADATASOURCE_CATALOG);
            this.metadataSourceCombo.setEnabled(false);
            this.metadataComposite = new Composite(this.driverOptionsComposite, 0);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginLeft = -1;
            layout.marginRight = -1;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            this.metadataComposite.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalSpan = 4;
            gd.horizontalAlignment = 4;
            this.metadataComposite.setLayoutData((Object)gd);
            this.addCatalogWidgets();
            this.urlLabel = new Label(this.driverOptionsComposite, 0);
            this.urlLabel.setText(IMS_NEWCW_URL_LBL);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(this.driverOptionsComposite, 2634);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 3;
            gd.heightHint = 45;
            this.urlText.setLayoutData((Object)gd);
            this.urlText.setEnabled(false);
            this.optionalPropsComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout4 = new GridLayout();
            layout4.numColumns = 3;
            this.optionalPropsComposite.setLayout((Layout)layout4);
            optionalPropsTab.setControl((Control)this.optionalPropsComposite);
            this.sslConnectionLabel = new Label(this.optionalPropsComposite, 0);
            this.sslConnectionLabel.setText(IMS_NEWCW_SSLCONNECTION_LBL);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            this.sslConnectionLabel.setLayoutData((Object)gd);
            this.sslConnectionCombo = new Combo(this.optionalPropsComposite, 8);
            this.sslConnectionCombo.add(IMS_NEWCW_YES);
            this.sslConnectionCombo.add(IMS_NEWCW_NO);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            this.sslConnectionCombo.setLayoutData((Object)gd);
            Label fillerLabel = new Label(this.optionalPropsComposite, 0);
            fillerLabel.setText("");
            fillerLabel.setCapture(false);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            fillerLabel.setLayoutData((Object)gd);
            this.loginTimeoutLabel = new Label(this.optionalPropsComposite, 0);
            this.loginTimeoutLabel.setText(IMS_NEWCW_LOGINTIMEOUT_LBL);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            this.loginTimeoutLabel.setLayoutData((Object)gd);
            this.loginTimeoutText = new Text(this.optionalPropsComposite, 2052);
            this.loginTimeoutText.setToolTipText(IMS_NEWCW_LOGINTIMEOUT_HOVERTEXT);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.loginTimeoutText.setLayoutData((Object)gd);
            this.secondsLabel = new Label(this.optionalPropsComposite, 0);
            this.secondsLabel.setText(IMS_NEWCW_SECONDS_LBL);
            gd = new GridData();
            gd.verticalAlignment = 17408;
            this.secondsLabel.setLayoutData((Object)gd);
            this.datastoreLabel = new Label(this.optionalPropsComposite, 0);
            this.datastoreLabel.setText(IMS_NEWCW_DATASTORE_LBL);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            this.datastoreLabel.setLayoutData((Object)gd);
            this.datastoreText = new Text(this.optionalPropsComposite, 2052);
            this.datastoreText.setToolTipText(IMS_NEWCW_DATASTORE_HOVERTEXT);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.datastoreText.setLayoutData((Object)gd);
            this.datastoreText.setEnabled(true);
            Group propertiesGroup = new Group(this.optionalPropsComposite, 0);
            propertiesGroup.setText(ResourceLoader.ADDITIONAL_PROPERTIES);
            gd = new GridData();
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            propertiesGroup.setLayoutData((Object)gd);
            GridLayout layout5 = new GridLayout();
            layout5.numColumns = 5;
            propertiesGroup.setLayout((Layout)layout5);
            Label nameLabel = new Label((Composite)propertiesGroup, 0);
            nameLabel.setText(ResourceLoader.IMS_NEWCW_PROP_NAME);
            nameLabel.setToolTipText(ResourceLoader.IMS_NEWCW_OPTIONAL_PROPERTIES_1);
            this.nameText = new Text((Composite)propertiesGroup, 18432);
            this.nameText.setToolTipText(ResourceLoader.IMS_NEWCW_OPTIONAL_PROPERTIES_2);
            Label valueLabel = new Label((Composite)propertiesGroup, 0);
            valueLabel.setText(ResourceLoader.IMS_NEWCW_PROP_VALUE);
            valueLabel.setToolTipText(ResourceLoader.IMS_NEWCW_OPTIONAL_PROPERTIES_3);
            this.valueText = new Text((Composite)propertiesGroup, 18432);
            this.valueText.setToolTipText(ResourceLoader.IMS_NEWCW_OPTIONAL_PROPERTIES_4);
            this.addButton = new Button((Composite)propertiesGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.addButton.setLayoutData((Object)gd);
            this.addButton.setText(ResourceLoader.ADD);
            this.addButton.setSize(150, 30);
            this.propertiesTable = new Table((Composite)propertiesGroup, 2564);
            this.propertiesTable.setSize(450, 100);
            gd = new GridData();
            gd.verticalAlignment = 4;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            gd.verticalSpan = 4;
            this.propertiesTable.setLayoutData((Object)gd);
            this.moveUpButton = new Button((Composite)propertiesGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.moveUpButton.setLayoutData((Object)gd);
            this.moveUpButton.setText(ResourceLoader.MOVE_UP);
            this.moveDownButton = new Button((Composite)propertiesGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.moveDownButton.setLayoutData((Object)gd);
            this.moveDownButton.setText(ResourceLoader.MOVE_DOWN);
            this.removeButton = new Button((Composite)propertiesGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.removeButton.setLayoutData((Object)gd);
            this.removeButton.setText(ResourceLoader.REMOVE);
            this.clearAllButton = new Button((Composite)propertiesGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.clearAllButton.setLayoutData((Object)gd);
            this.clearAllButton.setText(ResourceLoader.CLEAR_ALL);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
        }
        return this.parentComposite;
    }

    private void addCatalogWidgets() {
        GridData gd = new GridData();
        Label dummyLabel = new Label(this.metadataComposite, 0);
        gd.horizontalSpan = 2;
        dummyLabel.setText(BUFFERSPACES);
        dummyLabel.setLayoutData((Object)gd);
        this.catalogPsbLabel = new Label(this.metadataComposite, 0);
        this.catalogPsbLabel.setText(IMS_NEWCW_PSB_LBL);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 131072;
        this.catalogPsbLabel.setLayoutData((Object)gd);
        this.catalogPsbText = new Text(this.metadataComposite, 2052);
        this.catalogPsbText.setText("DFSCP000");
        this.catalogPsbText.setToolTipText(IMS_NEWCW_CATALOGPSB_HOVERTEXT);
        this.catalogPsbText.addVerifyListener((VerifyListener)this);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        this.catalogPsbText.setLayoutData((Object)gd);
        this.catalogPsbText.setEditable(false);
        this.catalogPsbText.setEnabled(false);
    }

    public UnivDriverConnectionType getUnivDriverConnection() {
        return this.univDriverConnection;
    }

    private void removeListeners() {
        this.connectionProfileCombo.removeListener(24, (Listener)this);
        this.connectionProfileCombo.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.connectionNameText.removeListener(24, (Listener)this);
        this.connectionNameText.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.datastoreText.removeListener(24, (Listener)this);
        this.datastoreText.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.removeMetadataListeners();
        this.loginTimeoutText.removeListener(24, (Listener)this);
        this.loginTimeoutText.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.sslConnectionCombo.removeListener(24, (Listener)this);
        this.propertiesTable.removeListener(13, (Listener)this);
        this.addButton.removeListener(13, (Listener)this);
        this.moveUpButton.removeListener(13, (Listener)this);
        this.moveDownButton.removeListener(13, (Listener)this);
        this.removeButton.removeListener(13, (Listener)this);
        this.clearAllButton.removeListener(13, (Listener)this);
        this.nameText.removeListener(24, (Listener)this);
        this.nameText.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.valueText.removeListener(24, (Listener)this);
        this.valueText.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.urlText.removeFocusListener((FocusListener)this.textFocusHighLight);
    }

    private void addListeners() {
        this.connectionProfileCombo.addListener(24, (Listener)this);
        this.connectionProfileCombo.addFocusListener((FocusListener)this.textFocusHighLight);
        this.connectionNameText.addListener(24, (Listener)this);
        this.connectionNameText.addFocusListener((FocusListener)this.textFocusHighLight);
        this.datastoreText.addListener(24, (Listener)this);
        this.datastoreText.addFocusListener((FocusListener)this.textFocusHighLight);
        this.addMetadataListeners();
        this.loginTimeoutText.addListener(24, (Listener)this);
        this.loginTimeoutText.addFocusListener((FocusListener)this.textFocusHighLight);
        this.sslConnectionCombo.addListener(24, (Listener)this);
        this.propertiesTable.addListener(13, (Listener)this);
        this.addButton.addListener(13, (Listener)this);
        this.moveUpButton.addListener(13, (Listener)this);
        this.moveDownButton.addListener(13, (Listener)this);
        this.removeButton.addListener(13, (Listener)this);
        this.clearAllButton.addListener(13, (Listener)this);
        this.nameText.addListener(24, (Listener)this);
        this.nameText.addFocusListener((FocusListener)this.textFocusHighLight);
        this.valueText.addListener(24, (Listener)this);
        this.valueText.addFocusListener((FocusListener)this.textFocusHighLight);
        this.urlText.addFocusListener((FocusListener)this.textFocusHighLight);
    }

    private void removeMetadataListeners() {
        this.metadataSourceCombo.removeListener(24, (Listener)this);
        if (this.catalogPsbText != null) {
            this.catalogPsbText.removeListener(24, (Listener)this);
            this.catalogPsbText.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.browseButton != null) {
            this.browseButton.removeListener(24, (Listener)this);
        }
    }

    private void addMetadataListeners() {
        this.metadataSourceCombo.addListener(24, (Listener)this);
        if (this.catalogPsbText != null) {
            this.catalogPsbText.addListener(24, (Listener)this);
            this.catalogPsbText.addFocusListener((FocusListener)this.textFocusHighLight);
        }
    }

    public void setProperties(UnivDriverConnectionType udb, ConnectionProfile connectionProfile) {
        this.connectionProfile = connectionProfile;
        this.univDriverConnection = new UnivDriverConnectionType();
        this.univDriverConnection.setConnName(udb.getConnName());
        this.univDriverConnection.setCurrentSchema(udb.getCurrentSchema());
        this.univDriverConnection.setDatastoreName(udb.getDatastoreName());
        this.univDriverConnection.setDbViewLocation(udb.getDbViewLocation());
        this.univDriverConnection.setDpsbOnCommit(udb.isDpsbOnCommit());
        this.univDriverConnection.setDtpConnProfileName(udb.getDtpConnProfileName());
        this.univDriverConnection.setFetchSize(udb.getFetchSize());
        this.univDriverConnection.setIpAddr(udb.getIpAddr());
        this.univDriverConnection.setLoginTimeout(udb.getLoginTimeout());
        this.univDriverConnection.setMetadataClassName(udb.getMetadataClassName());
        this.univDriverConnection.setPort(udb.getPort());
        this.univDriverConnection.setPsbName(udb.getPsbName());
        this.univDriverConnection.setSslConnection(udb.isSslConnection());
        this.univDriverConnection.setTraceLevel(udb.getTraceLevel());
        this.univDriverConnection.setTraceDirectory(udb.getTraceDirectory());
        this.univDriverConnection.setTraceFile(udb.getTraceFile());
        this.univDriverConnection.setTraceFileAppend(udb.isTraceFileAppend());
        this.univDriverConnection.setDpsbOnCommit(Boolean.valueOf(true));
        List newPropList = this.univDriverConnection.getAdditionalProperty();
        List origPropList = udb.getAdditionalProperty();
        int i = 0;
        while (i < origPropList.size()) {
            newPropList.add((String)origPropList.get(i));
            ++i;
        }
    }

    public void loadProperties() {
        this.removeListeners();
        String profileName = this.univDriverConnection.getDtpConnProfileName();
        if (profileName != null) {
            if (this.connectionProfile == null) {
                this.setErrorMessage(IMS_CONNECTION_PROFILE_ERROR_MESSAGE + " " + profileName + ".");
                this.connectionProfileCombo.setText("");
                this.setValid(false);
            } else {
                this.connectionProfileCombo.setText(profileName);
            }
        } else {
            this.connectionProfileCombo.setText("");
        }
        String connName = this.univDriverConnection.getConnName();
        if (connName != null) {
            this.connectionNameText.setText(connName);
        } else {
            this.connectionNameText.setText("");
        }
        String host = this.univDriverConnection.getIpAddr();
        if (host != null) {
            this.hostText.setText(host);
        } else {
            this.hostText.setText("");
        }
        String port = this.univDriverConnection.getPort();
        if (port != null) {
            this.portText.setText(port);
        } else {
            this.portText.setText("");
        }
        String currentSchema = this.univDriverConnection.getCurrentSchema();
        if (currentSchema != null) {
            this.currSchemaText.setText(currentSchema);
        } else {
            this.currSchemaText.setText("");
        }
        boolean sslConnection = this.univDriverConnection.isSslConnection();
        if (sslConnection) {
            this.sslConnectionCombo.setText(IMS_NEWCW_YES);
        } else {
            this.sslConnectionCombo.setText(IMS_NEWCW_NO);
        }
        BigInteger loginTimeout = this.univDriverConnection.getLoginTimeout();
        if (loginTimeout != null) {
            this.loginTimeoutText.setText(String.valueOf(loginTimeout));
        } else {
            this.loginTimeoutText.setText("");
        }
        this.tracingOptionsComposite.initWidgets(this.univDriverConnection);
        String dataStoreName = this.univDriverConnection.getDatastoreName();
        if (dataStoreName != null) {
            this.datastoreText.setText(dataStoreName);
        } else {
            this.datastoreText.setText("");
        }
        this.propertiesTable.removeAll();
        TableItem propertyItem = new TableItem(this.propertiesTable, 16384);
        BigInteger fetchSize = this.univDriverConnection.getFetchSize();
        if (fetchSize != null) {
            propertyItem.setText("fetchSize=" + String.valueOf(fetchSize) + ";");
        }
        for (String propName : this.univDriverConnection.getAdditionalProperty()) {
            propertyItem = new TableItem(this.propertiesTable, 16384);
            propertyItem.setText(propName);
        }
        this.updateURL();
        this.addListeners();
    }

    @Override
    public void setConnectionInformation() {
        this.univDriverConnection.setDtpConnProfileName(this.connectionProfileCombo.getText().trim());
        this.univDriverConnection.setConnName(this.connectionNameText.getText().trim());
        String traceProperties = this.tracingOptionsComposite.getTracingURLProperties();
        if (!traceProperties.isEmpty()) {
            this.univDriverConnection.setTraceDirectory(this.tracingOptionsComposite.getTraceDirectory());
            this.univDriverConnection.setTraceFile(this.tracingOptionsComposite.getTraceFile());
            this.univDriverConnection.setTraceFileAppend(Boolean.valueOf(this.tracingOptionsComposite.getAppendFile()));
            this.univDriverConnection.setTraceLevel(new BigInteger(this.tracingOptionsComposite.getTraceLevel()));
        } else {
            this.univDriverConnection.setTraceFileAppend(Boolean.valueOf(false));
            this.univDriverConnection.setTraceLevel(null);
        }
        this.univDriverConnection.setSslConnection(Boolean.valueOf(this.sslConnectionCombo.getText().equals(IMS_NEWCW_YES)));
        String loginTimeoutStr = this.loginTimeoutText.getText();
        if (loginTimeoutStr != null && loginTimeoutStr.length() > 0) {
            try {
                int loginTimeout = Integer.parseInt(loginTimeoutStr);
                this.univDriverConnection.setLoginTimeout(BigInteger.valueOf(loginTimeout));
            }
            catch (NumberFormatException numberFormatException) {
                this.univDriverConnection.setLoginTimeout(null);
            }
        }
        this.univDriverConnection.setDatastoreName(this.datastoreText.getText());
        this.univDriverConnection.getAdditionalProperty().clear();
        TableItem[] items = this.propertiesTable.getItems();
        int i = 0;
        while (i < items.length) {
            String property = items[i].getText();
            int index = property.indexOf("fetchSize=");
            if (index > -1) {
                String fetchSize = property.substring(index + 10, property.length() - 1);
                try {
                    int loginTimeout = Integer.parseInt(fetchSize);
                    this.univDriverConnection.setFetchSize(BigInteger.valueOf(loginTimeout));
                }
                catch (NumberFormatException numberFormatException) {
                    this.univDriverConnection.setFetchSize(null);
                }
            } else {
                this.univDriverConnection.getAdditionalProperty().add(property);
            }
            ++i;
        }
    }

    @Override
    public void updateURL() {
        String loginTimeoutStr;
        String currSchema;
        String url = "jdbc:ims://" + this.hostText.getText().trim() + ":" + this.portText.getText().trim() + "/";
        String catalogPsbStr = this.catalogPsbText.getText().trim();
        url = catalogPsbStr.equals("") ? url + "<psbName>" : url + catalogPsbStr;
        url = url + ":dpsbOnCommit=true;";
        String datastoreName = this.datastoreText.getText();
        if (datastoreName != null && datastoreName.length() > 0) {
            url = url + "datastoreName=" + datastoreName + ";";
        }
        url = url + this.tracingOptionsComposite.getTracingURLProperties();
        if (this.sslConnectionCombo.getText().equals(IMS_NEWCW_YES)) {
            url = url + "sslConnection=true;";
        }
        if ((currSchema = this.currSchemaText.getText()) != null && !currSchema.isEmpty()) {
            url = url + "currentSchema=" + currSchema + ";";
        }
        if ((loginTimeoutStr = this.loginTimeoutText.getText()) != null && loginTimeoutStr.length() > 0) {
            try {
                Integer.parseInt(loginTimeoutStr);
                url = url + "loginTimeout=" + loginTimeoutStr + ";";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        TableItem[] items = this.propertiesTable.getItems();
        int i = 0;
        while (i < items.length) {
            url = url + items[i].getText();
            ++i;
        }
        this.urlText.setText(url);
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public void dispose() {
        this.removeListeners();
    }
}

