/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.cobol.spi.properties;

import com.ibm.adapter.cobol.CobolMessageResource;
import com.ibm.adapter.cobol.spi.properties.CobolBaseProperty;
import com.ibm.adapter.cobol.spi.properties.CobolExtDecimalSignProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class CobolExtDecimalSignHostCodePageProperty
extends CobolBaseProperty {
    private static String[] validValuesArray = null;
    private static String osCodePage = null;
    private static String noCodePage = new String();

    public CobolExtDecimalSignHostCodePageProperty() throws CoreException {
        super(CobolMessageResource.HOST_CODE_PAGE_PROP_NAME, CobolMessageResource.HOST_CODE_PAGE_PROP_DISPLAY_NAME, CobolMessageResource.HOST_CODE_PAGE_PROP_DESC);
        this.initializeProperty();
    }

    private void initializeProperty() {
        try {
            this.cobolKey = "com.ibm.etools.cobol.COBOL_HOST_CODEPAGE_EC";
            validValuesArray = (String[])this.findCodePages();
            osCodePage = "IBM-1047";
            super.setValidValues((Object[])validValuesArray);
            this.setDefaultValue(noCodePage);
            this.setValue(noCodePage);
            this.setExpert(true);
            this.setEnabled(false);
        }
        catch (CoreException ex) {
            this.envStatus = new Status(4, "com.ibm.adapter.cobol", 4, ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof CobolExtDecimalSignProperty) {
            if (((String)evt.getNewValue()).equalsIgnoreCase("EBCDIC Custom")) {
                try {
                    this.setEnabled(true);
                    this.setValue(osCodePage);
                }
                catch (CoreException e) {
                    this.envStatus = new Status(4, "com.ibm.adapter.cobol", 4, e.getMessage(), (Throwable)e);
                }
            } else if (this.isEnabled()) {
                this.unSet();
                this.setEnabled(false);
            }
        }
    }

    private Object[] findCodePages() {
        SortedMap<String, Charset> csMap = Charset.availableCharsets();
        Set<String> keySet = csMap.keySet();
        TreeSet<String> allCodepages = new TreeSet<String>();
        allCodepages.addAll(keySet);
        for (String canonicalCP : keySet) {
            Charset aCs = Charset.forName(canonicalCP);
            Set<String> aliasSet = aCs.aliases();
            if (aliasSet.isEmpty()) continue;
            for (String aliasCP : aliasSet) {
                allCodepages.add(aliasCP);
            }
        }
        allCodepages.add(new String());
        return allCodepages.toArray(new String[allCodepages.size()]);
    }
}

