/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.cobol;

import com.ibm.adapter.cobol.CobolMessageResource;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.spi.BaseResultNodeSelection;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLVariableLengthArray;
import com.ibm.etools.ctc.cobol2xsd.MessageResource;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class CobolResultSelection
extends BaseResultNodeSelection {
    protected Resource importerResource_ = null;

    public CobolResultSelection(Resource importerResource) {
        this.importerResource_ = importerResource;
    }

    protected String acceptAddition(IResultNode node) {
        if (!this.canAdd(node)) {
            return CobolMessageResource.ERROR_ONLY_ONE_SELECTION_ALLOWED;
        }
        String uriFragment = (String)node.getData();
        if (uriFragment == null) {
            return null;
        }
        COBOLElement cobolElement = (COBOLElement)this.importerResource_.getEObject(uriFragment);
        String selectedLevelString = cobolElement.getLevel();
        int selectedLevel = Integer.parseInt(selectedLevelString);
        if (selectedLevel > 1 && cobolElement.getSharedType() instanceof COBOLComposedType) {
            ArrayList dependentList = new ArrayList();
            this.findODODependentElements(dependentList, (COBOLComposedType)cobolElement.getSharedType());
            if (!dependentList.isEmpty()) {
                for (COBOLElement element : dependentList) {
                    String dependentLevelString = element.getLevel();
                    int dependentLevel = Integer.parseInt(dependentLevelString);
                    if (dependentLevel > selectedLevel) continue;
                    return MessageResource._ERROR_missing_depending_on_element;
                }
            }
        }
        return null;
    }

    public boolean canAdd(IResultNode node) {
        return this.internalSelection.size() <= 0;
    }

    protected void findODODependentElements(ArrayList dependentList, COBOLComposedType compType) {
        EList elements = compType.getElement();
        for (COBOLElement element : elements) {
            if (element.getArray() != null && element.getArray() instanceof COBOLVariableLengthArray) {
                COBOLVariableLengthArray vlArray = (COBOLVariableLengthArray)element.getArray();
                COBOLElement dependentElement = vlArray.getDependingOn();
                dependentList.add(dependentElement);
            }
            if (!(element.getSharedType() instanceof COBOLComposedType)) continue;
            this.findODODependentElements(dependentList, (COBOLComposedType)element.getSharedType());
        }
    }
}

