/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.cobol;

import com.ibm.adapter.cobol.CobolDiscoveryAgentMetaData;
import com.ibm.adapter.cobol.CobolImportResult;
import com.ibm.adapter.cobol.CobolMessageResource;
import com.ibm.adapter.cobol.CobolSearchTree;
import com.ibm.adapter.cobol.spi.properties.CobolFileProperty;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IDiscoveryAgentMetaData;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;

public class CobolDiscoveryAgent
extends BaseDiscoveryAgent {
    private String cobolFilePath = null;
    private URI cobolFilePathURI = null;
    private boolean isInitialized = false;
    private Resource importerResource;
    private String[] cobolFileExt = new String[]{"ccp", "cob", "cbl", "cpy"};

    public CobolDiscoveryAgent() {
        this.setMetaData((IDiscoveryAgentMetaData)new CobolDiscoveryAgentMetaData());
    }

    public IDiscoveryAgent newInstance() {
        return new CobolDiscoveryAgent();
    }

    private void validateCobolFile(URI cobolFilePathURI) throws BaseException {
        File cobolFile;
        if (cobolFilePathURI != null && cobolFilePathURI.isFile() && (cobolFile = new File(cobolFilePathURI.toFileString())).exists()) {
            this.cobolFilePath = cobolFile.getPath();
            String fileName = cobolFile.getName().toLowerCase();
            int i = 0;
            while (i < this.cobolFileExt.length) {
                if (fileName.endsWith(this.cobolFileExt[i]) && cobolFile.canRead() && cobolFile.length() != 0L) {
                    return;
                }
                ++i;
            }
        }
        Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, CobolMessageResource.INVALID_COBOL_FILE, null);
        throw new BaseException((IStatus)newStatus);
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        if (this.initializeProperties == null) {
            try {
                BasePropertyGroup propertyGroup = new BasePropertyGroup(CobolMessageResource.COBOL_FILE_PROP_GROUP_NAME, CobolMessageResource.COBOL_FILE_PROP_GROUP_DISPLAY_NAME, CobolMessageResource.COBOL_FILE_PROP_GROUP_DESC);
                CobolFileProperty cobolfile = new CobolFileProperty(CobolMessageResource.COBOL_FILE_PROP_NAME, CobolMessageResource.COBOL_FILE_PROP_DISPLAY_NAME, CobolMessageResource.COBOL_FILE_PROP_DESC, propertyGroup, this.cobolFileExt);
                cobolfile.setRequired(true);
                this.initializeProperties = propertyGroup;
            }
            catch (CoreException e) {
                throw new BaseException(e.getStatus());
            }
        }
        return this.initializeProperties;
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        CobolFileProperty cobolFileProperty = (CobolFileProperty)initializeProperties.getProperty(CobolMessageResource.COBOL_FILE_PROP_NAME);
        this.cobolFilePathURI = (URI)cobolFileProperty.getValue();
        this.cobolFileExt = cobolFileProperty.getFileExtensions();
        this.validateCobolFile(this.cobolFilePathURI);
        this.isInitialized = true;
    }

    public void close() throws BaseException {
        this.isInitialized = false;
    }

    public ISearchTree getSearchTree() throws BaseException {
        if (!this.isInitialized) {
            Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, CobolMessageResource.INITIALIZATION_REQUIRED, null);
            throw new BaseException((IStatus)newStatus);
        }
        URI cobolFileURI = URI.createFileURI((String)this.cobolFilePath);
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(cobolFileURI);
        this.importerResource = factory.createResource(cobolFileURI);
        return new CobolSearchTree(this.importerResource);
    }

    public IImportResult performImport(IEnvironment environment, IResultNodeSelection selection) throws BaseException {
        if (!this.isInitialized) {
            Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, CobolMessageResource.INITIALIZATION_REQUIRED, null);
            throw new BaseException((IStatus)newStatus);
        }
        IResultNode[] selectedNodes = selection.getSelection();
        if (selectedNodes.length == 1) {
            String uriFragment = (String)selectedNodes[0].getData();
            COBOLElement cobolElement = (COBOLElement)this.importerResource.getEObject(uriFragment);
            CobolImportResult importResult = new CobolImportResult(cobolElement);
            importResult.setImportFile(new File(this.cobolFilePath));
            return importResult;
        }
        Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, CobolMessageResource.ERROR_ONLY_ONE_SELECTION_ALLOWED, null);
        throw new BaseException((IStatus)newStatus);
    }
}

