/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.c2xsd.typesimport;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.StringTokenizer;
import java.util.List;
import java.util.Vector;

public class GeneralUtil {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    public static final String XSD_SOAPENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    private static GeneralUtil thisInstance;
    private static Vector KEYWORDS;

    static {
        KEYWORDS = new Vector();
    }

    public GeneralUtil() {
        KEYWORDS.add("abstract");
        KEYWORDS.add("boolean");
        KEYWORDS.add("byte");
        KEYWORDS.add("catch");
        KEYWORDS.add("class");
        KEYWORDS.add("extends");
        KEYWORDS.add("false");
        KEYWORDS.add("final");
        KEYWORDS.add("finally");
        KEYWORDS.add("implements");
        KEYWORDS.add("import");
        KEYWORDS.add("instanceof");
        KEYWORDS.add("interface");
        KEYWORDS.add("native");
        KEYWORDS.add("new");
        KEYWORDS.add("null");
        KEYWORDS.add("package");
        KEYWORDS.add("private");
        KEYWORDS.add("protected");
        KEYWORDS.add("public");
        KEYWORDS.add("super");
        KEYWORDS.add("synchronized");
        KEYWORDS.add("this");
        KEYWORDS.add("throw");
        KEYWORDS.add("throws");
        KEYWORDS.add("transient");
        KEYWORDS.add("true");
        KEYWORDS.add("try");
        KEYWORDS.add("volatile");
    }

    public static synchronized GeneralUtil getInstance() {
        if (thisInstance == null) {
            thisInstance = new GeneralUtil();
        }
        return thisInstance;
    }

    public String capitalizeFirstLetter(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() == 0) {
            return str;
        }
        int char32 = UTF16.charAt((String)str, (int)0);
        if (UCharacter.isUpperCase((int)char32)) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        char32 = UCharacter.toUpperCase((int)char32);
        UTF16.append((StringBuffer)sb, (int)char32);
        sb.append(str.substring(UTF16.getCharCount((int)char32)));
        return sb.toString();
    }

    public String getJavaNameFromXMLName(String xmlName, String delims) {
        int char32;
        StringBuffer buffer = new StringBuffer();
        boolean needUpperCase = false;
        int offset = 0;
        while (offset < xmlName.length()) {
            char32 = UTF16.charAt((String)xmlName, (int)offset);
            if (UCharacter.getCodePoint((char)'.') == char32 || UCharacter.isJavaIdentifierPart((int)char32) && UTF16.indexOf((String)delims, (int)char32) == -1) {
                if (needUpperCase) {
                    char32 = UCharacter.toUpperCase((int)char32);
                }
                UTF16.append((StringBuffer)buffer, (int)char32);
                needUpperCase = false;
            } else {
                needUpperCase = true;
            }
            offset += UTF16.getCharCount((int)char32);
        }
        if (buffer.length() != 0) {
            char32 = UTF16.charAt((StringBuffer)buffer, (int)0);
            if (!UCharacter.isJavaIdentifierStart((int)char32)) {
                buffer.insert(0, '_');
            }
            boolean allDigits = true;
            offset = 0;
            while (offset < buffer.length()) {
                char32 = UTF16.charAt((StringBuffer)buffer, (int)offset);
                if (!UCharacter.isDigit((int)char32)) {
                    allDigits = false;
                    break;
                }
                offset += UTF16.getCharCount((int)char32);
            }
            if (allDigits) {
                buffer.insert(0, '_');
            }
        }
        return this.mangleKeywords(buffer.toString());
    }

    public String getJavaNameFromXMLName(String xmlName) {
        return this.getJavaNameFromXMLName(xmlName, "-.:\u00b7\u0387\u06dd\u06de");
    }

    public String mangleKeywords(String name) {
        if (KEYWORDS.contains(name)) {
            name = "_" + name;
        }
        return name;
    }

    public void replaceOrAppendToList(List list, Object ele, int pos) {
        if (pos < 0) {
            list.add(ele);
        } else {
            list.set(pos, ele);
        }
    }

    public boolean isAllUpperCase(String str) {
        boolean allUpper = true;
        int offset = 0;
        while (offset < str.length()) {
            int char32 = UTF16.charAt((String)str, (int)offset);
            if (UCharacter.isLowerCase((int)char32)) {
                allUpper = false;
                break;
            }
            offset += UTF16.getCharCount((int)char32);
        }
        return allUpper;
    }

    public String toLowerUpperCaseToken(String str) {
        boolean leading2Underscores = false;
        if (str.startsWith("__")) {
            leading2Underscores = true;
        }
        StringTokenizer tokens = new StringTokenizer(str, "_");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (this.isAllUpperCase(token)) {
                token = token.toLowerCase();
            }
            if (buf.length() > 0) {
                buf.append("_");
            }
            buf.append(token);
        }
        String result = buf.toString();
        if (leading2Underscores) {
            result = "__" + result;
        }
        return result;
    }
}

