/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.ui.util;

import com.ibm.ims.datatools.sqltools.common.ui.internal.Activator;
import com.ibm.ims.datatools.sqltools.common.ui.util.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SWTUtils {
    public static final int DEFAULT_BUTTON_WIDTH = 70;
    public static final int DEFAULT_COMBO_WIDTH = 100;
    public static final int DEFAULT_TEXTBOX_WIDTH = 100;
    public static final int DEFAULT_RADIO_FILL = 36;
    static final String ENABLEKEY = "com.sybase.stf.dmp.ui.originalEnable";

    public static Button createCheckBox(Composite parent) {
        return SWTUtils.createCheckBox(parent, null, 1, 0);
    }

    public static Button createCheckBox(Composite parent, String label, int numColumns) {
        return SWTUtils.createCheckBox(parent, label, numColumns, 0);
    }

    public static Button createCheckBox(Composite parent, String label, int numColumns, int indent) {
        Button button = new Button(parent, 16416);
        if (label == null) {
            button.setAlignment(0x1000000);
        }
        GridData data = new GridData(4);
        data.horizontalSpan = numColumns;
        data.horizontalIndent = indent;
        button.setLayoutData((Object)data);
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static Combo createCombo(Composite parent, String[] items, int numColumns) {
        return SWTUtils.createCombo(parent, items, numColumns, 100);
    }

    public static Combo createCombo(Composite parent, String tokenString, int numColumns) {
        return SWTUtils.createCombo(parent, SWTUtils.getTokenNames(tokenString), numColumns, 100);
    }

    public static Combo createCombo(Composite parent, String tokenString, int numColumns, int minWidth) {
        return SWTUtils.createCombo(parent, SWTUtils.getTokenNames(tokenString), numColumns, minWidth);
    }

    public static Combo createCombo(Composite parent, String[] items, int numColumns, int minWidth) {
        return SWTUtils.createCombo(parent, items, numColumns, minWidth, false);
    }

    public static Combo createCombo(Composite parent, String tokenString, int numColumns, int minWidth, boolean editable) {
        return SWTUtils.createCombo(parent, SWTUtils.getTokenNames(tokenString), numColumns, minWidth, editable);
    }

    public static Combo createCombo(Composite parent, String[] items, int numColumns, int minWidth, boolean editable) {
        GridData data;
        Combo combo;
        if (editable) {
            combo = new Combo(parent, 4);
            data = new GridData(768);
        } else {
            combo = new Combo(parent, 12);
            data = new GridData(4);
        }
        data.horizontalSpan = numColumns;
        data.widthHint = minWidth;
        combo.setLayoutData((Object)data);
        combo.setItems(items);
        return combo;
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        return SWTUtils.createComposite(parent, numColumns, -1, -1, 768, -1, -1, -1);
    }

    public static Composite createComposite(Composite parent, int numColumns, int verticalSpacing, int horizontalSpan) {
        return SWTUtils.createComposite(parent, numColumns, verticalSpacing, horizontalSpan, 768, -1, -1, -1);
    }

    public static Composite createComposite(Composite parent, int numColumns, int verticalSpacing, int horizontalSpan, int gridDataFill) {
        return SWTUtils.createComposite(parent, numColumns, verticalSpacing, horizontalSpan, gridDataFill, -1, -1, -1);
    }

    public static Composite createComposite(Composite parent, int numColumns, int verticalSpacing, int horizontalSpan, int gridDataFill, int horizontalSpacing, int marginWidth, int marginHeight) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        if (verticalSpacing >= 0) {
            layout.verticalSpacing = verticalSpacing;
        }
        if (horizontalSpacing >= 0) {
            layout.horizontalSpacing = horizontalSpacing;
        }
        if (marginWidth >= 0) {
            layout.marginWidth = marginWidth;
        }
        if (marginHeight >= 0) {
            layout.marginHeight = marginHeight;
        }
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(gridDataFill);
        if (horizontalSpan > 0) {
            gd.horizontalSpan = horizontalSpan;
        }
        composite.setLayoutData((Object)gd);
        return composite;
    }

    public static Group createGroup(Composite parent, String title, int numColumns) {
        return SWTUtils.createGroup(parent, title, numColumns, -1, 768);
    }

    public static Group createGroup(Composite parent, String title, int numColumns, int horizontalSpan, int gridDataFill) {
        Group group = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(gridDataFill);
        if (horizontalSpan > 0) {
            data.horizontalSpan = horizontalSpan;
        }
        group.setLayoutData((Object)data);
        group.setText(title);
        return group;
    }

    public static Label createLabel(Composite parent, String text, int numColumns) {
        return SWTUtils.createLabel(parent, text, numColumns, 0);
    }

    public static Label createLabel(Composite parent, String text, int numColumns, int indent) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = numColumns;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        label.setLayoutData((Object)data);
        label.setText(text);
        return label;
    }

    public static Label createLableImage(Composite parent, Image theImage, int numColumns, Color background) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = numColumns;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        if (background != null) {
            label.setBackground(background);
        }
        label.setImage(theImage);
        return label;
    }

    public static Button createPushButton(Composite parent, String label) {
        return SWTUtils.createPushButton(parent, label, 70);
    }

    public static Button createPushButton(Composite parent, String label, int widthHint) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.horizontalAlignment = 768;
        data.widthHint = widthHint;
        button.setLayoutData((Object)data);
        button.setText(label);
        return button;
    }

    public static Button createPushButton(Composite parent, Image theImage, int widthHint) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.horizontalAlignment = 768;
        data.widthHint = widthHint;
        button.setLayoutData((Object)data);
        button.setImage(theImage);
        button.setAlignment(0x1000000);
        return button;
    }

    public static Button createRadioButton(Composite parent, String label) {
        return SWTUtils.createRadioButton(parent, label, 36);
    }

    public static Button createRadioButton(Composite parent, String label, int gridDataFill) {
        return SWTUtils.createRadioButton(parent, label, gridDataFill, 1);
    }

    public static Button createRadioButton(Composite parent, String label, int gridDataFill, int horizontalSpan) {
        Button button = new Button(parent, 16400);
        GridData data = new GridData(gridDataFill);
        data.horizontalSpan = horizontalSpan;
        button.setLayoutData((Object)data);
        button.setText(label);
        return button;
    }

    public static void createSpacer(Composite parent, int numColumns) {
        SWTUtils.createSpacer(parent, numColumns, 0);
    }

    public static void createSpacer(Composite parent, int numColumns, int minWidth) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = numColumns;
        data.widthHint = minWidth;
        label.setLayoutData((Object)data);
    }

    public static Table createTable(Composite composite, String tokenString, int tablewidth, int tableHeight) {
        int style = 68356;
        Table table = new Table(composite, style);
        GridData gridData = new GridData(1808);
        if (tablewidth > 0) {
            gridData.widthHint = tablewidth;
        }
        if (tableHeight > 0) {
            gridData.heightHint = tableHeight;
        }
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        if (tokenString != null) {
            String[] columns = SWTUtils.getTokenNames(tokenString);
            int columnSize = 50;
            if (tablewidth > 0) {
                columnSize = tablewidth / columns.length;
            }
            int ii = 0;
            while (ii < columns.length) {
                SWTUtils.createTableColumn(table, columns[ii], ii, columnSize);
                ++ii;
            }
        }
        return table;
    }

    public static Table createTable(Composite composite, String[] columns, int tablewidth) {
        Table table = new Table(composite, 65536);
        GridData gridData = new GridData(1808);
        gridData.widthHint = tablewidth;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        if (columns != null) {
            int i = 0;
            while (i < columns.length) {
                SWTUtils.createTableColumn(table, columns[i], i);
                ++i;
            }
        }
        return table;
    }

    public static TableColumn createTableColumn(Table parent, String name, int index) {
        TableColumn column = new TableColumn(parent, 16384, index);
        column.setText(name);
        return column;
    }

    public static TableColumn createTableColumn(Table parent, Image image, int index) {
        TableColumn column = new TableColumn(parent, 16384, index);
        column.setImage(image);
        column.setWidth(image.getBounds().width);
        column.setResizable(false);
        return column;
    }

    public static TableColumn createTableColumn(Table parent, String name, int index, int tablewidth) {
        TableColumn column = new TableColumn(parent, 16384, index);
        column.setText(name);
        column.setWidth(tablewidth);
        return column;
    }

    public static Text createTextBox(Composite parent) {
        return SWTUtils.createTextBox(parent, 1, 100);
    }

    public static Text createTextBox(Composite parent, String text) {
        Text textbox = SWTUtils.createTextBox(parent, 1);
        textbox.setText(text);
        return textbox;
    }

    public static Text createTextBox(Composite parent, int numColumns) {
        return SWTUtils.createTextBox(parent, numColumns, 100);
    }

    public static Text createTextBox(Composite parent, int numColumns, int minWidth) {
        return SWTUtils.createTextBox(parent, numColumns, minWidth, -1);
    }

    public static Text createTextBox(Composite parent, int numColumns, int minWidth, int minHeight) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(4);
        data.horizontalSpan = numColumns;
        data.widthHint = minWidth;
        data.heightHint = minHeight;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createTextBoxScrollable(Composite parent, int numColumns, int minWidth, int minHeight) {
        Text text = new Text(parent, 2624);
        GridData data = new GridData(minWidth > 0 ? 4 : 768);
        data.horizontalSpan = numColumns;
        if (minWidth > 0) {
            data.widthHint = minWidth;
        }
        data.heightHint = minHeight;
        text.setLayoutData((Object)data);
        return text;
    }

    public static List createList(Composite parent, int numColumns, int minWidth, int minHeight, String[] items) {
        return SWTUtils.createList(parent, numColumns, minWidth, minHeight, items, true);
    }

    public static List createList(Composite parent, int numColumns, int minWidth, int minHeight, String[] items, boolean bmulti) {
        return SWTUtils.createList(parent, numColumns, minWidth, minHeight, items, bmulti, 1);
    }

    public static List createList(Composite parent, int numColumns, int minWidth, int minHeight, String[] items, boolean bmulti, int verticalSpan) {
        List theList = bmulti ? new List(parent, 2818) : new List(parent, 2820);
        GridData data = new GridData(1810);
        data.horizontalSpan = numColumns;
        data.widthHint = minWidth;
        data.heightHint = minHeight;
        data.verticalSpan = verticalSpan;
        theList.setLayoutData((Object)data);
        if (items != null) {
            theList.setItems(items);
        }
        return theList;
    }

    public static void computeScrollArea(ScrolledComposite parentComposite, Composite childComposite) {
        Point pt = childComposite.computeSize(-1, -1);
        parentComposite.setExpandHorizontal(true);
        parentComposite.setExpandVertical(true);
        parentComposite.setMinWidth(pt.x);
        parentComposite.setMinHeight(pt.y);
    }

    public static String[] getTokenNames(String tokenString) {
        if (tokenString == null) {
            return new String[0];
        }
        return tokenString.split(",");
    }

    public static void listenModify(Composite container, Listener listener, Widget[] except) {
        Control[] children = container.getChildren();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            block15: {
                block14: {
                    if (except == null) break block14;
                    boolean found = false;
                    int j = 0;
                    while (j < except.length) {
                        if (except[j] == children[i]) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (found) break block15;
                }
                if (children[i] instanceof Combo || children[i] instanceof Text || children[i] instanceof Spinner) {
                    children[i].addListener(24, listener);
                    children[i].addListener(13, listener);
                } else if (children[i] instanceof Table) {
                    children[i].addListener(24, listener);
                    children[i].addListener(13, listener);
                } else if (!(children[i] instanceof Label)) {
                    if (children[i] instanceof Composite) {
                        SWTUtils.listenModify((Composite)children[i], listener, except);
                    } else {
                        children[i].addListener(13, listener);
                    }
                }
            }
            ++i;
        }
    }

    public static boolean notEmpty(Text text) {
        return text.getText() != null && !"".equals(text.getText().trim());
    }

    public static boolean notEmpty(Combo text) {
        return text != null && text.getText() != null && !"".equals(text.getText().trim());
    }

    public static void recursiveEnable(Control control, boolean enable) {
        if (enable) {
            Object o = control.getData(ENABLEKEY);
            control.setData(ENABLEKEY, null);
            if (o instanceof Boolean) {
                control.setEnabled(((Boolean)o).booleanValue());
            } else {
                control.setEnabled(true);
            }
        } else {
            control.setData(ENABLEKEY, (Object)control.getEnabled());
            control.setEnabled(false);
        }
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                SWTUtils.recursiveEnable(children[i], enable);
                ++i;
            }
        }
    }

    public static int getTableHeightHint(Table table, int rows) {
        if (table.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            table.setFont(JFaceResources.getDialogFont());
        }
        int result = table.getItemHeight() * rows + table.getHeaderHeight();
        if (table.getLinesVisible()) {
            result += table.getGridLineWidth() * (rows - 1);
        }
        return result;
    }

    public static void processError(final String msg, final Exception error, final IStatus status) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IStatus stat = status;
                if (stat == null) {
                    stat = new Status(4, "com.ibm.ims.datatools.sqltools.common.ui", 0, error.getMessage() == null ? "" : error.getMessage(), (Throwable)error);
                }
                String title = Messages.common_error;
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)msg, (IStatus)stat);
            }
        });
        Activator.getDefault().log(msg, error);
    }
}

