/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.ui.tableviewer;

import com.ibm.ims.datatools.sqltools.common.core.tableviewer.IRowData;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.ITableData;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.CellSelection;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.TableCheckBoxCellEditor;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.TableCursor;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.TableDataCellModifier;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableDataTableCursor
extends TableCursor
implements ISelectionProvider {
    protected AccessibleTableViewer _tableViewer;
    protected ListenerList<ISelectionChangedListener> _selectionChangedListeners = new ListenerList();

    public TableDataTableCursor(AccessibleTableViewer tableViewer) {
        super(tableViewer.getTable(), 0);
        this._tableViewer = tableViewer;
        tableViewer.setCursor(this);
        this.setBackground(Display.getDefault().getSystemColor(26));
        this.setForeground(Display.getDefault().getSystemColor(27));
    }

    public void registerListeners() {
        this.registerCellEditorsListener();
        this.registerSelectionListener();
        this.registerKeyListener();
        this.registerMouseListener();
        this.registerTraverseListener();
    }

    protected void registerTraverseListener() {
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                TableDataTableCursor.this.handleTraverse(e);
            }
        });
    }

    protected void registerMouseListener() {
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    TableDataTableCursor.this.edit();
                    CellEditor editor = TableDataTableCursor.this._tableViewer.getCellEditors()[TableDataTableCursor.this.getColumn()];
                    if (editor instanceof TableCheckBoxCellEditor) {
                        Boolean value = (Boolean)((TableCheckBoxCellEditor)editor).doGetValue();
                        ((TableCheckBoxCellEditor)editor).doSetValue(value == false);
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void registerKeyListener() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character != '\u0000' && e.character != '\r' && e.character != '\n' && e.character != '\b' && e.character != '\u007f' && e.character != '\t' && e.character != '\u001b' && (e.stateMask == 0 || e.stateMask == 131072)) {
                    TableDataTableCursor.this.edit();
                    CellEditor editor = TableDataTableCursor.this._tableViewer.getCellEditors()[TableDataTableCursor.this.getColumn()];
                    if (editor instanceof TextCellEditor) {
                        editor.setValue((Object)String.valueOf(e.character));
                        ((Text)editor.getControl()).setSelection(1);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected void registerSelectionListener() {
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDataTableCursor.this.selectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableDataTableCursor.this.edit();
            }
        });
    }

    protected void registerCellEditorsListener() {
        ICellEditorListener editorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                TableDataTableCursor.this.setVisible(true);
                TableDataTableCursor.this.redraw();
            }

            public void cancelEditor() {
                TableDataTableCursor.this.setVisible(true);
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
        CellEditor[] editors = this._tableViewer.getCellEditors();
        int i = 0;
        while (i < editors.length) {
            if (editors[i] != null) {
                editors[i].addListener(editorListener);
            }
            ++i;
        }
    }

    public void edit() {
        ((TableDataCellModifier)this._tableViewer.getCellModifier()).setCanModify(true);
        if (((ITableData)this._tableViewer.getInput()).isReadonly()) {
            return;
        }
        if (this._tableViewer.getCellEditors()[this.getColumn()] == null) {
            return;
        }
        Object object = null;
        try {
            object = this.getRow().getData();
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        ICellModifier cellModifier = this._tableViewer.getCellModifier();
        if (cellModifier == null) {
            this.setVisible(false);
            return;
        }
        if (!((TableDataCellModifier)this._tableViewer.getCellModifier()).canChange(object, this.getColumn())) {
            return;
        }
        this._tableViewer.editElement(object, this.getColumn() + 1);
        ((TableDataCellModifier)this._tableViewer.getCellModifier()).setCanModify(false);
        this.setVisible(false);
    }

    /*
     * Unable to fully structure code
     */
    protected void handleTraverse(TraverseEvent event) {
        row = this.getRow() == null ? 0 : this._tableViewer.getTable().indexOf(this.getRow());
        col = this.getColumn() + 1;
        columnCount = this._tableViewer.getTable().getColumnCount() - 1;
        itemCount = this._tableViewer.getTable().getItemCount() - 1;
        cellModifier = (TableDataCellModifier)this._tableViewer.getCellModifier();
        canChange = false;
        tableData = (ITableData)this._tableViewer.getInput();
        switch (event.detail) {
            case 8: {
                if (col - 1 == 0) ** GOTO lbl29
                --col;
                while (!canChange) {
                    if (row <= tableData.getRows().size() - 1) {
                        rowData = (IRowData)tableData.getRows().get(row);
                        if (col > 0) {
                            canChange = cellModifier.canChange(rowData, col - 1);
                        }
                        if (!canChange) {
                            if (col > 0) {
                                --col;
                                continue;
                            }
                            if (row > 0) {
                                --row;
                                col = columnCount;
                                continue;
                            }
                            return;
                        }
                    }
                    ** GOTO lbl46
                }
                ** GOTO lbl46
lbl29:
                // 1 sources

                if (row == 0) ** GOTO lbl45
                col = columnCount;
                rowData = (IRowData)tableData.getRows().get(--row);
                while (!canChange) {
                    canChange = cellModifier.canChange(rowData, col - 1);
                    if (!canChange) {
                        if (col > 0) {
                            --col;
                            continue;
                        }
                        if (row > 0) {
                            --row;
                            col = columnCount;
                            continue;
                        }
                        return;
                    }
                    ** GOTO lbl46
                }
                ** GOTO lbl46
lbl45:
                // 1 sources

                return;
lbl46:
                // 4 sources

                this.setSelection(row, col);
                event.doit = false;
                return;
            }
            case 16: {
                if (col == columnCount) ** GOTO lbl67
                ++col;
                while (this._tableViewer.getTable().getColumns()[col].getWidth() == 0) {
                    ++col;
                }
                while (!canChange) {
                    if (row <= tableData.getRows().size() - 1 && !(canChange = cellModifier.canChange(rowData = (IRowData)tableData.getRows().get(row), col - 1))) {
                        if (col < columnCount) {
                            ++col;
                            continue;
                        }
                        if (row < itemCount) {
                            ++row;
                            col = 0;
                            continue;
                        }
                        return;
                    }
                    ** GOTO lbl90
                }
                ** GOTO lbl90
lbl67:
                // 1 sources

                if (row == itemCount) ** GOTO lbl89
                col = 1;
                ++row;
                while (!canChange) {
                    if (row <= tableData.getRows().size()) {
                        if (row < tableData.getRows().size()) {
                            rowData = (IRowData)tableData.getRows().get(row);
                            canChange = cellModifier.canChange(rowData, col - 1);
                        } else {
                            canChange = cellModifier.canChange(new Object(), col - 1);
                        }
                        if (!canChange) {
                            if (col < columnCount) {
                                ++col;
                                continue;
                            }
                            if (row < itemCount) {
                                ++row;
                                col = 0;
                                continue;
                            }
                            return;
                        }
                    }
                    ** GOTO lbl90
                }
                ** GOTO lbl90
lbl89:
                // 1 sources

                return;
lbl90:
                // 4 sources

                this.setSelection(row, col);
                event.doit = false;
                return;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.getRow() == null) {
            return null;
        }
        return new CellSelection(this.getRow().getData(), this.getColumn());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged() {
        for (final ISelectionChangedListener l : this._selectionChangedListeners) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)TableDataTableCursor.this, TableDataTableCursor.this.getSelection()));
                }
            });
        }
    }

    @Override
    public void setSelection(int row, int column) {
        if (column == 0) {
            ++column;
        }
        super.setSelection(row, column);
    }

    @Override
    public void setSelection(TableItem row, int column) {
        if (column == 0) {
            ++column;
        }
        super.setSelection(row, column);
    }

    @Override
    public int getColumn() {
        if (super.getColumn() == 0) {
            return super.getColumn();
        }
        return super.getColumn() - 1;
    }

    public int getTableRow() {
        return this.getRow() == null ? 0 : this._tableViewer.getTable().indexOf(this.getRow());
    }
}

