/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.ui.tableviewer;

import com.ibm.ims.datatools.sqltools.common.core.tableviewer.DataDeserializer;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.DataSerializer;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.IRowData;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.Messages;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.TableComboBoxCellEditor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Shell;

public class TableDataCellModifier
implements ICellModifier {
    protected AccessibleTableViewer _viewer;
    protected boolean _canModify = true;

    public boolean canChange(Object element, int index) {
        return true;
    }

    public TableDataCellModifier(AccessibleTableViewer viewer) {
        this._viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        return this._canModify && !this._viewer.isReadonly();
    }

    public void setCanModify(boolean canModify) {
        this._canModify = canModify;
    }

    public Object getValue(Object element, String property) {
        int col = this.getColumnIndex(property);
        CellEditor[] cellEditor = this._viewer.getCellEditors();
        if (!(element instanceof IRowData)) {
            if (cellEditor[col] instanceof TableComboBoxCellEditor) {
                return -1;
            }
            return "";
        }
        IRowData row = (IRowData)element;
        try {
            Object o = row.getValue(col);
            String s = DataSerializer.serialize(o, row.getTableData().getColumnType(col));
            if (cellEditor[col] instanceof ComboBoxCellEditor) {
                ComboBoxCellEditor comboBoxCellEditor = (ComboBoxCellEditor)cellEditor[col];
                String[] values = comboBoxCellEditor.getItems();
                int i = 0;
                while (i < values.length) {
                    if (values[i].equals(s)) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }
            if (cellEditor[col] instanceof CheckboxCellEditor) {
                CheckboxCellEditor cfr_ignored_0 = (CheckboxCellEditor)cellEditor[col];
                if (s != null && s.equalsIgnoreCase("true")) {
                    return true;
                }
                return false;
            }
            return s == null ? "" : s;
        }
        catch (Exception exception) {
            return Messages.TableDataCellModifier_error;
        }
    }

    public void modify(Object element, String property, Object value) {
        int column = this.getColumnIndex(property);
        IRowData row = this._viewer.getOrCreateRow();
        Object oldObject = row.getValue(column);
        String oldString = DataSerializer.serialize(oldObject, row.getTableData().getColumnType(column));
        if (value.equals(oldString)) {
            return;
        }
        try {
            this._viewer.setDirty(true);
            Object inputValue = null;
            CellEditor[] cellEditor = this._viewer.getCellEditors();
            if (cellEditor[column] instanceof TableComboBoxCellEditor) {
                String text = ((CCombo)this._viewer.getCellEditors()[column].getControl()).getText();
                row.updateValue(column, text);
            } else if (cellEditor[column] instanceof CheckboxCellEditor) {
                row.updateValue(column, value.toString());
            } else {
                inputValue = value;
                Object o = DataDeserializer.deserialize((String)inputValue, row.getTableData().getColumnType(column));
                row.updateValue(column, o);
            }
        }
        catch (Exception ex) {
            Status warning = new Status(4, "com.ibm.ims.datatools.sqltools.common.ui", 1, Messages.TableDataCellModifier_data_type_conform, (Throwable)ex);
            ErrorDialog.openError((Shell)this._viewer.getControl().getShell(), (String)Messages.TableDataCellModifier_error_in_update, null, (IStatus)warning);
        }
        this._viewer.refreshViewer(row);
    }

    protected int getColumnIndex(String property) {
        Object[] properties = this._viewer.getColumnProperties();
        int col = 0;
        while (properties[col] != property && col < properties.length) {
            ++col;
        }
        if (col == properties.length) {
            return -1;
        }
        return col;
    }
}

