/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.ui.tableviewer;

import com.ibm.ims.datatools.sqltools.common.core.tableviewer.IRowData;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TableComboBoxCellEditor
extends ComboBoxCellEditor {
    private CCombo _combo;
    public static final int VISIBLE_ITEM_COUNT = 15;
    protected AccessibleTableViewer _accessibleTableViewer;

    public TableComboBoxCellEditor(AccessibleTableViewer accessibleTableViewer, Composite parent, String[] items, int style) {
        super(parent, items, style);
        this._accessibleTableViewer = accessibleTableViewer;
    }

    public TableComboBoxCellEditor(AccessibleTableViewer accessibleTableViewer, String[] items) {
        this(accessibleTableViewer, items, 0);
    }

    public TableComboBoxCellEditor(AccessibleTableViewer accessibleTableViewer, String[] items, int style) {
        super((Composite)accessibleTableViewer.getTable(), items, style);
        this._accessibleTableViewer = accessibleTableViewer;
        this.setItems(items);
        if (items.length > 15) {
            this._combo.setVisibleItemCount(15);
        } else {
            this._combo.setVisibleItemCount(items.length);
        }
    }

    protected Control createControl(Composite parent) {
        Control c = super.createControl(parent);
        c.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                TableComboBoxCellEditor.this.handleTraverse(e);
            }
        });
        c.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TableComboBoxCellEditor.this.setText();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this._combo = (CCombo)c;
        return c;
    }

    protected void handleTraverse(TraverseEvent e) {
        if (e.detail == 8 || e.detail == 16) {
            this.fireApplyEditorValue();
            this.deactivate();
            this._accessibleTableViewer.getCursor().handleTraverse(e);
            this._accessibleTableViewer.getCursor().edit();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        }
    }

    private void setText() {
        String text;
        int col;
        IRowData rowData = this._accessibleTableViewer.getRow();
        if (rowData != null && rowData.getValue(col = this._accessibleTableViewer.getCursor().getColumn()) instanceof String && (text = (String)rowData.getValue(col)) != null) {
            ((CCombo)this.getControl()).setText(text);
        }
    }

    public void setItems(String[] items) {
        if (items.length > 15) {
            this._combo.setVisibleItemCount(15);
        } else {
            this._combo.setVisibleItemCount(items.length);
        }
        super.setItems(items);
    }

    public CCombo getCombo() {
        return this._combo;
    }
}

