/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.ui.tableviewer;

import com.ibm.ims.datatools.help.HelpUtil;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.IRowData;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.ITableData;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.RowData;
import com.ibm.ims.datatools.sqltools.common.ui.internal.Activator;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.Messages;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.ObjectTransfer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class PasteRowAction
extends Action {
    protected Clipboard _clipboard;
    protected int _insertIndex;
    protected AccessibleTableViewer _accessibleTableViewer;

    public PasteRowAction(AccessibleTableViewer accessibleTableViewer, Clipboard clipboard) {
        this.setText(Messages.PasteRowAction_text);
        this._accessibleTableViewer = accessibleTableViewer;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this._clipboard = clipboard;
        this.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"paste_row_action", (String)Activator.getDefault().getBundle().getSymbolicName()));
    }

    public void setViewer(AccessibleTableViewer accessibleTableViewer) {
        this._accessibleTableViewer = accessibleTableViewer;
    }

    public void run() {
        if (!((ITableData)this._accessibleTableViewer.getInput()).isNewRowDataAllowed()) {
            return;
        }
        if (this._clipboard == null || !this._accessibleTableViewer.getCursor().getVisible()) {
            return;
        }
        RowData rowData = (RowData)this._clipboard.getContents((Transfer)ObjectTransfer.getInstance());
        ITableData tableData = (ITableData)this._accessibleTableViewer.getInput();
        Object rData = null;
        try {
            rData = rowData.clone();
            ((RowData)rData).setTableData(tableData);
            TableItem selectedItem = this._accessibleTableViewer.getCursor().getRow();
            this._insertIndex = selectedItem != null ? this._accessibleTableViewer.getTable().indexOf(selectedItem) : 0;
            tableData.insertRow((IRowData)rData, this._insertIndex);
            this._accessibleTableViewer.refresh();
        }
        catch (Exception ex) {
            Status warning = new Status(4, "com.ibm.ims.datatools.sqltools.common.ui", 1, Messages.PasteRowAction_can_not_paste_info, (Throwable)ex);
            ErrorDialog.openError((Shell)this._accessibleTableViewer.getControl().getShell(), (String)Messages.PasteRowAction_can_not_paste_title, null, (IStatus)warning);
        }
    }

    public void updateEnablement() {
        this.setEnabled(false);
        if (this._clipboard == null) {
            return;
        }
        IRowData rowData = (IRowData)this._clipboard.getContents((Transfer)ObjectTransfer.getInstance());
        if (rowData == null) {
            return;
        }
        this.setEnabled(true);
    }
}

