/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.ui.tableviewer;

import com.ibm.ims.datatools.help.HelpUtil;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.IRowData;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.RowData;
import com.ibm.ims.datatools.sqltools.common.ui.internal.Activator;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.Messages;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.ObjectTransfer;
import com.ibm.ims.datatools.sqltools.common.ui.tableviewer.TableDataTableCursor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CopyRowAction
extends Action {
    private Clipboard _clipboard;
    private AccessibleTableViewer _accessibleTableViewer;

    public CopyRowAction(AccessibleTableViewer accessibleTableViewer, Clipboard clipboard) {
        this.setText(Messages.CopyRowAction_text);
        this._accessibleTableViewer = accessibleTableViewer;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this._clipboard = clipboard;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"copy_row_action", (String)Activator.getDefault().getBundle().getSymbolicName()));
    }

    public void setViewer(AccessibleTableViewer accessibleTableViewer) {
        this._accessibleTableViewer = accessibleTableViewer;
    }

    public void run() {
        if (this._clipboard == null) {
            return;
        }
        TableDataTableCursor cursor = this._accessibleTableViewer.getCursor();
        if (!cursor.getVisible() || cursor.getRow() == null || !(cursor.getRow().getData() instanceof IRowData)) {
            return;
        }
        RowData rowData = (RowData)cursor.getRow().getData();
        Object rData = null;
        try {
            rData = rowData.clone();
            Object[] data = new Object[]{rData};
            Transfer[] transfers = new Transfer[]{ObjectTransfer.getInstance()};
            this._clipboard.setContents(data, transfers);
            this._accessibleTableViewer.refresh();
        }
        catch (Exception ex) {
            Status warning = new Status(4, "com.ibm.ims.datatools.sqltools.common.ui", 1, Messages.CopyRowAction_can_not_copy_info, (Throwable)ex);
            ErrorDialog.openError((Shell)this._accessibleTableViewer.getControl().getShell(), (String)Messages.CopyRowAction_can_not_copy_title, null, (IStatus)warning);
        }
    }

    public void updateEnablement() {
        this.setEnabled(false);
        if (this._clipboard == null) {
            return;
        }
        if (this._accessibleTableViewer == null || this._accessibleTableViewer.getCursor().isDisposed() || this._accessibleTableViewer.getCursor().getRow() == null || !(this._accessibleTableViewer.getCursor().getRow().getData() instanceof IRowData)) {
            return;
        }
        this.setEnabled(true);
    }
}

