/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.ui.resource;

import com.ibm.ims.datatools.sqltools.common.ui.resource.ContainerSelectionGroup;
import com.ibm.ims.datatools.sqltools.common.ui.resource.Messages;
import com.ibm.ims.explorer.common.util.PosixPortablePathValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ResourceAndContainerGroup
implements Listener {
    public static final int PROBLEM_NONE = 0;
    public static final int PROBLEM_RESOURCE_EMPTY = 1;
    public static final int PROBLEM_RESOURCE_EXIST = 2;
    public static final int PROBLEM_RESOURCE_CONTAINS_SEPARATOR = 3;
    public static final int PROBLEM_PATH_INVALID = 4;
    public static final int PROBLEM_CONTAINER_EMPTY = 5;
    public static final int PROBLEM_PROJECT_DOES_NOT_EXIST = 6;
    public static final int PROBLEM_NAME_INVALID = 7;
    public static final int PROBLEM_LINKED_PROJECT = 8;
    protected static final String LINKED_NATURE_ID = "com.sybase.stf.navigator.linked.NavLinkedNature";
    private String _PLAINTYPE = "";
    private Listener _client;
    private boolean _allowExistingResources = false;
    private String _resourceType = Messages.ResourceGroup_resource;
    private boolean _showClosedProjects = true;
    private String _problemMessage = "";
    private int _problemType = 0;
    private ContainerSelectionGroup _containerGroup;
    private Text _resourceNameField;
    private static final int _SIZING_TEXT_FIELD_WIDTH = 250;

    public ResourceAndContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType) {
        this(parent, client, resourceFieldLabel, resourceType, true);
    }

    public ResourceAndContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, boolean showClosedProjects) {
        this(parent, client, resourceFieldLabel, resourceType, showClosedProjects, -1);
    }

    public ResourceAndContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, boolean showClosedProjects, int heightHint) {
        this._resourceType = resourceType;
        this._showClosedProjects = showClosedProjects;
        this.createContents(parent, resourceFieldLabel, heightHint);
        this._client = client;
    }

    public boolean areAllValuesValid() {
        return this._problemType == 0;
    }

    protected void createContents(Composite parent, String resourceLabelString, int heightHint) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        this._containerGroup = heightHint == -1 ? new ContainerSelectionGroup(composite, this, true, null, this._showClosedProjects) : new ContainerSelectionGroup(composite, this, true, null, this._showClosedProjects, heightHint);
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        nameGroup.setFont(font);
        Label label = new Label(nameGroup, 0);
        label.setText(resourceLabelString);
        label.setFont(font);
        this._resourceNameField = new Text(nameGroup, 2048);
        this._resourceNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this._resourceNameField.setLayoutData((Object)data);
        this._resourceNameField.setFont(font);
        this.createAdvancedContents(composite, layout, font, data);
        this.validateControls();
    }

    protected void createAdvancedContents(Composite composite, GridLayout layout, Font font, GridData data) {
    }

    public IPath getContainerFullPath() {
        return this._containerGroup.getContainerFullPath();
    }

    public String getProblemMessage() {
        return this._problemMessage;
    }

    public int getProblemType() {
        return this._problemType;
    }

    public String getResource() {
        return this._resourceNameField.getText();
    }

    public void handleEvent(Event e) {
        this.validateControls();
        if (this._client != null) {
            this._client.handleEvent(e);
        }
    }

    public void setAllowExistingResources(boolean value) {
        this._allowExistingResources = value;
    }

    public void setContainerFullPath(IPath path) {
        IResource initial = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (initial != null) {
            if (!(initial instanceof IContainer)) {
                initial = initial.getParent();
            }
            this._containerGroup.setSelectedContainer((IContainer)initial);
        }
        this.validateControls();
    }

    public void setFocus() {
        this._containerGroup.setInitialFocus();
        this._resourceNameField.setSelection(0, this._resourceNameField.getText().length());
        this._resourceNameField.setFocus();
    }

    public void setResource(String value) {
        this._resourceNameField.setText(value);
        this.validateControls();
    }

    protected boolean validateContainer() {
        IPath path = this._containerGroup.getContainerFullPath();
        if (path == null) {
            this._problemType = 5;
            this._problemMessage = Messages.ResourceGroup_folderEmpty;
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = path.segment(0);
        IProject project = workspace.getRoot().getProject(projectName);
        if (projectName == null || !project.exists()) {
            this._problemType = 6;
            this._problemMessage = Messages.ResourceGroup_noProject;
            return false;
        }
        try {
            if (project.hasNature(LINKED_NATURE_ID)) {
                this._problemType = 8;
                this._problemMessage = Messages.ResourceAndContainerGroup_error_linked_project;
                return false;
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    protected boolean validateControls() {
        if (this._containerGroup == null) {
            return false;
        }
        this._problemType = 0;
        this._problemMessage = "";
        if (!this.validateContainer() || !this.validateResourceName()) {
            return false;
        }
        IPath path = this._containerGroup.getContainerFullPath().append(this._resourceNameField.getText());
        return this.validateFullResourcePath(path);
    }

    protected boolean validateFullResourcePath(IPath resourcePath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(resourcePath.toString(), 2);
        if (!result.isOK()) {
            this._problemType = 4;
            this._problemMessage = result.getMessage();
            return false;
        }
        if (!this._allowExistingResources && (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists())) {
            this._problemType = 2;
            this._problemMessage = Messages.ResourceGroup_nameExists;
            return false;
        }
        return true;
    }

    protected boolean validateResourceName() {
        String resourceName = this._resourceNameField.getText();
        if (resourceName.equals("")) {
            this._problemType = 1;
            this._problemMessage = NLS.bind((String)Messages.ResourceGroup_emptyName, (Object)this._resourceType);
            return false;
        }
        if (!PosixPortablePathValidator.isPortableName((String)resourceName)) {
            this._problemType = 7;
            this._problemMessage = NLS.bind((String)Messages.ResourceGroup_invalidFilename, (Object)resourceName);
            return false;
        }
        return true;
    }
}

