/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboFieldEditor
extends FieldEditor {
    private Combo _fCombo;
    private String _fValue;
    private String[][] _fEntryNamesAndValues;

    public ComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this._fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this._fCombo.getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this._fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this._fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this._fValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(Composite parent) {
        if (this._fCombo == null) {
            this._fCombo = new Combo(parent, 8);
            this._fCombo.setFont(parent.getFont());
            int i = 0;
            while (i < this._fEntryNamesAndValues.length) {
                this._fCombo.add(this._fEntryNamesAndValues[i][0], i);
                ++i;
            }
            this._fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String oldValue = ComboFieldEditor.this._fValue;
                    String name = ComboFieldEditor.this._fCombo.getText();
                    ComboFieldEditor.this._fValue = ComboFieldEditor.this.getValueForName(name);
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, ComboFieldEditor.this._fValue);
                }
            });
        }
        return this._fCombo;
    }

    protected String getValueForName(String name) {
        int i = 0;
        while (i < this._fEntryNamesAndValues.length) {
            String[] entry = this._fEntryNamesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return this._fEntryNamesAndValues[0][0];
    }

    protected void updateComboForValue(String value) {
        this._fValue = value;
        int i = 0;
        while (i < this._fEntryNamesAndValues.length) {
            if (value.equals(this._fEntryNamesAndValues[i][1])) {
                this._fCombo.setText(this._fEntryNamesAndValues[i][0]);
                return;
            }
            ++i;
        }
        if (this._fEntryNamesAndValues.length > 0) {
            this._fValue = this._fEntryNamesAndValues[0][1];
        }
    }
}

