/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.core.tableviewer;

import com.ibm.ims.datatools.sqltools.common.core.tableviewer.IRowData;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.ITableData;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.TableDataSaveStatus;

public class RowData
implements IRowData,
Cloneable {
    protected ITableData _tableData;
    protected int _state;
    public static final int STATE_ORIGINAL = 0;
    public static final int STATE_UPDATED = 1;
    public static final int STATE_DELETED = 2;
    public static final int STATE_INSERTED = 3;
    protected Object[] _newData;
    protected Object[] _oldData;

    public RowData() {
    }

    public RowData(ITableData table, int type, Object[] data) {
        this._tableData = table;
        this._state = type;
        this._newData = data;
        if (type == 0) {
            this._oldData = (Object[])data.clone();
        }
    }

    @Override
    public ITableData getTableData() {
        return this._tableData;
    }

    @Override
    public Object getValue(int col) {
        return this._newData[col];
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public void setState(int state) {
        this._state = state;
    }

    @Override
    public void updateValue(int col, Object value) {
        if (this._state == 0) {
            this._state = 1;
        }
        Object oldVal = this._newData[col];
        this._newData[col] = value;
        this.getTableData().fireUpdated(this, col, oldVal, value);
    }

    public void save(TableDataSaveStatus status) throws Exception {
        switch (this._state) {
            case 1: {
                this.doUpdate(status);
                break;
            }
            case 3: {
                this.doInsert(status);
                break;
            }
            case 2: {
                this.doDelete(status);
                break;
            }
            case 0: {
                break;
            }
        }
    }

    protected void doInsert(TableDataSaveStatus status) throws Exception {
    }

    protected void doUpdate(TableDataSaveStatus status) throws Exception {
    }

    protected void doDelete(TableDataSaveStatus status) throws Exception {
    }

    public void resetToOriginal() {
        this._state = 0;
        this._oldData = (Object[])this._newData.clone();
    }

    public void revertToOriginal() {
        this._state = 0;
        this._newData = (Object[])this._oldData.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        Object result = super.clone();
        RowData row = (RowData)result;
        row._newData = (Object[])this._newData.clone();
        if (this._oldData != null) {
            row._oldData = (Object[])this._oldData.clone();
        }
        return result;
    }

    public void setTableData(ITableData data) {
        this._tableData = data;
    }

    public void updateValueWithoutNotification(int col, Object value) {
        if (this._state == 0) {
            this._state = 1;
        }
        this._newData[col] = value;
    }
}

