/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.common.core.tableviewer;

import com.ibm.ims.datatools.sqltools.common.core.tableviewer.IRowData;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.ITableData;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.ITableDataChangeListener;
import com.ibm.ims.datatools.sqltools.common.core.tableviewer.RowData;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;

public abstract class AbstractTableData
implements ITableData {
    protected Vector _rows = new Vector();
    protected ListenerList<ITableDataChangeListener> _listenerList = new ListenerList();

    public void setRows(Vector rows) {
        this._rows = rows;
    }

    @Override
    public void deleteRow(IRowData row) {
        if (((RowData)row).getState() == 3 || ((RowData)row).getState() == 0 || ((RowData)row).getState() == 1) {
            this._rows.remove(row);
        } else {
            ((RowData)row).setState(2);
        }
        for (ITableDataChangeListener listener : this._listenerList) {
            listener.rowDeleted(row);
        }
    }

    @Override
    public IRowData insertRow() {
        Object[] data = new Object[this.getColumnCount()];
        RowData row = new RowData(this, 3, data);
        this._rows.add(row);
        for (ITableDataChangeListener listener : this._listenerList) {
            listener.rowAdded(row);
        }
        return row;
    }

    @Override
    public void insertRow(IRowData rowData, int row) {
        this._rows.insertElementAt(rowData, row);
        for (ITableDataChangeListener listener : this._listenerList) {
            listener.rowAdded(rowData);
        }
    }

    @Override
    public void revert() {
        int i = 0;
        while (i < this._rows.size()) {
            RowData row = (RowData)this._rows.elementAt(i);
            if (row.getState() == 1 || row.getState() == 2) {
                row.revertToOriginal();
                ++i;
                continue;
            }
            if (row.getState() == 3) {
                this._rows.remove(i);
                continue;
            }
            if (row.getState() != 0) continue;
            ++i;
        }
    }

    @Override
    public void resetRowsToOriginal() {
        int i = 0;
        while (i < this._rows.size()) {
            RowData row = (RowData)this._rows.elementAt(i);
            if (row.getState() == 1 || row.getState() == 3) {
                row.resetToOriginal();
                ++i;
                continue;
            }
            if (row.getState() == 2) {
                this._rows.remove(i);
                continue;
            }
            if (row.getState() != 0) continue;
            ++i;
        }
    }

    @Override
    public void fireUpdated(IRowData row, int colIndex, Object oldVal, Object newVal) {
        for (ITableDataChangeListener listener : this._listenerList) {
            listener.rowDataUpdated(row, colIndex, oldVal, newVal);
        }
    }

    @Override
    public void addTableDataChangeListener(ITableDataChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof ITableDataChangeListener) {
            this._listenerList.add((Object)listener);
        }
    }

    @Override
    public void removeTableDataChangeListener(ITableDataChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof ITableDataChangeListener) {
            this._listenerList.remove((Object)listener);
        }
    }

    @Override
    public boolean isNewRowDataAllowed() {
        return true;
    }

    @Override
    public abstract boolean isReadonly();

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract String getColumnName(int var1);

    @Override
    public abstract int getColumnType(int var1);

    @Override
    public abstract String getColumnHeader(int var1);

    @Override
    public abstract Vector getRows();

    @Override
    public abstract boolean save() throws Exception;
}

