/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli.spi.properties;

import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.spi.properties.PliBaseProperty;
import com.ibm.ccl.pli.importer.IPliPreferenceConstants;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PliPlatformProperty
extends PliBaseProperty {
    private static String[] validValuesArray = null;
    private static String defaultPlatform = null;

    public PliPlatformProperty() throws CoreException {
        super(PliMessageResource.PLATFORM_PROP_NAME, PliMessageResource.PLATFORM_PROP_DISPLAY_NAME, PliMessageResource.PLATFORM_PROP_DESC);
        this.initializeProperty();
    }

    private void initializeProperty() {
        try {
            this.pliKey = "com.ibm.ccl.pli.PLI_PLATFORM_SELECTION";
            validValuesArray = new String[]{"Win32", "z/OS", IPliPreferenceConstants.PLATFORM_NONE};
            defaultPlatform = "Win32";
            super.setValidValues((Object[])validValuesArray);
            this.setDefaultValue(defaultPlatform);
            this.setValue(defaultPlatform);
            this.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        }
        catch (CoreException ex) {
            this.envStatus = new Status(4, "com.ibm.adapter.pli", 4, ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean valid = false;
        int i = 0;
        while (i < validValuesArray.length) {
            String newVal = (String)evt.getNewValue();
            if (newVal != null && newVal.equalsIgnoreCase(validValuesArray[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            throw new PropertyVetoException(PliMessageResource.INVALID_PROPERTY_VALUE, (java.beans.PropertyChangeEvent)evt);
        }
    }

    public void setValidValues(Object[] values) throws CoreException {
        Status status = new Status(4, ((Object)((Object)this)).getClass().getName(), 4, PliMessageResource.ERROR_METHOD_NOT_IMPLEMENTED, (Throwable)new Exception(PliMessageResource.ERROR_METHOD_NOT_IMPLEMENTED));
        throw new CoreException((IStatus)status);
    }
}

