/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.transform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class ModelDependencyTracker {
    public static final int NEW_FLAG = 0;
    public static final int DELETE_FLAG = 1;
    public static final int MODIFY_FLAG = 2;
    private Set newObjects;
    private Set deletedObjects;
    private Set modifiedObjects;

    public void clear() {
        if (this.deletedObjects != null) {
            this.deletedObjects.clear();
        }
        if (this.modifiedObjects != null) {
            this.modifiedObjects.clear();
        }
        if (this.newObjects != null) {
            this.newObjects.clear();
        }
    }

    public void modelChanged(int flag, EObject modelObject) {
        if (this.isInterrested(modelObject.eClass(), flag)) {
            switch (flag) {
                case 0: {
                    this.trackNew(modelObject);
                    break;
                }
                case 1: {
                    this.trackDeleted(modelObject);
                    break;
                }
                case 2: {
                    this.trackModified(modelObject);
                }
            }
        }
    }

    protected boolean isInterrested(EClass type, int flag) {
        return true;
    }

    private void trackNew(EObject modelObject) {
        if (this.newObjects == null) {
            this.newObjects = new HashSet();
        }
        this.newObjects.add(modelObject);
    }

    private void trackDeleted(EObject modelObject) {
        if (this.deletedObjects == null) {
            this.deletedObjects = new HashSet();
        }
        this.deletedObjects.add(modelObject);
    }

    private void trackModified(EObject modelObject) {
        if (this.modifiedObjects == null) {
            this.modifiedObjects = new HashSet();
        }
        this.modifiedObjects.add(modelObject);
    }

    public Collection getDeletedObjects() {
        if (this.deletedObjects == null) {
            return Collections.EMPTY_SET;
        }
        return this.deletedObjects;
    }

    public Collection getModifiedObjects() {
        if (this.modifiedObjects == null) {
            return Collections.EMPTY_SET;
        }
        return this.modifiedObjects;
    }

    public Collection getNewObjects() {
        if (this.newObjects == null) {
            return Collections.EMPTY_SET;
        }
        return this.newObjects;
    }

    public boolean hasChanges() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty() || this.modifiedObjects != null && !this.modifiedObjects.isEmpty() || this.newObjects != null && !this.newObjects.isEmpty();
    }
}

