/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.transform;

import com.ibm.zcc.etools.wrd.extensions.transform.AnnotationModelTransformer;
import com.ibm.zcc.etools.wrd.extensions.transform.ModelContentHandler;
import com.ibm.zcc.etools.wrd.extensions.transform.ModelDependencyTracker;
import com.ibm.zcc.etools.wrd.extensions.util.AnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;

public abstract class AbstractModelContentHandlerImpl
implements ModelContentHandler {
    protected AnnotationModelTransformer transformer;
    protected int state;
    protected IProject project;
    protected EClass currentClass;
    protected Set interestingPackages;
    protected Collection dependencyModelTrackers;
    private Set dirtyModelObjects;
    private Set deletedModelObjects;

    public AbstractModelContentHandlerImpl(IProject project) {
        this.project = project;
        this.interestingPackages = this.getInitialInterestingPackages();
    }

    protected abstract Set getInitialInterestingPackages();

    @Override
    public final Object doSwitch(EObject theEObject) {
        if (!this.checkInterestingAndSetCurrentClass(theEObject)) {
            return null;
        }
        return this.delegatedDoSwitch(theEObject);
    }

    @Override
    public final void processUpdatedFeatures(EObject eObject, List featureChanges) {
        if (!this.checkInterestingAndSetCurrentClass(eObject) || featureChanges.isEmpty()) {
            return;
        }
        this.doProcessUpdatedFeatures(eObject, featureChanges);
    }

    protected abstract void doProcessUpdatedFeatures(EObject var1, List var2);

    protected boolean checkInterestingAndSetCurrentClass(EObject theEObject) {
        if (theEObject == null || !this.interestingPackages.contains(theEObject.eClass().getEPackage())) {
            return false;
        }
        EClass javaClass = AnnotationUtil.INSTANCE.getJavaClassFromDoclet(theEObject);
        if (javaClass != this.currentClass) {
            this.setCurrentClass(javaClass);
        }
        return true;
    }

    protected void setCurrentClass(EClass javaClass) {
        this.currentClass = javaClass;
    }

    protected abstract Object delegatedDoSwitch(EObject var1);

    @Override
    public void setState(int stateFlag) {
        this.state = stateFlag;
    }

    @Override
    public void startModel(AnnotationModelTransformer aTransformer) {
        this.transformer = aTransformer;
        this.clearDependencyTrackers();
    }

    private void clearDependencyTrackers() {
        if (this.dependencyModelTrackers == null || this.dependencyModelTrackers.isEmpty()) {
            return;
        }
        for (ModelDependencyTracker tracker : this.dependencyModelTrackers) {
            tracker.clear();
        }
    }

    @Override
    public void endModel() {
    }

    public Set getDirtyModelObjects() {
        return this.dirtyModelObjects == null ? Collections.EMPTY_SET : this.dirtyModelObjects;
    }

    public Set getDeletedModelObjects() {
        return this.deletedModelObjects == null ? Collections.EMPTY_SET : this.deletedModelObjects;
    }

    protected boolean isDeleted(EObject modelObject) {
        return this.deletedModelObjects != null && this.deletedModelObjects.contains(modelObject);
    }

    protected void markDirty(EObject aModelObject) {
        if (aModelObject == null) {
            return;
        }
        this.doMarkDirty(aModelObject);
        this.notifyDependencyTrackers(2, aModelObject);
    }

    private void doMarkDirty(EObject aModelObject) {
        if (this.dirtyModelObjects == null) {
            this.dirtyModelObjects = new HashSet();
        }
        this.dirtyModelObjects.add(aModelObject);
    }

    protected void markNew(EObject modelObject) {
        this.doMarkDirty(modelObject);
        this.notifyDependencyTrackers(0, modelObject);
    }

    protected void markForDeletion(EObject modelObject) {
        if (modelObject == null) {
            return;
        }
        if (this.deletedModelObjects == null) {
            this.deletedModelObjects = new HashSet();
        }
        if (!this.deletedModelObjects.contains(modelObject)) {
            this.deletedModelObjects.add(modelObject);
            this.setID(null, modelObject);
            this.notifyDependencyTrackers(1, modelObject);
        }
    }

    private void notifyDependencyTrackers(int flag, EObject modelObject) {
        if (this.dependencyModelTrackers == null || this.dependencyModelTrackers.isEmpty()) {
            return;
        }
        for (ModelDependencyTracker tracker : this.dependencyModelTrackers) {
            tracker.modelChanged(flag, modelObject);
        }
    }

    protected void setID(String id, EObject eObject) {
        XMLResource eResource = (XMLResource)eObject.eResource();
        if (eResource == null) {
            return;
        }
        if (id != null) {
            eResource.setID(eObject, id);
        } else {
            String idValue = eResource.getID(eObject);
            eResource.getEObjectToIDMap().remove(eObject);
            if (idValue != null) {
                eResource.getIDToEObjectMap().remove(idValue);
            }
        }
    }

    protected abstract String getIDValue(EObject var1);

    @Override
    public void setDependencyModelTrackers(Collection trackers) {
        this.dependencyModelTrackers = trackers;
    }

    protected Set getFilteredDeletedModelObjects(EClass aClass) {
        return this.getFilteredObjects(this.deletedModelObjects, aClass);
    }

    protected Set getFilteredDirtyModelObjects(EClass aClass) {
        return this.getFilteredObjects(this.dirtyModelObjects, aClass);
    }

    private Set getFilteredObjects(Set aSet, EClass aClass) {
        if (aSet == null || aSet.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<EObject> result = null;
        for (EObject obj : aSet) {
            if (obj.eClass() != aClass) continue;
            if (result == null) {
                result = new HashSet<EObject>();
            }
            result.add(obj);
        }
        return result == null ? Collections.EMPTY_SET : result;
    }

    @Override
    public int getState() {
        return this.state;
    }
}

