/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.dynamic.model;

import com.ibm.zcc.etools.wrd.extensions.dynamic.model.AnnotationChangeRecorder;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicModelAnnotationTagHandlerRegistry;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicModelTagRegistationManager;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicModelTagSetRegistrationOptions;
import com.ibm.zcc.etools.wrd.extensions.transform.AnnotationModelTransformer;
import com.ibm.zcc.etools.wrd.extensions.transform.ModelContentHandler;
import com.ibm.zcc.etools.wrd.extensions.transform.ModelDependencyTracker;
import com.ibm.zcc.etools.wrd.extensions.util.AnnotationUtil;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationTagHandler;
import com.ibm.zcc.ws.rd.annotations.core.FieldTagData;
import com.ibm.zcc.ws.rd.annotations.core.IAnnotationProcessor;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TagProcessingException;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.osgi.framework.Bundle;

public abstract class DynamicModelAnnotationTagHandler
implements AnnotationTagHandler {
    private static final String CU_ID_PREFIX = "CU:";
    protected static final String ANNOT_PROB_MARKER = "com.ibm.zcc.ws.rapiddeploy.annotations.core.AnnotationProblemMarker";
    private XMLResource resource;
    private ICompilationUnit currentCompilationUnit;
    private List allCompilationUnits;
    private Map tagFeatureIndexes;
    private IJavaElement currentJavaElement;
    private IProject currentProject;
    private IAnnotationProcessor annotationProcessor;
    private Map recorders;
    private Set annotatedCUs = new HashSet();
    private AnnotationModelTransformer transformer;
    private Collection modelDependencyTrackers;
    private boolean currentTagDataMarkersClear;
    private Bundle metaBundle;
    private Map filesRequiringCleanMap = new HashMap();

    public DynamicModelAnnotationTagHandler() {
        DynamicModelAnnotationTagHandlerRegistry.INSTANCE.registerHandler(this);
    }

    public final void beginBuild(IAnnotationProcessor ap, IProject project) throws TagProcessingException {
        DynamicModelAnnotationTagHandlerRegistry.INSTANCE.beginBuildCalled(this, project);
        this.currentProject = project;
        this.resource = null;
        this.annotationProcessor = ap;
        if (this.allCompilationUnits != null) {
            this.allCompilationUnits.clear();
        }
        this.annotatedCUs.clear();
        if (this.requiresInMemoryModel()) {
            this.getRecorder().beginRecording();
            if (this.shouldResolveAnnotationProxies()) {
                this.resolveAnnotationProxies(project);
            }
        }
        this.doBeginBuild(ap, project);
    }

    protected boolean shouldResolveAnnotationProxies() {
        return false;
    }

    private void resolveAnnotationProxies(IProject project) {
        try {
            AnnotationUtil.INSTANCE.resolveMetaResourceAnnotationProxiesOnLoad(this.getMetaURI(), project, this.getMetaBundle());
        }
        catch (IOException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected AnnotationChangeRecorder getRecorder() {
        return this.getRecorder(this.currentProject);
    }

    protected AnnotationChangeRecorder getRecorder(IProject project) {
        if (!this.requiresInMemoryModel()) {
            return null;
        }
        AnnotationChangeRecorder recorder = this.getExistingRecorder(project);
        if (recorder == null) {
            recorder = new AnnotationChangeRecorder(this.getEAnnotationSource());
            if (this.recorders == null) {
                this.recorders = new HashMap();
            }
            this.recorders.put(project, recorder);
        }
        return recorder;
    }

    protected AnnotationChangeRecorder getExistingRecorder(IProject project) {
        if (this.recorders == null) {
            return null;
        }
        return (AnnotationChangeRecorder)((Object)this.recorders.get(project));
    }

    protected void doBeginBuild(IAnnotationProcessor ap, IProject project) {
    }

    public final void endBuild(IProject project) throws TagProcessingException {
        AnnotationChangeRecorder recorder = this.getExistingRecorder(this.currentProject);
        try {
            try {
                if (recorder != null) {
                    this.updateForDeletedAnnotations();
                    recorder.endRecording();
                }
                this.doEndBuild(project);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    DynamicModelAnnotationTagHandlerRegistry.INSTANCE.endBuildCalled(this, project);
                }
                finally {
                    this.clearFilesRequiringClean();
                    if (this.allCompilationUnits != null) {
                        this.allCompilationUnits.clear();
                    }
                    if (recorder != null) {
                        recorder.reset();
                    }
                    this.currentProject = null;
                    this.resource = null;
                }
            }
        }
        finally {
            try {
                DynamicModelAnnotationTagHandlerRegistry.INSTANCE.endBuildCalled(this, project);
            }
            finally {
                this.clearFilesRequiringClean();
                if (this.allCompilationUnits != null) {
                    this.allCompilationUnits.clear();
                }
                if (recorder != null) {
                    recorder.reset();
                }
                this.currentProject = null;
                this.resource = null;
            }
        }
    }

    private void clearFilesRequiringClean() {
        this.filesRequiringCleanMap.remove(this.getCurrentProject());
    }

    protected void doEndBuild(IProject project) {
    }

    public final void beginResource(IResource res) throws TagProcessingException {
        this.cacheCurrentCompilationUnit(res);
        if (res.exists()) {
            this.doBeginResource(res);
        }
    }

    protected XMLResource getResource() {
        if (this.resource == null) {
            try {
                this.resource = (XMLResource)DynamicModelAnnotationTagHandlerRegistry.INSTANCE.getAnnotationState(this.currentProject);
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        return this.resource;
    }

    private void cacheCurrentCompilationUnit(IResource res) {
        this.currentCompilationUnit = (ICompilationUnit)JavaCore.create((IResource)res);
        if (this.currentCompilationUnit != null) {
            if (this.allCompilationUnits == null) {
                this.allCompilationUnits = new ArrayList();
            }
            this.allCompilationUnits.add(this.currentCompilationUnit);
        }
    }

    protected void doBeginResource(IResource res) throws TagProcessingException {
    }

    public final void endResource(IResource res) throws TagProcessingException {
        try {
            this.doEndResource(res);
        }
        finally {
            this.currentCompilationUnit = null;
            this.currentJavaElement = null;
            if (this.tagFeatureIndexes != null) {
                this.tagFeatureIndexes.clear();
            }
        }
    }

    private void updateForDeletedAnnotations() {
        if (this.allCompilationUnits == null || this.allCompilationUnits.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.allCompilationUnits.size()) {
            this.updateForDeletedAnnotations((ICompilationUnit)this.allCompilationUnits.get(i));
            ++i;
        }
    }

    private void updateForDeletedAnnotations(ICompilationUnit cu) {
        if (this.annotatedCUs.contains(cu)) {
            this.unsetNonVisitedAnnotations(cu);
        } else {
            this.removeExistingAnnotations(cu, !cu.exists());
        }
    }

    private void removeExistingAnnotations(ICompilationUnit cu, boolean removeAll) {
        EPackage modelCU = this.getExistingCompilationUnitModel(cu);
        if (modelCU != null) {
            EList javaClasses = modelCU.getEClassifiers();
            if (javaClasses.isEmpty()) {
                return;
            }
            Iterator it = javaClasses.iterator();
            while (it.hasNext()) {
                EClass javaClass = (EClass)it.next();
                this.removeExistingAnnotations(javaClass, removeAll);
                if (!javaClass.getEAttributes().isEmpty() || !javaClass.getEOperations().isEmpty() || !javaClass.getEAnnotations().isEmpty()) continue;
                AnnotationUtil.INSTANCE.simplePreDelete((EObject)javaClass);
                it.remove();
            }
            if (javaClasses.isEmpty()) {
                AnnotationUtil.INSTANCE.simplePreDelete((EObject)modelCU);
                this.getResource().getContents().remove((Object)modelCU);
            }
        }
    }

    private void unsetNonVisitedAnnotations(ICompilationUnit cu) {
        EPackage modelCU = this.getExistingCompilationUnitModel(cu);
        if (modelCU != null) {
            EList javaClasses = modelCU.getEClassifiers();
            AnnotationChangeRecorder rec = this.getRecorder();
            Iterator it = javaClasses.iterator();
            while (it.hasNext()) {
                EClass javaClass = (EClass)it.next();
                rec.unsetNonVisitedAnnotations(javaClass);
                if (!javaClass.getEAttributes().isEmpty() || !javaClass.getEOperations().isEmpty() || !javaClass.getEAnnotations().isEmpty()) continue;
                AnnotationUtil.INSTANCE.simplePreDelete((EObject)javaClass);
                it.remove();
            }
            if (javaClasses.isEmpty()) {
                AnnotationUtil.INSTANCE.simplePreDelete((EObject)modelCU);
                this.getResource().getContents().remove((Object)modelCU);
            }
        }
    }

    private void removeExistingAnnotations(EClass javaClass, boolean removeAll) {
        if (javaClass == null) {
            return;
        }
        this.removeAnnotations((List)javaClass.getEAttributes(), removeAll);
        this.removeAnnotations((List)javaClass.getEOperations(), removeAll);
        this.removeAnnotations((EModelElement)javaClass, removeAll);
    }

    private void removeAnnotations(List modelElements, boolean removeAll) {
        if (modelElements.isEmpty()) {
            return;
        }
        Iterator it = modelElements.iterator();
        while (it.hasNext()) {
            EModelElement eObject = (EModelElement)it.next();
            this.removeAnnotations(eObject, removeAll);
            if (!eObject.getEAnnotations().isEmpty()) continue;
            AnnotationUtil.INSTANCE.simplePreDelete((EObject)eObject);
            it.remove();
        }
    }

    private void removeAnnotations(EModelElement modelElement, boolean removeAll) {
        if (removeAll) {
            EList annotations = modelElement.getEAnnotations();
            int i = 0;
            while (i < annotations.size()) {
                EAnnotation annotation = (EAnnotation)annotations.get(i);
                this.removeAnnotations(modelElement, annotation);
                ++i;
            }
        } else {
            EAnnotation eAnnotation = modelElement.getEAnnotation(this.getEAnnotationSource());
            this.removeAnnotations(modelElement, eAnnotation);
        }
    }

    private void removeAnnotations(EModelElement modelElement, EAnnotation eAnnotation) {
        if (eAnnotation != null) {
            this.getRecorder().add((EObject)eAnnotation);
            EList annotations = modelElement.getEAnnotations();
            AnnotationUtil.INSTANCE.cacheOldContainer((EObject)eAnnotation);
            this.setChildProxies(eAnnotation);
            annotations.remove(eAnnotation);
        }
    }

    private void setChildProxies(EAnnotation annotation) {
        if (annotation.getContents().isEmpty()) {
            return;
        }
        TreeIterator it = annotation.eAllContents();
        AnnotationUtil util = AnnotationUtil.INSTANCE;
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            util.simpleBecomeProxy(child);
        }
    }

    protected void doEndResource(IResource res) throws TagProcessingException {
    }

    public final void handleTag(MethodTagData methodTagData, IResource res) throws TagProcessingException {
        this.annotatedCUs.add(this.currentCompilationUnit);
        if (this.requiresInMemoryModel()) {
            IMethod method = this.getExistingMethod(methodTagData);
            EOperation javaMethod = this.getOrCreateJavaMethod(method);
            this.javaElementToEAnnotation((EObject)javaMethod, (IJavaElement)method);
            this.tagToEAnnotation((EObject)javaMethod, (TagData)methodTagData, res, 0);
        }
    }

    private IMethod getExistingMethod(MethodTagData methodTagData) {
        MethodDeclaration methodDeclaration = methodTagData.getMethodDeclaration();
        IJavaElement javaElement = null;
        try {
            javaElement = this.currentCompilationUnit.getElementAt(methodDeclaration.getStartPosition());
        }
        catch (JavaModelException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        if (javaElement.getElementType() == 9) {
            return (IMethod)javaElement;
        }
        return null;
    }

    private EOperation getOrCreateJavaMethod(IMethod method) {
        EOperation javaMethod = null;
        EClass javaClass = this.getJavaClass(method.getDeclaringType());
        EList methods = javaClass.getEOperations();
        String methodIdentifier = method.getHandleIdentifier();
        int i = 0;
        while (i < methods.size()) {
            javaMethod = (EOperation)methods.get(i);
            if (this.hasEAnnotation((EModelElement)javaMethod, methodIdentifier)) break;
            javaMethod = null;
            ++i;
        }
        if (javaMethod == null) {
            javaMethod = EcoreFactory.eINSTANCE.createEOperation();
            javaMethod.setName(method.getElementName());
            javaClass.getEOperations().add((Object)javaMethod);
        }
        return javaMethod;
    }

    public final void handleTag(FieldTagData fieldTagData, IResource res) throws TagProcessingException {
        this.annotatedCUs.add(this.currentCompilationUnit);
        if (this.requiresInMemoryModel()) {
            IField field = this.getExistingField(fieldTagData);
            EAttribute eAttribute = this.getOrCreateJavaField(field);
            this.javaElementToEAnnotation((EObject)eAttribute, (IJavaElement)field);
            this.tagToEAnnotation((EObject)eAttribute, (TagData)fieldTagData, res, 2);
        }
    }

    private EAttribute getOrCreateJavaField(IField field) {
        EAttribute attribute;
        EAttribute eAttribute = null;
        EClass javaClass = this.getJavaClass(field.getDeclaringType());
        EList attributes = javaClass.getEAttributes();
        String fieldIdentifier = field.getHandleIdentifier();
        int i = 0;
        if (i < attributes.size() && this.hasEAnnotation((EModelElement)(attribute = (EAttribute)attributes.get(i)), fieldIdentifier)) {
            eAttribute = attribute;
        }
        if (eAttribute == null) {
            eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            javaClass.getEAttributes().add((Object)eAttribute);
        }
        eAttribute.setName(field.getElementName());
        return eAttribute;
    }

    private boolean hasEAnnotation(EModelElement modelElement, String javaIdentifier) {
        EAnnotation eAnnotation = modelElement.getEAnnotation(this.getEAnnotationSource());
        return eAnnotation != null && javaIdentifier.equals(eAnnotation.getDetails().get((Object)"id"));
    }

    private IField getExistingField(FieldTagData fieldTagData) {
        FieldDeclaration fieldDeclaration = fieldTagData.getFieldDeclaration();
        IJavaElement javaElement = null;
        try {
            javaElement = this.currentCompilationUnit.getElementAt(fieldDeclaration.getStartPosition());
        }
        catch (JavaModelException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        if (javaElement.getElementType() == 8) {
            return (IField)javaElement;
        }
        return null;
    }

    public final void handleTag(TypeTagData typeTagData, IResource res) throws TagProcessingException {
        this.annotatedCUs.add(this.currentCompilationUnit);
        if (this.requiresInMemoryModel()) {
            IType type = this.currentCompilationUnit.getType(typeTagData.getTypeDeclaration().getName().getIdentifier());
            EClass javaClass = this.getJavaClass(type);
            this.javaElementToEAnnotation((EObject)javaClass, (IJavaElement)type);
            this.tagToEAnnotation((EObject)javaClass, (TagData)typeTagData, res, 1);
        }
    }

    protected void tagToEAnnotation(EObject container, TagData tagData, IResource res, int scope) throws TagProcessingException {
        String tagName = tagData.getName();
        int dot = tagName.lastIndexOf(46);
        String prefix = dot > 0 ? tagName.substring(0, dot) : "";
        tagName = tagName.substring(dot + 1);
        EPackage tagEPackage = this.getEPackageForTagName(prefix);
        EAnnotation eAnnotation = ((EModelElement)container).getEAnnotation(this.getEAnnotationSource());
        EObject annotationObject = this.getOrCreateAnnotationObject(eAnnotation, tagEPackage, tagName, scope);
        EStructuralFeature tagFeature = this.getFeatureForTagName(tagName, annotationObject, tagEPackage);
        if (tagFeature == null) {
            return;
        }
        if (this.validateTag(tagData)) {
            EObject tagObject = this.getOrCreateTagObject(tagFeature, annotationObject, tagData);
            AnnotationUtil.INSTANCE.cacheDocletRange(eAnnotation, tagObject, tagData);
            this.updateTagObjectAttributes(tagObject, tagData);
        }
    }

    protected final boolean validateTag(TagData tagData) {
        if (tagData.hasErrors()) {
            return false;
        }
        this.currentTagDataMarkersClear = false;
        return this.doValidateTag(tagData);
    }

    protected boolean doValidateTag(TagData tagData) {
        return true;
    }

    private EStructuralFeature getFeatureForTagName(String tagName, EObject owner, EPackage ePackage) {
        ExtendedMetaData emd = ExtendedMetaData.INSTANCE;
        EClass eClass = owner.eClass();
        EStructuralFeature feature = emd.getAttribute(eClass, null, tagName);
        if (feature == null && (feature = emd.getElement(eClass, null, tagName)) == null) {
            if (ePackage == null) {
                ePackage = eClass.getEPackage();
            }
            if ((feature = emd.getAttribute(eClass, ePackage.getNsURI(), tagName)) == null) {
                feature = emd.getElement(eClass, ePackage.getNsURI(), tagName);
            }
        }
        return feature;
    }

    private void updateTagObjectAttributes(EObject tagObject, TagData tagData) {
        if (tagData.isEmpty()) {
            return;
        }
        for (String attrName : tagData) {
            EStructuralFeature feature = this.getFeatureForTagName(attrName, tagObject, null);
            if (feature == null) continue;
            Object value = this.convertValueForTagObject(tagData.get(attrName), feature);
            if (feature.isMany()) {
                ((List)tagObject.eGet(feature)).add(value);
                continue;
            }
            tagObject.eSet(feature, value);
        }
    }

    private Object convertValueForTagObject(Object value, EStructuralFeature feature) {
        EClassifier eType = feature.getEType();
        EcorePackage ePack = EcorePackage.eINSTANCE;
        XMLTypePackage xPack = XMLTypePackage.eINSTANCE;
        if (eType == ePack.getEBoolean() || eType == ePack.getEBooleanObject() || eType == xPack.getBoolean() || eType == xPack.getBooleanObject()) {
            value = Boolean.valueOf((String)value);
        } else if (eType == ePack.getEInt() || eType == ePack.getEIntegerObject() || eType == xPack.getInteger() || eType == xPack.getIntObject()) {
            value = Integer.valueOf((String)value);
        } else if (ePack.getEEnum().isInstance((Object)eType) && (value = ((EEnum)eType).getEEnumLiteral((String)value)) != null) {
            value = ((EEnumLiteral)value).getInstance();
        }
        return value;
    }

    private int getNextTagFeatureIndex(EStructuralFeature tagFeature) {
        if (tagFeature.isMany()) {
            Index currentIndex = null;
            if (this.tagFeatureIndexes == null) {
                this.tagFeatureIndexes = new HashMap();
            } else {
                currentIndex = (Index)this.tagFeatureIndexes.get(tagFeature);
            }
            if (currentIndex == null) {
                currentIndex = new Index();
                this.tagFeatureIndexes.put(tagFeature, currentIndex);
            } else {
                currentIndex.increment();
            }
            return currentIndex.value;
        }
        return 0;
    }

    protected EObject getOrCreateTagObject(EStructuralFeature tagFeature, EObject annotationObject, TagData tagData) {
        if (tagFeature == null) {
            return null;
        }
        EObject tagObject = this.getExistingTagObject(annotationObject, tagFeature, tagData);
        if (tagObject == null) {
            EClass tagClass = (EClass)tagFeature.getEType();
            tagObject = tagClass.getEPackage().getEFactoryInstance().create(tagClass);
            if (tagFeature.isMany()) {
                ((List)annotationObject.eGet(tagFeature)).add(tagObject);
            } else {
                annotationObject.eSet(tagFeature, (Object)tagObject);
            }
        }
        return tagObject;
    }

    protected EObject getExistingTagObject(EObject annotationObject, EStructuralFeature containmentFeature, TagData data) {
        EObject existing = null;
        existing = containmentFeature.isMany() ? this.getExistingTagObjectFromManyFeature(annotationObject, containmentFeature, data) : (EObject)annotationObject.eGet(containmentFeature);
        if (existing != null) {
            this.getRecorder().touch(existing);
        }
        return existing;
    }

    protected EObject getExistingTagObjectFromManyFeature(EObject annotationObject, EStructuralFeature containmentFeature, TagData data) {
        List list = (List)annotationObject.eGet(containmentFeature);
        if (list.isEmpty()) {
            this.ignoreFeaturePositions(containmentFeature);
            return null;
        }
        if (this.shouldIgnoreFeaturePositions(containmentFeature)) {
            return null;
        }
        EStructuralFeature uniqueSF = this.getUniqueStructuralFeature(containmentFeature.getEType(), data);
        if (uniqueSF == null) {
            int index = this.getNextTagFeatureIndex(containmentFeature);
            if (list.size() > index) {
                return (EObject)list.get(index);
            }
        } else if (!list.isEmpty()) {
            String attributeName = ExtendedMetaData.INSTANCE.getName(uniqueSF);
            Object tagValue = this.convertValueForTagObject(data.get(attributeName), uniqueSF);
            int i = 0;
            while (i < list.size()) {
                EObject eObject = (EObject)list.get(i);
                Object eObjValue = eObject.eGet(uniqueSF);
                if (eObjValue == tagValue || eObjValue != null && eObjValue.equals(tagValue)) {
                    return eObject;
                }
                ++i;
            }
        }
        return null;
    }

    private void ignoreFeaturePositions(EStructuralFeature aFeature) {
        if (this.tagFeatureIndexes == null) {
            this.tagFeatureIndexes = new HashMap();
        }
        Index ignoreIndex = new Index();
        ignoreIndex.shouldIgnore = true;
        this.tagFeatureIndexes.put(aFeature, ignoreIndex);
    }

    private boolean shouldIgnoreFeaturePositions(EStructuralFeature aFeature) {
        if (this.tagFeatureIndexes == null) {
            return true;
        }
        Index index = (Index)this.tagFeatureIndexes.get(aFeature);
        return index == null ? false : index.shouldIgnore;
    }

    protected EStructuralFeature getUniqueStructuralFeature(EClassifier type, TagData data) {
        return this.getUniqueStructuralFeature(type);
    }

    protected EStructuralFeature getUniqueStructuralFeature(EClassifier docletType) {
        return null;
    }

    protected EObject getOrCreateAnnotationObject(EAnnotation eAnnotation, EPackage tagEPackage, String tagName, int scope) {
        DynamicModelTagSetRegistrationOptions options = this.getOptions(tagEPackage);
        EClass annotationClass = (EClass)tagEPackage.getEClassifier(options.getTypeName(scope));
        if (annotationClass == null) {
            return null;
        }
        EObject annotationObject = (EObject)EcoreUtil.getObjectByType((Collection)eAnnotation.getContents(), (EClassifier)annotationClass);
        if (annotationObject == null) {
            annotationObject = tagEPackage.getEFactoryInstance().create(annotationClass);
            eAnnotation.getContents().add((Object)annotationObject);
        }
        return annotationObject;
    }

    protected abstract String getEAnnotationSource();

    private DynamicModelTagSetRegistrationOptions getOptions(EPackage tagEPackage) {
        return DynamicModelTagRegistationManager.INSTANCE.getOptions(tagEPackage);
    }

    protected EPackage getEPackageForTagName(String tagName) {
        if (tagName == null) {
            return null;
        }
        return DynamicModelTagRegistationManager.INSTANCE.getEPackage(tagName);
    }

    protected void javaElementToEAnnotation(EObject container, IJavaElement javaElement) throws TagProcessingException {
        EModelElement modelElement;
        EAnnotation eAnnotation;
        if (this.currentJavaElement == null || !this.currentJavaElement.equals(javaElement)) {
            this.currentJavaElement = javaElement;
            if (this.tagFeatureIndexes != null) {
                this.tagFeatureIndexes.clear();
            }
        }
        if ((eAnnotation = (modelElement = (EModelElement)container).getEAnnotation(this.getEAnnotationSource())) == null) {
            eAnnotation = this.createEAnnotation(modelElement);
        }
        this.getRecorder().add((EObject)eAnnotation);
        EMap details = eAnnotation.getDetails();
        details.put((Object)"id", (Object)javaElement.getHandleIdentifier());
    }

    private EAnnotation createEAnnotation(EModelElement modelElement) {
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource(this.getEAnnotationSource());
        modelElement.getEAnnotations().add((Object)eAnnotation);
        return eAnnotation;
    }

    protected void registerTagEPackage(EPackage ePackage) {
        this.registerTags(new DynamicModelTagSetRegistrationOptions(ePackage));
    }

    protected void registerTags(DynamicModelTagSetRegistrationOptions options) {
        DynamicModelTagRegistationManager.INSTANCE.registerTags(options, this);
    }

    protected EClass getJavaClassFromTypeName(String simpleName) {
        IType type = this.currentCompilationUnit.getType(simpleName);
        return this.getJavaClass(type);
    }

    protected EClass getJavaClass(IType type) {
        if (type == null) {
            return null;
        }
        String id = this.computeID(type);
        EClass javaClass = this.getExistingJavaClass(id);
        if (javaClass == null) {
            javaClass = EcoreFactory.eINSTANCE.createEClass();
            javaClass.setName(type.getFullyQualifiedName());
            this.getResource().setID((EObject)javaClass, id);
            this.cacheJavaClass(javaClass, type);
        }
        return javaClass;
    }

    private String computeID(IType type) {
        StringBuffer b = new StringBuffer();
        this.appendTypeID(type, b);
        return b.toString();
    }

    private void appendTypeID(IType type, StringBuffer b) {
        this.appendTypeID(type.getFullyQualifiedName(), type.getJavaProject(), b);
    }

    private void appendTypeID(String qualifiedName, IJavaProject javaProject, StringBuffer b) {
        b.append(javaProject.getElementName());
        b.append('/');
        b.append(qualifiedName);
    }

    private String computeID(ICompilationUnit cu) {
        StringBuffer b = new StringBuffer();
        b.append(CU_ID_PREFIX);
        this.appendTypeID(cu, b);
        return b.toString();
    }

    private void appendTypeID(ICompilationUnit cu, StringBuffer b) {
        IType type = cu.findPrimaryType();
        if (type != null) {
            this.appendTypeID(type, b);
        } else {
            this.appendTypeID(this.computeQualifiedName(cu), cu.getJavaProject(), b);
        }
    }

    private String computeQualifiedName(ICompilationUnit cu) {
        ArrayList<String> segments = new ArrayList<String>();
        ICompilationUnit test = cu;
        while (test.getElementType() != 3) {
            int index;
            String name = test.getElementName();
            if (test.getElementType() == 5 && (index = name.indexOf(46)) > 0) {
                name = name.substring(0, index);
            }
            segments.add(0, name);
            test = test.getParent();
        }
        StringBuffer b = new StringBuffer();
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            String seg = (String)it.next();
            b.append(seg);
            if (!it.hasNext()) continue;
            b.append('.');
        }
        return b.toString();
    }

    private void cacheJavaClass(EClass javaClass, IType type) {
        ICompilationUnit cu = type.getCompilationUnit();
        String cuID = this.computeID(cu);
        EPackage modelCU = (EPackage)this.getResource().getEObject(cuID);
        if (modelCU == null) {
            modelCU = EcoreFactory.eINSTANCE.createEPackage();
            modelCU.setName(cu.getElementName());
            XMLResource res = this.getResource();
            res.getContents().add((Object)modelCU);
            res.setID((EObject)modelCU, cuID);
        }
        modelCU.getEClassifiers().add((Object)javaClass);
    }

    private EPackage getExistingCompilationUnitModel(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        String id = this.computeID(cu);
        return id == null ? null : (EPackage)this.getResource().getEObject(id);
    }

    private EClass getExistingJavaClass(String id) {
        return this.getExistingJavaClassFromID(id);
    }

    private EClass getExistingJavaClassFromID(String id) {
        return (EClass)this.getResource().getEObject(id);
    }

    protected ICompilationUnit getCompilationUnit() {
        return this.currentCompilationUnit;
    }

    protected void transformAll(ModelContentHandler handler) {
        if (this.allCompilationUnits == null || this.allCompilationUnits.isEmpty()) {
            return;
        }
        if (this.transformer == null) {
            String markerId = this.hasUniqueMarkerTypeID() ? this.getMarkerTypeID() : null;
            this.transformer = new AnnotationModelTransformer(markerId);
        }
        handler.setDependencyModelTrackers(this.modelDependencyTrackers);
        this.transformer.transform(this.getRecorder(), handler);
    }

    private boolean hasUniqueMarkerTypeID() {
        return !ANNOT_PROB_MARKER.equals(this.getMarkerTypeID());
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    public IAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    protected boolean hasAnyChanges() {
        AnnotationChangeRecorder recorder = this.getExistingRecorder(this.currentProject);
        return recorder != null && recorder.hasAnyChanges();
    }

    protected Set getAnnotatedCUs() {
        if (this.annotatedCUs == null) {
            return Collections.EMPTY_SET;
        }
        return this.annotatedCUs;
    }

    protected boolean requiresInMemoryModel() {
        return true;
    }

    protected void createErrorMarker(TagData tagData, String message) {
        if (!this.currentTagDataMarkersClear) {
            AnnotationUtil.INSTANCE.deleteMarkers(this.getMarkerTypeID(), tagData);
            this.currentTagDataMarkersClear = true;
        }
        tagData.addErr(message);
    }

    protected void createWarningMarker(TagData tagData, String message) {
        if (!this.currentTagDataMarkersClear) {
            AnnotationUtil.INSTANCE.deleteMarkers(this.getMarkerTypeID(), tagData);
            this.currentTagDataMarkersClear = true;
        }
        tagData.addWarning(message);
    }

    protected String getMarkerTypeID() {
        return ANNOT_PROB_MARKER;
    }

    public void registerModelDependencyTracker(ModelDependencyTracker tracker) {
        if (tracker == null) {
            return;
        }
        if (this.modelDependencyTrackers == null) {
            this.modelDependencyTrackers = new ArrayList();
            this.modelDependencyTrackers.add(tracker);
        } else if (!this.modelDependencyTrackers.contains(tracker)) {
            this.modelDependencyTrackers.add(tracker);
        }
    }

    public void saveSymanticMetaInformation(IProject project, ResourceSet set) throws IOException {
        URI uri = this.getMetaURI();
        if (uri != null) {
            AnnotationUtil.INSTANCE.saveResourceToMetaLocation(uri, project, this.getMetaBundle(), set);
        }
    }

    protected abstract URI getMetaURI();

    protected final Bundle getMetaBundle() {
        String bundleName;
        if (this.metaBundle == null && (bundleName = this.getMetaBundleName()) != null) {
            this.metaBundle = Platform.getBundle((String)bundleName);
        }
        return this.metaBundle;
    }

    protected abstract String getMetaBundleName();

    public void clean(IProject project) throws TagProcessingException {
        DynamicModelAnnotationTagHandlerRegistry.INSTANCE.clean(project);
    }

    public void deleteMetaInformation(IProject project) {
        if (this.requiresInMemoryModel()) {
            AnnotationUtil.INSTANCE.deleteAllMetaInformation(project, this.getMetaBundle());
            this.discardRecorder(project);
        }
    }

    private void discardRecorder(IProject project) {
        if (this.recorders != null) {
            this.recorders.remove(project);
        }
    }

    public void generatedResourceDeleted(IFile generatedFile, IResource parentResource) {
        this.getOrCreateFilesRequiringClean(parentResource.getProject()).add(parentResource);
    }

    private Collection getOrCreateFilesRequiringClean(IProject project) {
        HashSet col = (HashSet)this.filesRequiringCleanMap.get(project);
        if (col == null) {
            col = new HashSet();
            this.filesRequiringCleanMap.put(project, col);
        }
        return col;
    }

    protected Collection getFilesRequiringClean() {
        Collection col = (Collection)this.filesRequiringCleanMap.get(this.getCurrentProject());
        if (col == null) {
            col = Collections.EMPTY_LIST;
        }
        return col;
    }

    protected IType[] getJavaTypes(IFile file) {
        IJavaElement element = JavaCore.create((IFile)file);
        if (element.getElementType() == 5) {
            try {
                return ((ICompilationUnit)element).getTypes();
            }
            catch (JavaModelException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return null;
    }

    public List getInterrestedProjects(IProject project) {
        return Collections.EMPTY_LIST;
    }

    public boolean isInterrestedProject(IProject project) {
        return false;
    }

    public void preClean(IProject project) {
    }

    private final class Index {
        private int value = 0;
        private boolean shouldIgnore = false;

        private Index() {
        }

        public void increment() {
            ++this.value;
        }
    }
}

