/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.dynamic.model;

import com.ibm.zcc.etools.wrd.extensions.dynamic.model.AnnotationResourceImpl;
import com.ibm.zcc.etools.wrd.model.extensions.WsEMFLinker;
import com.ibm.zcc.etools.wrd.model.extensions.impl.WsEMFLinkerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class AnnotationLinkerResource
extends XMIResourceImpl
implements Adapter {
    private Map requiresProcessing = new HashMap();

    public AnnotationLinkerResource() {
    }

    public AnnotationLinkerResource(URI uri) {
        super(uri);
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        super.doLoad(inputStream, options);
        this.processLinkers();
    }

    private void processLinkers() {
        if (this.getContents().isEmpty()) {
            return;
        }
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            WsEMFLinker linker = (WsEMFLinker)iter.next();
            if (this.processLinker(linker)) continue;
            iter.remove();
        }
    }

    private boolean processLinker(WsEMFLinker linker) {
        boolean result = this.processRightDomain(linker);
        result = result && this.processLeftDomain(linker);
        return result;
    }

    private boolean processRightDomain(WsEMFLinker linker) {
        EObject eObject = linker.getRightDomain();
        if (eObject == null || eObject.eIsProxy()) {
            return false;
        }
        if (!eObject.eAdapters().contains((Object)linker)) {
            eObject.eAdapters().add((Object)linker);
        }
        return true;
    }

    private boolean processLeftDomain(WsEMFLinker linker) {
        EList leftDomain = linker.getLeftDomain();
        if (!leftDomain.isEmpty()) {
            Iterator iter = leftDomain.iterator();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (eObject == null || eObject.eIsProxy()) {
                    iter.remove();
                    continue;
                }
                if (eObject.eAdapters().contains((Object)linker)) continue;
                eObject.eAdapters().add((Object)linker);
            }
        }
        return !leftDomain.isEmpty();
    }

    public void requiresProcessing(WsEMFLinkerImpl linker, URI uri) {
        if (this.getResourceSet() == null) {
            this.requiresProcessing.clear();
            return;
        }
        URI resourceURI = uri.trimFragment();
        ArrayList<WeakReference<WsEMFLinkerImpl>> linkers = (ArrayList<WeakReference<WsEMFLinkerImpl>>)this.requiresProcessing.get(resourceURI);
        if (linkers == null) {
            linkers = new ArrayList<WeakReference<WsEMFLinkerImpl>>();
            this.requiresProcessing.put(resourceURI, linkers);
            Resource res = this.getResourceSet().getResource(resourceURI, false);
            if (res != null) {
                res.eAdapters().add((Object)this);
            }
        }
        linkers.add(new WeakReference<WsEMFLinkerImpl>(linker));
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 1 && notification.getFeatureID(Resource.class) == 4 && notification.getNewBooleanValue()) {
            Resource resource = (Resource)notification.getNotifier();
            this.processLinkers(resource);
        }
    }

    private void processLinkers(Resource resource) {
        Collection linkers = (Collection)this.requiresProcessing.get(resource.getURI());
        if (linkers != null && !linkers.isEmpty()) {
            Iterator it = linkers.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                WsEMFLinker linker = (WsEMFLinker)ref.get();
                if (linker == null || !this.processLinker(linker)) continue;
                it.remove();
            }
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type == AnnotationResourceImpl.class;
    }

    protected void doUnload() {
        this.requiresProcessing.clear();
        super.doUnload();
    }
}

