/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.codegen.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jmerge.JControlModel;
import org.eclipse.emf.codegen.jmerge.JMerger;
import org.eclipse.jdt.core.ICompilationUnit;

public class CompilationUnitGenerator {
    protected String templateURI;
    protected String mergeControlURI;
    protected Object templateInstance;
    protected JETEmitter emitter;
    protected JControlModel controlModel;

    public CompilationUnitGenerator(String template, String merger) {
        this.templateURI = template;
        this.mergeControlURI = merger;
    }

    public CompilationUnitGenerator(Object instance) {
        this.templateInstance = instance;
    }

    public void generate(ICompilationUnit compilationUnit, Object modelAdapter, IProgressMonitor progressMonitor) throws JETException {
        try {
            try {
                IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(compilationUnit.getPath());
                progressMonitor.beginTask(targetFile.getFullPath().toString(), 100);
                if (this.emitter == null) {
                    this.emitter = new JETEmitter(this.templateURI);
                    if (this.templateInstance != null) {
                        try {
                            this.emitter.setMethod(this.templateInstance.getClass().getDeclaredMethod("generate", Object.class));
                        }
                        catch (NoSuchMethodException e) {
                            throw new JETException((Throwable)e);
                        }
                    }
                }
                if (this.controlModel == null) {
                    if (this.mergeControlURI == null) {
                        this.mergeControlURI = this.templateInstance.getClass().getClassLoader().getResource("jmerge.xml").toString();
                    }
                    this.controlModel = new JControlModel(this.mergeControlURI);
                }
                progressMonitor.worked(10);
                String emitterResult = this.emitter.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 50), new Object[]{modelAdapter});
                ByteArrayInputStream contents = new ByteArrayInputStream(emitterResult.getBytes());
                JMerger jMerger = new JMerger();
                jMerger.setControlModel(this.controlModel);
                jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(emitterResult));
                if (targetFile.exists()) {
                    progressMonitor.subTask("Examining old " + targetFile.getFullPath());
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(targetFile.getContents(true)));
                }
                progressMonitor.subTask("Preparing new " + targetFile.getFullPath());
                jMerger.merge();
                contents = new ByteArrayInputStream(jMerger.getTargetCompilationUnit().getContents().getBytes());
                progressMonitor.worked(70);
                if (targetFile.exists()) {
                    targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 30));
                } else {
                    IPath path = targetFile.getProjectRelativePath();
                    IProject project = targetFile.getProject();
                    int i = 1;
                    int n = path.segmentCount();
                    while (i < n) {
                        IFolder folder = project.getFolder(path.uptoSegment(i));
                        if (!folder.exists()) {
                            folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        }
                        ++i;
                    }
                    targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 30));
                }
            }
            catch (JETException e) {
                if (e.getStatus() != null) {
                    Throwable targetException = e.getStatus().getException();
                    if (targetException instanceof InvocationTargetException) {
                        targetException = ((InvocationTargetException)targetException).getTargetException();
                        targetException.printStackTrace();
                    } else if (targetException != null) {
                        targetException.printStackTrace();
                    }
                }
                throw e;
            }
            catch (CoreException e) {
                throw new JETException((Throwable)e);
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

