/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.binding.registry.internal;

import com.ibm.adapter.binding.registry.IBinding;
import com.ibm.adapter.binding.registry.internal.Binding;
import com.ibm.adapter.binding.registry.internal.BindingRegistry;
import com.ibm.adapter.binding.registry.internal.BindingRegistryActivator;
import com.ibm.adapter.binding.registry.internal.BindingRegistryConstants;
import com.ibm.adapter.binding.registry.internal.FaultBinding;
import com.ibm.adapter.binding.registry.util.BindingRegistryHelper;
import com.ibm.adapter.binding.registry.util.QNameUtil;
import commonj.connector.metadata.BindingConfigurationEdit;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BindingRegistryPersistence
implements BindingRegistryConstants {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005, 2006 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static String persistentStore = BindingRegistryActivator.getDefault().getStateLocation().append("binding.registry").toOSString();
    private static BindingRegistry bidingRegistry = BindingRegistry.getRegistry();
    private static PersistentStoreContentHandler persistentStoreContentHandler = new PersistentStoreContentHandler();
    private static UserEntriesContentHandler userEntriesContentHandler = new UserEntriesContentHandler();

    public static PersistentStoreContentHandler getPersistentStoreContentHandler() {
        return persistentStoreContentHandler;
    }

    public static UserEntriesContentHandler getUserEntriesContentHandler() {
        return userEntriesContentHandler;
    }

    public static void save(IBinding[] bindings) {
        File file = new File(persistentStore);
        OutputStream outputStream = null;
        try {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                    outputStream = new FileOutputStream(file, true);
                    int i = 0;
                    while (i < bindings.length) {
                        BindingRegistryPersistence.save(bindings[i], outputStream);
                        ++i;
                    }
                } else {
                    persistentStoreContentHandler.getContent().clear();
                    BindingRegistryPersistence.load();
                    List persistentEntries = persistentStoreContentHandler.getContent();
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    outputStream = new FileOutputStream(file, true);
                    if (persistentEntries != null && !persistentEntries.isEmpty()) {
                        int i = 0;
                        while (i < bindings.length) {
                            IBinding binding = bindings[i];
                            boolean alreadyExists = false;
                            for (IBinding persistentEntry : persistentEntries) {
                                if (!persistentEntry.getClassName().equals(binding.getClassName()) || !persistentEntry.getProjectPath().equals(binding.getProjectPath())) continue;
                                alreadyExists = true;
                                break;
                            }
                            if (!alreadyExists) {
                                BindingRegistryPersistence.save(binding, outputStream);
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < bindings.length) {
                            BindingRegistryPersistence.save(bindings[i], outputStream);
                            ++i;
                        }
                    }
                }
            }
            catch (Exception e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception e2) {
                    BindingRegistryActivator.logError(e2, e2.getLocalizedMessage());
                }
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
            }
        }
    }

    public static void save(IBinding binding) {
        File file = new File(persistentStore);
        OutputStream outputStream = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
                outputStream = new FileOutputStream(file, true);
                BindingRegistryPersistence.save(binding, outputStream);
            } else {
                BindingRegistryPersistence.load();
                List bindings = persistentStoreContentHandler.getContent();
                int index = 0;
                boolean replace = false;
                if (bindings != null && !bindings.isEmpty()) {
                    for (IBinding fileBinding : bindings) {
                        if (!fileBinding.getClassName().equals(binding.getClassName()) || !fileBinding.getProjectPath().equals(binding.getProjectPath())) continue;
                        if (fileBinding.equals(binding)) {
                            return;
                        }
                        index = bindings.indexOf(fileBinding);
                        replace = true;
                        break;
                    }
                    if (replace) {
                        bindings.remove(index);
                        bindings.add(binding);
                        file.delete();
                        file.createNewFile();
                        outputStream = new FileOutputStream(file, true);
                        for (IBinding fileBinding : bindings) {
                            BindingRegistryPersistence.save(fileBinding, outputStream);
                        }
                        return;
                    }
                }
                try {
                    outputStream = new FileOutputStream(file, true);
                    BindingRegistryPersistence.save(binding, outputStream);
                }
                catch (Exception e) {
                    BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                }
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
            }
        }
    }

    public static void save(String fileName) {
        File file = new File(fileName);
        OutputStream outputStream = null;
        try {
            try {
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                outputStream = new FileOutputStream(file, true);
                IBinding[] bindings = bidingRegistry.getUserDefinedBindings();
                if (bindings != null) {
                    int i = 0;
                    while (i < bindings.length) {
                        BindingRegistryPersistence.save(bindings[i], outputStream);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception e2) {
                    BindingRegistryActivator.logError(e2, e2.getLocalizedMessage());
                }
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
            }
        }
    }

    private static void save(IBinding binding, OutputStream outputStream) {
        if (binding != null) {
            int i;
            String[] starr;
            StringBuffer stsb;
            String description = binding.getDescription();
            String displayName = binding.getDisplayName();
            String className = binding.getClassName();
            List supportedTypes = binding.getSupportedTypes();
            List supportedDataTypes = binding.getSupportedDataTypes();
            List dataCategories = binding.getDataCategories();
            List supportedFaults = binding.getSupportedFaults();
            List asiNSURIs = binding.getAsiNamespaces();
            String type = binding.getType();
            String generatedType = binding.getGeneratedType();
            List serviceTypes = binding.getSupportedServiceTypes();
            List tags = binding.getTags();
            String requireConfiguration = Boolean.valueOf(binding.requireConfiguration()).toString();
            String configurationClassName = binding.getConfigurationClassName();
            String propertiesJavaBeanClassName = binding.getPropertiesJavaBeanClassName();
            int linkage = binding.getLinkage();
            String projectPath = binding.getProjectPath();
            int indent = 0;
            PrintStream out = new PrintStream(outputStream);
            BindingRegistryPersistence.printIndented(out, indent, "<Binding");
            BindingRegistryPersistence.printIndented(out, indent += 2, "description=" + BindingRegistryPersistence.quote(description));
            BindingRegistryPersistence.printIndented(out, indent, "displayName=" + BindingRegistryPersistence.quote(displayName));
            BindingRegistryPersistence.printIndented(out, indent, "className=" + BindingRegistryPersistence.quote(className));
            if (supportedTypes != null && !supportedTypes.isEmpty()) {
                stsb = new StringBuffer();
                starr = supportedTypes.toArray(new String[0]);
                i = 0;
                while (i < starr.length - 1) {
                    stsb.append(starr[i]).append(",");
                    ++i;
                }
                stsb.append(starr[starr.length - 1]);
                BindingRegistryPersistence.printIndented(out, indent, "supportedType=" + BindingRegistryPersistence.quote(stsb.toString()));
            }
            BindingRegistryPersistence.printIndented(out, indent, "type=" + BindingRegistryPersistence.quote(type));
            if (supportedDataTypes != null && !supportedDataTypes.isEmpty()) {
                StringBuffer qnsb = new StringBuffer();
                QName[] qnarr = supportedDataTypes.toArray(new QName[0]);
                i = 0;
                while (i < qnarr.length - 1) {
                    qnsb.append(QNameUtil.toString(qnarr[i])).append(",");
                    ++i;
                }
                qnsb.append(QNameUtil.toString(qnarr[qnarr.length - 1]));
                BindingRegistryPersistence.printIndented(out, indent, "supportedDataType=" + BindingRegistryPersistence.quote(qnsb.toString()));
            }
            if (dataCategories != null && !dataCategories.isEmpty()) {
                stsb = new StringBuffer();
                starr = dataCategories.toArray(new String[0]);
                i = 0;
                while (i < starr.length - 1) {
                    stsb.append(starr[i]).append(",");
                    ++i;
                }
                stsb.append(starr[starr.length - 1]);
                BindingRegistryPersistence.printIndented(out, indent, "dataCategory=" + BindingRegistryPersistence.quote(stsb.toString()));
            }
            if (generatedType != null) {
                BindingRegistryPersistence.printIndented(out, indent, "generatedType=" + BindingRegistryPersistence.quote(generatedType));
            }
            if (asiNSURIs != null && !asiNSURIs.isEmpty()) {
                StringBuffer asisb = new StringBuffer();
                String[] asiarr = asiNSURIs.toArray(new String[0]);
                i = 0;
                while (i < asiarr.length - 1) {
                    asisb.append(asiarr[i]).append(",");
                    ++i;
                }
                asisb.append(asiarr[asiarr.length - 1]);
                BindingRegistryPersistence.printIndented(out, indent, "asiNamespaceURI=" + BindingRegistryPersistence.quote(asisb.toString()));
            }
            if (serviceTypes != null && !serviceTypes.isEmpty()) {
                stsb = new StringBuffer();
                starr = serviceTypes.toArray(new String[0]);
                i = 0;
                while (i < starr.length - 1) {
                    stsb.append(starr[i]).append(",");
                    ++i;
                }
                stsb.append(starr[starr.length - 1]);
                BindingRegistryPersistence.printIndented(out, indent, "supportedServiceType=" + BindingRegistryPersistence.quote(stsb.toString()));
            }
            if (tags != null && !tags.isEmpty()) {
                stsb = new StringBuffer();
                starr = tags.toArray(new String[0]);
                i = 0;
                while (i < starr.length - 1) {
                    stsb.append(starr[i]).append(",");
                    ++i;
                }
                stsb.append(starr[starr.length - 1]);
                BindingRegistryPersistence.printIndented(out, indent, "tag=" + BindingRegistryPersistence.quote(stsb.toString()));
            }
            BindingRegistryPersistence.printIndented(out, indent, "requireConfiguration=" + BindingRegistryPersistence.quote(requireConfiguration));
            if (configurationClassName != null) {
                BindingRegistryPersistence.printIndented(out, indent, "configurationClassName=" + BindingRegistryPersistence.quote(configurationClassName));
            }
            if (propertiesJavaBeanClassName != null) {
                BindingRegistryPersistence.printIndented(out, indent, "propertiesJavaBeanClassName=" + BindingRegistryPersistence.quote(propertiesJavaBeanClassName));
            }
            BindingRegistryPersistence.printIndented(out, indent, "project=" + BindingRegistryPersistence.quote(projectPath));
            BindingRegistryPersistence.printIndented(out, indent, "linkage=" + BindingRegistryPersistence.quote(new Integer(linkage).toString()));
            indent = 0;
            if (supportedFaults != null && !supportedFaults.isEmpty()) {
                BindingRegistryPersistence.printIndented(out, indent, ">");
                IBinding.IFault[] farr = supportedFaults.toArray(new IBinding.IFault[0]);
                indent += 2;
                int i2 = 0;
                while (i2 < farr.length) {
                    BindingRegistryPersistence.printIndented(out, indent, "<SupportedFault dataType=" + BindingRegistryPersistence.quote(QNameUtil.toString(farr[i2].getDataType())) + " " + "nativeName" + "=" + BindingRegistryPersistence.quote(farr[i2].getNativeName()) + "/>");
                    ++i2;
                }
                indent = 0;
                BindingRegistryPersistence.printIndented(out, indent, "</Binding>");
            } else {
                BindingRegistryPersistence.printIndented(out, indent, "/>");
            }
            out.flush();
        }
    }

    public static void load() {
        FileInputStream inputStream = null;
        try {
            try {
                File file = new File(persistentStore);
                if (file.exists()) {
                    inputStream = new FileInputStream(persistentStore);
                    BindingRegistryPersistence.load(inputStream, true);
                }
            }
            catch (Exception e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e2) {
                    BindingRegistryActivator.logError(e2, e2.getLocalizedMessage());
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
            }
        }
    }

    public static List load(String fileName) {
        block15: {
            FileInputStream inputStream = null;
            try {
                try {
                    File file = new File(fileName);
                    if (file.exists()) {
                        inputStream = new FileInputStream(fileName);
                        BindingRegistryPersistence.load(inputStream, false);
                    }
                }
                catch (Exception e) {
                    BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block15;
                    }
                    catch (Exception e2) {
                        BindingRegistryActivator.logError(e2, e2.getLocalizedMessage());
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
            }
        }
        return userEntriesContentHandler.getContent();
    }

    private static void load(FileInputStream inputStream, boolean isPersitentStoreContentHandler) throws Exception {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(BindingRegistryPersistence.class.getClassLoader());
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentRoot>\n");
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            while (line != null) {
                sb.append(line);
                line = reader.readLine();
            }
            reader.close();
            sb.append("</DocumentRoot>");
            String xmlString = sb.toString();
            xmlString = xmlString.replaceAll("&#xD;", "");
            xmlString = xmlString.replaceAll("&#xA;", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
            if (isPersitentStoreContentHandler) {
                parser.parse(new InputSource(is), (DefaultHandler)persistentStoreContentHandler);
            } else {
                parser.parse(new InputSource(is), (DefaultHandler)userEntriesContentHandler);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    public static void primeRegistryFromPersistentStoreEntries() {
        BindingRegistryPersistence.load();
        List bindings = persistentStoreContentHandler.getContent();
        if (bindings != null && !bindings.isEmpty()) {
            for (Binding binding : bindings) {
                try {
                    Object propertiesJavaBean;
                    Object instance = BindingRegistryHelper.getBindingConfiguartionObject(binding.getProject(), binding.getClassName(), binding.getLinkage());
                    binding.setInstance(instance);
                    BindingConfigurationEdit configuration = (BindingConfigurationEdit)BindingRegistryHelper.getBindingConfiguartionObject(binding.getProject(), binding.getConfigurationClassName(), binding.getLinkage());
                    if (configuration != null) {
                        binding.setConfiguration(configuration);
                    }
                    if ((propertiesJavaBean = BindingRegistryHelper.getBindingConfiguartionObject(binding.getProject(), binding.getPropertiesJavaBeanClassName(), binding.getLinkage())) != null) {
                        binding.setPropertiesJavaBean(propertiesJavaBean);
                    }
                }
                catch (CoreException e) {
                    BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                }
                bidingRegistry.addEntry(binding);
            }
        }
    }

    public static void deletePersistentStoreEntries(IBinding[] bindings) {
        persistentStoreContentHandler.getContent().clear();
        BindingRegistryPersistence.load();
        List persistentEntries = persistentStoreContentHandler.getContent();
        if (persistentEntries != null && !persistentEntries.isEmpty()) {
            ArrayList<Binding> keepEntries = new ArrayList<Binding>();
            for (IBinding persistentEntry : persistentEntries) {
                String className = persistentEntry.getClassName();
                String path = persistentEntry.getProjectPath();
                boolean preserve = true;
                int i = 0;
                while (i < bindings.length) {
                    IBinding binding = bindings[i];
                    if (className.equals(binding.getClassName()) && path.equals(binding.getProjectPath())) {
                        preserve = false;
                        break;
                    }
                    ++i;
                }
                if (!preserve) continue;
                Binding bindingClone = (Binding)persistentEntry.clone();
                keepEntries.add(bindingClone);
            }
            File file = new File(persistentStore);
            if (file.exists()) {
                file.delete();
            }
            persistentStoreContentHandler.getContent().clear();
            if (!keepEntries.isEmpty()) {
                BindingRegistryPersistence.save(keepEntries.toArray(new Binding[0]));
            }
        }
    }

    public static void deletePersistentStoreEntry(String bindingObjectClassName, String projectPath) {
        BindingRegistryPersistence.load();
        List bindings = persistentStoreContentHandler.getContent();
        if (bindings != null && !bindings.isEmpty()) {
            IBinding binding2 = null;
            boolean matched = false;
            for (IBinding binding2 : bindings) {
                String className = binding2.getClassName();
                String path = binding2.getProjectPath();
                if (!className.equals(bindingObjectClassName) || !path.equals(projectPath)) continue;
                matched = true;
                break;
            }
            if (matched) {
                bindings.remove(binding2);
                File file = new File(persistentStore);
                if (file.exists()) {
                    file.delete();
                }
                ArrayList<IBinding> clone = new ArrayList<IBinding>();
                Iterator bit = bindings.iterator();
                while (bit.hasNext()) {
                    IBinding bindingClone = (IBinding)((Binding)bit.next()).clone();
                    if (clone.contains(bindingClone)) continue;
                    clone.add(bindingClone);
                }
                bindings.clear();
                Iterator cit = clone.iterator();
                while (cit.hasNext()) {
                    BindingRegistryPersistence.save((IBinding)cit.next());
                }
            }
        }
    }

    private static String quote(String string) {
        return "\"" + string + "\"";
    }

    private static void printIndented(PrintStream out, int indent, String string) {
        int i = 0;
        while (i < indent) {
            out.print(" ");
            ++i;
        }
        out.println(string);
    }

    public static class BaseContentHandler
    extends DefaultHandler {
        private List content;

        public BaseContentHandler(List newContent) {
            this.content = newContent;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            int contentEntryIndex;
            if (localName.equals("Binding")) {
                String dataCategories;
                IBinding binding = bidingRegistry.createEntry();
                String linkage = attributes.getValue("", "linkage");
                binding.setLinkage(new Integer(linkage));
                String projectPath = attributes.getValue("", "project");
                binding.setProjectPath(projectPath);
                String description = attributes.getValue("", "description");
                binding.setDescription(description);
                String displayName = attributes.getValue("", "displayName");
                binding.setDisplayName(displayName);
                String className = attributes.getValue("", "className");
                binding.setClassName(className);
                String supportedType = attributes.getValue("", "supportedType");
                if (supportedType != null && !"".equals(supportedType)) {
                    String[] supportedTypeTokens = supportedType.split(",");
                    ArrayList<String> supportedTypes = new ArrayList<String>();
                    int i = 0;
                    while (i < supportedTypeTokens.length) {
                        supportedTypes.add(supportedTypeTokens[i].trim());
                        ++i;
                    }
                    binding.setSupportedTypes(supportedTypes);
                }
                String type = attributes.getValue("", "type");
                binding.setType(type);
                String supportedDataType = attributes.getValue("", "supportedDataType");
                if (supportedDataType != null && !"".equals(supportedDataType)) {
                    String[] supportedDataTypeTokens = supportedDataType.split(",");
                    ArrayList<QName> supportedDataTypes = new ArrayList<QName>();
                    int i = 0;
                    while (i < supportedDataTypeTokens.length) {
                        supportedDataTypes.add(QNameUtil.qnameFromString(supportedDataTypeTokens[i].trim()));
                        ++i;
                    }
                    binding.setSupportedDataTypes(supportedDataTypes);
                }
                if ((dataCategories = attributes.getValue("", "dataCategory")) != null && !"".equals(dataCategories)) {
                    String[] dataCategoryTokens = dataCategories.split(",");
                    ArrayList<String> dataCategoryNames = new ArrayList<String>();
                    int i = 0;
                    while (i < dataCategoryTokens.length) {
                        dataCategoryNames.add(dataCategoryTokens[i].trim());
                        ++i;
                    }
                    binding.setDataCategories(dataCategoryNames);
                }
                String generatedType = attributes.getValue("", "generatedType");
                binding.setGeneratedType(generatedType);
                String asiNSURIs = attributes.getValue("", "asiNamespaceURI");
                if (asiNSURIs != null && !"".equals(asiNSURIs)) {
                    String[] asiNSURITokens = asiNSURIs.split(",");
                    ArrayList<String> asiNamespaces = new ArrayList<String>();
                    int i = 0;
                    while (i < asiNSURITokens.length) {
                        asiNamespaces.add(asiNSURITokens[i].trim());
                        ++i;
                    }
                    binding.setAsiNamespaces(asiNamespaces);
                }
                String supportedServiceType = attributes.getValue("", "supportedServiceType");
                String[] serviceTypeTokens = supportedServiceType.split(",");
                ArrayList<String> supportedServiceTypes = new ArrayList<String>();
                int i = 0;
                while (i < serviceTypeTokens.length) {
                    supportedServiceTypes.add(serviceTypeTokens[i].trim());
                    ++i;
                }
                binding.setSupportedServiceTypes(supportedServiceTypes);
                String tags = attributes.getValue("", "tag");
                if (tags != null && !"".equals(tags)) {
                    String[] tagTokens = tags.split(",");
                    ArrayList<String> tagNames = new ArrayList<String>();
                    int i2 = 0;
                    while (i2 < tagTokens.length) {
                        tagNames.add(tagTokens[i2].trim());
                        ++i2;
                    }
                    binding.setTags(tagNames);
                }
                String requireConfiguration = attributes.getValue("", "requireConfiguration");
                binding.setRequireConfiguration(Boolean.valueOf(requireConfiguration));
                String configurationClassName = attributes.getValue("", "configurationClassName");
                binding.setConfigurationClassName(configurationClassName);
                String propertiesJavaBeanClassName = attributes.getValue("", "propertiesJavaBeanClassName");
                binding.setPropertiesJavaBeanClassName(propertiesJavaBeanClassName);
                if (!this.content.contains(binding)) {
                    this.content.add(binding);
                }
            } else if (localName.equals("SupportedFault") && (contentEntryIndex = this.content.size() - 1) >= 0) {
                IBinding binding = (IBinding)this.content.get(contentEntryIndex);
                FaultBinding fault = new FaultBinding();
                String dataType = attributes.getValue("", "dataType");
                QName dataTypeQName = QNameUtil.qnameFromString(dataType);
                fault.setDataType(dataTypeQName);
                String nativeName = attributes.getValue("", "nativeName");
                fault.setNativeName(nativeName);
                binding.addSupportedFault(fault);
            }
        }

        public List getContent() {
            return this.content;
        }

        public void clearContent() {
            this.content.clear();
        }
    }

    public static class PersistentStoreContentHandler
    extends BaseContentHandler {
        public PersistentStoreContentHandler() {
            super(new ArrayList());
        }
    }

    public static class UserEntriesContentHandler
    extends BaseContentHandler {
        public UserEntriesContentHandler() {
            super(new ArrayList());
        }
    }
}

