/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.wizards;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IPublishingObject;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.ccl.discovery.ui.api.IDiscoveryFlowModel;
import com.ibm.ccl.discovery.ui.internal.properties.UnconfiguredResultNodesTreeNodeProperty;
import com.ibm.ccl.discovery.ui.internal.properties.UnconfiguredResultNodesTreeProperty;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.ccl.discovery.ui.plugin.DiscUIPlugin;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard;
import com.ibm.ccl.discovery.ui.wizards.PublishingPropertiesPage;
import com.ibm.ccl.discovery.ui.wizards.ResolutionPropertiesPage;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.BaseNodeProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage_PropertyGroup;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;

public class PublishingObjectConfigurationParametersPage
extends MessageBundleWizardDynamicPage_PropertyGroup {
    protected IResourceWriter writer_ = null;
    protected IPublishingSet publishingSet_ = null;
    protected Map<IPublishingObject, IPropertyGroup> configParamMap_ = null;
    protected boolean hasPublishingProperties_ = false;
    protected boolean hasResolutionProperties_ = false;
    protected IPropertyGroup pg_;

    public PublishingObjectConfigurationParametersPage(String name, PropertyUIMessageBundle newBundle) {
        super(name, newBundle);
        this.initPageTitle();
    }

    protected void initPageTitle() {
        this.setTitle(this.messageBundle_.getMessage("DISC_UI_WIZARD_PO_CONFIG_PARAMS_PAGE_TITLE"));
        this.setDescription(this.messageBundle_.getMessage("DISC_UI_WIZARD_PO_CONFIG_PARAMS_PAGE_DESC"));
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_DISC_WIZARD_PO_CONFIG_PARAMS_PAGE")));
    }

    public void initPage(IResourceWriter writer, IPublishingSet publishingSet, Map<IPublishingObject, IPropertyGroup> configParamMap) {
        this.writer_ = writer;
        this.publishingSet_ = publishingSet;
        this.configParamMap_ = configParamMap;
        IPropertyGroup pg = this.createUnifiedPropertyGroup(configParamMap);
        IDiscoveryFlowModel model = ((DiscWizard)this.getWizard()).getFlowModel();
        if (model != null && this.firstOpens()) {
            try {
                pg.populateFromString(model.getPublishingObjectConfigurationParametersPagePropertyGroup());
                ((DiscWizard)this.getWizard()).restoreSensitiveProperties(pg, model);
            }
            catch (CoreException exc) {
                DiscUIPlugin.getInstance().getLog().log(exc.getStatus());
            }
            this.firstOpens(false);
        }
        this.pg_ = pg;
        this.displayPage(pg);
        this.isModified(true);
    }

    private IPropertyGroup createUnifiedPropertyGroup(Map<IPublishingObject, IPropertyGroup> configParamMap) {
        if (configParamMap.size() == 1) {
            return configParamMap.values().iterator().next();
        }
        String name = "UnconfiguredNodes_container";
        BasePropertyGroup bpg = null;
        try {
            bpg = new BasePropertyGroup(name, name, name);
            name = "rootProperty";
            BaseNodeProperty rootProperty = new BaseNodeProperty(name, name, name);
            name = "UnconfiguredNodes_treeProperty";
            UnconfiguredResultNodesTreeProperty treeProperty = new UnconfiguredResultNodesTreeProperty(name, name, name, (INodeProperty)rootProperty);
            treeProperty.setSelectableTree(false);
            treeProperty.setShowRoot(false);
            int i = 0;
            for (Map.Entry<IPublishingObject, IPropertyGroup> entry : configParamMap.entrySet()) {
                IPropertyGroup configParams;
                IPublishingObject pubObject = entry.getKey();
                INodeProperty nodeProperty = this.createNodeProperty(pubObject, configParams = entry.getValue(), ++i);
                if (nodeProperty == null) continue;
                rootProperty.addChild(nodeProperty);
            }
            bpg.addProperty((IPropertyDescriptor)treeProperty);
        }
        catch (Exception exception) {}
        if (bpg == null || bpg.getProperties().length < 1) {
            return null;
        }
        return bpg;
    }

    private INodeProperty createNodeProperty(IPublishingObject pubObject, IPropertyGroup pg, int counter) {
        String name = pubObject.getName();
        StringBuffer nodeName = new StringBuffer(name).append(Integer.toString(counter));
        UnconfiguredResultNodesTreeNodeProperty property = null;
        try {
            property = new UnconfiguredResultNodesTreeNodeProperty(nodeName.toString(), name, pubObject.getDescription(), null);
            property.setConfigurationParameters(pg);
            property.applyConfigurationProperties(pg);
        }
        catch (Exception exception) {
            property = null;
        }
        return property;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void isModified(boolean newValue) {
        super.isModified(newValue);
        if (newValue) {
            this.setWizardCanFinish(false);
            this.hasPublishingProperties_ = false;
            this.hasResolutionProperties_ = false;
            this.setPageComplete(this.determinePageCompletion());
        }
    }

    public IWizardPage getNextPage() {
        MessageBundleWizardDynamicPage_PropertyGroup nextPage = this;
        DiscWizard wizard = (DiscWizard)this.getWizard();
        if (this.isModified()) {
            try {
                IPropertyGroup publishingProperties = this.publishingSet_.createPublishingProperties();
                if (publishingProperties != null) {
                    this.hasPublishingProperties_ = true;
                    this.publishingSet_.applyPublishingProperties(publishingProperties);
                    PublishingPropertiesPage publishPropPage = wizard.getPublishingPropertiesPage();
                    nextPage = publishPropPage;
                    publishPropPage.initPage(this.writer_, this.publishingSet_, publishingProperties);
                }
                if (this.publishingSet_.publishCheck()) {
                    nextPage = null;
                }
                this.hasResolutionProperties_ = true;
                IPropertyGroup resolutionProperties = this.publishingSet_.createResolutionProperties();
                this.publishingSet_.applyResolutionProperties(resolutionProperties);
                ResolutionPropertiesPage resolutionPropsPage = wizard.getResolutionPropertiesPage();
                nextPage = resolutionPropsPage;
                resolutionPropsPage.initPage(this.writer_, this.publishingSet_, resolutionProperties);
            }
            catch (BaseException ie) {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage(ie, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException((CoreException)((Object)ie)));
                return nextPage;
            }
            catch (Exception e) {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage(e, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), e.getMessage());
                return nextPage;
            }
        } else {
            nextPage = this.hasPublishingProperties_ ? wizard.getPublishingPropertiesPage() : (this.hasResolutionProperties_ ? wizard.getResolutionPropertiesPage() : null);
        }
        this.isModified(false);
        return nextPage;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ((IWizardContainer2)this.getWizard().getContainer()).updateSize();
        }
        super.setVisible(visible);
    }

    public PropertyUIFactory getPropertyUIFactory() {
        if (this.pg_ != null && this.checkNestedLayoutExtensionInPropertyGroup(this.pg_)) {
            PropertyUIFactory factory = PropertyUIFactory.newInstance((boolean)true);
            if (this.contextPrefix_ != null) {
                factory.setHelpContextIdPrefix(this.contextPrefix_);
            }
            factory.setRootGroupingStyle(1);
            factory.setNestedGroupStyle(1);
            factory.needSeparatorForNoDisplayNameProprtyGroup(false);
            factory.needSeparatorForProperty(false);
            return factory;
        }
        return super.getPropertyUIFactory();
    }

    protected boolean checkNestedLayoutExtensionInPropertyGroup(IPropertyGroup propertyGroup) {
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        int i = 0;
        while (i < properties.length) {
            IPropertyDescriptor ipd = properties[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                if ("com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(ipd.getID())) {
                    return true;
                }
                if (this.checkNestedLayoutExtensionInPropertyGroup((IPropertyGroup)ipd)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

