/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.internal.providers;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeIterator;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.ccl.discovery.ui.internal.messages.DiscUIMessageBundle;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard;
import com.ibm.ccl.discpub.ui.core.internal.environment.UICoreImportEnvironment;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;

public class MetaDataObjectContentProvider
implements ITreeContentProvider {
    private WizardPage wizardPage_ = null;
    private HashMap<Object, IPropertyGroup> filterMap_ = new HashMap();
    private PropertyUIMessageBundle messageBundle_;

    private MetaDataObjectContentProvider() {
    }

    public MetaDataObjectContentProvider(WizardPage wizardPage) {
        this(wizardPage, null);
    }

    public MetaDataObjectContentProvider(WizardPage wizardPage, PropertyUIMessageBundle newBundle) {
        this();
        this.wizardPage_ = wizardPage;
        this.messageBundle_ = newBundle;
        if (this.messageBundle_ == null && wizardPage instanceof MessageBundleWizardPage) {
            this.messageBundle_ = ((MessageBundleWizardPage)wizardPage).getMessageBundle();
        }
        if (this.messageBundle_ == null) {
            this.messageBundle_ = new DiscUIMessageBundle(null);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Collection) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof IResultNodeResponse) {
            IResultNodeResponse node = (IResultNodeResponse)parentElement;
            ArrayList<IResultNode> children = new ArrayList<IResultNode>();
            if (node.hasContent()) {
                IResultNodeIterator iterator = node.getResultNodeIterator();
                while (iterator.hasNext()) {
                    IResultNode child = iterator.nextResultNode();
                    children.add(child);
                }
            }
            return children.toArray();
        }
        if (parentElement instanceof IResultNode) {
            return this.fetchDeferredChildren(parentElement);
        }
        return new Object[0];
    }

    public Object[] fetchDeferredChildren(Object parentElement) {
        final IResultNode node = (IResultNode)parentElement;
        ArrayList<IResultNode> children = new ArrayList<IResultNode>();
        IPropertyGroup appliedFilter = null;
        if (this.filterMap_.containsKey(parentElement)) {
            appliedFilter = this.filterMap_.get(parentElement);
            this.filterMap_.remove(parentElement);
        } else {
            appliedFilter = node.getAppliedFilter();
        }
        IResultNodeResponse nodeResponse = null;
        final Object[] results = new Object[2];
        results[0] = appliedFilter;
        final DiscWizard wizard = (DiscWizard)this.wizardPage_.getWizard();
        try {
            wizard.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        String msg = MetaDataObjectContentProvider.this.messageBundle_.getMessage("DISC_UI_WIZARD_MSG_FETCHING_CHILDREN", new Object[]{MetaDataObjectContentProvider.this.getElementName(node)});
                        monitor.beginTask(msg, -1);
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
                        UICoreImportEnvironment env = wizard.getImportEnvironment();
                        env.setProgressMonitor((IProgressMonitor)subMonitor);
                        results[1] = node.getChildren((IPropertyGroup)results[0], (IEnvironment)env);
                        subMonitor.done();
                        monitor.done();
                    }
                    catch (BaseException exc) {
                        final DiscUIHelper helper = DiscUIHelper.getDiscUIHelper();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                helper.showExceptionMessage(exc, MetaDataObjectContentProvider.this.wizardPage_.getShell(), MetaDataObjectContentProvider.this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), helper.getMessageFromCoreException((CoreException)((Object)exc)));
                            }
                        });
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            final DiscUIHelper helper = DiscUIHelper.getDiscUIHelper();
            final Throwable exc = e.getTargetException();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    helper.showExceptionMessage(exc, MetaDataObjectContentProvider.this.wizardPage_.getShell(), MetaDataObjectContentProvider.this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), exc.getLocalizedMessage());
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return new Object[0];
        }
        nodeResponse = (IResultNodeResponse)results[1];
        if (nodeResponse != null) {
            final String message = nodeResponse.getMessage();
            if (message != null && !"".equals(message) && this.wizardPage_ != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MetaDataObjectContentProvider.this.wizardPage_.setMessage(message, 1);
                    }
                });
            }
            if (nodeResponse.hasContent()) {
                IResultNodeIterator iterator = nodeResponse.getResultNodeIterator();
                while (iterator.hasNext()) {
                    IResultNode child = iterator.nextResultNode();
                    children.add(child);
                }
            }
        }
        return children.toArray();
    }

    public String getElementName(Object element) {
        if (element instanceof IResultNode) {
            return ((IResultNode)element).getName();
        }
        return element.toString();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IResultNode) {
            return ((IResultNode)element).hasChildren();
        }
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    public boolean hasFilter(IResultNode node) {
        IPropertyGroup pg = this.filterMap_.get(node);
        if (pg == null && this.filterMap_.containsKey(node)) {
            return false;
        }
        return pg != null || node.getAppliedFilter() != null;
    }

    public IPropertyGroup getFilterPropertyGroup(IResultNode node) {
        IPropertyGroup pg = this.filterMap_.get(node);
        if (pg == null && this.filterMap_.containsKey(node)) {
            return null;
        }
        if (pg != null) {
            return pg;
        }
        pg = node.getAppliedFilter();
        return pg;
    }

    public void setFilterPropertyGroup(IResultNode node, IPropertyGroup filterPropertyGroup) {
        this.filterMap_.put(node, filterPropertyGroup);
    }

    public IWizardPage getWizardPage() {
        return this.wizardPage_;
    }

    public void setWizardPage(WizardPage wizardPage) {
        this.wizardPage_ = wizardPage;
    }

    public PropertyUIMessageBundle getMessageBundle() {
        return this.messageBundle_;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

