/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.internal.datastore;

import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.IPropertyType;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.ui.datastores.DynamicPropStore;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTree;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DiscConnectionStore
extends DynamicPropStore {
    public static final int MAX_CONNECTION_COUNT = 11;
    public static final String CONNECTION_LIST_KEY = "Connections";
    public ArrayList connectionNames_ = new ArrayList();

    public DiscConnectionStore(AbstractUIPlugin plugin) {
        super(plugin);
    }

    public ArrayList loadConnectionNames(String raName) {
        this.connectionNames_ = new ArrayList();
        this.connectionNames_ = this.restoreCustomProperties(raName, CONNECTION_LIST_KEY);
        return this.connectionNames_;
    }

    public ArrayList getConnectionLists(IDialogSettings raStore) {
        String[] pConnectionLists_;
        ArrayList<String> CList = new ArrayList<String>();
        if (raStore != null && (pConnectionLists_ = DiscConnectionStore.getArray((IDialogSettings)raStore, (String)CONNECTION_LIST_KEY)) != null && pConnectionLists_.length > 0) {
            int size = pConnectionLists_.length;
            int start = 0;
            if (size > 11) {
                start = size - 11;
            }
            int i = start;
            while (i < size) {
                CList.add(pConnectionLists_[i]);
                ++i;
            }
        }
        return CList;
    }

    public void restoreConnection(String raName, String connectionSectionName, ArrayList widgets, IPropertyGroup properties) {
        if (connectionSectionName != null) {
            this.restorePropertyGroups(raName, connectionSectionName, properties);
        }
        this.restoreSuggestionsOnWidgets(raName, widgets);
    }

    public String getConnectionName(ArrayList widgets) {
        PropertyUIWidget element;
        Iterator iter;
        IPropertyType pt;
        String connectionSectionName = null;
        if (widgets == null) {
            return null;
        }
        ArrayList<PropertyUIWidget> requiredPropertyList = new ArrayList<PropertyUIWidget>();
        for (PropertyUIWidget widget : widgets) {
            if (widget instanceof PropertyUIWidgetTree) {
                IPropertyGroup iPropertyGroup;
                INodeProperty node;
                TreeItem[] items;
                PropertyUIWidgetTree treeWidget = (PropertyUIWidgetTree)widget;
                if (treeWidget.getTreeViewer() == null || treeWidget.getTreeViewer().getTree() == null || (items = treeWidget.getTreeViewer().getTree().getSelection()) == null || items.length <= 0 || (node = (INodeProperty)items[0].getData()) == null || (iPropertyGroup = node.getActiveConfigurationProperties()) == null) continue;
                this.findRequiredTreeNodeProperties(iPropertyGroup, requiredPropertyList);
                continue;
            }
            pt = widget.getPropertyType();
            if (pt == null || !pt.isRequired() || pt.isHidden() || pt.isSensitive() || pt.isReadOnly()) continue;
            requiredPropertyList.add(widget);
        }
        if (requiredPropertyList.size() < 3) {
            iter = widgets.iterator();
            while (iter.hasNext() && requiredPropertyList.size() < 3) {
                element = (PropertyUIWidget)iter.next();
                pt = element.getPropertyType();
                if (requiredPropertyList.contains(element) || pt != null && (pt.isHidden() || pt.isSensitive() || pt.isReadOnly())) continue;
                requiredPropertyList.add(element);
            }
        }
        if (requiredPropertyList.size() == 0) {
            iter = widgets.iterator();
            while (iter.hasNext() && requiredPropertyList.size() < 3) {
                element = (PropertyUIWidget)iter.next();
                pt = element.getPropertyType();
                if (requiredPropertyList.contains(element) || pt != null && pt.isSensitive()) continue;
                requiredPropertyList.add(element);
            }
        }
        String parm0 = ":";
        String parm1 = ":";
        String parm2 = ":";
        ArrayList<String> values = new ArrayList<String>();
        for (Object e : requiredPropertyList) {
            if (e instanceof PropertyUIWidget) {
                PropertyUIWidget widget = (PropertyUIWidget)e;
                if (widget.getWidgetValue() != "") {
                    values.add(widget.getWidgetValue());
                    continue;
                }
                values.add(":");
                continue;
            }
            if (!(e instanceof ISingleValuedProperty)) continue;
            ISingleValuedProperty property = (ISingleValuedProperty)e;
            if (property.getValueAsString() != null && !"".equals(property.getValueAsString())) {
                values.add(property.getValueAsString());
                continue;
            }
            values.add(":");
        }
        if (requiredPropertyList.size() >= 3) {
            parm0 = (String)values.get(0);
            parm1 = (String)values.get(1);
            parm2 = (String)values.get(2);
            connectionSectionName = String.valueOf(parm0) + ":" + parm1 + ":" + parm2;
        } else if (requiredPropertyList.size() >= 2) {
            parm0 = (String)values.get(0);
            parm1 = (String)values.get(1);
            connectionSectionName = String.valueOf(parm0) + ":" + parm1;
        } else if (requiredPropertyList.size() >= 1) {
            connectionSectionName = (String)values.get(0);
        }
        return connectionSectionName;
    }

    public void saveConnection(String raName, String customPropertyLabel, String customName, ArrayList widgets, IPropertyGroup properties) {
        if (widgets == null || customName == null) {
            return;
        }
        this.storePropertyGroups(raName, customPropertyLabel, customName, properties);
    }

    private void findRequiredTreeNodeProperties(IPropertyGroup pg, ArrayList requiredPropertyList) {
        IPropertyDescriptor[] descs = pg.getProperties();
        int i = 0;
        while (i < descs.length) {
            if (descs[i] instanceof ISingleValuedProperty) {
                ISingleValuedProperty prop = (ISingleValuedProperty)descs[i];
                IPropertyType pt = prop.getPropertyType();
                if (pt != null && pt.isRequired() && !pt.isHidden() && !pt.isSensitive() && !pt.isReadOnly()) {
                    requiredPropertyList.add(prop);
                }
            } else if (descs[i] instanceof IPropertyGroup) {
                this.findRequiredTreeNodeProperties((IPropertyGroup)descs[i], requiredPropertyList);
            }
            ++i;
        }
    }
}

