/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.Vector;

public class ProcessWatcher {
    private Process proc;
    private StreamWatcher swStdout;
    private StreamWatcher swStderr;
    private String charsetName;

    public ProcessWatcher(Process p) {
        this.proc = p;
        this.swStdout = new StreamWatcher(this.proc.getInputStream());
        this.swStderr = new StreamWatcher(this.proc.getErrorStream());
    }

    public ProcessWatcher(Process p, String csName) {
        this.proc = p;
        this.charsetName = csName;
        this.swStdout = new StreamWatcher(this.proc.getInputStream(), this.charsetName);
        this.swStderr = new StreamWatcher(this.proc.getErrorStream(), this.charsetName);
    }

    public int waitFor() throws InterruptedException {
        int result = this.proc.waitFor();
        this.swStdout.waitFor();
        this.swStderr.waitFor();
        return result;
    }

    public AbstractList getStdoutResult() {
        return this.swStdout.getOutputs();
    }

    public AbstractList getStderrResult() {
        return this.swStderr.getOutputs();
    }

    private class StreamWatcher
    implements Runnable {
        private BufferedReader reader;
        private boolean bRunning = true;
        private boolean bFinished = false;
        private Vector<String> outputs = new Vector();

        private StreamWatcher(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is));
            Thread t = new Thread(this);
            t.start();
        }

        private StreamWatcher(InputStream is, String charsetName) {
            this.reader = new BufferedReader(new InputStreamReader(is));
            try {
                this.reader = new BufferedReader(new InputStreamReader(is, charsetName));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            Thread t = new Thread(this);
            t.start();
        }

        private void waitFor() {
            if (this.bRunning) {
                this.bRunning = false;
                try {
                    while (!this.bFinished) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private AbstractList getOutputs() {
            return this.outputs;
        }

        @Override
        public void run() {
            while (this.bRunning) {
                try {
                    Thread.sleep(500L);
                    this.readFromStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.readFromStream();
            this.bFinished = true;
        }

        private void readFromStream() {
            try {
                while (this.reader.ready()) {
                    this.outputs.add(this.reader.readLine());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

