/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.plugin;

import java.net.URL;
import java.util.logging.Level;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CobolPlugin
extends AbstractUIPlugin {
    public static final String copyright = "(c) Copyright IBM Corporation 2001,2004.";
    private static final String EXTENSION_POINT_ID = "cobolImporterCopybookLocation";
    public static final String PLUGIN_ID = "com.ibm.etools.cobol";
    private static CobolPlugin fieldPlugin;
    private static String additionalCOPYBookLocations;
    private boolean DEBUG = false;
    private boolean DEBUG_SEVERE = false;
    private boolean DEBUG_FINE = false;
    private static final String PATH_SEPARATOR;

    static {
        additionalCOPYBookLocations = "";
        PATH_SEPARATOR = System.getProperty("path.separator");
    }

    public CobolPlugin() {
        if (fieldPlugin == null) {
            fieldPlugin = this;
        }
    }

    public static CobolPlugin getDefault() {
        return fieldPlugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.DEBUG = CobolPlugin.getDefault().isDebugging();
        this.DEBUG_SEVERE = true;
        this.DEBUG_FINE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.etools.cobol/debug/fine"));
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ces = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ces.length) {
                    if (ces[j].getAttribute("plugin-id") != "" && ces[j].getAttribute("relativeFolderLocation") != null) {
                        String plugin_id = ces[j].getAttribute("plugin-id");
                        String relativeFolderLocation = ces[j].getAttribute("relativeFolderLocation");
                        Path path = new Path(String.valueOf(CobolPlugin.getPluginLocation(plugin_id)) + relativeFolderLocation);
                        if (path.toFile().exists()) {
                            additionalCOPYBookLocations = String.valueOf(additionalCOPYBookLocations) + CobolPlugin.getPluginLocation(plugin_id) + relativeFolderLocation + PATH_SEPARATOR;
                        } else {
                            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolPlugin.start(): Unable to add the additionalCopyBookLocation: " + CobolPlugin.getPluginLocation(plugin_id) + relativeFolderLocation + " does not exist");
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public void writeMsg(Level logLevel, String msg) {
        this.writeMsg(logLevel, msg, null);
    }

    public void writeMsg(Level logLevel, String msg, Throwable t) {
        if (logLevel.intValue() == Level.SEVERE.intValue() && this.isDEBUG_SEVERE()) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, msg, t));
        } else if (this.isDEBUG() && this.isDEBUG_FINE()) {
            this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, msg, t));
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("com.ibm.etools.cobol.plugin", "com.ibm.etools.cobol.plugin");
        store.setDefault("com.ibm.etools.cobol.plugin.TOOL_EDITOR", false);
        store.setDefault("com.ibm.etools.cobol.plugin.TOOL_NEW_WIZARD", false);
        store.setDefault("com.ibm.etools.cobol.plugin.TOOL_PREFERENCE_PAGE", true);
        store.setDefault("com.ibm.etools.cobol.plugin.TOOL_EXTENSION", true);
        store.setDefault("com.ibm.etools.cobol.plugin.TOOL_PLUGIN_ID", "CobolPlugin");
        store.setDefault("com.ibm.etools.cobol.plugin.TOOL_VENDOR", "IBM");
        store.setDefault("com.ibm.etools.cobol.plugin.COBOL_COMPILE_TRUNC_BIN_OPTION", "true");
    }

    public static String getAdditionalCOPYBookLocations() {
        return additionalCOPYBookLocations;
    }

    public static String getPluginLocation(String pluginId) {
        try {
            String pluginLocation = null;
            URL installURL = Platform.getBundle((String)pluginId).getEntry("/");
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolPlugin.getPluginLocation(): OS = " + System.getProperty("os.name"));
            if (System.getProperty("os.name").startsWith("Linux") || System.getProperty("os.name").startsWith("Mac")) {
                pluginLocation = FileLocator.resolve((URL)installURL).getFile();
            } else {
                pluginLocation = FileLocator.resolve((URL)installURL).getFile();
                if (!pluginLocation.startsWith("//")) {
                    pluginLocation = pluginLocation.substring(1);
                }
                pluginLocation = pluginLocation.replace('/', '\\');
            }
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolPlugin.getPluginLocation(): Plugin location = " + pluginLocation);
            return pluginLocation;
        }
        catch (Exception e) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolPlugin.getPluginLocation(): Exception = " + e.getMessage(), e);
            return null;
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public boolean isDEBUG() {
        return this.DEBUG;
    }

    public boolean isDEBUG_FINE() {
        return this.DEBUG_FINE;
    }

    public boolean isDEBUG_SEVERE() {
        return this.DEBUG_SEVERE;
    }
}

