/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.importer.CobolException;
import com.ibm.etools.cobol.importer.RunCommand;
import com.ibm.etools.cobol.plugin.CobolPlugin;
import com.ibm.etools.cobol.plugin.Messages;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class RunCommandWin32
extends RunCommand {
    static {
        String dllLocation = String.valueOf(CobolPlugin.getPluginLocation("com.ibm.etools.cobol.win32")) + "importer/dll/RunCommand.dll";
        boolean nativesLoaded = false;
        try {
            try {
                System.load(dllLocation);
                nativesLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                dllLocation = String.valueOf(CobolPlugin.getPluginLocation("com.ibm.etools.cobol.win32")) + "importer/dll/RunCommand64.dll";
                System.load(dllLocation);
                nativesLoaded = true;
            }
        }
        catch (UnsatisfiedLinkError e) {
            nativesLoaded = false;
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandWin32: UnsatisfiedLinkError occured \n" + e.getMessage(), e);
        }
        if (!nativesLoaded) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandWin32: Could not load the dll = " + dllLocation);
        }
    }

    public native void runCommand(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, boolean var10);

    public RunCommandWin32(String path, String workingDir) {
        super(path, workingDir);
    }

    @Override
    public void getCOBOLCompilerComponentLocations() {
        this.cobolimporterLocation = String.valueOf(CobolPlugin.getPluginLocation("com.ibm.etools.cobol.win32")) + "importer\\cobol";
        this.exitRoutinesLocation = String.valueOf(CobolPlugin.getPluginLocation("com.ibm.etools.cobol.win32")) + "importer\\exit_routines";
        this.localePathLocation = String.valueOf(CobolPlugin.getPluginLocation("com.ibm.etools.cobol.win32")) + "importer\\locale";
    }

    @Override
    public void createAndRunCommand() throws CobolException {
        this.filePath = this.path;
        this.path = this.path.replace('\\', '/');
        String fileName = this.path.substring(this.path.lastIndexOf(47) + 1, this.path.length());
        String fileNameWOX = fileName.substring(0, fileName.lastIndexOf(46));
        this.path = this.path.substring(0, this.path.lastIndexOf(47));
        this.syslib = String.valueOf(additionalCOPYBookLocations) + this.syslib;
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): filename =" + fileName);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): filename w/o extension =" + fileNameWOX);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): path(current dir)=" + this.path);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): workingDir=" + this.workingDir);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): cobolimporterLocation=" + this.cobolimporterLocation);
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): syslib=" + this.syslib);
        if (this.xmiOptions.endsWith(",")) {
            this.xmiOptions = this.xmiOptions.substring(0, this.xmiOptions.length() - 1);
        }
        String ext = fileName.substring(fileName.lastIndexOf(46), fileName.length()).toLowerCase();
        String prtExit = ",prtexit(iwzprtx)";
        if (CobolPlugin.getDefault().isDEBUG_FINE()) {
            prtExit = "";
        }
        if (this.extensionSupportMap.get(ext).equals("DS")) {
            this.filePath = this.getWrappedProgramFilePath(fileName);
        }
        this.command = "-q\"XMI('" + this.xmiOptions + "'),ADATA,exit(xmiexit('cobol.xmi',iwzxmix),adexit(iwzadx)" + prtExit + ")," + this.otherOptions + "\" \"" + this.filePath + "\"";
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): command=" + this.command);
        if (this.command == null) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandWin32.createXMI(Hashmap): " + Messages._File_Extension_Not_Supported);
            throw new CobolException(Messages._File_Extension_Not_Supported);
        }
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): command=" + this.command);
        if (CobolPlugin.getDefault().isDEBUG_FINE()) {
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createXMI(Hashmap): c tracing= TRUE");
            this.createLoggingStateFile();
            this.runCommand(this.path, this.workingDir, this.command, this.cobolimporterLocation, this.exitRoutinesLocation, this.localePathLocation, this.syslib, String.valueOf(this.compileTimeLocale) + "." + this.asciiCodepage, this.errorMsgLang, true);
        } else {
            this.runCommand(this.path, this.workingDir, this.command, this.cobolimporterLocation, this.exitRoutinesLocation, this.localePathLocation, this.syslib, String.valueOf(this.compileTimeLocale) + "." + this.asciiCodepage, this.errorMsgLang, false);
        }
    }

    private void createLoggingStateFile() {
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommandWin32.createLoggingFileForExitRoutines(String)");
        File loggingStateFile = new File(String.valueOf(this.workingDir) + "\\cobol_exit_routines.log");
        try {
            loggingStateFile.createNewFile();
        }
        catch (IOException ioe) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** RunCommandWin32.createLoggingFileForExitRoutines(String): IOException occured - " + ioe.getMessage(), ioe);
        }
    }
}

