/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.importer.ErrorMessageInfo;
import com.ibm.etools.cobol.importer.ErrorMsgs;
import com.ibm.etools.cobol.plugin.CobolPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ParseSyntaxErrorsXMLOutput {
    private boolean errorsFlag = false;
    private String COMBINEDXMLFilename;
    private Vector msgNumberVector;
    private Vector msgLineVector;
    private Vector msgFileVector;
    private Vector msgTextVector;
    private Vector resourceVector;
    private boolean postErrorsToProblemsView;
    private Vector errorMessagesVector;

    public ParseSyntaxErrorsXMLOutput(String xmlFilename, String xmlCombinedFilename) {
        this(xmlFilename, xmlCombinedFilename, true);
    }

    public ParseSyntaxErrorsXMLOutput(String xmlFilename, String xmlCombinedFilename, boolean postErrorsToProblemsView) {
        this.COMBINEDXMLFilename = xmlCombinedFilename;
        this.postErrorsToProblemsView = postErrorsToProblemsView;
        if (CobolPlugin.isWindows()) {
            this.combineXMLErrorFiles(xmlFilename, "", this.COMBINEDXMLFilename);
        }
        ErrorMsgs parsedOutput = new ErrorMsgs();
        parsedOutput.read(this.COMBINEDXMLFilename);
        this.msgNumberVector = parsedOutput.getCmpMsgNumberVector();
        this.msgLineVector = parsedOutput.getCmpMsgLineVector();
        this.msgFileVector = parsedOutput.getCmpMsgFileVector();
        this.msgTextVector = parsedOutput.getCmpMsgTextVector();
        this.resourceVector = parsedOutput.getCmpMsgResourceVector();
        this.logErrorMessages();
    }

    private void logErrorMessages() {
        if (this.msgNumberVector.size() > 0) {
            this.errorMessagesVector = new Vector();
            char severityChar = 'E';
            this.setErrorFlag(this.msgNumberVector);
            int vi = 0;
            while (vi < this.msgTextVector.size()) {
                String sevMessage = (String)this.msgNumberVector.elementAt(vi);
                String messageString = String.valueOf(sevMessage) + " " + (String)this.msgTextVector.elementAt(vi);
                if (sevMessage.trim().length() > 1) {
                    severityChar = sevMessage.trim().charAt(sevMessage.length() - 1);
                }
                int lineNumberint = (Integer)this.msgLineVector.elementAt(vi);
                String fileLocation = (String)this.msgFileVector.elementAt(vi);
                String errorMessage = "Error (" + (vi + 1) + ") = " + "Severity:" + severityChar + " Error message:" + messageString + " Line Number:" + lineNumberint + " File Location:" + fileLocation;
                CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.logErrorMessages(): " + errorMessage);
                this.errorMessagesVector.add(new ErrorMessageInfo(severityChar, messageString, lineNumberint, fileLocation));
                ++vi;
            }
        }
    }

    public void parseXMLOutputFile(IResource originalResource) {
        Path AbsPath2;
        if (originalResource == null) {
            return;
        }
        int depth = 0;
        Vector<Object> adjMsgFileVector = new Vector<Object>();
        Vector<Object> adjResourceVector = new Vector<Object>();
        Vector<Integer> adjMsgLineVector = new Vector<Integer>();
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.parseXMLOutputFile(IResource): Files involved = " + this.resourceVector);
        int vi = 0;
        while (vi < this.resourceVector.size()) {
            File xf1;
            String proposedFilename = (String)this.resourceVector.elementAt(vi);
            if (proposedFilename.startsWith(".\\")) {
                IPath p1 = originalResource.getLocation().removeLastSegments(1);
                proposedFilename = String.valueOf(p1.toString()) + proposedFilename.substring(1, proposedFilename.length());
            }
            if ((xf1 = new File(proposedFilename)).exists()) {
                AbsPath2 = new Path(proposedFilename);
                String drive = AbsPath2.getDevice();
                if (drive == null) {
                    drive = "";
                }
                IFile f2 = originalResource.getWorkspace().getRoot().getFileForLocation((IPath)AbsPath2);
                IFile resourceF1 = null;
                if (f2 != null) {
                    resourceF1 = f2;
                    adjResourceVector.addElement(resourceF1);
                } else {
                    adjResourceVector.addElement(originalResource);
                }
            } else {
                adjResourceVector.addElement(originalResource);
            }
            ++vi;
        }
        vi = 0;
        while (vi < this.msgFileVector.size()) {
            File xf1;
            String proposedFilename = (String)this.msgFileVector.elementAt(vi);
            if (proposedFilename.startsWith(".\\")) {
                IPath p1 = originalResource.getLocation().removeLastSegments(1);
                proposedFilename = String.valueOf(p1.toString()) + proposedFilename.substring(1, proposedFilename.length());
            }
            if ((xf1 = new File(proposedFilename)).exists()) {
                AbsPath2 = new Path(proposedFilename);
                IFile f2 = originalResource.getWorkspace().getRoot().getFileForLocation((IPath)AbsPath2);
                if (f2 != null) {
                    adjMsgFileVector.addElement(f2);
                    adjMsgLineVector.addElement((Integer)this.msgLineVector.elementAt(vi));
                } else {
                    adjMsgFileVector.addElement(originalResource);
                    adjMsgLineVector.addElement(this.determineLineNumberInIncludeChain());
                }
            } else {
                adjMsgLineVector.addElement(this.determineLineNumberInIncludeChain());
                adjMsgFileVector.addElement(originalResource);
            }
            ++vi;
        }
        if (this.postErrorsToProblemsView) {
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.parseXMLOutputFile(IResource): Posting error messages to problems view");
            vi = 0;
            while (vi < adjResourceVector.size()) {
                IResource resource1 = (IResource)adjResourceVector.elementAt(vi);
                resource1 = this.chkFileExtension(resource1, originalResource);
                try {
                    CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.parseXMLOutputFile(IResource): delete resources currently in tasklist: resource=" + resource1.getFullPath());
                    resource1.deleteMarkers("org.eclipse.core.resources.problemmarker", true, depth);
                }
                catch (CoreException e) {
                    CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsXMLOutput.parseXMLOutputFile(IResource): CoreException Occured while deleting resources currently in tasklist ", e);
                }
                ++vi;
            }
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.parseXMLOutputFile(IResource): Number of errors = " + this.msgTextVector.size());
            vi = 0;
            while (vi < this.msgTextVector.size()) {
                try {
                    IResource zresource1 = (IResource)adjMsgFileVector.elementAt(vi);
                    zresource1 = this.chkFileExtension(zresource1, originalResource);
                    int zLineNumberint = (Integer)adjMsgLineVector.elementAt(vi);
                    String zmessageString = String.valueOf((String)this.msgNumberVector.elementAt(vi)) + " " + (String)this.msgTextVector.elementAt(vi);
                    IMarker marker = zresource1.createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("message", (Object)zmessageString);
                    marker.setAttribute("lineNumber", zLineNumberint);
                    String sevMsg = (String)this.msgNumberVector.elementAt(vi);
                    sevMsg = sevMsg.trim();
                    int sevChar = 69;
                    if (sevMsg.length() > 1) {
                        sevChar = sevMsg.charAt(sevMsg.length() - 1);
                    }
                    if (sevChar == 73) {
                        marker.setAttribute("severity", 0);
                    } else if (sevChar == 87) {
                        marker.setAttribute("severity", 1);
                    } else {
                        marker.setAttribute("severity", 2);
                    }
                }
                catch (CoreException coreException) {
                    CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.parseXMLOutputFile(IResource): CoreException: Unable to create markers. Code should never come here");
                }
                ++vi;
            }
        } else {
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.parseXMLOutputFile(IResource): Number of errors = " + this.msgTextVector.size());
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.parseXMLOutputFile(IResource): User has choosen not to populate the errors to eclipse's problems view");
        }
    }

    public Integer determineLineNumberInIncludeChain() {
        int TempInt = 1;
        Integer ln1LineNumberIntObject = new Integer(TempInt);
        return ln1LineNumberIntObject;
    }

    public IResource chkFileExtension(IResource resourceParm, IResource originalResource) {
        String ext1;
        IFile f2;
        Path AbsPath2;
        String lastseg;
        IPath p1;
        IResource resource = resourceParm;
        boolean successfulFindInWorkspace = false;
        IResource resource1 = resource;
        IResource lowerCaseResource = null;
        IResource upperCaseResource = null;
        if (resource1.exists()) {
            successfulFindInWorkspace = true;
            resource = resource1;
        }
        if (!successfulFindInWorkspace) {
            resource1 = resource;
            p1 = resource1.getLocation();
            lastseg = p1.lastSegment();
            p1 = p1.removeLastSegments(1);
            p1 = p1.append(lastseg.toLowerCase());
            AbsPath2 = new Path(p1.toString());
            f2 = originalResource.getWorkspace().getRoot().getFileForLocation((IPath)AbsPath2);
            lowerCaseResource = resource1 = f2;
            if (resource1.exists()) {
                successfulFindInWorkspace = true;
                resource = resource1;
            }
        }
        if (!successfulFindInWorkspace) {
            resource1 = resource;
            p1 = resource1.getLocation();
            lastseg = p1.lastSegment();
            p1 = p1.removeLastSegments(1);
            p1 = p1.append(lastseg.toUpperCase());
            AbsPath2 = new Path(p1.toString());
            f2 = originalResource.getWorkspace().getRoot().getFileForLocation((IPath)AbsPath2);
            upperCaseResource = resource1 = f2;
            if (resource1.exists()) {
                successfulFindInWorkspace = true;
                resource = resource1;
            }
        }
        if (!successfulFindInWorkspace) {
            resource1 = upperCaseResource;
            p1 = resource1.getLocation();
            if (resource1.getFileExtension() != null) {
                ext1 = resource1.getFileExtension().toLowerCase();
                p1 = p1.removeFileExtension();
                p1 = p1.addFileExtension(ext1);
                AbsPath2 = new Path(p1.toString());
                f2 = originalResource.getWorkspace().getRoot().getFileForLocation((IPath)AbsPath2);
                resource1 = f2;
                if (resource1.exists()) {
                    successfulFindInWorkspace = true;
                    resource = resource1;
                }
            }
        }
        if (!successfulFindInWorkspace) {
            resource1 = lowerCaseResource;
            p1 = resource1.getLocation();
            if (resource1.getFileExtension() != null) {
                ext1 = resource1.getFileExtension().toUpperCase();
                p1 = p1.removeFileExtension();
                p1 = p1.addFileExtension(ext1);
                AbsPath2 = new Path(p1.toString());
                f2 = originalResource.getWorkspace().getRoot().getFileForLocation((IPath)AbsPath2);
                resource1 = f2;
                if (resource1.exists()) {
                    successfulFindInWorkspace = true;
                    resource = resource1;
                }
            }
        }
        if (!successfulFindInWorkspace) {
            resource = originalResource;
        }
        return resource;
    }

    public IResource chkFileExtension00(IResource resource) {
        IResource resource1 = resource;
        return resource1;
    }

    public boolean combineXMLErrorFiles(String xmlfile1, String xmlfile2, String xmlfileout) {
        String xmlHeaderLine1 = "<?xml";
        String xmlHeaderLine2 = "<!DOCTYPE";
        String buildTag = "<build>";
        String endbuildTag = "</build>";
        String headerLine1 = "<?xml version=\"1.0\" standalone=\"yes\"?>";
        String headerLine2 = "<!-- ************************************************************************************ -->";
        String headerLine0 = "<!-- ************************************************************************************ -->";
        boolean wroteHeader = false;
        try {
            OutputStreamWriter outfile = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlfileout), "UTF-8");
            BufferedWriter obuff = new BufferedWriter(outfile);
            boolean eof = false;
            int j = 1;
            while (j < 3) {
                FileReader infile = null;
                boolean foundTheXMLFile = false;
                if (j == 1) {
                    File file = new File(xmlfile1);
                    if (file.exists()) {
                        infile = new FileReader(xmlfile1);
                        foundTheXMLFile = true;
                    }
                } else if (!xmlfile2.trim().equals("")) {
                    File file = new File(xmlfile2);
                    if (file.exists()) {
                        infile = new FileReader(xmlfile2);
                        foundTheXMLFile = true;
                    }
                } else {
                    foundTheXMLFile = false;
                }
                if (foundTheXMLFile) {
                    BufferedReader ibuff = new BufferedReader(infile);
                    while (!eof) {
                        boolean skip = false;
                        String line = ibuff.readLine();
                        if (line == null) {
                            eof = true;
                            continue;
                        }
                        if (!wroteHeader) {
                            obuff.write(headerLine1, 0, headerLine1.length());
                            obuff.newLine();
                            obuff.write(headerLine2, 0, headerLine2.length());
                            obuff.newLine();
                            obuff.write(buildTag, 0, buildTag.length());
                            obuff.newLine();
                            wroteHeader = true;
                        }
                        if ((line = line.trim()).equals(buildTag)) {
                            skip = true;
                        }
                        if (line.equals(endbuildTag)) {
                            skip = true;
                        }
                        if (line.equals(headerLine0)) {
                            skip = true;
                        }
                        if (line.startsWith(xmlHeaderLine1)) {
                            skip = true;
                        }
                        if (line.startsWith(xmlHeaderLine2)) {
                            skip = true;
                        }
                        if (skip) continue;
                        obuff.write(line, 0, line.length());
                        obuff.newLine();
                    }
                    ibuff.close();
                }
                eof = false;
                ++j;
            }
            if (wroteHeader) {
                obuff.write(endbuildTag, 0, endbuildTag.length());
            }
            obuff.close();
        }
        catch (IOException e) {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** ParseSyntaxErrorsXMLOutput.combineXMLErrorFiles(String, String, String): IOException occurred", e);
        }
        return wroteHeader;
    }

    private void setErrorFlag(Vector msgNumberVector) {
        int vi = 0;
        while (vi < msgNumberVector.size()) {
            String sevMsg = (String)msgNumberVector.elementAt(vi);
            sevMsg = sevMsg.trim();
            int sevChar = 69;
            if (sevMsg.length() > 1) {
                sevChar = sevMsg.charAt(sevMsg.length() - 1);
            }
            if (sevChar != 73 && sevChar != 87) {
                CobolPlugin.getDefault().writeMsg(Level.FINE, "*** ParseSyntaxErrorsXMLOutput.setErrorFlag(Vector): Found severe error = " + sevMsg);
                this.errorsFlag = true;
                break;
            }
            ++vi;
        }
    }

    public boolean hasErrors() {
        return this.errorsFlag;
    }

    public Vector getErrorMessagesVector() {
        return this.errorMessagesVector;
    }

    public Vector getResourceVector() {
        return this.resourceVector;
    }
}

