/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.importer.COBOLLocaleRelatedConstants;
import com.ibm.etools.cobol.importer.CobolException;
import com.ibm.etools.cobol.importer.CobolPreferenceStore;
import com.ibm.etools.cobol.importer.CobolTypeUtilities;
import com.ibm.etools.cobol.importer.ICobolPreferenceConstants;
import com.ibm.etools.cobol.importer.ParseSyntaxErrorsXMLOutput;
import com.ibm.etools.cobol.importer.RunCommand;
import com.ibm.etools.cobol.plugin.CobolPlugin;
import com.ibm.etools.cobol.plugin.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class CobolSourceResource
extends XMIResourceImpl {
    protected static HashMap cobolOptions;
    protected RunCommand runCommand;
    private Vector resourcesList;
    private Vector errorMessagesVector;

    public abstract RunCommand getRunCommand(String var1, String var2);

    public CobolSourceResource() {
        this(null);
    }

    public CobolSourceResource(URI arg) {
        super(arg);
    }

    public void doLoad(InputStream inputStream, Map options) throws CobolException {
        block73: {
            File tmpFolder = null;
            String uri = this.getURI().toFileString();
            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): URI = " + uri);
            cobolOptions = CobolPreferenceStore.getValues();
            try {
                try {
                    if (options != null) {
                        Map userOptions = options;
                        Set npSet = userOptions.keySet();
                        for (String key : npSet) {
                            Object original = cobolOptions.get(key);
                            if (original != null) {
                                Object[] obj;
                                COBOLLocaleRelatedConstants clrc;
                                Object[] obj2;
                                String endian;
                                if (key.equals("com.ibm.etools.cobol.COBOL_CODEPAGE")) {
                                    CobolTypeUtilities.validateCodepage((String)userOptions.get(key));
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_ENDIAN")) {
                                    endian = (String)userOptions.get(key);
                                    if (endian != null && !endian.equals("Big") && !endian.equalsIgnoreCase("Little")) {
                                        obj2 = new Object[]{endian, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_EXT_DECIMAL_SIGN")) {
                                    String codepage_ec;
                                    String sign = (String)userOptions.get(key);
                                    if (!(sign == null || sign.equals("ASCII") || sign.equals("EBCDIC") || sign.equals("EBCDIC Custom"))) {
                                        obj2 = new Object[]{sign, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                    if (sign.equals("EBCDIC Custom") && (codepage_ec = (String)userOptions.get("com.ibm.etools.cobol.COBOL_HOST_CODEPAGE_EC")) != null) {
                                        CobolTypeUtilities.validateCodepage(codepage_ec);
                                        cobolOptions.put("com.ibm.etools.cobol.COBOL_HOST_CODEPAGE_EC", codepage_ec);
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_FLOATING_POINT_FORMAT")) {
                                    Integer fpf = (Integer)userOptions.get(key);
                                    if (fpf != 0 && fpf != 1) {
                                        obj2 = new Object[]{fpf, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_NSYMBOL")) {
                                    String sym = (String)userOptions.get(key);
                                    if (sym != null && !sym.equals("DBCS") && !sym.equals("NATIONAL")) {
                                        obj2 = new Object[]{sym, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_QUOTE")) {
                                    String quote = (String)userOptions.get(key);
                                    if (quote != null && !quote.equals("SINGLE") && !quote.equals("DOUBLE")) {
                                        obj2 = new Object[]{quote, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_REMOTE_ENDIAN")) {
                                    endian = (String)userOptions.get(key);
                                    if (endian != null && !endian.equals("Big") && !endian.equals("Little")) {
                                        obj2 = new Object[]{endian, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_TRUNC")) {
                                    String trunc = (String)userOptions.get(key);
                                    if (!(trunc == null || trunc.equals("BIN") || trunc.equals("OPT") || trunc.equals("STD"))) {
                                        obj2 = new Object[]{trunc, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE")) {
                                    Integer ctl = (Integer)userOptions.get(key);
                                    clrc = new COBOLLocaleRelatedConstants();
                                    if (ctl < 0 || ctl > clrc.getLocaleNames().size() - 1) {
                                        obj = new Object[]{ctl, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_ASCII_CODEPAGE")) {
                                    if (CobolPlugin.isWindows()) {
                                        Integer ac = (Integer)userOptions.get(key);
                                        clrc = new COBOLLocaleRelatedConstants();
                                        String ctl = userOptions.containsKey("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE") ? (String)clrc.getLocaleNames().get((Integer)userOptions.get("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE")) : (String)clrc.getLocaleNames().get((Integer)cobolOptions.get("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE"));
                                        if (ac < 0 || ac > clrc.getASCIICodePages(ctl).size() - 1) {
                                            Object[] obj3 = new Object[]{ac, key};
                                            throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj3));
                                        }
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_ERROR_MSGS_LANG")) {
                                    Integer eml = (Integer)userOptions.get(key);
                                    clrc = new COBOLLocaleRelatedConstants();
                                    if (eml < 0 || eml > clrc.getErrorMessagesLanguage().size() - 1) {
                                        obj = new Object[]{eml, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_CURRENCY")) {
                                    String c = (String)userOptions.get(key);
                                    try {
                                        CobolTypeUtilities.validateCurrency(c);
                                    }
                                    catch (Exception exception) {
                                        obj2 = new Object[]{c, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_COLLSEQ")) {
                                    String collseq = (String)userOptions.get(key);
                                    if (!(collseq == null || collseq.equals("BIN") || collseq.equals("EBCDIC") || collseq.equals("LOCALE"))) {
                                        obj2 = new Object[]{collseq, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_NCOLLSEQ")) {
                                    String ncollseq = (String)userOptions.get(key);
                                    if (ncollseq != null && !ncollseq.equals("BIN") && !ncollseq.equals("LOCALE")) {
                                        obj2 = new Object[]{ncollseq, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_PGMNAME")) {
                                    String pgmname = (String)userOptions.get(key);
                                    if (pgmname != null && !pgmname.equals("LU") && !pgmname.equals("LM")) {
                                        obj2 = new Object[]{pgmname, key};
                                        throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Value_for_Option, (Object[])obj2));
                                    }
                                } else if (key.equals("com.ibm.etools.cobol.COBOL_SYSLIB")) {
                                    String syslib = (String)userOptions.get(key);
                                    syslib = String.valueOf(syslib) + ICobolPreferenceConstants.PATH_SEPARATOR + original;
                                    userOptions.put(key, syslib);
                                }
                                cobolOptions.put(key, userOptions.get(key));
                                continue;
                            }
                            Object[] obj = new Object[]{key};
                            throw new CobolException(Messages.bind((String)Messages._EXC_Invalid_Option, (Object[])obj));
                        }
                    }
                    String tmpFolderName = new Long(new Date().getTime()).toString();
                    tmpFolder = new File(String.valueOf(CobolPlugin.getDefault().getStateLocation().toOSString()) + "/" + tmpFolderName);
                    while (tmpFolder.exists()) {
                        tmpFolderName = new Long(new Date().getTime()).toString();
                        tmpFolder = new File(String.valueOf(CobolPlugin.getDefault().getStateLocation().toOSString()) + "/" + tmpFolderName);
                    }
                    if (!tmpFolder.mkdir()) {
                        CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Creation of Directory " + tmpFolder.getName() + " Failed", new CobolException(Messages._Error_Creating_Folder));
                        throw new CobolException(Messages._Error_Creating_Folder);
                    }
                    CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Created Directory " + tmpFolder.getName() + " Successfully");
                    Path absPath = new Path(uri);
                    String resourceFileString = null;
                    IFile typesFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)absPath);
                    if (typesFile == null) {
                        resourceFileString = absPath.toString();
                        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): File is not an IFile = " + absPath.toString());
                    } else {
                        resourceFileString = typesFile.getLocation().toString();
                        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Selected IFile = " + typesFile);
                        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Selected resource file location = " + resourceFileString);
                    }
                    if (resourceFileString.substring(resourceFileString.lastIndexOf(47) + 1, resourceFileString.length()).length() > 64) {
                        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** RunCommand.createXMI(Hashmap): length of the file > 60 =");
                        throw new CobolException(Messages._File_Name_Too_Long);
                    }
                    this.runCommand = this.getRunCommand(resourceFileString, tmpFolder.getPath());
                    this.runCommand.createXMI(cobolOptions);
                    String xmlFilename = String.valueOf(tmpFolder.getPath()) + "/syntaxerrors.xml";
                    String xmlCombinedFilename = String.valueOf(tmpFolder.getPath()) + "/syntaxerrors_complete.xml";
                    boolean postErrorsToProblemsView = (Boolean)cobolOptions.get("com.ibm.etools.cobol.COBOL_POSTERRORS_TO_PROBLEMS_VIEW");
                    ParseSyntaxErrorsXMLOutput parseErrors = new ParseSyntaxErrorsXMLOutput(xmlFilename, xmlCombinedFilename, postErrorsToProblemsView);
                    if (new File(xmlCombinedFilename).exists()) {
                        parseErrors.parseXMLOutputFile((IResource)typesFile);
                        this.resourcesList = parseErrors.getResourceVector();
                        if (!parseErrors.hasErrors()) {
                            String fullPath = String.valueOf(tmpFolder.getPath()) + System.getProperty("file.separator") + "COBOL.XMI";
                            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): XMI File location = " + fullPath);
                            if (!new File(fullPath).exists()) {
                                CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): XMI file not found.");
                                throw new CobolException(Messages._XMI_File_Not_Found);
                            }
                            CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): XMI Exists");
                            this.loadXMI(fullPath);
                            if (typesFile != null) {
                                typesFile.getParent().refreshLocal(2, null);
                            }
                        } else {
                            if (typesFile != null) {
                                typesFile.getParent().refreshLocal(2, null);
                                if (postErrorsToProblemsView && PlatformUI.isWorkbenchRunning()) {
                                    CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Workbench is running");
                                    this.openProblemsView();
                                } else {
                                    CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Workbench is not running or user requested not to post errors to the problems view.");
                                }
                                CobolException ce = new CobolException(Messages._Syntax_Errors_Found_For_IFile);
                                ce.setMessageNote(this.getMessageNote());
                                ce.setErrorMessagesVector(parseErrors.getErrorMessagesVector());
                                CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Syntax errors found. Check in the task list.", ce);
                                throw ce;
                            }
                            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Syntax errors found in a non IFile. Check in the syntaxerrors.xml file.");
                            CobolException ce = new CobolException(Messages._Syntax_Errors_Found_For_IFile);
                            ce.setMessageNote(this.getMessageNote());
                            ce.setErrorMessagesVector(parseErrors.getErrorMessagesVector());
                            throw ce;
                        }
                        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): importerResource = " + this.toString());
                    } else {
                        if (typesFile != null) {
                            typesFile.getParent().refreshLocal(2, null);
                        }
                        CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): " + xmlCombinedFilename + " file does not exist, please try again.");
                        throw new CobolException(Messages._Syntax_Error_File_Not_Found);
                    }
                    this.errorMessagesVector = parseErrors.getErrorMessagesVector();
                    List ele = this.getCobolTopElements();
                    if (ele.isEmpty()) {
                        CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): Syntax errors found. Check in the task list.");
                        CobolException ce = new CobolException(Messages._Syntax_Errors_Found_For_IFile);
                        ce.setMessageNote(this.getNoElementsFoundMessageNote());
                        throw ce;
                    }
                }
                catch (CobolException e) {
                    throw e;
                }
                catch (Exception e) {
                    CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.load(ResourceSet, String, InputStream , Object): This Exception should not occur: " + e.getMessage(), e);
                    this.deleteTempFolder(tmpFolder);
                    break block73;
                }
            }
            catch (Throwable throwable) {
                this.deleteTempFolder(tmpFolder);
                throw throwable;
            }
            this.deleteTempFolder(tmpFolder);
        }
    }

    public Vector getResourcesList() {
        return this.resourcesList;
    }

    private void openProblemsView() {
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow[] windows = CobolPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                        if (windows != null) {
                            int i = 0;
                            while (i < windows.length) {
                                IWorkbenchPage page = windows[i].getActivePage();
                                if (page != null) {
                                    IViewPart problemsView = page.findView("org.eclipse.ui.views.ProblemView");
                                    try {
                                        if (problemsView == null) {
                                            page.showView("org.eclipse.ui.views.ProblemView");
                                            IWorkbenchPart activePart = page.getActivePart();
                                            page.activate(activePart);
                                            break;
                                        }
                                        page.showView("org.eclipse.ui.views.ProblemView", null, 2);
                                        break;
                                    }
                                    catch (PartInitException e) {
                                        CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.openProblemsView(): Unable to open the Problems view.", e);
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                });
            } else {
                CobolPlugin.getDefault().writeMsg(Level.INFO, "*** CobolSourceResource.openProblemsView(): Unable to access Display.", new IllegalStateException());
            }
        } else {
            CobolPlugin.getDefault().writeMsg(Level.INFO, "*** CobolSourceResource.openProblemsView(): Unable to access PlatformUI.", new IllegalStateException());
        }
    }

    private String getNoElementsFoundMessageNote() {
        String fileName = this.getURI().lastSegment();
        Object[] obj = new Object[]{fileName};
        String errMsg = String.valueOf(Messages._Syntax_Errors_Found_For_IFile_Reason_Label) + "\n" + Messages.bind((String)Messages._Syntax_Errors_Found_For_IFile_NoDataReason1, (Object[])obj) + "\n";
        errMsg = String.valueOf(errMsg) + Messages.bind((String)Messages._Syntax_Errors_Found_For_IFile_NoDataReason2, (Object[])obj);
        errMsg = String.valueOf(errMsg) + Messages._Syntax_Errors_Found_For_IFile_MoreInfo;
        return errMsg;
    }

    private String getMessageNote() {
        String fileName = this.getURI().lastSegment();
        String ext = "." + this.getURI().fileExtension().toLowerCase();
        Object[] obj = new Object[]{fileName};
        Object[] viewName = new Object[]{cobolOptions.get("com.ibm.etools.cobol.PRE_COBOL_ERRORS_VIEW_NAME")};
        String errMsg = String.valueOf(Messages._Syntax_Errors_Found_For_IFile_Reason_Label) + "\n" + Messages.bind((String)Messages._Syntax_Errors_Found_For_IFile_Reason1, (Object[])viewName) + "\n";
        HashMap extensionSupportMap = this.runCommand.getExtensionSupportMap();
        errMsg = extensionSupportMap.get(ext).equals("FP") ? String.valueOf(errMsg) + Messages.bind((String)Messages._Syntax_Errors_Found_For_IFile_Reason2a, (Object[])obj) : String.valueOf(errMsg) + Messages.bind((String)Messages._Syntax_Errors_Found_For_IFile_Reason2b, (Object[])obj);
        errMsg = String.valueOf(errMsg) + Messages._Syntax_Errors_Found_For_IFile_MoreInfo;
        return errMsg;
    }

    private void deleteTempFolder(File tmpFolder) {
        boolean deleteStatus = false;
        CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.deleteTempFolder(File): Is logging (fine) on? = " + CobolPlugin.getDefault().isDEBUG_FINE());
        if (CobolPlugin.getDefault().isDEBUG_FINE()) {
            return;
        }
        if (tmpFolder.exists()) {
            File[] tempFiles = tmpFolder.listFiles();
            int i = 0;
            while (i < tempFiles.length) {
                tempFiles[i].delete();
                ++i;
            }
            deleteStatus = tmpFolder.delete();
            if (deleteStatus) {
                CobolPlugin.getDefault().writeMsg(Level.FINE, "*** CobolSourceResource.deleteTempFolder(File): Temporary folder successfully deleted.");
            } else {
                CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.deleteTempFolder(File): Unable to delete the Temporary folder.");
            }
        } else {
            CobolPlugin.getDefault().writeMsg(Level.SEVERE, "*** CobolSourceResource.deleteTempFolder(File): Temporary folder does not exist.");
        }
    }

    private void loadXMI(String fullPath) throws IOException {
        Resource.Factory rf = Resource.Factory.Registry.INSTANCE.getFactory(URI.createFileURI((String)fullPath));
        XMLResourceImpl importerResource = (XMLResourceImpl)rf.createResource(URI.createFileURI((String)fullPath));
        importerResource.load(null);
        this.getEObjectToIDMap().putAll(importerResource.getEObjectToIDMap());
        this.getContents().addAll((Collection)importerResource.getContents());
    }

    public List getCobolTopElements() {
        ArrayList eleList = new ArrayList();
        if (this == null) {
            return eleList;
        }
        for (Object possibleType : this.getContents()) {
            COBOLClassifier childClassifier;
            if (!(possibleType instanceof COBOLElement) || !((childClassifier = ((COBOLElement)possibleType).getSharedType()) instanceof COBOLComposedType) && !(childClassifier instanceof COBOLSimpleType)) continue;
            eleList.add(possibleType);
        }
        return eleList;
    }

    public static String getRefId(EObject ce) {
        String refID = null;
        String elementName = "";
        String path = "";
        COBOLElement cobolElement = null;
        if (ce instanceof COBOLElement) {
            refID = "Element:";
            cobolElement = (COBOLElement)ce;
        } else if (ce instanceof COBOLClassifier) {
            refID = "Type:";
            cobolElement = (COBOLElement)((COBOLClassifier)ce).getTypedElement().get(0);
        }
        elementName = cobolElement.getName();
        while (cobolElement.getGroup() != null) {
            COBOLElement parentCE = (COBOLElement)cobolElement.getGroup().getTypedElement().get(0);
            path = String.valueOf(parentCE.getName()) + "/" + path;
            cobolElement = parentCE;
        }
        refID = String.valueOf(refID) + path + elementName;
        return refID;
    }

    public Vector getErrorMessagesVector() {
        return this.errorMessagesVector;
    }
}

