/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.importer.CobolElementaryRecord;
import com.ibm.etools.cobol.importer.CobolGroupRecord;
import java.util.Vector;

public abstract class CobolRecord {
    public static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    protected String name_;
    protected String redefinedItem_;
    protected String value_;
    protected String figConst_;
    protected String picString_;
    protected CobolRecord owner_;
    protected Vector dependedOnItem_;
    protected Vector list_;
    protected boolean filler_;
    protected boolean alignment_;
    protected int level_;
    protected int usage_;
    protected int sign_;
    protected int arrayBound_;
    protected int arrayLowBound;
    protected Class javaType_;
    protected String[] qualifiedName_;
    protected String cobolTypeString_;
    protected Vector varLengthArrayNames_;
    protected Vector redefineTypes_;
    protected Vector keys_;
    protected Vector possibleValues_;
    public static final short NOUSAGE = 0;
    public static final short COMP = 1;
    public static final short COMP1 = 2;
    public static final short COMP2 = 3;
    public static final short COMP3 = 4;
    public static final short COMP5 = 5;
    public static final short DISPLAY = 6;
    public static final short DISPLAY1 = 7;
    public static final short NATIONAL = 8;
    public static final short NOSIGN = 9;
    public static final short TRAILING = 10;
    public static final short LEADING = 11;
    public static final short TRAILINGSEPARATE = 12;
    public static final short LEADINGSEPARATE = 13;

    CobolRecord(CobolRecord owner, String name, int level) {
        this.owner_ = owner;
        this.level_ = level;
        this.filler_ = false;
        this.alignment_ = false;
        this.list_ = new Vector();
        this.arrayBound_ = 1;
        this.arrayLowBound = 0;
        this.usage_ = 0;
        this.sign_ = 9;
        this.name_ = name;
        this.value_ = null;
        this.figConst_ = null;
        this.redefinedItem_ = null;
        this.dependedOnItem_ = null;
        this.redefineTypes_ = new Vector();
        this.varLengthArrayNames_ = new Vector();
        this.possibleValues_ = new Vector();
        this.keys_ = new Vector();
    }

    void addRedefineType(CobolRecord rec) {
        this.redefineTypes_.addElement(rec);
    }

    int arrayBound() {
        return this.arrayBound_;
    }

    String cobolType() {
        String sign = new String();
        String cobolType = new String();
        int usageType = 0;
        int signType = 9;
        if (this instanceof CobolGroupRecord) {
            usageType = ((CobolGroupRecord)this).usage();
            signType = ((CobolGroupRecord)this).sign();
        } else if (this instanceof CobolElementaryRecord) {
            usageType = ((CobolElementaryRecord)this).usage();
            signType = ((CobolElementaryRecord)this).sign();
        }
        switch (signType) {
            case 9: {
                break;
            }
            case 11: {
                sign = "SIGN_LEADING";
                break;
            }
            case 10: {
                sign = "SIGN_TRAILING";
                break;
            }
            case 13: {
                sign = "SIGN_LEADING_SEPARATE";
                break;
            }
            case 12: {
                sign = "SIGN_TRAILING_SEPARATE";
            }
        }
        switch (usageType) {
            case 0: 
            case 6: {
                if (signType == 9) {
                    cobolType = "DISPLAY";
                    break;
                }
                cobolType = sign;
                break;
            }
            case 1: {
                if (signType == 9) {
                    cobolType = "COMP";
                    break;
                }
                cobolType = sign;
                break;
            }
            case 2: {
                if (signType == 9) {
                    cobolType = "COMP1";
                    break;
                }
                cobolType = sign;
                break;
            }
            case 3: {
                if (signType == 9) {
                    cobolType = "COMP2";
                    break;
                }
                cobolType = sign;
                break;
            }
            case 4: {
                if (signType == 9) {
                    cobolType = "COMP3";
                    break;
                }
                cobolType = sign;
                break;
            }
            case 5: {
                if (signType == 9) {
                    cobolType = "COMP5";
                    break;
                }
                cobolType = sign;
                break;
            }
            case 7: {
                cobolType = "DISPLAY1";
                break;
            }
            case 8: {
                cobolType = "NATIONAL";
            }
        }
        return cobolType;
    }

    CobolRecord element(int index) {
        return (CobolRecord)this.list_.elementAt(index);
    }

    int level() {
        return this.level_;
    }

    Vector list() {
        return this.list_;
    }

    String name() {
        return this.name_;
    }

    CobolRecord owner() {
        return this.owner_;
    }

    String[] qualifiedName() {
        return this.qualifiedName_;
    }

    String redefinedItem() {
        return this.redefinedItem_;
    }

    public Vector removeCommareaName() {
        Vector<String[]> newVec = new Vector<String[]>();
        int i = 0;
        while (i < this.varLengthArrayNames_.size()) {
            String[] fullName = (String[])this.varLengthArrayNames_.elementAt(i);
            String[] name = new String[fullName.length - 1];
            int j = 0;
            while (j < fullName.length - 1) {
                name[j] = fullName[j + 1];
                ++j;
            }
            newVec.addElement(name);
            ++i;
        }
        return newVec;
    }

    /*
     * Unable to fully structure code
     */
    boolean sameItem(String[] fullName, Vector partName) {
        if (partName.size() > fullName.length) {
            return false;
        }
        if (!fullName[fullName.length - 1].equals(partName.firstElement())) {
            return false;
        }
        j = 0;
        i = partName.size() - 1;
        ** GOTO lbl13
        {
            if (++j == fullName.length) {
                return false;
            }
            do {
                if (!fullName[j].equalsIgnoreCase((String)partName.elementAt(i))) continue block0;
                --i;
lbl13:
                // 2 sources

            } while (i >= 0);
        }
        return true;
    }

    void setAlignment(boolean alignment) {
        this.alignment_ = alignment;
    }

    void setArrayBound(int bound) {
        this.arrayBound_ = bound;
    }

    void setDependedOnItem(Vector vec) {
        this.dependedOnItem_ = vec;
    }

    void setFigConst(String figConst) {
        this.figConst_ = figConst;
    }

    void setFiller(boolean filler) {
        this.filler_ = filler;
    }

    void setName(String name) {
        this.name_ = name;
    }

    void setNewPicClass(Class javaType) {
        this.javaType_ = javaType;
    }

    void setPicString(String picString) {
        this.picString_ = picString;
    }

    void setPossibleValues(String key, Vector possibleValues) {
        Object[] possibleVals = new Object[possibleValues.size()];
        possibleValues.copyInto(possibleVals);
        this.possibleValues_.addElement(possibleVals);
        this.keys_.addElement(key);
    }

    void setRedefinedItem(String str) {
        this.redefinedItem_ = str;
    }

    void setSign(short value) {
        this.sign_ = value;
    }

    void setUsage(short value) {
        this.usage_ = value;
    }

    void setValue(String value) {
        this.value_ = value;
    }

    void setVarLengthArrayName(String[] name) {
        this.varLengthArrayNames_.addElement(name);
    }

    public int getArrayLowBound() {
        return this.arrayLowBound;
    }

    public void setArrayLowBound(int i) {
        this.arrayLowBound = i;
    }
}

