/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.importer.CobolElementaryRecord;
import com.ibm.etools.cobol.importer.CobolException;
import com.ibm.etools.cobol.importer.CobolRecord;
import java.util.Vector;

public class CobolGroupRecord
extends CobolRecord {
    public static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";

    CobolGroupRecord(CobolRecord owner, String name, int level) {
        super(owner, name, level);
    }

    void add(CobolRecord record) {
        this.list_.addElement(record);
    }

    String alignment() {
        if (this.alignment_) {
            return "ALIGN";
        }
        return " ";
    }

    int sign() {
        return this.sign_;
    }

    void trace() {
        int i = 0;
        while (i < this.list_.size()) {
            if (this.list_.elementAt(i) instanceof CobolGroupRecord) {
                ((CobolGroupRecord)this.list_.elementAt(i)).trace();
            } else if (this.list_.elementAt(i) instanceof CobolElementaryRecord) {
                ((CobolElementaryRecord)this.list_.elementAt(i)).trace();
            }
            ++i;
        }
    }

    int usage() {
        return this.usage_;
    }

    void walkTree(Vector aNonRedefineList, Vector aNonDependingList, Vector qualifiedName, boolean nestedODO) throws CobolException {
        CobolRecord rec;
        if (((CobolGroupRecord)this.owner()).alignment() == "ALIGN") {
            this.alignment_ = true;
        }
        Vector<String> names = new Vector<String>();
        int nameGen = 0;
        int i = 0;
        while (i < this.list_.size()) {
            CobolRecord rec2 = (CobolRecord)this.list_.elementAt(i);
            String recName = rec2.name().toLowerCase();
            if (names.contains(recName)) {
                rec2.name_ = String.valueOf(recName) + "_" + nameGen;
                ++nameGen;
                Object[] objectArray = new Object[]{this.name(), recName, rec2.name()};
            } else {
                names.addElement(rec2.name().toLowerCase());
            }
            ++i;
        }
        if (nestedODO) {
            qualifiedName.addElement("0");
        }
        qualifiedName.addElement(this.name_);
        this.qualifiedName_ = new String[qualifiedName.size()];
        qualifiedName.copyInto(this.qualifiedName_);
        boolean nestODO = this.dependedOnItem_.size() > 0;
        int i2 = 0;
        while (i2 < this.list_.size()) {
            CobolRecord type;
            if (this.list_.elementAt(i2) instanceof CobolGroupRecord) {
                type = (CobolGroupRecord)this.list_.elementAt(i2);
                ((CobolGroupRecord)type).walkTree(aNonRedefineList, aNonDependingList, qualifiedName, nestODO);
            } else if (this.list_.elementAt(i2) instanceof CobolElementaryRecord) {
                type = (CobolElementaryRecord)this.list_.elementAt(i2);
                ((CobolElementaryRecord)type).walkTree(aNonRedefineList, aNonDependingList, qualifiedName, nestODO);
            }
            ++i2;
        }
        if (this.dependedOnItem_.size() > 0) {
            i2 = 0;
            while (i2 < aNonDependingList.size()) {
                rec = (CobolRecord)aNonDependingList.elementAt(i2);
                if (this.sameItem(rec.qualifiedName(), this.dependedOnItem_)) {
                    rec.setVarLengthArrayName(this.qualifiedName_);
                    break;
                }
                ++i2;
            }
        }
        if (this.redefinedItem_ != null) {
            i2 = 0;
            while (i2 < aNonRedefineList.size()) {
                rec = (CobolRecord)aNonRedefineList.elementAt(i2);
                String str = rec.name();
                int num = rec.level();
                if (num == this.level_ && str.equalsIgnoreCase(this.redefinedItem_)) {
                    rec.addRedefineType(this);
                    break;
                }
                ++i2;
            }
        } else {
            aNonRedefineList.addElement(this);
        }
        if (nestedODO) {
            qualifiedName.removeElementAt(qualifiedName.size() - 1);
        }
        qualifiedName.removeElementAt(qualifiedName.size() - 1);
    }
}

