/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.importer;

import com.ibm.etools.cobol.plugin.CobolPlugin;
import com.ibm.etools.cobol.util.ProcessWatcher;
import java.util.AbstractList;
import java.util.Vector;

public class COBOLLocaleRelatedConstants {
    public static final String copyright = "(c) Copyright IBM Corporation 2004.";
    public String PLUGIN_ID = "com.ibm.etools.cobol";
    private Vector localeNameList = new Vector();
    private Vector errorMessagesLanguagesList = new Vector();
    private final String[] localNames = new String[]{"en_US", "ar_AA", "be_BY", "bg_BG", "ca_ES", "cs_CZ", "da_DK", "de_CH", "de_DE", "el_GR", "en_AU", "en_BE", "en_GB", "en_JP", "en_US", "en_ZA", "es_ES", "fi_FI", "fr_BE", "fr_CA", "fr_CH", "fr_FR", "hr_HR", "hu_HU", "is_IS", "it_CH", "it_IT", "iw_IL", "ja_JP", "ko_KR", "lt_LT", "lv_LV", "mk_MK", "nl_BE", "nl_NL", "no_NO", "pl_PL", "pt_BR", "pt_PT", "ro_RO", "ru_RU", "sh_SP", "sk_SK", "sl_SL", "sq_AL", "sv_SE", "th_TH", "tr_TR", "uk_UA", "zh_CN", "zh_TW"};
    private final String[][] asciiCodePages = new String[][]{{"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1256", "IBM-864"}, {"IBM-1251", "IBM-866"}, {"IBM-1251", "IBM-855"}, {"IBM-1252", "IBM-850"}, {"IBM-1250", "IBM-852"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1253"}, {"IBM-1252", "IBM-437"}, {"IBM-1252", "IBM-850"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-863"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1250", "IBM-852"}, {"IBM-1250", "IBM-852"}, {"IBM-1252", "IBM-850", "IBM-861"}, {"IBM-1252", "IBM-850"}, {"IBM-437", "IBM-850", "IBM-1252"}, {"IBM-1255", "IBM-862"}, {"IBM-943"}, {"IBM-1363"}, {"IBM-1257"}, {"IBM-1257"}, {"IBM-1251", "IBM-855"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-1250", "IBM-852"}, {"IBM-1252", "IBM-850"}, {"IBM-1252", "IBM-850", "IBM-860"}, {"IBM-1250", "IBM-850", "IBM-852"}, {"IBM-1251", "IBM-866"}, {"IBM-1250", "IBM-852"}, {"IBM-1250", "IBM-852"}, {"IBM-1250", "IBM-852"}, {"IBM-1252", "IBM-850"}, {"IBM-1252", "IBM-850", "IBM-437"}, {"IBM-874"}, {"IBM-1254", "IBM-857"}, {"IBM-1251", "IBM-866"}, {"IBM-1386"}, {"IBM-950"}};
    private final String[] errorMessagesLanguages = new String[]{"en_US", "ja_JP", "zh_TW", "zh_CN", "ko_KR", "it_IT", "fr_FR", "es_ES", "de_DE", "pt_BR", "cs_CZ", "hu_HU", "pl_PL", "ru_RU", "en_US"};

    private Vector getLinuxLocaleList(String charsetName) {
        String locale2 = null;
        Vector<String> locales = new Vector<String>();
        Runtime r = Runtime.getRuntime();
        Process proc = null;
        try {
            String[] cmd = new String[]{"locale", "-a"};
            proc = r.exec(cmd);
            ProcessWatcher pw = null;
            pw = charsetName == null ? new ProcessWatcher(proc) : new ProcessWatcher(proc, charsetName);
            pw.waitFor();
            if (pw.getStderrResult().size() > 0) {
                System.out.println("std err" + pw.getStderrResult());
            }
            AbstractList localesList = pw.getStdoutResult();
            for (String locale2 : localesList) {
                if (locale2.indexOf(95) != 2) continue;
                locales.add(locale2);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        return locales;
    }

    public Vector getLocaleNames() {
        if (!CobolPlugin.isWindows()) {
            this.localeNameList = this.getLinuxLocaleList("ISO-8859-1");
            if (this.localeNameList.size() == 0) {
                this.localeNameList = this.getLinuxLocaleList(null);
            }
        }
        if (this.localeNameList.size() > 0) {
            return this.localeNameList;
        }
        int i = 0;
        while (i < this.localNames.length) {
            this.localeNameList.add(this.localNames[i]);
            ++i;
        }
        return this.localeNameList;
    }

    public Vector getErrorMessagesLanguage() {
        int i = 0;
        while (i < this.errorMessagesLanguages.length) {
            this.errorMessagesLanguagesList.add(this.errorMessagesLanguages[i]);
            ++i;
        }
        return this.errorMessagesLanguagesList;
    }

    public Vector getASCIICodePages(String localeName) {
        Vector<String> v = new Vector<String>();
        int i = this.getLocaleNames().indexOf(localeName);
        if (i != -1) {
            int j = 0;
            while (j < this.asciiCodePages[i].length) {
                v.add(this.asciiCodePages[i][j]);
                ++j;
            }
        }
        return v;
    }
}

