/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.modelbase.sql.schema.helper;

import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.schema.helper.ISQLObjectNameHelper;
import com.ibm.ims.datatools.modelbase.sql.tables.Column;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLObjectNameHelper
implements ISQLObjectNameHelper {
    private String fQuoteString = "\"";

    @Override
    public String getNameInSQLFormat(Column column) {
        String sqlFormatName = null;
        if (column != null) {
            String quoteString = this.getIdentifierQuoteString();
            String name = column.getName();
            sqlFormatName = this.convertCatalogIdentifierToSQLFormat(name, quoteString);
        }
        return sqlFormatName;
    }

    @Override
    public String getNameInSQLFormat(Table table) {
        String sqlFormatName = null;
        if (table != null) {
            String quoteString = this.getIdentifierQuoteString();
            String name = table.getName();
            sqlFormatName = this.convertCatalogIdentifierToSQLFormat(name, quoteString);
        }
        return sqlFormatName;
    }

    @Override
    public String getQualifiedNameInSQLFormat(Column column) {
        Object qualifiedSQLName = null;
        if (column != null) {
            String quoteString = this.getIdentifierQuoteString();
            String name = column.getName();
            String sqlFormatName = this.convertCatalogIdentifierToSQLFormat(name, quoteString);
            qualifiedSQLName = sqlFormatName;
            String tableName = null;
            Table table = column.getTable();
            if (table != null) {
                tableName = table.getName();
                String sqlFormatTableName = this.convertCatalogIdentifierToSQLFormat(tableName, quoteString);
                qualifiedSQLName = sqlFormatTableName + "." + sqlFormatName;
            }
        }
        return qualifiedSQLName;
    }

    @Override
    public String getQualifiedNameInSQLFormat(Table table) {
        Object qualifiedSQLName = null;
        if (table != null) {
            String quoteString = this.getIdentifierQuoteString();
            String tableName = table.getName();
            String sqlFormatTableName = this.convertCatalogIdentifierToSQLFormat(tableName, quoteString);
            qualifiedSQLName = sqlFormatTableName;
            String schemaName = null;
            Schema schema = table.getSchema();
            if (schema != null) {
                schemaName = schema.getName();
                String sqlFormatSchemaName = this.convertCatalogIdentifierToSQLFormat(schemaName, quoteString);
                qualifiedSQLName = sqlFormatSchemaName + "." + sqlFormatTableName;
            }
        }
        return qualifiedSQLName;
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.fQuoteString;
    }

    @Override
    public void setIdentifierQuoteString(String quoteString) {
        this.fQuoteString = quoteString;
    }

    protected String convertCatalogIdentifierToSQLFormat(String catIdentifier, String quoteString) {
        Object sqlIdentifier = catIdentifier;
        if (catIdentifier != null && quoteString != null && quoteString.length() > 0 && !quoteString.equals(" ")) {
            boolean containsDelimiters = catIdentifier.indexOf(quoteString) > -1;
            boolean containsSpace = catIdentifier.indexOf(32) > -1;
            boolean containsDot = catIdentifier.indexOf(46) > -1;
            boolean isLowerOrMixedCase = !catIdentifier.toUpperCase().equals(catIdentifier);
            boolean allDigits = false;
            try {
                Integer.parseInt(catIdentifier);
                allDigits = true;
            }
            catch (NumberFormatException numberFormatException) {}
            boolean containsNonAlpha = false;
            String nonAlphaRegex = "[\\W&&[^$#@]]";
            Pattern patern = Pattern.compile(nonAlphaRegex);
            Matcher matcher = patern.matcher(catIdentifier);
            while (!containsNonAlpha && matcher.find()) {
                containsNonAlpha = true;
            }
            if (containsDelimiters || containsSpace || containsDot || containsNonAlpha || isLowerOrMixedCase || allDigits) {
                if (containsDelimiters) {
                    if (!((String)sqlIdentifier).startsWith(quoteString) || !((String)sqlIdentifier).endsWith(quoteString)) {
                        if (quoteString.length() == 1) {
                            char quoteChar = quoteString.charAt(0);
                            StringBuffer sqlIdentSB = new StringBuffer((String)sqlIdentifier);
                            int i = 0;
                            while (i < sqlIdentSB.length()) {
                                if (sqlIdentSB.charAt(i) == quoteChar) {
                                    sqlIdentSB.insert(i, quoteChar);
                                    ++i;
                                }
                                ++i;
                            }
                            sqlIdentifier = sqlIdentSB.toString();
                        }
                        sqlIdentifier = quoteString + (String)sqlIdentifier + quoteString;
                    }
                } else {
                    sqlIdentifier = quoteString + (String)sqlIdentifier + quoteString;
                }
            }
        }
        return sqlIdentifier;
    }

    protected Database getDatabase(Schema schema) {
        Database database = null;
        if (schema != null) {
            database = schema.getCatalog() == null ? schema.getDatabase() : schema.getCatalog().getDatabase();
        }
        return database;
    }
}

