/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.modelbase.sql.schema.helper;

import com.ibm.ims.datatools.modelbase.sql.schema.Catalog;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class DatabaseHelper {
    public static Schema findSchema(Database database, String schemaName) {
        Schema returnSchema = null;
        for (Schema schema : database.getSchemas()) {
            if (DatabaseHelper.compareIdentifiers(database, schema.getName(), schemaName) != 0) continue;
            returnSchema = schema;
            break;
        }
        if (returnSchema == null && database.getCatalogs() != null) {
            EList catalogs = database.getCatalogs();
            block1: for (Catalog catalog : catalogs) {
                if (catalog.getSchemas() == null || catalog.getSchemas().size() <= 0) continue;
                for (Schema schema : catalog.getSchemas()) {
                    if (DatabaseHelper.compareIdentifiers(database, schema.getName(), schemaName) != 0) continue;
                    returnSchema = schema;
                    continue block1;
                }
            }
        }
        return returnSchema;
    }

    public static List findTables(Database database, String tableName) {
        Vector<Table> returnTables = new Vector<Table>();
        for (Schema schema : database.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (DatabaseHelper.compareIdentifiers(database, table.getName(), tableName) != 0) continue;
                returnTables.add(table);
            }
        }
        return returnTables;
    }

    public static int compareIdentifiers(Database database, String identifier, String lookupName) {
        int compResult = -1;
        String delimiter = "\"";
        if (lookupName.startsWith(delimiter)) {
            if (identifier.startsWith(delimiter)) {
                compResult = identifier.compareTo(lookupName);
            } else if (lookupName.endsWith(delimiter)) {
                String lookupNameContent = lookupName.substring(1, lookupName.length() - 1);
                compResult = identifier.compareTo(lookupNameContent);
            }
        } else {
            compResult = identifier.compareToIgnoreCase(lookupName);
        }
        return compResult;
    }
}

