/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.preference.ui.preferencepage;

import com.ibm.etools.cobol.plugin.CobolPlugin;
import com.ibm.etools.cobol.plugin.Messages;
import com.ibm.etools.cobol.preference.ui.common.CobolPropertiesPage;
import com.ibm.etools.cobol.preference.ui.common.ICobolUIPreferenceConstants;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CobolPreferencePage
extends PreferencePage
implements ICobolUIPreferenceConstants,
IWorkbenchPreferencePage {
    public static final String copyright = "(c) Copyright IBM Corporation 2001,2004.";
    public static final String PLUGIN_PREFERENCEPAGE_ID = "com.ibm.etools.cobol.preference.ui.preferencepage.COBOLPreferencePage";
    private CobolPropertiesPage cobolProps;

    public void init(IWorkbench wb) {
    }

    public Control createContents(Composite parent) {
        this.cobolProps = new CobolPropertiesPage((DialogPage)this);
        this.cobolProps.createContents(parent);
        this.cobolProps.setHelpContextIds();
        return parent;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        IPreferenceStore store = CobolPlugin.getDefault().getPreferenceStore();
        return store;
    }

    protected void performApply() {
        Vector validationErrors = this.cobolProps.getValidationErrorMessages();
        if (validationErrors.size() == 0) {
            this.setErrorMessage(null);
            this.storeValues();
        } else {
            this.setErrorMessage((String)validationErrors.elementAt(0));
            if (((String)validationErrors.get(0)).equalsIgnoreCase(Messages._EXC_Invalid_codepage)) {
                this.cobolProps.getCodePageField().setFocus();
            } else {
                this.cobolProps.getTextCurrency().setFocus();
            }
        }
    }

    protected void performDefaults() {
        this.cobolProps.performDefaults();
    }

    public boolean performOk() {
        Vector validationErrors = this.cobolProps.getValidationErrorMessages();
        if (validationErrors.size() != 0) {
            this.setErrorMessage((String)validationErrors.elementAt(0));
            if (((String)validationErrors.get(0)).equalsIgnoreCase(Messages._EXC_Invalid_codepage)) {
                this.cobolProps.getCodePageField().setFocus();
            } else {
                this.cobolProps.getTextCurrency().setFocus();
            }
            return false;
        }
        this.storeValues();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        HashMap props = this.cobolProps.getValues();
        for (String key : props.keySet()) {
            if (key.equals("com.ibm.etools.cobol.COBOL_PLATFORM_SELECTION") || key.equals("com.ibm.etools.cobol.COBOL_FLOATING_POINT_FORMAT") || key.equals("com.ibm.etools.cobol.COBOL_ASCII_CODEPAGE") || key.equals("com.ibm.etools.cobol.COBOL_ERROR_MSGS_LANG") || key.equals("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE")) {
                int intValue = (Integer)props.get(key);
                if (key.equals("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE") && intValue == 0) {
                    intValue = 14;
                }
                if (key.equals("com.ibm.etools.cobol.COBOL_ERROR_MSGS_LANG") && intValue == 0) {
                    intValue = 14;
                }
                store.setValue(key, intValue);
                continue;
            }
            if (key.equals("com.ibm.etools.cobol.COBOL_SOSI")) {
                store.setValue(key, ((Boolean)props.get(key)).booleanValue());
                continue;
            }
            store.setValue(key, (String)props.get(key));
        }
    }

    public void validate() {
        Vector validationErrors = this.cobolProps.getValidationErrorMessages();
        if (validationErrors.size() == 0) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage((String)validationErrors.elementAt(0));
            this.cobolProps.getTextCurrency().setFocus();
            this.setValid(false);
        }
    }
}

