/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.preference.ui.common;

import com.ibm.etools.cobol.importer.COBOLLocaleRelatedConstants;
import com.ibm.etools.cobol.importer.CobolPreferenceStore;
import com.ibm.etools.cobol.importer.CobolTypeUtilities;
import com.ibm.etools.cobol.plugin.CobolPlugin;
import com.ibm.etools.cobol.preference.ui.common.CobolCodePageSelectionDialog;
import com.ibm.etools.cobol.preference.ui.common.GridUtil;
import com.ibm.etools.cobol.preference.ui.common.ICobolUIPreferenceConstants;
import com.ibm.etools.cobol.preference.ui.plugin.Messages;
import com.ibm.etools.cobol.preference.ui.preferencepage.CobolPreferencePage;
import com.ibm.etools.cobol.preference.ui.typeimport.CobolImporterPropertiesPage;
import com.ibm.etools.lang.common.ui.LocalSystemLibraryTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CobolPropertiesPage
implements SelectionListener,
ModifyListener,
ICobolUIPreferenceConstants {
    protected static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private Composite main;
    public Combo comboPS;
    public Combo comboLC;
    public Combo comboACP;
    public Combo comboEL;
    public Text textCP;
    public Text textCurrency;
    public Button buttonCPSelect;
    public Combo comboFPF;
    public Button radioEBig;
    public Button radioELittle;
    public Button radioRIEBig;
    public Button radioRIELittle;
    public Button radioASCII;
    public Button radioEBCDIC;
    public Button radioEBCDICC;
    public Text textHostCP;
    public Button buttonHostCPSelect;
    public Button radioCOSTD;
    public Button radioCOOPT;
    public Button radioCOBIN;
    public Button radioNSDBCS;
    public Button radioNSNATIONAL;
    public Button radioASINGLE;
    public Button radioADOUBLE;
    public Button radioCSLOCALE;
    public Button radioCSEBCDIC;
    public Button radioCSBIN;
    public Button radioNCSLOCALE;
    public Button radioNCSBIN;
    public Button radioUPPER;
    public Button radioMIXED;
    public Text textAdditional;
    public Button checkBoxCur;
    public Button checkBoxSOSI;
    private Button _editBtn;
    public TableViewer tableViewer;
    private MyTableElement[] tableElements;
    private final ArrayList platform_selection_values = new ArrayList(4);
    private final ArrayList floating_pt_values = new ArrayList(2);
    private final HashMap endian_values = new HashMap(2);
    private final HashMap remote_int_endian_values = new HashMap(2);
    private final HashMap extra_decimal_sign_values = new HashMap(3);
    private final HashMap quote_values = new HashMap(2);
    private final HashMap trunc_values = new HashMap(2);
    private final HashMap nsymbol_values = new HashMap(2);
    private final HashMap collseq_values = new HashMap(3);
    private final HashMap ncollseq_values = new HashMap(2);
    private final HashMap pgmname_values = new HashMap(2);
    private final String[] COLUMNS = new String[]{"STRING", "COMBO"};
    private final String[] VALUES = new String[]{Messages.EXTENSION_SUPPORT_VALUE1, Messages.EXTENSION_SUPPORT_VALUE2};
    private DialogPage parentPage;
    private COBOLLocaleRelatedConstants clrc;
    private String hostCodePageValue;
    LocalSystemLibraryTable libraryTable;

    public CobolPropertiesPage(DialogPage page) {
        this.parentPage = page;
        this.clrc = new COBOLLocaleRelatedConstants();
    }

    public Text getCodePageField() {
        return this.textCP;
    }

    public Control createContents(Composite parent) {
        this.main = this.createComposite(parent, 1, true);
        this.createTabControl(this.main);
        this.main.pack(true);
        this.main.layout(true);
        this.initializePreferenceStoreValues();
        this.initializeValues();
        return this.main;
    }

    private void createTabControl(Composite parent) {
        TabFolder folder = new TabFolder(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        folder.setLayoutData((Object)data);
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.TAB1_LABEL);
        item.setControl(this.createPage1Contents((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Messages.TAB2_LABEL);
        item.setControl(this.createPage2Contents((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Messages.TAB3_LABEL);
        this.libraryTable = new LocalSystemLibraryTable((Composite)folder);
        item.setControl((Control)this.libraryTable);
    }

    public Control createPage1Contents(Composite parent) {
        Composite main = this.createComposite(parent, 1, false);
        Composite labelComp = this.createComposite(main, 1, false);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        labelComp.setLayout((Layout)layout);
        Label lb = new Label(labelComp, 0);
        lb.setText(Messages.SPECIFY_TARGET_PLATFORM_PROPERTIES);
        Composite platformComp = this.createComposite(main, 2, false);
        this.comboPS = this.createCombo(platformComp, Messages.PLATFORM_SELECTION_LABEL);
        Composite codePageComp = this.createComposite(main, 3, false);
        this.textCP = this.createText(codePageComp, Messages.CODE_PAGE_SELECT_HEADER);
        this.buttonCPSelect = this.createPushButton(codePageComp, Messages.SELECT_BUTTON);
        Composite floatingPtComp = this.createComposite(main, 2, false);
        this.comboFPF = this.createCombo(floatingPtComp, Messages.FLOATING_POINT_FORMAT_LABEL);
        Composite endianComp = this.createComposite(main, 2, false);
        this.createEndianGroup(endianComp);
        this.createRemoteEndianGroup(endianComp);
        this.createExtDecimalGroup(main);
        Composite labelComp1 = this.createComposite(main, 1, false);
        GridLayout layout1 = new GridLayout();
        layout1.marginHeight = 1;
        labelComp1.setLayout((Layout)layout1);
        Label lbl = new Label(labelComp1, 0);
        lbl.setText(Messages.SPECIFY_COMPILE_OPTIONS);
        this.createQuoteGroup(main);
        this.createTruncGroup(main);
        this.createNSymbolGroup(main);
        return main;
    }

    public Control createPage2Contents(Composite parent) {
        Composite main = this.createComposite(parent, 1, false);
        Composite labelComp = this.createComposite(main, 1, false);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        labelComp.setLayout((Layout)layout);
        Label lbl = new Label(labelComp, 0);
        lbl.setText(Messages.SPECIFY_COMPILE_OPTIONS);
        Composite localeNameComp = this.createComposite(main, 2, false);
        this.comboLC = this.createCombo(localeNameComp, Messages.COMPILE_TIME_LOCALE_LABEL);
        if (CobolPlugin.isWindows()) {
            Composite asciiColdePagesComp = this.createComposite(main, 2, false);
            this.comboACP = this.createCombo(asciiColdePagesComp, Messages.ASCII_CODEPAGE_LABEL);
        }
        Composite errorMsgsLanguageComp = this.createComposite(main, 2, false);
        this.comboEL = this.createCombo(errorMsgsLanguageComp, Messages.ERROR_MESSAGES_LANGUAGE);
        Composite currencyComp = this.createComposite(main, 2, false);
        this.textCurrency = this.createText(currencyComp, Messages.CURRENCY_LABEL);
        this.textCurrency.setTextLimit(5);
        Composite composite = new Composite(main, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        layout2.marginHeight = 0;
        composite.setLayout((Layout)layout2);
        Label lb2 = new Label(composite, 0);
        lb2.setText(Messages.CURRENCY_EXAMPLE_LABEL);
        Composite sosiComp = this.createComposite(main, 2, false);
        this.checkBoxSOSI = this.createCheckboxButton(sosiComp, Messages.SOSI_LABEL);
        this.createCOLLSEQGroup(main);
        this.createNCOLLSEQGroup(main);
        this.createPGMNAMEGroup(main);
        Composite labelComp3 = this.createComposite(main, 1, false);
        GridLayout layout3 = new GridLayout();
        layout3.marginHeight = 10;
        labelComp3.setLayout((Layout)layout3);
        Label lb3 = new Label(labelComp3, 0);
        lb3.setText(Messages.FILE_EXTENSION_SUPPORT);
        this.createFileExtensionTable(main);
        return main;
    }

    private Composite createComposite(Composite parent, int numColumns, boolean bGrabExcessVert) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (bGrabExcessVert) {
            data.grabExcessVerticalSpace = true;
        }
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Group createGroup(Composite parent, int numColumns, String label) {
        Group composite = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setText(label);
        return composite;
    }

    private Combo createCombo(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        combo.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        combo.setLayoutData((Object)gd);
        combo.addSelectionListener((SelectionListener)this);
        return combo;
    }

    private Text createText(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Text textField = new Text(parent, 2052);
        GridData gd = new GridData(768);
        textField.setLayoutData((Object)gd);
        textField.addSelectionListener((SelectionListener)this);
        textField.addModifyListener((ModifyListener)this);
        return textField;
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private Button createCheckboxButton(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private void createEndianGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.ENDIAN_LABEL);
        this.radioELittle = this.createRadioButton((Composite)group, Messages.LITTLE_ENDIAN_VALUE);
        this.radioEBig = this.createRadioButton((Composite)group, Messages.BIG_ENDIAN_VALUE);
    }

    private void createRemoteEndianGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.REMOTE_INTEGER_ENDIAN_LABEL);
        this.radioRIELittle = this.createRadioButton((Composite)group, Messages.LITTLE_ENDIAN_VALUE);
        this.radioRIEBig = this.createRadioButton((Composite)group, Messages.BIG_ENDIAN_VALUE);
    }

    private void createExtDecimalGroup(Composite parent) {
        Group group = this.createGroup(parent, 1, Messages.EXTERNAL_DECIMAL_SIGN_LABEL);
        this.radioASCII = this.createRadioButton((Composite)group, Messages.ASCII_ENCODING_VALUE);
        this.radioEBCDIC = this.createRadioButton((Composite)group, Messages.EBCDIC_ENCODING_VALUE);
        this.radioEBCDICC = this.createRadioButton((Composite)group, Messages.EBCDIC_CUSTOM_ENCODING_VALUE);
        Composite codePageComp = this.createComposite((Composite)group, 4, false);
        Label label = new Label(codePageComp, 0);
        label.setText("  ");
        this.textHostCP = this.createText(codePageComp, Messages.HOST_CODE_PAGE_SELECT_HEADER);
        this.buttonHostCPSelect = this.createPushButton(codePageComp, Messages.SELECT_BUTTON2);
    }

    private void createQuoteGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.QUOTE_LABEL);
        this.radioADOUBLE = this.createRadioButton((Composite)group, Messages.DOUBLE_VALUE);
        this.radioASINGLE = this.createRadioButton((Composite)group, Messages.SINGLE_VALUE);
    }

    private void createTruncGroup(Composite parent) {
        Group group = this.createGroup(parent, 3, Messages.TRUNC_LABEL);
        this.radioCOSTD = this.createRadioButton((Composite)group, Messages.STD_VALUE);
        this.radioCOOPT = this.createRadioButton((Composite)group, Messages.OPT_VALUE);
        this.radioCOBIN = this.createRadioButton((Composite)group, Messages.BIN_VALUE);
    }

    private void createNSymbolGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.NSYMBOL_LABEL);
        this.radioNSNATIONAL = this.createRadioButton((Composite)group, Messages.NATIONAL_VALUE);
        this.radioNSDBCS = this.createRadioButton((Composite)group, Messages.DBCS_VALUE);
    }

    private void createCOLLSEQGroup(Composite parent) {
        Group group = this.createGroup(parent, 3, Messages.COLLSEQ_LABEL);
        this.radioCSLOCALE = this.createRadioButton((Composite)group, Messages.LOCALE_LABEL);
        this.radioCSEBCDIC = this.createRadioButton((Composite)group, Messages.EBCDIC_VALUE);
        this.radioCSBIN = this.createRadioButton((Composite)group, Messages.BIN_VALUE);
    }

    private void createNCOLLSEQGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.NCOLLSEQ_LABEL);
        this.radioNCSLOCALE = this.createRadioButton((Composite)group, Messages.LOCALE_LABEL);
        this.radioNCSBIN = this.createRadioButton((Composite)group, Messages.BIN_VALUE);
    }

    private void createPGMNAMEGroup(Composite parent) {
        Group group = this.createGroup(parent, 2, Messages.PGMNAME_LABEL);
        this.radioUPPER = this.createRadioButton((Composite)group, Messages.UPPER_VALUE);
        this.radioMIXED = this.createRadioButton((Composite)group, Messages.MIXED_VALUE);
    }

    private void createFileExtensionTable(Composite parent) {
        new GridData();
        GridLayout layout = new GridLayout();
        Composite composite = new Composite(parent, 0);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridUtil.createFill());
        this.createFileExtensionTableViewer(composite);
        Composite btnGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 15;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._editBtn = new Button(btnGroup, 8);
        this._editBtn.setText(Messages.EDIT_BUTTON);
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
    }

    private void createFileExtensionTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 100356);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = this.createFill();
        data.heightHint = 50;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[this.COLUMNS.length];
        TableColumn stringColumn = new TableColumn(table, 16384);
        stringColumn.setText(Messages.EXTENSION_COLUMN_LABEL);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        cellEditors[0] = new TextCellEditor((Composite)table);
        TableColumn comboColumn = new TableColumn(table, 16384);
        comboColumn.setText(Messages.EXTENSION_SUPPORT_LABEL);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        cellEditors[1] = new ComboBoxCellEditor((Composite)table, this.VALUES);
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(this.COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new PreferenceCellModifier((Viewer)this.tableViewer));
        this.tableViewer.setCellEditors(cellEditors);
    }

    public GridData createFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    private void disableAllButtons() {
        this.radioEBig.setSelection(false);
        this.radioELittle.setSelection(false);
        this.radioRIEBig.setSelection(false);
        this.radioRIELittle.setSelection(false);
        this.radioASCII.setSelection(false);
        this.radioEBCDIC.setSelection(false);
        this.radioEBCDICC.setSelection(false);
        this.radioCOSTD.setSelection(false);
        this.radioCOOPT.setSelection(false);
        this.radioCOBIN.setSelection(false);
        this.radioNSDBCS.setSelection(false);
        this.radioNSNATIONAL.setSelection(false);
        this.radioASINGLE.setSelection(false);
        this.radioADOUBLE.setSelection(false);
        this.radioCSBIN.setSelection(false);
        this.radioCSEBCDIC.setSelection(false);
        this.radioCSLOCALE.setSelection(false);
        this.radioNCSBIN.setSelection(false);
        this.radioNCSLOCALE.setSelection(false);
        this.radioUPPER.setSelection(false);
        this.radioMIXED.setSelection(false);
    }

    private Object getKey(Map map, Object value) {
        for (Object o : map.keySet()) {
            if (!map.get(o).equals(value)) continue;
            return o;
        }
        return null;
    }

    public Vector getValidationErrorMessages() {
        Vector<String> errorMessages = new Vector<String>();
        try {
            CobolTypeUtilities.validateCodepage((String)this.textCP.getText());
            if (!this.textHostCP.getText().equals("")) {
                CobolTypeUtilities.validateCodepage((String)this.textHostCP.getText());
            }
            CobolTypeUtilities.validateCurrency((String)this.textCurrency.getText());
        }
        catch (Exception ex) {
            errorMessages.add(ex.getMessage());
        }
        return errorMessages;
    }

    public HashMap getValues() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("com.ibm.etools.cobol.COBOL_PLATFORM_SELECTION", new Integer(this.comboPS.getSelectionIndex()));
        propertyMap.put("com.ibm.etools.cobol.COBOL_CODEPAGE", this.textCP.getText());
        propertyMap.put("com.ibm.etools.cobol.COBOL_FLOATING_POINT_FORMAT", new Integer(this.comboFPF.getSelectionIndex()));
        if (this.radioEBig.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_ENDIAN", (String)this.endian_values.get(this.radioEBig));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_ENDIAN", (String)this.endian_values.get(this.radioELittle));
        }
        if (this.radioRIEBig.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_REMOTE_ENDIAN", (String)this.remote_int_endian_values.get(this.radioRIEBig));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_REMOTE_ENDIAN", (String)this.remote_int_endian_values.get(this.radioRIELittle));
        }
        if (this.radioASCII.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_EXT_DECIMAL_SIGN", (String)this.extra_decimal_sign_values.get(this.radioASCII));
        } else if (this.radioEBCDIC.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_EXT_DECIMAL_SIGN", (String)this.extra_decimal_sign_values.get(this.radioEBCDIC));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_EXT_DECIMAL_SIGN", (String)this.extra_decimal_sign_values.get(this.radioEBCDICC));
            propertyMap.put("com.ibm.etools.cobol.COBOL_HOST_CODEPAGE_EC", this.textHostCP.getText());
        }
        propertyMap.put("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE", new Integer(this.comboLC.getSelectionIndex()));
        if (CobolPlugin.isWindows()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_ASCII_CODEPAGE", new Integer(this.comboACP.getSelectionIndex()));
        }
        propertyMap.put("com.ibm.etools.cobol.COBOL_ERROR_MSGS_LANG", new Integer(this.comboEL.getSelectionIndex()));
        propertyMap.put("com.ibm.etools.cobol.COBOL_CURRENCY", this.textCurrency.getText());
        propertyMap.put("com.ibm.etools.cobol.COBOL_SOSI", new Boolean(this.checkBoxSOSI.getSelection()));
        if (this.radioCOSTD.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_TRUNC", (String)this.trunc_values.get(this.radioCOSTD));
        } else if (this.radioCOOPT.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_TRUNC", (String)this.trunc_values.get(this.radioCOOPT));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_TRUNC", (String)this.trunc_values.get(this.radioCOBIN));
        }
        propertyMap.put("com.ibm.etools.cobol.COBOL_NUMPROC", "PFD");
        if (this.radioNSDBCS.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_NSYMBOL", (String)this.nsymbol_values.get(this.radioNSDBCS));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_NSYMBOL", (String)this.nsymbol_values.get(this.radioNSNATIONAL));
        }
        if (this.radioASINGLE.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_QUOTE", (String)this.quote_values.get(this.radioASINGLE));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_QUOTE", (String)this.quote_values.get(this.radioADOUBLE));
        }
        if (this.radioCSBIN.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_COLLSEQ", (String)this.collseq_values.get(this.radioCSBIN));
        } else if (this.radioCSEBCDIC.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_COLLSEQ", (String)this.collseq_values.get(this.radioCSEBCDIC));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_COLLSEQ", (String)this.collseq_values.get(this.radioCSLOCALE));
        }
        if (this.radioNCSBIN.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_NCOLLSEQ", (String)this.ncollseq_values.get(this.radioNCSBIN));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_NCOLLSEQ", (String)this.ncollseq_values.get(this.radioNCSLOCALE));
        }
        if (this.radioUPPER.getSelection()) {
            propertyMap.put("com.ibm.etools.cobol.COBOL_PGMNAME", (String)this.pgmname_values.get(this.radioUPPER));
        } else {
            propertyMap.put("com.ibm.etools.cobol.COBOL_PGMNAME", (String)this.pgmname_values.get(this.radioMIXED));
        }
        MyTableElement[] myTableElements = (MyTableElement[])this.tableViewer.getInput();
        if (myTableElements != null) {
            int i = 0;
            while (i < myTableElements.length) {
                if (myTableElements[i].getText().equals(".cbl")) {
                    propertyMap.put("com.ibm.etools.cobol.COBOL_EXTENSION_CBL", this.getExtenstionSupportIndex(myTableElements[i].getValue()));
                } else if (myTableElements[i].getText().equals(".ccp")) {
                    propertyMap.put("com.ibm.etools.cobol.COBOL_EXTENSION_CCP", this.getExtenstionSupportIndex(myTableElements[i].getValue()));
                } else if (myTableElements[i].getText().equals(".cob")) {
                    propertyMap.put("com.ibm.etools.cobol.COBOL_EXTENSION_COB", this.getExtenstionSupportIndex(myTableElements[i].getValue()));
                } else if (myTableElements[i].getText().equals(".cpy")) {
                    propertyMap.put("com.ibm.etools.cobol.COBOL_EXTENSION_CPY", this.getExtenstionSupportIndex(myTableElements[i].getValue()));
                }
                ++i;
            }
        }
        Collection syslibList = this.libraryTable.getTableList();
        String syslib = "";
        Iterator iter = syslibList.iterator();
        while (iter.hasNext()) {
            syslib = String.valueOf(syslib) + iter.next() + PATH_SEPARATOR;
        }
        propertyMap.put("com.ibm.etools.cobol.COBOL_SYSLIB", syslib);
        return propertyMap;
    }

    private void initializePreferenceStoreValues() {
        this.floating_pt_values.add("IEEE Non-Extended");
        this.floating_pt_values.add("IBM 390 Hexadecimal");
        this.platform_selection_values.add("Win32");
        this.platform_selection_values.add("AIX");
        this.platform_selection_values.add("z/OS");
        this.platform_selection_values.add("Not Specified");
        this.endian_values.put(this.radioEBig, "Big");
        this.endian_values.put(this.radioELittle, "Little");
        this.remote_int_endian_values.put(this.radioRIEBig, "Big");
        this.remote_int_endian_values.put(this.radioRIELittle, "Little");
        this.extra_decimal_sign_values.put(this.radioASCII, "ASCII");
        this.extra_decimal_sign_values.put(this.radioEBCDIC, "EBCDIC");
        this.extra_decimal_sign_values.put(this.radioEBCDICC, "EBCDIC Custom");
        this.quote_values.put(this.radioADOUBLE, "DOUBLE");
        this.quote_values.put(this.radioASINGLE, "SINGLE");
        this.trunc_values.put(this.radioCOSTD, "STD");
        this.trunc_values.put(this.radioCOOPT, "OPT");
        this.trunc_values.put(this.radioCOBIN, "BIN");
        this.nsymbol_values.put(this.radioNSDBCS, "DBCS");
        this.nsymbol_values.put(this.radioNSNATIONAL, "NATIONAL");
        this.collseq_values.put(this.radioCSLOCALE, "LOCALE");
        this.collseq_values.put(this.radioCSEBCDIC, "EBCDIC");
        this.collseq_values.put(this.radioCSBIN, "BIN");
        this.ncollseq_values.put(this.radioNCSLOCALE, "LOCALE");
        this.ncollseq_values.put(this.radioNCSBIN, "BIN");
        this.pgmname_values.put(this.radioUPPER, "LU");
        this.pgmname_values.put(this.radioMIXED, "LM");
    }

    protected void initializeValues() {
        int cfr_ignored_0 = PS_ITEM.length - 1;
        int ix = 0;
        while (ix < PS_ITEM.length) {
            this.comboPS.add(PS_ITEM[ix]);
            ++ix;
        }
        int cfr_ignored_1 = FPF_ITEM.length - 1;
        ix = 0;
        while (ix < FPF_ITEM.length) {
            this.comboFPF.add(FPF_ITEM[ix]);
            ++ix;
        }
        Vector v = this.clrc.getLocaleNames();
        Enumeration enum1 = v.elements();
        while (enum1.hasMoreElements()) {
            this.comboLC.add((String)enum1.nextElement());
        }
        v = this.clrc.getErrorMessagesLanguage();
        enum1 = v.elements();
        while (enum1.hasMoreElements()) {
            this.comboEL.add((String)enum1.nextElement());
        }
        this.setValuesFromMap(CobolPreferenceStore.getValues());
    }

    public void setValuesFromMap(HashMap map) {
        Button b;
        String work;
        int iValue = 0;
        boolean bValue = false;
        Vector<MyTableElement> workVector = new Vector<MyTableElement>();
        this.disableAllButtons();
        if (map.containsKey("com.ibm.etools.cobol.COBOL_PLATFORM_SELECTION")) {
            iValue = (Integer)map.get("com.ibm.etools.cobol.COBOL_PLATFORM_SELECTION");
            this.comboPS.setText(this.comboPS.getItem(iValue));
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_CODEPAGE")) != null) {
            this.textCP.setText(work);
        }
        if (map.containsKey("com.ibm.etools.cobol.COBOL_FLOATING_POINT_FORMAT")) {
            iValue = (Integer)map.get("com.ibm.etools.cobol.COBOL_FLOATING_POINT_FORMAT");
            this.comboFPF.setText(this.comboFPF.getItem(iValue));
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_ENDIAN")) != null && (b = (Button)this.getKey(this.endian_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_REMOTE_ENDIAN")) != null && (b = (Button)this.getKey(this.remote_int_endian_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_EXT_DECIMAL_SIGN")) != null && (b = (Button)this.getKey(this.extra_decimal_sign_values, work)) != null) {
            b.setSelection(true);
            this.hostCodePageValue = (String)map.get("com.ibm.etools.cobol.COBOL_HOST_CODEPAGE_EC");
            this.workOnHostCodePageSection(b);
        }
        if (map.containsKey("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE")) {
            iValue = (Integer)map.get("com.ibm.etools.cobol.COBOL_COMPILE_TIME_LOCALE");
            this.comboLC.setText(this.comboLC.getItem(iValue));
        }
        if (CobolPlugin.isWindows() && map.containsKey("com.ibm.etools.cobol.COBOL_ASCII_CODEPAGE")) {
            iValue = (Integer)map.get("com.ibm.etools.cobol.COBOL_ASCII_CODEPAGE");
            Vector v = this.clrc.getASCIICodePages(this.comboLC.getText());
            Enumeration enum1 = v.elements();
            this.comboACP.removeAll();
            while (enum1.hasMoreElements()) {
                this.comboACP.add((String)enum1.nextElement());
            }
            this.comboACP.setText(this.comboACP.getItem(iValue));
        }
        if (map.containsKey("com.ibm.etools.cobol.COBOL_ERROR_MSGS_LANG")) {
            iValue = (Integer)map.get("com.ibm.etools.cobol.COBOL_ERROR_MSGS_LANG");
            this.comboEL.setText(this.comboEL.getItem(iValue));
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_CURRENCY")) != null) {
            this.textCurrency.setText(work);
        }
        if (map.containsKey("com.ibm.etools.cobol.COBOL_SOSI")) {
            bValue = (Boolean)map.get("com.ibm.etools.cobol.COBOL_SOSI");
            this.checkBoxSOSI.setSelection(bValue);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_TRUNC")) != null && (b = (Button)this.getKey(this.trunc_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_NSYMBOL")) != null && (b = (Button)this.getKey(this.nsymbol_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_QUOTE")) != null && (b = (Button)this.getKey(this.quote_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_NSYMBOL")) != null && (b = (Button)this.getKey(this.nsymbol_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_COLLSEQ")) != null && (b = (Button)this.getKey(this.collseq_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_NCOLLSEQ")) != null && (b = (Button)this.getKey(this.ncollseq_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_PGMNAME")) != null && (b = (Button)this.getKey(this.pgmname_values, work)) != null) {
            b.setSelection(true);
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_EXTENSION_CBL")) != null) {
            workVector.add(new MyTableElement(".cbl", this.getExtenstionSupportValue(work)));
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_EXTENSION_CCP")) != null) {
            workVector.add(new MyTableElement(".ccp", this.getExtenstionSupportValue(work)));
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_EXTENSION_COB")) != null) {
            workVector.add(new MyTableElement(".cob", this.getExtenstionSupportValue(work)));
        }
        if ((work = (String)map.get("com.ibm.etools.cobol.COBOL_EXTENSION_CPY")) != null) {
            workVector.add(new MyTableElement(".cpy", this.getExtenstionSupportValue(work)));
        }
        this.loadDataIntoTable(workVector);
        work = (String)map.get("com.ibm.etools.cobol.COBOL_SYSLIB");
        if (work != null) {
            this.loadDataIntoSyslibTable(work);
        }
    }

    private void loadDataIntoSyslibTable(String work) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(work, PATH_SEPARATOR);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        this.libraryTable.setTableInput(list);
    }

    private String getExtenstionSupportValue(String text) {
        if (text.equals("FP")) {
            return Messages.EXTENSION_SUPPORT_VALUE1;
        }
        return Messages.EXTENSION_SUPPORT_VALUE2;
    }

    private String getExtenstionSupportIndex(String value) {
        if (value.equals(Messages.EXTENSION_SUPPORT_VALUE1)) {
            return "FP";
        }
        return "DS";
    }

    public void widgetSelected(SelectionEvent e) {
        this.parentPage.setErrorMessage(null);
        Object source = e.getSource();
        if (source == this.tableViewer.getTable()) {
            this.enableButtons();
            return;
        }
        if (source == this._editBtn) {
            int idx = this.tableViewer.getTable().getSelectionIndex();
            if (idx != -1) {
                CBETableElement sel = (CBETableElement)this.tableViewer.getElementAt(idx);
                String extension = sel.getText();
                String support = sel.getValue();
                this.showEditDialog(Messages.EDIT_FILE_EXTENSION_SUPPORT, extension, support);
            }
            return;
        }
        if (source == this.buttonCPSelect) {
            this.selectCP(this.textCP);
        } else if (source == this.buttonHostCPSelect) {
            this.selectCP(this.textHostCP);
        } else if (source == this.comboPS) {
            this.resetPlatformSelection();
        } else if (source == this.comboLC) {
            this.resetAsciiCodepages();
        } else {
            this.workOnHostCodePageSection(source);
        }
        if (this.parentPage instanceof WizardPage) {
            ((CobolImporterPropertiesPage)this.parentPage).validatePage();
        }
    }

    private void workOnHostCodePageSection(Object source) {
        if (source == this.radioASCII || source == this.radioEBCDIC) {
            if (!this.textHostCP.getText().equals("")) {
                this.hostCodePageValue = this.textHostCP.getText();
                this.textHostCP.setText("");
            }
            this.textHostCP.setEnabled(false);
            this.buttonHostCPSelect.setEnabled(false);
        } else if (source == this.radioEBCDICC) {
            this.textHostCP.setEnabled(true);
            this.textHostCP.setText(this.hostCodePageValue);
            this.buttonHostCPSelect.setEnabled(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.textCP || e.getSource() == this.textHostCP || e.getSource() == this.textCurrency) {
            if (this.parentPage instanceof CobolPreferencePage) {
                ((CobolPreferencePage)this.parentPage).validate();
            } else if (this.parentPage instanceof WizardPage) {
                ((CobolImporterPropertiesPage)this.parentPage).validatePage();
            }
        }
    }

    public void performDefaults() {
        this.setValuesFromMap(CobolPreferenceStore.getDefaultValues());
        this.hostCodePageValue = "IBM-1047";
        this.parentPage.setErrorMessage(null);
    }

    private void resetPlatformSelection() {
        int iValue = 0;
        iValue = this.comboPS.getSelectionIndex() >= 0 ? this.comboPS.getSelectionIndex() : 0;
        switch (iValue) {
            case 0: {
                this.textCP.setText("ISO-8859-1");
                this.comboFPF.setText(this.comboFPF.getItem(0));
                this.radioEBig.setSelection(false);
                this.radioELittle.setSelection(true);
                this.radioRIEBig.setSelection(false);
                this.radioRIELittle.setSelection(true);
                this.radioASCII.setSelection(true);
                this.radioEBCDIC.setSelection(false);
                this.radioEBCDICC.setSelection(false);
                this.checkBoxSOSI.setSelection(false);
                this.radioCSBIN.setSelection(true);
                this.radioCSEBCDIC.setSelection(false);
                this.radioCSLOCALE.setSelection(false);
                this.radioNCSBIN.setSelection(true);
                this.radioNCSLOCALE.setSelection(false);
                this.radioUPPER.setSelection(true);
                this.radioMIXED.setSelection(false);
                break;
            }
            case 1: {
                this.textCP.setText("ISO-8859-1");
                this.comboFPF.setText(this.comboFPF.getItem(0));
                this.radioEBig.setSelection(true);
                this.radioELittle.setSelection(false);
                this.radioRIEBig.setSelection(true);
                this.radioRIELittle.setSelection(false);
                this.radioASCII.setSelection(true);
                this.radioEBCDIC.setSelection(false);
                this.radioEBCDICC.setSelection(false);
                this.checkBoxSOSI.setSelection(false);
                this.radioCSBIN.setSelection(true);
                this.radioCSEBCDIC.setSelection(false);
                this.radioCSLOCALE.setSelection(false);
                this.radioNCSBIN.setSelection(true);
                this.radioNCSLOCALE.setSelection(false);
                this.radioUPPER.setSelection(true);
                this.radioMIXED.setSelection(false);
                break;
            }
            case 2: {
                this.textCP.setText("IBM-1047");
                this.comboFPF.setText(this.comboFPF.getItem(1));
                this.radioEBig.setSelection(true);
                this.radioELittle.setSelection(false);
                this.radioRIEBig.setSelection(true);
                this.radioRIELittle.setSelection(false);
                this.radioASCII.setSelection(false);
                this.radioEBCDIC.setSelection(true);
                this.radioEBCDICC.setSelection(false);
                this.checkBoxSOSI.setSelection(true);
                this.radioCSBIN.setSelection(false);
                this.radioCSEBCDIC.setSelection(true);
                this.radioCSLOCALE.setSelection(false);
                this.radioNCSBIN.setSelection(true);
                this.radioNCSLOCALE.setSelection(false);
                this.radioUPPER.setSelection(true);
                this.radioMIXED.setSelection(false);
                break;
            }
        }
    }

    private void resetAsciiCodepages() {
        if (CobolPlugin.isWindows() && this.comboLC.getSelectionIndex() > -1) {
            String localeName = this.comboLC.getText();
            Vector v = this.clrc.getASCIICodePages(localeName);
            Enumeration enum1 = v.elements();
            this.comboACP.removeAll();
            while (enum1.hasMoreElements()) {
                this.comboACP.add((String)enum1.nextElement());
            }
            if (this.comboACP.getSelectionIndex() == -1) {
                this.comboACP.select(0);
            }
        }
    }

    private void selectCP(Text textButton) {
        CobolCodePageSelectionDialog ccpsd = new CobolCodePageSelectionDialog(this.main.getShell(), textButton.getText());
        int rtnBtn = ccpsd.open();
        if (rtnBtn == 0 && ccpsd.getSelectedObject() != null) {
            textButton.setText((String)ccpsd.getSelectedObject());
            if (textButton == this.textHostCP) {
                this.hostCodePageValue = textButton.getText();
            }
        }
    }

    private void loadDataIntoTable(Vector v) {
        this.tableElements = this.initializeTable(v);
        this.tableViewer.setInput((Object)this.tableElements);
    }

    private MyTableElement[] initializeTable(Vector v) {
        MyTableElement[] tableElements = new MyTableElement[v.size()];
        return v.toArray(tableElements);
    }

    public Text getTextCurrency() {
        return this.textCurrency;
    }

    private void showEditDialog(String title, String extension, String support) {
        int idx;
        EditDialog dialog = new EditDialog(this.main.getShell(), title, extension, support);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (idx = this.tableViewer.getTable().getSelectionIndex()) != -1) {
            CBETableElement tableElem = (CBETableElement)this.tableViewer.getElementAt(idx);
            tableElem.setValue(dialog.support());
            tableElem.setUserModified(true);
            this.tableViewer.update((Object)tableElem, null);
        }
    }

    private void enableButtons() {
        int selection = this.tableViewer.getTable().getSelectionIndex();
        this._editBtn.setEnabled(this.tableViewer.getTable().getItemCount() > 0 && selection != -1);
    }

    public void setHelpContextIds() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.parentPage.getControl(), "com.ibm.etools.cobol.preference.ui.pcob0010");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboPS, "com.ibm.etools.cobol.preference.ui.pcob0015");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textCP, "com.ibm.etools.cobol.preference.ui.pcob0020");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboFPF, "com.ibm.etools.cobol.preference.ui.pcob0030");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioEBig, "com.ibm.etools.cobol.preference.ui.pcob0040");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioELittle, "com.ibm.etools.cobol.preference.ui.pcob0050");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioRIEBig, "com.ibm.etools.cobol.preference.ui.pcob0060");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioRIELittle, "com.ibm.etools.cobol.preference.ui.pcob0070");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioASCII, "com.ibm.etools.cobol.preference.ui.pcob0080");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioEBCDIC, "com.ibm.etools.cobol.preference.ui.pcob0090");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioEBCDICC, "com.ibm.etools.cobol.preference.ui.pcob0100");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioCOSTD, "com.ibm.etools.cobol.preference.ui.pcob0110");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioCOOPT, "com.ibm.etools.cobol.preference.ui.pcob0120");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioCOBIN, "com.ibm.etools.cobol.preference.ui.pcob0130");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioNSDBCS, "com.ibm.etools.cobol.preference.ui.pcob0170");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioNSNATIONAL, "com.ibm.etools.cobol.preference.ui.pcob0180");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioADOUBLE, "com.ibm.etools.cobol.preference.ui.pcob0190");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioASINGLE, "com.ibm.etools.cobol.preference.ui.pcob0200");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboLC, "com.ibm.etools.cobol.preference.ui.pcob0210");
        if (CobolPlugin.isWindows()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboACP, "com.ibm.etools.cobol.preference.ui.pcob0210");
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.comboEL, "com.ibm.etools.cobol.preference.ui.pcob0230");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textCurrency, "com.ibm.etools.cobol.preference.ui.pcob0240");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.checkBoxSOSI, "com.ibm.etools.cobol.preference.ui.pcob0250");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioCSLOCALE, "com.ibm.etools.cobol.preference.ui.pcob0260");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioCSEBCDIC, "com.ibm.etools.cobol.preference.ui.pcob0270");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioCSBIN, "com.ibm.etools.cobol.preference.ui.pcob0280");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioNCSLOCALE, "com.ibm.etools.cobol.preference.ui.pcob0290");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioNCSBIN, "com.ibm.etools.cobol.preference.ui.pcob0300");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioUPPER, "com.ibm.etools.cobol.preference.ui.pcob0320");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioMIXED, "com.ibm.etools.cobol.preference.ui.pcob0330");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tableViewer.getTable(), "com.ibm.etools.cobol.preference.ui.pcob0310");
    }

    private class CBETableElement {
        private String text;
        private String value;
        private String originalValue;
        private String defaultValue;
        private boolean useDefaultValue;
        private boolean isUserModified = false;

        public CBETableElement(String text, String value, String defaultValue, boolean useDefaultValue) {
            this.setText(text);
            this.setValue(value);
            this.originalValue = value;
            this.defaultValue = defaultValue;
            this.useDefaultValue = useDefaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isUserModified() {
            return this.isUserModified;
        }

        public void setUserModified(boolean isUserModified) {
            this.isUserModified = isUserModified;
        }

        public String getOriginalValue() {
            return this.originalValue;
        }

        public void setOriginalValue(String originalValue) {
            this.originalValue = originalValue;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isUseDefaultValue() {
            return this.useDefaultValue;
        }

        public void setUseDefaultValue(boolean useDefaultValue) {
            this.useDefaultValue = useDefaultValue;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isAffected() {
            return this.isUseDefaultValue();
        }

        public String toString() {
            return "<text=\"" + this.text + "\" value=\"" + this.value + "\" originalValue=\"" + this.originalValue + "\" defaultValue=\"" + this.defaultValue + "\"/>";
        }
    }

    private class EditDialog
    extends Dialog {
        private String _extension;
        private String _support;
        private Text _extensionText;
        private Text _supportText;
        private Combo _supportCombo;
        private String _title;

        public EditDialog(Shell shell, String title, String extension, String support) {
            super(shell);
            if (extension != null) {
                this._extension = extension;
            }
            this._support = support;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void extension(String extension) {
            this._extension = extension;
        }

        public String extension() {
            return this._extension;
        }

        public void support(String support) {
            this._support = support;
        }

        public String support() {
            return this._support;
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(Messages.EXTENSION_COLUMN_LABEL);
            this._extensionText = new Text(result, 2048);
            this._extensionText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._extensionText.setEditable(false);
            label = new Label(result, 0);
            label.setText(Messages.EXTENSION_SUPPORT_LABEL);
            this._supportCombo = new Combo(result, 2056);
            this._supportCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
            int i = 0;
            while (i < CobolPropertiesPage.this.VALUES.length) {
                this._supportCombo.add(CobolPropertiesPage.this.VALUES[i]);
                ++i;
            }
            if (this._extension != null) {
                this._extensionText.setText(this._extension);
            }
            if (this._support != null) {
                this._supportCombo.setText(this._support);
            }
            this._supportCombo.setFocus();
            return result;
        }

        protected void okPressed() {
            this._extension = this._extensionText.getText().trim();
            this._support = this._supportCombo.getText();
            super.okPressed();
        }
    }

    private class MyTableElement
    extends CBETableElement {
        private String text;
        private String value;

        public MyTableElement(String text, String value) {
            super(text, value, "", false);
            this.setText(text);
            this.setValue(value);
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }

    private class PreferenceCellModifier
    implements ICellModifier {
        private Viewer viewer;

        public PreferenceCellModifier(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof MyTableElement) {
                MyTableElement cfr_ignored_0 = (MyTableElement)element;
                if (property.equals(CobolPropertiesPage.this.COLUMNS[0])) {
                    return false;
                }
                if (property.equals(CobolPropertiesPage.this.COLUMNS[1])) {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)element;
                if (property.equals(CobolPropertiesPage.this.COLUMNS[0])) {
                    return myTableElement.getText();
                }
                if (property.equals(CobolPropertiesPage.this.COLUMNS[1])) {
                    return this.getValueIndex(myTableElement.getValue());
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Object myElement;
            if (element instanceof TableItem && (myElement = ((TableItem)element).getData()) instanceof MyTableElement) {
                String stringValue;
                MyTableElement myTableElement = (MyTableElement)myElement;
                if (property.equals(CobolPropertiesPage.this.COLUMNS[0])) {
                    myTableElement.setText((String)value);
                }
                if (property.equals(CobolPropertiesPage.this.COLUMNS[1]) && (stringValue = this.getValue((Integer)value)) != null) {
                    myTableElement.setValue(stringValue);
                }
                this.viewer.refresh();
            }
        }

        private Integer getValueIndex(String value) {
            int i = 0;
            int length = CobolPropertiesPage.this.VALUES.length;
            while (i < length) {
                if (CobolPropertiesPage.this.VALUES[i].equals(value)) {
                    return new Integer(i);
                }
                ++i;
            }
            return new Integer(0);
        }

        private String getValue(Integer index) {
            int idx;
            if (index != null && (idx = index.intValue()) >= 0 && idx < CobolPropertiesPage.this.VALUES.length) {
                return CobolPropertiesPage.this.VALUES[idx];
            }
            return null;
        }
    }

    private class PreferenceContentProvider
    implements IStructuredContentProvider {
        private PreferenceContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof MyTableElement[]) {
                return (MyTableElement[])element;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)element;
                if (columnIndex == 0) {
                    return myTableElement.getText();
                }
                if (columnIndex == 1) {
                    return myTableElement.getValue();
                }
            }
            return "";
        }
    }
}

