/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ast.internal.facets.core;

import com.ibm.ws.ast.internal.facets.core.DelegateExtension;
import com.ibm.ws.ast.internal.facets.core.FacetPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class DelegatesExtensionProcessor {
    private static final DelegatesExtensionProcessor INSTANCE = new DelegatesExtensionProcessor();
    private Map<DelegateKey, List<DelegateExtension>> _delegatesMap;

    private DelegatesExtensionProcessor() {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void registryChanged(IRegistryChangeEvent event) {
                DelegatesExtensionProcessor delegatesExtensionProcessor = DelegatesExtensionProcessor.this;
                synchronized (delegatesExtensionProcessor) {
                    DelegatesExtensionProcessor.this._delegatesMap = null;
                }
            }
        });
    }

    public static DelegatesExtensionProcessor getInstance() {
        return INSTANCE;
    }

    public synchronized DelegateExtension[] getDelegates(String facet, String version, String action) throws CoreException {
        List<DelegateExtension> delegates;
        if (this._delegatesMap == null) {
            this.initialize();
        }
        if ((delegates = this._delegatesMap.get(this.createKey(facet, version, action))) == null) {
            return new DelegateExtension[0];
        }
        return delegates.toArray(new DelegateExtension[delegates.size()]);
    }

    private DelegateKey createKey(String facetId, String version, String action) {
        return new DelegateKey(facetId, action, version);
    }

    private synchronized void initialize() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.ibm.ws.ast.facets.core", "delegates");
        this._delegatesMap = new HashMap<DelegateKey, List<DelegateExtension>>();
        int i = 0;
        while (i < elements.length) {
            this.processFacetDelegate(elements[i]);
            ++i;
        }
    }

    private void processFacetDelegate(IConfigurationElement element) {
        IProjectFacet facet;
        String facetId = element.getAttribute("facet");
        try {
            facet = ProjectFacetsManager.getProjectFacet((String)facetId);
        }
        catch (IllegalArgumentException e) {
            FacetPlugin.getDefault().log("Unknown facet id: " + facetId, e);
            return;
        }
        try {
            String[] versions;
            String versionString = element.getAttribute("version");
            if (versionString == null || versionString.trim().length() == 0) {
                Set set = facet.getVersions();
                versions = new String[set.size()];
                int index = 0;
                for (IProjectFacetVersion facetVersion : set) {
                    versions[index++] = facetVersion.getVersionString();
                }
            } else {
                versions = versionString.split(",");
                int i = 0;
                while (i < versions.length) {
                    versions[i] = versions[i].trim();
                    ++i;
                }
            }
            IConfigurationElement[] actions = element.getChildren();
            int i = 0;
            while (i < actions.length) {
                this.processAction(actions[i], facetId, versions);
                ++i;
            }
        }
        catch (CoreException e) {
            FacetPlugin.getDefault().log("Error processing facet id " + facetId, e);
        }
    }

    private void processAction(IConfigurationElement action, String facetId, String[] versions) throws CoreException {
        IConfigurationElement[] children = action.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        IConfigurationElement delegate = action.getChildren()[0];
        String type = action.getAttribute("type");
        int i = 0;
        while (i < versions.length) {
            DelegateKey key = this.createKey(facetId, versions[i], type);
            List<DelegateExtension> list = this._delegatesMap.get(key);
            if (list == null) {
                list = new ArrayList<DelegateExtension>();
                this._delegatesMap.put(key, list);
            }
            list.add(new DelegateExtension(delegate));
            ++i;
        }
    }

    private static class DelegateKey {
        private final String _facetId;
        private final String _action;
        private final String _version;

        public DelegateKey(String facetId, String action, String version) {
            this._facetId = facetId;
            this._action = action;
            this._version = version;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DelegateKey)) {
                return false;
            }
            DelegateKey other = (DelegateKey)obj;
            if (!this._facetId.equals(other._facetId)) {
                return false;
            }
            if (!this._action.equals(other._action)) {
                return false;
            }
            return this._version.equals(other._version);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this._facetId.hashCode();
            result = 37 * result + this._action.hashCode();
            result = 37 * result + this._version.hashCode();
            return result;
        }
    }
}

