/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ast.facets.core;

import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetUtilities {
    private static final Set<String> WEBSPHERE_FACET_IDS = new HashSet<String>();

    static String createFacetId(String base, String extension) {
        String id = String.valueOf(base) + extension;
        WEBSPHERE_FACET_IDS.add(id);
        return id;
    }

    public static boolean isWebSphereFacetId(String id) {
        if (WEBSPHERE_FACET_IDS.isEmpty()) {
            IFacetConstants.EAR_COEXISTENCE_FACET_ID.charAt(0);
        }
        return WEBSPHERE_FACET_IDS.contains(id);
    }

    private FacetUtilities() {
    }

    public static boolean hasFacet(IProject project, String identifier) throws CoreException {
        IFacetedProject facetProject = ProjectFacetsManager.create((IProject)project);
        return facetProject == null ? false : facetProject.hasProjectFacet(FacetUtilities.getFacet(identifier));
    }

    public static boolean hasFacet(IProject project, IProjectFacet facet) throws CoreException {
        IFacetedProject facetProject = ProjectFacetsManager.create((IProject)project);
        return facetProject == null ? false : facetProject.hasProjectFacet(facet);
    }

    public static boolean hasFacetVersion(IProject project, String identifier, String version) throws CoreException {
        return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)identifier, (String)version);
    }

    public static boolean hasFacetVersion(IProject project, IProjectFacetVersion version) throws CoreException {
        IFacetedProject facetProject = ProjectFacetsManager.create((IProject)project);
        return facetProject == null ? false : facetProject.hasProjectFacet(version);
    }

    public static IProjectFacetVersion getFacetVersion(String identifier, String version) {
        return FacetUtilities.getFacet(identifier).getVersion(version);
    }

    public static IProjectFacetVersion getFacetVersion(IProject project, String identifier) throws CoreException {
        return ProjectFacetsManager.create((IProject)project).getInstalledVersion(FacetUtilities.getFacet(identifier));
    }

    public static IProjectFacetVersion getFacetVersion(IProject project, IProjectFacet facet) throws CoreException {
        return ProjectFacetsManager.create((IProject)project).getInstalledVersion(facet);
    }

    public static IProjectFacet getFacet(String identifier) {
        return ProjectFacetsManager.getProjectFacet((String)identifier);
    }

    public static int compareFacetVersion(IProject project, String identifier, String version) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.ast.facets.core", "Not a faceted project: " + project));
        }
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)identifier);
        if (facet == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.ast.facets.core", "Facet \"" + identifier + "\" not installed on project " + project));
        }
        IProjectFacetVersion facetVersion = facetedProject.getInstalledVersion(facet);
        if (facetVersion == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.ast.facets.core", "No version of facet \"" + identifier + "\" installed on project " + project));
        }
        return facet.getVersionComparator().compare(facetVersion.getVersionString(), version);
    }

    public static int compareFacetVersion(IProjectFacetVersion facetVersion, String version) throws CoreException {
        return facetVersion.getProjectFacet().getVersionComparator().compare(facetVersion.getVersionString(), version);
    }

    public static boolean hasWebSphereFacet(IProject project) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject != null) {
            Set facets = facetedProject.getProjectFacets();
            for (IProjectFacetVersion facetVersion : facets) {
                if (!FacetUtilities.isWebSphereFacetId(facetVersion.getProjectFacet().getId())) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<IProjectFacetVersion> getWebSphereFacetVersions(IProject project) throws CoreException {
        HashSet<IProjectFacetVersion> result = new HashSet<IProjectFacetVersion>();
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject != null) {
            for (IProjectFacetVersion facetVersion : facetedProject.getProjectFacets()) {
                String facetId = facetVersion.getProjectFacet().getId();
                if (!FacetUtilities.isWebSphereFacetId(facetId)) continue;
                result.add(facetVersion);
            }
        }
        return result;
    }
}

