/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.ui;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.faceted.project.wizard.contributions.configurations.AbstractTemplateConfigurationDelegate;
import com.ibm.faceted.project.wizard.contributions.configurations.DefaultDataModelBasedWizardPageConfigurationDelegate;
import com.ibm.faceted.project.wizard.contributions.configurations.DefaultWizardPageConfigurationDelegate;
import com.ibm.faceted.project.wizard.contributions.configurations.ui.slickui.DefaultSlickUiDescriptorComparator;
import com.ibm.faceted.project.wizard.contributions.configurations.ui.slickui.WizardPageSlickControlDescriptor;
import com.ibm.faceted.project.wizard.core.configuration.IContributionProjectManager;
import com.ibm.faceted.project.wizard.core.datamodel.wtpextensions.FacetedProjectWizardDataModelProvider;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.DefaultCoreFacetSetApprover;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.WizardLevelExtensionPointManager;
import com.ibm.faceted.project.wizard.core.internal.util.WebProjectFacetUtil;
import com.ibm.faceted.project.wizard.core.management.FacetSetUtil;
import com.ibm.faceted.project.wizard.core.management.IExtensionPointManager;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IConfigurationDelegate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSetApprover;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IFacetRange;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectWizardContribution;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ITemplateCategory;
import com.ibm.faceted.project.wizard.core.serviceability.Debugger;
import com.ibm.faceted.project.wizard.core.serviceability.Logger;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceabilityManager;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceablilityUtil;
import com.ibm.faceted.project.wizard.core.serviceability.Tracer;
import com.ibm.faceted.project.wizard.internal.management.ProjectConfigurationManager;
import com.ibm.faceted.project.wizard.internal.management.WizardImageManager;
import com.ibm.faceted.project.wizard.internal.management.extensionpts.DelegateUtil;
import com.ibm.faceted.project.wizard.internal.management.extensionpts.comparator.DefaultCoreFacetSetComparator;
import com.ibm.faceted.project.wizard.internal.management.extensionpts.comparator.DefaultProjectTemplateComparator;
import com.ibm.faceted.project.wizard.internal.management.extensionpts.comparator.DefaultTemplateCategoryComparator;
import com.ibm.faceted.project.wizard.internal.nls.Messages;
import com.ibm.faceted.project.wizard.internal.ui.pages.configuration.ConfigurationPage;
import com.ibm.faceted.project.wizard.internal.ui.pages.template.DefaultProjectTemplateUIProvider;
import com.ibm.faceted.project.wizard.internal.ui.pages.template.TemplateSelectionPage;
import com.ibm.faceted.project.wizard.management.IProjectConfigurationManager;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizardOptions;
import com.ibm.faceted.project.wizard.ui.IImageManager;
import com.ibm.faceted.project.wizard.ui.IProjectTemplateUIProvider;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFrameworkException;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.ProjectFacetsUiManager;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionDialog;
import org.eclipse.wst.web.internal.DelegateConfigurationElement;
import org.eclipse.wst.web.ui.internal.WSTWebUIPlugin;

public abstract class FacetedProjectWizard
extends Wizard
implements INewWizard,
IFacetProjectCreationDataModelProperties,
IFacetedProjectListener,
IContributionProjectManager,
ControlListener {
    private WizardImageManager imageManager;
    private static String LIST_SEPERATOR = ",";
    private static String KEY_VALUE_DELIMITOR = ":";
    private static String TEMPLATE_SELECTION_PAGE = "template.selection.page";
    private static String TEMPLETE_CONFIGURATION_PAGE = "configuration.page";
    private static String DIALOG_SETTING_KEY_CORE_FACET_SET = "coreFacetSet";
    private static String DIALOG_SETTING_KEY_PROJECT_TEMPLATE = "projectTemplate";
    private static String DIALOG_SETTING_KEY_RUNTIME = "primaryRuntime";
    private static String DIALOG_SETTING_KEY_PROJECT_FACETS = "projectFacets";
    private static String EMPTY = "";
    private static String FACETED_PROJECT_WIZARD_SETTINGS = "com.ibm.adapter.j2c.codegenFacetedProjectWizard";
    private IDataModel model = null;
    private IFacetedProjectWorkingCopy fpjwc;
    private Point currentWizardSize = new Point(575, 575);
    private ConfigurationPage configurationPage;
    private TemplateSelectionPage templateSelectionPage;
    private Layout layout;
    private ServiceabilityManager serviceabilityManger;
    private Tracer tracer;
    private Logger logger;
    private Debugger debugger;
    private Set<IConfigurationDelegate> allTemplateConfigurations;
    private WizardPageSlickControlDescriptor[] cachedDescriptors;
    private Map<IConfigurationDelegate, WizardPageSlickControlDescriptor> cachedDescriptorsMap;
    private Map<String, IFacetWizardPage> cachedWizardPages;
    private Map<IProjectFacetVersion, List<IFacetWizardPage>> facetToPagesMap;
    private Map<IFacetWizardPage, Object> facetPageToConfigMap;
    private Map<IFacetWizardPage, String> facetPageToFacetIdMap;
    private Map<String, IConfigurationDelegate> wizardPageToConfiguration;
    private List<IWizardPage> wizardPagesForNextButton;
    private Composite pageContainer;
    private SlickUIWizardContext wizardContext;
    private volatile boolean silenceEvents = false;
    private volatile boolean refreshingUI = false;
    private ProjectConfigurationManager projectConfigurationManager;
    private WizardLevelExtensionPointManager wizardLevelExtPtMgr;
    private boolean initComplete = false;
    private Comparator<ICoreFacetSet> defaultCoreFacetSetComparator;
    private Comparator<IProjectTemplate> defaultProjectTemplateComparator;
    private Comparator<ITemplateCategory> defaultTemplateCategoryComparator;
    private ICoreFacetSetApprover defaultCoreFacetSetApprover;
    private Comparator<WizardPageSlickControlDescriptor> defaultSlickUiDescriptorComparator;
    private boolean skipConfigurationPage;
    private IProjectTemplateUIProvider defaultProjectTemplateUIProvider;
    private FacetedProjectWizardOptions wizardOptions;

    public FacetedProjectWizard() {
        this.model = this.createDataModel();
        this.wizardOptions = new FacetedProjectWizardOptions();
        this.defaultCoreFacetSetComparator = new DefaultCoreFacetSetComparator();
        this.defaultProjectTemplateComparator = new DefaultProjectTemplateComparator();
        this.defaultTemplateCategoryComparator = new DefaultTemplateCategoryComparator();
        this.defaultSlickUiDescriptorComparator = new DefaultSlickUiDescriptorComparator();
        this.defaultCoreFacetSetApprover = new DefaultCoreFacetSetApprover();
        this.defaultProjectTemplateUIProvider = new DefaultProjectTemplateUIProvider();
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        this.wizardLevelExtPtMgr = new WizardLevelExtensionPointManager(this.getId());
        this.projectConfigurationManager = ProjectConfigurationManager.getInstance(this);
        IDialogSettings workbenchSettings = CodegenPlugin.getDefault().getDialogSettings();
        String wizardKey = String.valueOf(FACETED_PROJECT_WIZARD_SETTINGS) + "." + this.getId();
        IDialogSettings wizardSettings = workbenchSettings.getSection(wizardKey);
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection(wizardKey);
        }
        this.setDialogSettings(wizardSettings);
    }

    @Override
    public IStatus addFacetVersion(IProjectFacetVersion facetVersion) {
        IStatus status = this.projectConfigurationManager.addFacetVersion(facetVersion);
        if (status.getSeverity() != 4) {
            this.applyFacetChangesToModels(false, false);
        }
        return status;
    }

    public synchronized void addPages() {
        try {
            this.init();
            this.tracer.trace(Tracer.TraceType.WIZARD, "Loading faceted project wizard");
            this.templateSelectionPage = new TemplateSelectionPage(this.getDataModel(), TEMPLATE_SELECTION_PAGE, this.fpjwc);
            this.configurationPage = new ConfigurationPage(this.getDataModel(), TEMPLETE_CONFIGURATION_PAGE, this.fpjwc);
            this.fpjwc.addListener((IFacetedProjectListener)this, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED, IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED});
            this.addPage((IWizardPage)this.templateSelectionPage);
            this.addPage((IWizardPage)this.configurationPage);
            this.skipConfigurationPage = false;
            this.wizardPagesForNextButton.add((IWizardPage)this.templateSelectionPage);
            this.wizardPagesForNextButton.add((IWizardPage)this.configurationPage);
        }
        catch (CoreException e) {
            String message = "Failed to load wizard due to configuration errors: " + this.getClass().getCanonicalName();
            this.logger.logError(message, (Exception)((Object)e));
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public void addWorkingCopyListener(IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        this.fpjwc.addListener(listener, types);
    }

    private void applyFacetChangesToModels(boolean fireChangeEvents, boolean coreFacetSetChanged) {
        this.silenceEvents = true;
        try {
            this.projectConfigurationManager.applyFacetChangesToWorkingCopy(coreFacetSetChanged);
            if (this.configurationPage != null) {
                if (Thread.currentThread() == Display.getDefault().getThread()) {
                    this.configurationPage.updateValidationState();
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FacetedProjectWizard.this.configurationPage.updateValidationState();
                        }
                    });
                }
            }
            if (fireChangeEvents) {
                this.updateDataModelActionConfigObjects();
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        this.silenceEvents = false;
    }

    private Set<IProjectFacetVersion> calculateDefaultFacetVersionsForRuntimeChange(boolean updateCoreFacetVersions) {
        HashSet<IProjectFacetVersion> defaultFacetValues = new HashSet<IProjectFacetVersion>();
        Set<IProjectFacetVersion> currentFacetVersions = this.projectConfigurationManager.getProjectFacetVersions();
        Set<IFacetRange> coreFacetSet = this.projectConfigurationManager.getCoreFacetSet().getFacets();
        HashSet<IProjectFacet> coreFacets = new HashSet<IProjectFacet>();
        for (IFacetRange facetRange : coreFacetSet) {
            coreFacets.add(facetRange.getProjectFacet());
        }
        for (IProjectFacetVersion projectFacetVersion : currentFacetVersions) {
            if (updateCoreFacetVersions && coreFacets.contains(projectFacetVersion.getProjectFacet())) continue;
            defaultFacetValues.add(projectFacetVersion);
        }
        return defaultFacetValues;
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!(this.skipConfigurationPage && pages[i].equals(this.configurationPage) || pages[i].isPageComplete())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void changeCoreFacetSet(final ICoreFacetSet newCoreFacetSet) {
        if (this.onUiThread()) {
            this.doChangeCoreFacetSet(newCoreFacetSet);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FacetedProjectWizard.this.doChangeCoreFacetSet(newCoreFacetSet);
                }
            });
        }
    }

    @Override
    public IStatus changeFacetVersion(IProjectFacetVersion facetVersion) {
        return this.changeFacetVersion(facetVersion, false);
    }

    @Override
    public IStatus changeFacetVersion(final IProjectFacetVersion facetVersion, final boolean refreshUI) {
        if (this.onUiThread()) {
            return this.doChangeFacetVersion(facetVersion, refreshUI);
        }
        final IStatus[] result = new IStatus[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = FacetedProjectWizard.this.doChangeFacetVersion(facetVersion, refreshUI);
            }
        });
        return result[0];
    }

    public void changeProjectTemplate(IProjectTemplate newTemplate) {
        this.changeProjectTemplate(newTemplate, false);
    }

    public void changeProjectTemplate(final IProjectTemplate newTemplate, final boolean force) {
        if (this.onUiThread()) {
            this.doChangeProjectTemplate(newTemplate, force);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FacetedProjectWizard.this.doChangeProjectTemplate(newTemplate, force);
                }
            });
        }
    }

    @Override
    public IStatus changeRuntime(final IRuntime newRuntime, final boolean updateCoreFacetVersions) {
        if (this.onUiThread()) {
            return this.doChangeRuntime(newRuntime, updateCoreFacetVersions);
        }
        final IStatus[] result = new IStatus[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = FacetedProjectWizard.this.doChangeRuntime(newRuntime, updateCoreFacetVersions);
            }
        });
        return result[0];
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        Point size = this.getShell().getSize();
        this.currentWizardSize.x = size.x;
        this.currentWizardSize.y = size.y;
    }

    protected IDataModel createDataModel() {
        IDataModel wizardDataModel = DataModelFactory.createDataModel((IDataModelProvider)new FacetedProjectWizardDataModelProvider(this));
        wizardDataModel.setProperty("IEnhancedFacetDataModelProperties.PROJECT_CONFIGURATION_MANAGER", (Object)this);
        wizardDataModel.setProperty("IEnhancedFacetDataModelProperties.WIZARD_ID", (Object)this.getId());
        return wizardDataModel;
    }

    public void createPageControls(Composite container) {
        this.pageContainer = container;
        this.layout = container.getLayout();
        this.templateSelectionPage.createControl(this.pageContainer);
        this.configurationPage.createControl(this.pageContainer);
        this.templateSelectionPage.initializeFirstSelection();
        this.changeProjectTemplate(this.projectConfigurationManager.getProjectTemplate(), true);
        this.getShell().addControlListener((ControlListener)this);
        this.initComplete = true;
    }

    private void createWizardDescriptor(IConfigurationDelegate templateConfiguration, IFacetWizardPage facetPage) {
        WizardPageSlickControlDescriptor cachedDescriptor = null;
        try {
            String message;
            cachedDescriptor = new WizardPageSlickControlDescriptor(this, templateConfiguration);
            this.cachedDescriptorsMap.put(templateConfiguration, cachedDescriptor);
            AbstractTemplateConfigurationDelegate delegate = cachedDescriptor.getConfigurationDelegate();
            delegate.setWizard((IWizard)this);
            delegate.setDataModel(this.getDataModel());
            delegate.setProjectManager(this);
            delegate.setLayout(this.layout);
            if (templateConfiguration.isWizardConfigration() && facetPage != null) {
                DefaultWizardPageConfigurationDelegate wizardPageDelegate = (DefaultWizardPageConfigurationDelegate)delegate;
                wizardPageDelegate.setWizardPage(facetPage);
                wizardPageDelegate.setFacetId(this.facetPageToFacetIdMap.get(facetPage));
                Object config = this.facetPageToConfigMap.get(facetPage);
                if (config instanceof IDataModel && delegate instanceof DefaultDataModelBasedWizardPageConfigurationDelegate) {
                    DefaultDataModelBasedWizardPageConfigurationDelegate dataModelPageDelegate = (DefaultDataModelBasedWizardPageConfigurationDelegate)delegate;
                    dataModelPageDelegate.setFacetDataModel((IDataModel)config);
                }
            }
            delegate.init();
            if (!delegate.shouldShow(delegate.getDataModel())) {
                this.cachedDescriptorsMap.remove(templateConfiguration);
                if (this.tracer.isEnabled()) {
                    message = "Created descriptor for template configuration (but shouldShow was false so removed it again): " + templateConfiguration.getId();
                    if (templateConfiguration.isWizardConfigration()) {
                        message = String.valueOf(message) + ": wraps wizard page (" + templateConfiguration.getWizardClassName() + ")";
                    }
                    this.tracer.trace(Tracer.TraceType.WIZARD, message);
                }
            } else {
                delegate.addValidationStateChangedListener(this.configurationPage);
                delegate.updateValidationState();
                if (this.tracer.isEnabled()) {
                    message = "Created descriptor for template configuration: " + templateConfiguration.getId();
                    if (templateConfiguration.isWizardConfigration()) {
                        message = String.valueOf(message) + ": wraps wizard page (" + templateConfiguration.getWizardClassName() + ")";
                    }
                    this.tracer.trace(Tracer.TraceType.WIZARD, message);
                }
            }
        }
        catch (Exception e) {
            this.logger.logContributorError(templateConfiguration, "Could not create instanceof " + templateConfiguration.getDelegateClassName(), e);
        }
    }

    private UiChange createWizardDescriptors() {
        UiChange changed = UiChange.NONE;
        for (IConfigurationDelegate templateConfiguration : this.allTemplateConfigurations) {
            if (!templateConfiguration.isEnabled(this) || this.cachedDescriptorsMap.containsKey(templateConfiguration)) continue;
            boolean success = false;
            boolean shouldNotShow = false;
            if (templateConfiguration.isWizardConfigration()) {
                if (!templateConfiguration.isHidden()) {
                    IFacetWizardPage facetPage;
                    String wizardClassName;
                    String string = wizardClassName = templateConfiguration.hasOverrideWizardClass() ? templateConfiguration.getOverrideWizardClassName() : templateConfiguration.getWizardClassName();
                    if (wizardClassName != null && !wizardClassName.isEmpty() && (facetPage = this.cachedWizardPages.get(wizardClassName)) != null) {
                        this.createWizardDescriptor(templateConfiguration, facetPage);
                        success = this.cachedDescriptorsMap.containsKey(templateConfiguration);
                        if (!success) {
                            shouldNotShow = true;
                            this.removeWizardPage(facetPage, "Removing wizard page because descriptor was not created (because its shouldShow returned false): " + facetPage.getClass().getCanonicalName());
                        }
                    }
                } else {
                    this.createWizardDescriptor(templateConfiguration, null);
                    success = true;
                }
            } else {
                this.createWizardDescriptor(templateConfiguration, null);
                success = true;
            }
            if (success) {
                changed = UiChange.DESCRIPTOR;
            }
            if (success) continue;
            if (shouldNotShow) {
                changed = changed == UiChange.NONE ? UiChange.WIZARD_PAGE : UiChange.BOTH;
                continue;
            }
            String message = NLS.bind((String)"Could not create configuration with id {0}", (Object)templateConfiguration.getId());
            this.logger.logContributorError(templateConfiguration, "Could not create Slick UI wizard descriptor.  Configuration was invalid.  " + message);
        }
        if (changed == UiChange.DESCRIPTOR || changed == UiChange.BOTH) {
            this.refreshSlickUIDescriptorCache();
        }
        return changed;
    }

    private synchronized UiChange createWizardPages() {
        Set actions = this.fpjwc.getProjectFacetActions();
        ArrayList sortedActions = new ArrayList(actions);
        HashSet base = new HashSet();
        ProjectFacetsManager.sort(base, sortedActions);
        UiChange changed = UiChange.NONE;
        for (IFacetedProject.Action action : sortedActions) {
            IActionDefinition actiondef;
            IProjectFacetVersion fv = action.getProjectFacetVersion();
            List<IFacetWizardPage> existingPageList = this.facetToPagesMap.get(fv);
            if (existingPageList != null) continue;
            try {
                actiondef = fv.getActionDefinition(base, action.getType());
            }
            catch (CoreException e) {
                this.logger.logException((Exception)((Object)e));
                continue;
            }
            List pages = ProjectFacetsUiManager.getWizardPages((String)actiondef.getId());
            if (pages.isEmpty()) continue;
            this.facetToPagesMap.put(fv, new ArrayList(pages));
            boolean facetPagesAllSucceeded = true;
            for (IFacetWizardPage page : pages) {
                IFacetWizardPage overridePage;
                this.tracer.trace(Tracer.TraceType.WIZARD, "Creating wizard page class: " + page.getClass().getCanonicalName());
                this.cachedWizardPages.put(page.getClass().getCanonicalName(), page);
                page.setWizard((IWizard)this);
                page.setWizardContext((IWizardContext)this.wizardContext);
                Object config = action.getConfig();
                page.setConfig(config);
                if (config != null) {
                    this.facetPageToConfigMap.put(page, config);
                }
                this.facetPageToFacetIdMap.put(page, fv.getProjectFacet().getId());
                IConfigurationDelegate templateConfiguration = this.wizardPageToConfiguration.get(page.getClass().getCanonicalName());
                if (page.getControl() != null) continue;
                if (templateConfiguration == null) {
                    this.tracer.trace(Tracer.TraceType.WIZARD, "Initializing wizard page controls (not wrapped in slickui): " + page.getClass().getCanonicalName());
                    try {
                        page.createControl(this.pageContainer);
                        page.getControl().setVisible(false);
                    }
                    catch (Exception e) {
                        this.logger.logError(NLS.bind((String)"Wizard page creation failed:  {0} \nFacet cannot be installed: {1}", (Object[])new String[]{page.getClass().getCanonicalName(), fv.getProjectFacet().getId()}), e);
                        facetPagesAllSucceeded = false;
                    }
                    this.wizardPagesForNextButton.add((IWizardPage)page);
                    changed = UiChange.WIZARD_PAGE;
                    continue;
                }
                if (!templateConfiguration.isHidden() && !templateConfiguration.hasOverrideWizardClass()) continue;
                this.removeWizardPage(fv, page, "Configuration Delegate is hidden or has wizard override class");
                if (!templateConfiguration.hasOverrideWizardClass() || (overridePage = DelegateUtil.createConfigurationDelegateOverrideClass(templateConfiguration)) == null) continue;
                this.cachedWizardPages.put(overridePage.getClass().getCanonicalName(), overridePage);
                overridePage.setWizard((IWizard)this);
                overridePage.setWizardContext((IWizardContext)this.wizardContext);
                overridePage.setConfig(config);
                if (config != null) {
                    this.facetPageToConfigMap.put(page, config);
                }
                this.facetPageToFacetIdMap.put(overridePage, fv.getProjectFacet().getId());
                List<IFacetWizardPage> facetPages = this.facetToPagesMap.get(fv);
                if (facetPages == null) {
                    facetPages = new ArrayList<IFacetWizardPage>();
                    this.facetToPagesMap.put(fv, facetPages);
                }
                facetPages.add(overridePage);
            }
            if (facetPagesAllSucceeded) continue;
            List<IFacetWizardPage> facetPages = this.facetToPagesMap.get(fv);
            if (facetPages != null) {
                ArrayList<IFacetWizardPage> copyOfFacetPagesList = new ArrayList<IFacetWizardPage>(facetPages);
                for (IFacetWizardPage facetPage : copyOfFacetPagesList) {
                    this.removeWizardPage(fv, facetPage, "All facet wizard pages could not be created so removing facet.");
                }
            }
            this.removeFacet(fv.getProjectFacet().getId());
        }
        return changed;
    }

    public synchronized void dispose() {
        this.getShell().removeControlListener((ControlListener)this);
        this.configurationPage.dispose();
        this.templateSelectionPage.dispose();
        this.configurationPage = null;
        this.templateSelectionPage = null;
        this.layout = null;
        this.allTemplateConfigurations = null;
        this.cachedDescriptors = null;
        this.cachedDescriptorsMap = null;
        this.cachedWizardPages = null;
        this.facetToPagesMap = null;
        this.wizardPageToConfiguration = null;
        this.wizardContext = null;
        this.wizardPagesForNextButton = null;
        this.facetPageToConfigMap = null;
        this.facetPageToFacetIdMap = null;
        this.projectConfigurationManager.dispose();
        this.wizardLevelExtPtMgr.dispose();
        this.imageManager.dispose();
        super.dispose();
    }

    private void doChangeCoreFacetSet(ICoreFacetSet newCoreFacetSet) {
        if (!this.initComplete) {
            return;
        }
        try {
            this.tracer.trace(Tracer.TraceType.WIZARD, "Setting new core facet. Facet ID: " + newCoreFacetSet.getId() + newCoreFacetSet.getDescription());
            if (!newCoreFacetSet.equals(this.projectConfigurationManager.getCoreFacetSet())) {
                this.silenceEvents = true;
                this.projectConfigurationManager.changeCoreFacetSet(newCoreFacetSet);
                this.silenceEvents = false;
                UiChange change = this.removeWizardPages();
                change = this.mergeChange(change, this.removeWizardDescriptors());
                this.refreshUI(change, true);
                change = UiChange.NONE;
                this.applyFacetChangesToModels(true, true);
                change = this.mergeChange(change, this.createWizardPages());
                change = this.mergeChange(change, this.createWizardDescriptors());
                this.refreshUI(change, true);
                change = this.removeUiWhichFailedToCreateContent();
                this.refreshUI(change, true);
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    private IStatus doChangeFacetVersion(IProjectFacetVersion facetVersion, boolean refreshUI) {
        IStatus status = this.projectConfigurationManager.changeFacetVersion(facetVersion);
        if (status.getSeverity() != 4) {
            if (refreshUI) {
                UiChange change = this.removeWizardPages();
                change = this.mergeChange(change, this.removeWizardDescriptors());
                this.refreshUI(change, false);
                change = UiChange.NONE;
                this.applyFacetChangesToModels(false, false);
                change = this.mergeChange(change, this.createWizardPages());
                change = this.mergeChange(change, this.createWizardDescriptors());
                this.refreshUI(change, false);
                change = this.removeUiWhichFailedToCreateContent();
                this.refreshUI(change, true);
            } else {
                this.applyFacetChangesToModels(false, false);
            }
        }
        return status;
    }

    private void doChangeProjectTemplate(IProjectTemplate newTemplate, boolean force) {
        if (!this.initComplete && !force) {
            return;
        }
        try {
            this.debugger.debug(Debugger.DebugType.WIZARD, "Being projectTemplateSelectionChange(). Changing the Project Template. Template ID: " + newTemplate.getId() + newTemplate.getDescription());
            if (!newTemplate.equals(this.projectConfigurationManager.getProjectTemplate()) || force) {
                this.silenceEvents = true;
                boolean coreFacetSetChanged = this.projectConfigurationManager.changeProjectTemplate(newTemplate, force ? this.projectConfigurationManager.getProjectFacetVersions() : null);
                this.silenceEvents = false;
                UiChange change = this.removeWizardPages();
                change = this.mergeChange(change, this.removeWizardDescriptors());
                this.refreshUI(change, true);
                change = UiChange.NONE;
                this.applyFacetChangesToModels(true, coreFacetSetChanged);
                change = this.mergeChange(change, this.createWizardPages());
                change = this.mergeChange(change, this.createWizardDescriptors());
                this.refreshUI(change, true);
                change = this.removeUiWhichFailedToCreateContent();
                this.refreshUI(change, true);
            }
            this.debugger.debug(Debugger.DebugType.WIZARD, "End projectTemplateSelectionChange(). ");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    private IStatus doChangeRuntime(IRuntime newRuntime, boolean updateCoreFacetVersions) {
        IStatus result = Status.OK_STATUS;
        try {
            result = this.projectConfigurationManager.changeRuntime(newRuntime, this.calculateDefaultFacetVersionsForRuntimeChange(updateCoreFacetVersions));
            if (result.getSeverity() != 4) {
                UiChange change = this.removeWizardPages();
                change = this.mergeChange(change, this.removeWizardDescriptors());
                this.refreshUI(change, false);
                change = UiChange.NONE;
                this.applyFacetChangesToModels(false, false);
                change = this.mergeChange(change, this.createWizardPages());
                change = this.mergeChange(change, this.createWizardDescriptors());
                this.refreshUI(change, false);
                change = this.removeUiWhichFailedToCreateContent();
                this.refreshUI(change, true);
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        return result;
    }

    private void doUpdateSelectedProjectTemplate(Set<IProjectFacetVersion> newProjectFacetVersions, Set<IProjectFacet> fixedProjectFacets) {
        try {
            this.tracer.trace(Tracer.TraceType.WIZARD, "Updating project template");
            boolean changed = this.projectConfigurationManager.updateCurrentProjectTemplateFacets(newProjectFacetVersions, fixedProjectFacets);
            this.updateDataModelActionConfigObjects();
            this.configurationPage.updateValidationState();
            if (changed) {
                UiChange change = this.removeWizardPages();
                change = this.mergeChange(change, this.removeWizardDescriptors());
                change = this.mergeChange(change, this.createWizardPages());
                change = this.mergeChange(change, this.createWizardDescriptors());
                this.refreshUI(change, false);
                change = this.removeUiWhichFailedToCreateContent();
                this.refreshUI(change, true);
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    private boolean equal(IRuntime runtime1, IRuntime runtime2) {
        if (runtime1 == null && runtime2 == null) {
            return true;
        }
        if (runtime1 != null && runtime1.equals(runtime2)) {
            return true;
        }
        return runtime2 != null && runtime2.equals(runtime1);
    }

    @Override
    public ICoreFacetSet getCoreFacetSet() {
        return this.projectConfigurationManager.getCoreFacetSet();
    }

    public ICoreFacetSetApprover getCoreFacetSetApprover() {
        return this.defaultCoreFacetSetApprover;
    }

    public Comparator<ICoreFacetSet> getCoreFacetSetComparator() {
        return this.defaultCoreFacetSetComparator;
    }

    public String getCoreFacetSetHeadingLabel() {
        return Messages.ProjectTemplateUiManager_ProgrammingModelLabel;
    }

    public IDataModel getDataModel() {
        return this.model;
    }

    public String getDefaultCategoryLabel() {
        return Messages.FacetedProjectWizard_DefaultCategory;
    }

    public Image getDefaultConfigurationDelegateIcon() {
        try {
            return this.imageManager.getImage("com.ibm.adapter.j2c.codegen", "icons/size16/default_option.gif");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ICoreFacetSet getDefaultCoreFacetSetForProjectTemplate(IProjectTemplate projectTemplate) {
        Set<ICoreFacetSet> unsortedPMSet = this.wizardLevelExtPtMgr.getCoreFacetSetsForTemplate(projectTemplate);
        ArrayList<ICoreFacetSet> sortedCoreFacetSetListForTemplate = new ArrayList<ICoreFacetSet>(unsortedPMSet);
        Collections.sort(sortedCoreFacetSetListForTemplate, this.getCoreFacetSetComparator());
        if (!sortedCoreFacetSetListForTemplate.isEmpty()) {
            return (ICoreFacetSet)sortedCoreFacetSetListForTemplate.get(0);
        }
        return null;
    }

    protected ICoreFacetSet getDefaultCoreFacetSetFromSettings(IProjectTemplate initialTemplate) {
        ICoreFacetSet coreFacetSet;
        String value;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (initialTemplate != null && (value = dialogSettings.get(DIALOG_SETTING_KEY_CORE_FACET_SET)) != null && !value.isEmpty() && (coreFacetSet = this.wizardLevelExtPtMgr.getCoreFacetSetById(value)) != null && this.wizardLevelExtPtMgr.getCoreFacetSetsForTemplate(initialTemplate).contains(coreFacetSet)) {
            return coreFacetSet;
        }
        dialogSettings.put(DIALOG_SETTING_KEY_CORE_FACET_SET, EMPTY);
        return null;
    }

    protected Map<ICoreFacetSet, IRuntime> getDefaultCoreFacetSetToRuntimeMapFromSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        String value = dialogSettings.get(DIALOG_SETTING_KEY_RUNTIME);
        HashMap<ICoreFacetSet, Object> result = new HashMap<ICoreFacetSet, IRuntime>();
        if (value != null) {
            String[] coreFacetSetRuntimePairs = value.split(LIST_SEPERATOR);
            boolean errorState = false;
            String[] stringArray = coreFacetSetRuntimePairs;
            int n = coreFacetSetRuntimePairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                if (errorState) break;
                String[] pieces = pair.split(KEY_VALUE_DELIMITOR);
                if (pieces.length == 2) {
                    ICoreFacetSet coreFacetSet = this.wizardLevelExtPtMgr.getCoreFacetSetById(pieces[0]);
                    if (coreFacetSet != null) {
                        String runtimeName = pieces[1];
                        if (runtimeName != null && !runtimeName.isEmpty() && RuntimeManager.isRuntimeDefined((String)runtimeName)) {
                            IRuntime runtime = RuntimeManager.getRuntime((String)runtimeName);
                            if (runtime != null) {
                                result.put(coreFacetSet, runtime);
                            } else {
                                errorState = true;
                            }
                        } else {
                            errorState = true;
                        }
                    } else {
                        errorState = true;
                    }
                } else {
                    errorState = true;
                }
                ++n2;
            }
            if (errorState) {
                dialogSettings.put(DIALOG_SETTING_KEY_RUNTIME, EMPTY);
                result = new HashMap();
            }
        }
        return result;
    }

    protected Set<IProjectFacetVersion> getDefaultProjectFacetVersionsFromSettings(IProjectTemplate projectTemplate, ICoreFacetSet coreFacetSet, IRuntime runtime) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (projectTemplate != null && coreFacetSet != null) {
            String[] facetValuePairs;
            String value = dialogSettings.get(DIALOG_SETTING_KEY_PROJECT_FACETS);
            HashSet<IProjectFacetVersion> result = null;
            if (value != null && !value.isEmpty() && (facetValuePairs = value.split(LIST_SEPERATOR)) != null) {
                result = new HashSet<IProjectFacetVersion>();
                boolean isValid = true;
                String[] stringArray = facetValuePairs;
                int n = facetValuePairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String facetValuePair = stringArray[n2];
                    String[] pieces = facetValuePair.split(KEY_VALUE_DELIMITOR);
                    if (pieces == null || pieces.length != 2) {
                        isValid = false;
                        break;
                    }
                    String facetId = pieces[0];
                    String facetVersion = pieces[1];
                    IProjectFacetVersion projectFacetVersion = WebProjectFacetUtil.getProjectFacetVersion(facetId, facetVersion);
                    if (projectFacetVersion == null) {
                        isValid = false;
                        break;
                    }
                    result.add(projectFacetVersion);
                    ++n2;
                }
                if (isValid) {
                    Map<IProjectFacet, Set<IProjectFacetVersion>> unionOfTemplateAndCoreFacetSet = FacetSetUtil.mergeOfTemplateAndCoreFacetSet(projectTemplate, coreFacetSet);
                    if (result.size() == unionOfTemplateAndCoreFacetSet.size()) {
                        for (IProjectFacetVersion projectFacetVersion : result) {
                            Set<IProjectFacetVersion> versionSet = unionOfTemplateAndCoreFacetSet.get(projectFacetVersion.getProjectFacet());
                            if (versionSet != null && versionSet.contains(projectFacetVersion) && (runtime == null || runtime.supports(projectFacetVersion))) continue;
                            isValid = false;
                            break;
                        }
                    }
                } else {
                    isValid = false;
                }
                if (!isValid) {
                    result = null;
                } else {
                    return result;
                }
            }
        }
        dialogSettings.put(DIALOG_SETTING_KEY_PROJECT_FACETS, EMPTY);
        return null;
    }

    public IProjectTemplate getDefaultProjectTemplate() {
        IProjectTemplate result = null;
        Set<IProjectTemplate> projectTemplates = this.wizardLevelExtPtMgr.getProjectTemplates();
        if (projectTemplates != null && !projectTemplates.isEmpty()) {
            ArrayList<IProjectTemplate> sortedTemplates = new ArrayList<IProjectTemplate>(projectTemplates);
            Collections.sort(sortedTemplates, this.getProjectTemplateComparator());
            result = (IProjectTemplate)sortedTemplates.get(0);
        }
        return result;
    }

    protected IProjectTemplate getDefaultProjectTemplateFromSettings() {
        IProjectTemplate projectTemplate;
        IDialogSettings dialogSettings = this.getDialogSettings();
        String value = dialogSettings.get(DIALOG_SETTING_KEY_PROJECT_TEMPLATE);
        if (value != null && !value.isEmpty() && (projectTemplate = this.wizardLevelExtPtMgr.getProjectTemplateById(value)) != null) {
            return projectTemplate;
        }
        dialogSettings.put(DIALOG_SETTING_KEY_PROJECT_TEMPLATE, EMPTY);
        return null;
    }

    public Image getDefaultProjectTemplateIcon() {
        try {
            return this.imageManager.getImage("com.ibm.adapter.j2c.codegen", "icons/size16/default_option.gif");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public WizardPageSlickControlDescriptor getDescriptorForTemplateConfiguration(String tcId) {
        if (tcId == null) {
            return null;
        }
        for (IConfigurationDelegate templateConfiguration : this.cachedDescriptorsMap.keySet()) {
            if (!templateConfiguration.getId().equals(tcId)) continue;
            return this.cachedDescriptorsMap.get(templateConfiguration);
        }
        return null;
    }

    public final IExtensionPointManager getExtensionPointManager() {
        return this.wizardLevelExtPtMgr;
    }

    @Override
    public Object getFacetConfig(String facetId) {
        IProjectFacet pf = WebProjectFacetUtil.getProjectFacet(facetId);
        IFacetedProject.Action action = this.fpjwc.getProjectFacetAction(pf);
        if (action != null) {
            return action.getConfig();
        }
        return null;
    }

    @Override
    public IDataModel getFacetDataModel(String facetId) {
        Object config = this.getFacetConfig(facetId);
        if (!(config instanceof IDataModel) && config != null) {
            config = Platform.getAdapterManager().loadAdapter(config, IDataModel.class.getName());
        }
        IDataModel dm = (IDataModel)config;
        return dm;
    }

    IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return this.fpjwc;
    }

    protected String getFinalPerspectiveID() {
        return null;
    }

    @Override
    public Set<IProjectFacet> getFixedProjectFacets() {
        return this.projectConfigurationManager.getFixedProjectFacets();
    }

    public abstract String getId();

    public IImageManager getImageManager() {
        return this.imageManager;
    }

    @Override
    public Set<IProjectFacetVersion> getIncompatibleFacets(IRuntime newRuntime, boolean updateCoreFacetVersions) {
        return this.projectConfigurationManager.getIncompatibleFacets(newRuntime, this.calculateDefaultFacetVersionsForRuntimeChange(updateCoreFacetVersions));
    }

    public synchronized IWizardPage getNextPage(IWizardPage page) {
        int padding;
        IWizardPage[] pages = this.getPages();
        int pos = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                pos = i;
            }
            ++i;
        }
        int n = padding = this.skipConfigurationPage && page.equals((Object)this.templateSelectionPage) ? 1 : 0;
        if (pos == pages.length - (1 + padding)) {
            return null;
        }
        return pages[pos + (1 + padding)];
    }

    public FacetedProjectWizardOptions getOptions() {
        return this.wizardOptions;
    }

    public IWizardPage getPage(String pageName) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page.getName().equals(pageName)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.getPages().length;
    }

    public synchronized IWizardPage[] getPages() {
        return this.wizardPagesForNextButton.toArray(new IWizardPage[0]);
    }

    public synchronized IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int pos = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                pos = i;
            }
            ++i;
        }
        if (pos == 0) {
            return null;
        }
        IWizardPage previousPage = pages[pos - 1];
        if (previousPage.equals(this.configurationPage) && this.skipConfigurationPage) {
            return this.templateSelectionPage;
        }
        return previousPage;
    }

    public final IProjectConfigurationManager getProjectConfigurationManager() {
        return this.projectConfigurationManager;
    }

    @Override
    public Set<IProjectFacetVersion> getProjectFacetVersions() {
        return this.projectConfigurationManager.getProjectFacetVersions();
    }

    @Override
    public String getProjectName() {
        if (this.initComplete && this.fpjwc != null) {
            return this.fpjwc.getProjectName();
        }
        return null;
    }

    @Override
    public IProjectTemplate getProjectTemplate() {
        return this.projectConfigurationManager.getProjectTemplate();
    }

    public Comparator<IProjectTemplate> getProjectTemplateComparator() {
        return this.defaultProjectTemplateComparator;
    }

    public IProjectTemplateUIProvider getProjectTemplateUIProvider() {
        return this.defaultProjectTemplateUIProvider;
    }

    @Override
    public IRuntime getRuntime() {
        return this.fpjwc.getPrimaryRuntime();
    }

    private Comparator<WizardPageSlickControlDescriptor> getSlickControlDescriptorComparator() {
        return this.defaultSlickUiDescriptorComparator;
    }

    public synchronized WizardPageSlickControlDescriptor[] getSlickControlDescriptors() {
        return this.cachedDescriptors;
    }

    public Comparator<ITemplateCategory> getTemplateCategoryComparator() {
        return this.defaultTemplateCategoryComparator;
    }

    public abstract String getTemplateSelectionPageDescription();

    public abstract String getTemplateSelectionPageTitle();

    public ImageDescriptor getWizardBannerImageDescriptor() {
        return null;
    }

    public void handleEvent(IFacetedProjectEvent event) {
        if (!this.silenceEvents) {
            final IFacetedProjectWorkingCopy workingCopy = this.fpjwc;
            if (event.getType() == IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED) {
                if (this.fpjwc.validate().getSeverity() != 4) {
                    this.updateSelectedProjectTemplate(workingCopy.getProjectFacets(), workingCopy.getFixedProjectFacets());
                    this.updateDataModelActionConfigObjects();
                }
            } else if (event.getType() == IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FacetedProjectWizard.this.changeRuntime(workingCopy.getPrimaryRuntime(), false);
                    }
                };
                if (Display.getDefault().getThread() == Thread.currentThread()) {
                    runnable.run();
                } else {
                    Display.getDefault().asyncExec(runnable);
                }
            }
        }
    }

    @Override
    public boolean hasFacet(String facetId) {
        return this.projectConfigurationManager.hasFacet(facetId);
    }

    @Override
    public boolean hasFacetVersion(IProjectFacetVersion facetVersion) {
        return this.projectConfigurationManager.hasFacetVersion(facetVersion);
    }

    protected synchronized void init() throws CoreException {
        this.serviceabilityManger = ServiceablilityUtil.getServiceabilityManager();
        this.tracer = this.serviceabilityManger.getTracer();
        this.logger = this.serviceabilityManger.getLogger();
        this.debugger = this.serviceabilityManger.getDebugger();
        this.wizardLevelExtPtMgr.setCoreFacetSetApprover(this.getCoreFacetSetApprover());
        this.validateWizardConfiguration();
        this.imageManager = new WizardImageManager();
        IProjectTemplate initialTemplate = this.getDefaultProjectTemplateFromSettings();
        ICoreFacetSet initialCoreFacetSet = this.getDefaultCoreFacetSetFromSettings(initialTemplate);
        Map<ICoreFacetSet, IRuntime> initialRuntimeMap = this.getDefaultCoreFacetSetToRuntimeMapFromSettings();
        IRuntime initialRuntime = initialCoreFacetSet != null ? initialRuntimeMap.get(initialCoreFacetSet) : null;
        Set<IProjectFacetVersion> initialProjectFacetVersions = this.getDefaultProjectFacetVersionsFromSettings(initialTemplate, initialCoreFacetSet, initialRuntime);
        this.projectConfigurationManager.init(initialTemplate, initialCoreFacetSet, initialRuntimeMap, initialProjectFacetVersions);
        this.applyFacetChangesToModels(true, true);
        this.cachedDescriptors = new WizardPageSlickControlDescriptor[0];
        this.cachedDescriptorsMap = new HashMap<IConfigurationDelegate, WizardPageSlickControlDescriptor>();
        this.cachedWizardPages = new HashMap<String, IFacetWizardPage>();
        this.facetToPagesMap = new HashMap<IProjectFacetVersion, List<IFacetWizardPage>>();
        this.facetPageToConfigMap = new HashMap<IFacetWizardPage, Object>();
        this.facetPageToFacetIdMap = new HashMap<IFacetWizardPage, String>();
        this.allTemplateConfigurations = this.wizardLevelExtPtMgr.getConfigurationDelegates();
        this.wizardPageToConfiguration = new HashMap<String, IConfigurationDelegate>();
        for (IConfigurationDelegate tc : this.allTemplateConfigurations) {
            String wizardClassName;
            if (!tc.isWizardConfigration() || (wizardClassName = tc.getWizardClassName()) == null || wizardClassName.isEmpty()) continue;
            if (!this.wizardPageToConfiguration.containsKey(wizardClassName)) {
                this.wizardPageToConfiguration.put(wizardClassName, tc);
                continue;
            }
            this.logger.logContributorError(tc, "Multiple configurations map to " + wizardClassName + ". Dropping configuration: " + tc.getId());
        }
        this.wizardPagesForNextButton = new ArrayList<IWizardPage>();
        this.wizardContext = new SlickUIWizardContext();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean isInitComplete() {
        return this.initComplete;
    }

    public void launchFacetSelectionDialog() {
        this.tracer.trace(Tracer.TraceType.WIZARD, "Launching facet selection Dialog");
        this.silenceEvents = true;
        IFacetedProjectWorkingCopy workingCopy = this.fpjwc;
        FacetsSelectionDialog.openDialog((Shell)this.getShell(), (IFacetedProjectWorkingCopy)this.fpjwc);
        this.updateSelectedProjectTemplate(workingCopy.getProjectFacets(), workingCopy.getFixedProjectFacets());
        this.silenceEvents = false;
        this.tracer.trace(Tracer.TraceType.WIZARD, "Closing facet selection Dialog");
    }

    private UiChange mergeChange(UiChange change, UiChange newChange) {
        UiChange result = change;
        result = change == UiChange.BOTH ? change : (newChange == UiChange.BOTH ? newChange : (change == newChange ? change : (change == UiChange.NONE ? newChange : UiChange.BOTH)));
        return result;
    }

    private boolean onUiThread() {
        return Display.getDefault().getThread() == Thread.currentThread();
    }

    public boolean performFinish() {
        this.fpjwc.removeListener((IFacetedProjectListener)this);
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IFacetWizardPage) {
                IFacetWizardPage fp = (IFacetWizardPage)page;
                fp.transferStateToConfig();
            } else if (page instanceof DataModelWizardPage) {
                ((DataModelWizardPage)page).storeDefaultSettings();
            }
            ++n2;
        }
        final IWorkspaceRunnable projectCreationWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int facetActionCount = FacetedProjectWizard.this.fpjwc.getProjectFacetActions().size();
                int actionCount = FacetedProjectWizard.this.cachedDescriptorsMap != null ? FacetedProjectWizard.this.cachedDescriptorsMap.size() + facetActionCount : facetActionCount;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)actionCount);
                try {
                    FacetedProjectWizard.this.fpjwc.commitChanges((IProgressMonitor)subMonitor.newChild(facetActionCount));
                    if (FacetedProjectWizard.this.cachedDescriptorsMap != null) {
                        for (Map.Entry entry : FacetedProjectWizard.this.cachedDescriptorsMap.entrySet()) {
                            try {
                                AbstractTemplateConfigurationDelegate delegate = ((WizardPageSlickControlDescriptor)entry.getValue()).getConfigurationDelegate();
                                if (delegate == null || delegate.isDisposed()) continue;
                                delegate.execute((IProgressMonitor)subMonitor.newChild(1));
                            }
                            catch (Exception exception) {
                                FacetedProjectWizard.this.logger.logContributorError((IProjectWizardContribution)entry.getKey(), "Failure while running 'execute' method.");
                            }
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        IRunnableWithProgress projectCreationRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(projectCreationWorkspaceRunnable, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, false, projectCreationRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof CoreException) {
                Throwable cause;
                IStatus st = ((CoreException)te).getStatus();
                String msg = st.getMessage();
                if (!(te instanceof FacetedProjectFrameworkException) || !((FacetedProjectFrameworkException)te).isExpected()) {
                    CodegenPlugin.getDefault().getLog().log(st);
                }
                if ((cause = st.getException()) instanceof CoreException) {
                    st = ((CoreException)cause).getStatus();
                }
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ProjectFacetWizard_ErrorDialogTitle, (String)msg, (IStatus)st);
            }
            throw new RuntimeException(e.getTargetException());
        }
        this.saveDialogSettings();
        if (this.getFinalPerspectiveID() != null && this.getFinalPerspectiveID().length() > 0) {
            DelegateConfigurationElement element = new DelegateConfigurationElement(null){

                public String getAttribute(String aName) {
                    return FacetedProjectWizard.this.getFinalPerspectiveID();
                }
            };
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)element);
        }
        String projName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        IWorkbench workbench = WSTWebUIPlugin.getDefault().getWorkbench();
        BasicNewResourceWizard.selectAndReveal((IResource)newProject, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
        if (this.cachedDescriptorsMap != null) {
            for (WizardPageSlickControlDescriptor wd : this.cachedDescriptorsMap.values()) {
                AbstractTemplateConfigurationDelegate delegate = wd.getConfigurationDelegate();
                if (delegate == null || delegate.isDisposed()) continue;
                delegate.wizardFinished();
            }
            for (IFacetWizardPage fwp : this.cachedWizardPages.values()) {
                fwp.dispose();
            }
            for (WizardPageSlickControlDescriptor wd : this.cachedDescriptorsMap.values()) {
                wd.dispose();
            }
        }
        return true;
    }

    public void refreshConfigurationDelegatesValidation() {
        this.configurationPage.updateValidationState();
    }

    private synchronized void refreshSlickUIDescriptorCache() {
        ArrayList<WizardPageSlickControlDescriptor> configurationPageDescriptors = new ArrayList<WizardPageSlickControlDescriptor>();
        for (WizardPageSlickControlDescriptor wizardPageSlickControlDescriptor : this.cachedDescriptorsMap.values()) {
            configurationPageDescriptors.add(wizardPageSlickControlDescriptor);
        }
        Collections.sort(configurationPageDescriptors, this.getSlickControlDescriptorComparator());
        this.cachedDescriptors = configurationPageDescriptors.toArray(new WizardPageSlickControlDescriptor[configurationPageDescriptors.size()]);
    }

    private synchronized void refreshUI(UiChange change, boolean selectedConfiguration) {
        if (!this.refreshingUI) {
            this.refreshingUI = true;
            UiChange realChange = this.mergeChange(change, this.updateBaseWizardPages());
            if (realChange == UiChange.BOTH || realChange == UiChange.WIZARD_PAGE) {
                this.pageContainer.layout(true, true);
                IWizardContainer wizardContainer = this.getContainer();
                if (wizardContainer.getCurrentPage() != null) {
                    wizardContainer.updateButtons();
                }
            }
            if (realChange == UiChange.BOTH || realChange == UiChange.DESCRIPTOR) {
                IConfigurationDelegate defaultConfiguration = this.wizardLevelExtPtMgr.getDefaultConfiguration(this.getProjectTemplate(), this.getCoreFacetSet());
                if (selectedConfiguration && defaultConfiguration != null) {
                    ConfigurationPage.setConfigurationSelection(defaultConfiguration.getId());
                }
                this.configurationPage.refreshConfigurations();
            }
            if (realChange != UiChange.NONE && this.configurationPage.equals(this.getContainer().getCurrentPage())) {
                this.resize(true);
            }
            this.refreshingUI = false;
        }
    }

    @Override
    public IStatus removeFacet(String facetId) {
        IStatus status = this.projectConfigurationManager.removeFacet(facetId);
        if (status.getSeverity() != 4) {
            this.applyFacetChangesToModels(false, false);
        }
        return status;
    }

    private UiChange removeUiWhichFailedToCreateContent() {
        UiChange result = UiChange.NONE;
        HashSet<IConfigurationDelegate> invalidDelegates = new HashSet<IConfigurationDelegate>();
        for (Map.Entry<IConfigurationDelegate, WizardPageSlickControlDescriptor> entry : this.cachedDescriptorsMap.entrySet()) {
            WizardPageSlickControlDescriptor descriptor = entry.getValue();
            if (!descriptor.getControlProvider().hasFatalError()) continue;
            invalidDelegates.add(entry.getKey());
        }
        if (!invalidDelegates.isEmpty()) {
            result = UiChange.DESCRIPTOR;
            for (IConfigurationDelegate invalidDelegate : invalidDelegates) {
                IFacetWizardPage facetPage;
                String wizardClassName;
                this.removeWizardDescriptor(invalidDelegate);
                if (!invalidDelegate.isWizardConfigration() || (wizardClassName = invalidDelegate.getWizardClassName()) == null || wizardClassName.isEmpty() || (facetPage = this.cachedWizardPages.get(wizardClassName)) == null) continue;
                result = UiChange.BOTH;
                this.removeWizardPage(facetPage, "Creating the actual composite (UI content) failed.");
            }
            this.refreshSlickUIDescriptorCache();
        }
        return result;
    }

    private void removeWizardDescriptor(IConfigurationDelegate templateConfiguration) {
        WizardPageSlickControlDescriptor cachedDescriptor = this.cachedDescriptorsMap.get(templateConfiguration);
        if (cachedDescriptor != null) {
            if (this.tracer.isEnabled()) {
                String message = "Removed descriptor for template configuration: " + templateConfiguration.getId();
                if (templateConfiguration.isWizardConfigration()) {
                    message = String.valueOf(message) + ": wraps wizard page (" + templateConfiguration.getWizardClassName() + ")";
                }
                this.tracer.trace(Tracer.TraceType.WIZARD, message);
            }
            AbstractTemplateConfigurationDelegate delegate = cachedDescriptor.getConfigurationDelegate();
            delegate.removeValidationStateChangedListener(this.configurationPage);
            cachedDescriptor.dispose();
            this.cachedDescriptorsMap.remove(templateConfiguration);
        }
    }

    private UiChange removeWizardDescriptors() {
        UiChange changed = UiChange.NONE;
        HashSet<IConfigurationDelegate> tcsToRemove = new HashSet<IConfigurationDelegate>();
        for (IConfigurationDelegate templateConfiguration : this.cachedDescriptorsMap.keySet()) {
            if (templateConfiguration.isEnabled(this) && !this.cachedDescriptorsMap.get(templateConfiguration).getConfigurationDelegate().recreateRequired()) continue;
            tcsToRemove.add(templateConfiguration);
            changed = UiChange.DESCRIPTOR;
        }
        for (IConfigurationDelegate templateConfiguration : tcsToRemove) {
            this.removeWizardDescriptor(templateConfiguration);
        }
        if (changed == UiChange.DESCRIPTOR) {
            this.refreshSlickUIDescriptorCache();
        }
        return changed;
    }

    private synchronized void removeWizardPage(IFacetWizardPage page, String errorMessage) {
        if (page == null) {
            return;
        }
        String facetId = this.facetPageToFacetIdMap.get(page);
        IProjectFacetVersion fvForPage = null;
        for (IProjectFacetVersion fv : this.getProjectFacetVersions()) {
            if (!fv.getProjectFacet().getId().equals(facetId)) continue;
            fvForPage = fv;
            break;
        }
        if (fvForPage != null) {
            this.removeWizardPage(fvForPage, page, errorMessage);
        }
    }

    private synchronized void removeWizardPage(IProjectFacetVersion fv, IFacetWizardPage page, String errorMessage) {
        if (this.tracer.isEnabled()) {
            String message = "Removing wizard page: " + page.getClass().getCanonicalName() + " for facet " + fv.toString() + " because of following error:\n" + errorMessage != null ? errorMessage : "";
            this.tracer.trace(Tracer.TraceType.WIZARD, message);
        }
        this.cachedWizardPages.remove(page.getClass().getCanonicalName());
        this.facetPageToConfigMap.remove(page);
        this.facetPageToFacetIdMap.remove(page);
        this.wizardPagesForNextButton.remove(page);
        List<IFacetWizardPage> facetPages = this.facetToPagesMap.get(fv);
        facetPages.remove(page);
        page.dispose();
        if (facetPages.isEmpty()) {
            this.facetToPagesMap.remove(fv);
        }
    }

    private synchronized UiChange removeWizardPages() {
        UiChange changed = UiChange.NONE;
        Set<IProjectFacetVersion> newFacetVersions = this.projectConfigurationManager.getProjectFacetVersions();
        HashSet<IFacetWizardPage> pagesToRemove = new HashSet<IFacetWizardPage>();
        HashSet<IProjectFacetVersion> projectVersionsToRemove = new HashSet<IProjectFacetVersion>();
        for (IProjectFacetVersion projectFacetVersion : this.facetToPagesMap.keySet()) {
            List<IFacetWizardPage> facetPages = this.facetToPagesMap.get(projectFacetVersion);
            if (facetPages == null) continue;
            boolean removePagesForFacet = false;
            if (!newFacetVersions.contains(projectFacetVersion)) {
                removePagesForFacet = true;
            } else {
                for (IFacetWizardPage facetWizardPage : facetPages) {
                    AbstractTemplateConfigurationDelegate configurationDelegate;
                    String wizardPageName = facetWizardPage.getClass().getCanonicalName();
                    IConfigurationDelegate templateConfiguration = this.wizardPageToConfiguration.get(wizardPageName);
                    if (!this.cachedDescriptorsMap.containsKey(templateConfiguration) || !(configurationDelegate = this.cachedDescriptorsMap.get(templateConfiguration).getConfigurationDelegate()).recreateRequired() && configurationDelegate.shouldShow(configurationDelegate.getDataModel())) continue;
                    removePagesForFacet = true;
                    break;
                }
            }
            if (!removePagesForFacet) continue;
            for (IFacetWizardPage facetPage : facetPages) {
                pagesToRemove.add(facetPage);
            }
            projectVersionsToRemove.add(projectFacetVersion);
        }
        for (IProjectFacetVersion projectFacetVersion : projectVersionsToRemove) {
            List<IFacetWizardPage> removedPages = this.facetToPagesMap.remove(projectFacetVersion);
            for (IFacetWizardPage removedPage : removedPages) {
                this.facetPageToConfigMap.remove(removedPage);
                this.facetPageToFacetIdMap.remove(removedPage);
            }
        }
        for (IFacetWizardPage facetPage : pagesToRemove) {
            IConfigurationDelegate templateConfiguration = this.wizardPageToConfiguration.get(facetPage.getClass().getCanonicalName());
            if (templateConfiguration != null) {
                this.removeWizardDescriptor(templateConfiguration);
                changed = UiChange.BOTH;
            } else {
                this.wizardPagesForNextButton.remove(facetPage);
            }
            this.tracer.trace(Tracer.TraceType.WIZARD, "Removing stale wizard page: " + facetPage.getClass().getCanonicalName());
            this.cachedWizardPages.remove(facetPage.getClass().getCanonicalName());
            facetPage.setWizard(null);
            Control control = facetPage.getControl();
            if (control != null) {
                control.dispose();
            }
            facetPage.dispose();
            UiChange uiChange = changed = changed == UiChange.NONE ? UiChange.WIZARD_PAGE : changed;
        }
        if (changed == UiChange.BOTH) {
            this.refreshSlickUIDescriptorCache();
        }
        return changed;
    }

    @Override
    public void removeWorkingCopyListener(IFacetedProjectListener listener) {
        this.fpjwc.removeListener(listener);
    }

    public void resize(boolean useConfigurationPage) {
        Shell shell = this.getShell();
        if (useConfigurationPage) {
            Point oldPageSize = this.configurationPage.getControl().getSize();
            Point oldShellSize = shell.getSize();
            Point buffer = new Point(oldShellSize.x - oldPageSize.x, oldShellSize.y - oldPageSize.y);
            Point newConfigPageSize = this.configurationPage.computeSize();
            newConfigPageSize.x += buffer.x;
            newConfigPageSize.y += buffer.y;
            Point wizardSize = new Point(this.currentWizardSize.x > newConfigPageSize.x ? this.currentWizardSize.x : newConfigPageSize.x, this.currentWizardSize.y > newConfigPageSize.y ? this.currentWizardSize.y : newConfigPageSize.y);
            this.currentWizardSize.x = wizardSize.x;
            this.currentWizardSize.y = wizardSize.y;
            shell.setSize(this.currentWizardSize);
        }
    }

    private void saveDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IProjectTemplate projectTemplate = this.projectConfigurationManager.getProjectTemplate();
        dialogSettings.put(DIALOG_SETTING_KEY_PROJECT_TEMPLATE, projectTemplate != null ? projectTemplate.getId() : EMPTY);
        ICoreFacetSet coreFacetSet = this.projectConfigurationManager.getCoreFacetSet();
        dialogSettings.put(DIALOG_SETTING_KEY_CORE_FACET_SET, coreFacetSet != null ? coreFacetSet.getId() : EMPTY);
        IRuntime primaryRuntime = this.fpjwc.getPrimaryRuntime();
        Map<ICoreFacetSet, IRuntime> coreFacetSetToRuntimeMap = this.getDefaultCoreFacetSetToRuntimeMapFromSettings();
        IRuntime cachedRuntime = coreFacetSetToRuntimeMap.get(coreFacetSet);
        if (!this.equal(primaryRuntime, cachedRuntime)) {
            if (primaryRuntime != null) {
                coreFacetSetToRuntimeMap.put(coreFacetSet, primaryRuntime);
            } else {
                coreFacetSetToRuntimeMap.remove(coreFacetSet);
            }
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<ICoreFacetSet, IRuntime> entry : coreFacetSetToRuntimeMap.entrySet()) {
                String coreFacetSetId = entry.getKey().getId();
                String runtimeName = entry.getValue().getName();
                if (coreFacetSetId == null || coreFacetSetId.isEmpty() || runtimeName == null || runtimeName.isEmpty()) continue;
                builder.append(coreFacetSetId);
                builder.append(KEY_VALUE_DELIMITOR);
                builder.append(runtimeName);
                builder.append(LIST_SEPERATOR);
            }
            String serializedCoreFacetSetToRuntime = builder.toString();
            if (serializedCoreFacetSetToRuntime.endsWith(LIST_SEPERATOR)) {
                serializedCoreFacetSetToRuntime = serializedCoreFacetSetToRuntime.substring(0, serializedCoreFacetSetToRuntime.length() - 1);
            }
            if (!serializedCoreFacetSetToRuntime.isEmpty()) {
                dialogSettings.put(DIALOG_SETTING_KEY_RUNTIME, serializedCoreFacetSetToRuntime);
            } else {
                dialogSettings.put(DIALOG_SETTING_KEY_RUNTIME, EMPTY);
            }
        }
        String projectFacetVersionsString = EMPTY;
        Set<IProjectFacetVersion> projectFacetVersions = this.projectConfigurationManager.getProjectFacetVersions();
        if (projectFacetVersions != null) {
            StringBuilder builder = new StringBuilder();
            for (IProjectFacetVersion projectFacetVersion : projectFacetVersions) {
                String facetId = projectFacetVersion.getProjectFacet().getId();
                String facetVersion = projectFacetVersion.getVersionString();
                builder.append(facetId);
                builder.append(KEY_VALUE_DELIMITOR);
                builder.append(facetVersion);
                builder.append(LIST_SEPERATOR);
            }
            projectFacetVersionsString = builder.toString();
            projectFacetVersionsString = projectFacetVersionsString.substring(0, projectFacetVersionsString.length() - 1);
        }
        dialogSettings.put(DIALOG_SETTING_KEY_PROJECT_FACETS, projectFacetVersionsString);
    }

    private synchronized UiChange updateBaseWizardPages() {
        UiChange result = UiChange.NONE;
        this.skipConfigurationPage = this.cachedDescriptors == null || this.cachedDescriptors.length == 0;
        return result;
    }

    void updateDataModelActionConfigObjects() {
        Set actions = this.fpjwc.getProjectFacetActions();
        HashSet<String> activeIds = new HashSet<String>();
        for (IFacetedProject.Action action : actions) {
            String id = action.getProjectFacetVersion().getProjectFacet().getId();
            activeIds.add(id);
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap dataModelMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        Set idSet = dataModelMap.keySet();
        for (String id : idSet) {
            IDataModel configDM = (IDataModel)dataModelMap.get((Object)id);
            boolean active = activeIds.contains(id);
            configDM.setBooleanProperty("IFacetDataModelProperties.SHOULD_EXECUTE", active);
            activeIds.remove(id);
        }
        IFacetProjectCreationDataModelProperties.FacetActionMap actionMap = (IFacetProjectCreationDataModelProperties.FacetActionMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP");
        actionMap.clear();
        for (IFacetedProject.Action action : actions) {
            String id = action.getProjectFacetVersion().getProjectFacet().getId();
            if (!activeIds.contains(id)) continue;
            actionMap.add(action);
        }
        this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
    }

    private void updateSelectedProjectTemplate(final Set<IProjectFacetVersion> newProjectFacetVersions, final Set<IProjectFacet> fixedProjectFacets) {
        if (this.onUiThread()) {
            this.doUpdateSelectedProjectTemplate(newProjectFacetVersions, fixedProjectFacets);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FacetedProjectWizard.this.doUpdateSelectedProjectTemplate(newProjectFacetVersions, fixedProjectFacets);
                }
            });
        }
    }

    @Override
    public IStatus validateAddFacetVersion(IProjectFacetVersion facetVersion) {
        return this.projectConfigurationManager.validateAddFacetVersion(facetVersion);
    }

    @Override
    public IStatus validateChangeFacetVersion(IProjectFacetVersion facetVersion) {
        return this.projectConfigurationManager.validateChangeFacetVersion(facetVersion);
    }

    @Override
    public IStatus validateRemoveFacet(String facetId) {
        return this.projectConfigurationManager.validateRemoveFacet(facetId);
    }

    @Override
    public IStatus validateRuntimeChange(IRuntime newRuntime, boolean updateCoreFacetVersions) {
        return this.projectConfigurationManager.validateRuntimeChange(newRuntime, this.calculateDefaultFacetVersionsForRuntimeChange(updateCoreFacetVersions));
    }

    private void validateWizardConfiguration() throws CoreException {
        IStatus status = this.wizardLevelExtPtMgr.validateWizardExtensionPoints();
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    private class SlickUIWizardContext
    implements IWizardContext {
        private SlickUIWizardContext() {
        }

        public IFacetedProject.Action getAction(IFacetedProject.Action.Type type, IProjectFacetVersion f) {
            if (this.isProjectFacetSelected(f)) {
                for (IFacetedProject.Action action : this.getActions()) {
                    if (action.getType() != type || action.getProjectFacetVersion() != f) continue;
                    return action;
                }
            }
            return null;
        }

        public Set<IFacetedProject.Action> getActions() {
            Set<IProjectFacetVersion> projectFacetVersions = this.getSelectedProjectFacets();
            HashSet<IFacetedProject.Action> result = new HashSet<IFacetedProject.Action>();
            for (IProjectFacetVersion projectFacetVersion : projectFacetVersions) {
                IFacetedProject.Action action = this.getAction(IFacetedProject.Action.Type.INSTALL, projectFacetVersion);
                if (action == null) continue;
                result.add(action);
            }
            return result;
        }

        public Object getConfig(IProjectFacetVersion fv, IFacetedProject.Action.Type type, String pjname) {
            return FacetedProjectWizard.this.getFacetConfig(fv.getProjectFacet().getId());
        }

        public String getProjectName() {
            return FacetedProjectWizard.this.fpjwc.getProjectName();
        }

        public Set<IProjectFacetVersion> getSelectedProjectFacets() {
            return FacetedProjectWizard.this.projectConfigurationManager.getProjectFacetVersions();
        }

        public boolean isProjectFacetSelected(IProjectFacetVersion fv) {
            return FacetedProjectWizard.this.projectConfigurationManager.hasFacetVersion(fv);
        }
    }

    private static enum UiChange {
        WIZARD_PAGE,
        DESCRIPTOR,
        BOTH,
        NONE;

    }
}

